/*
 * Decompiled with CFR 0.152.
 */
package danger.orespawn;

import danger.orespawn.OreSpawnMain;
import java.util.Random;

public class Trees {
    public static final mk[] CrystalChestContentsList = new mk[]{new mk(OreSpawnMain.CrystalTermiteBlock.cF, 0, 1, 5, 10), new mk(OreSpawnMain.CrystalFlowerRedBlock.cF, 0, 1, 10, 10), new mk(OreSpawnMain.CrystalFlowerBlueBlock.cF, 0, 1, 10, 10), new mk(OreSpawnMain.CrystalFlowerGreenBlock.cF, 0, 1, 10, 10), new mk(OreSpawnMain.CrystalFlowerYellowBlock.cF, 0, 1, 10, 10), new mk(OreSpawnMain.CrystalPlanksBlock.cF, 0, 1, 10, 10), new mk(OreSpawnMain.CrystalWorkbenchBlock.cF, 0, 1, 1, 10), new mk(OreSpawnMain.CrystalFurnaceBlock.cF, 0, 1, 1, 10), new mk(OreSpawnMain.MyTigersEyeBlock.cF, 0, 1, 10, 5), new mk(OreSpawnMain.CrystalStone.cF, 0, 1, 10, 10), new mk(OreSpawnMain.CrystalRat.cF, 0, 1, 10, 10), new mk(OreSpawnMain.CrystalFairy.cF, 0, 1, 10, 10), new mk(OreSpawnMain.CrystalCoal.cF, 0, 1, 10, 10), new mk(OreSpawnMain.CrystalGrass.cF, 0, 1, 10, 10), new mk(OreSpawnMain.CrystalCrystal.cF, 0, 1, 10, 10), new mk(OreSpawnMain.CrystalTorch.cF, 0, 1, 10, 10), new mk(OreSpawnMain.MyCrystalLeaves.cF, 0, 1, 10, 10), new mk(OreSpawnMain.MyCrystalLeaves2.cF, 0, 1, 10, 10), new mk(OreSpawnMain.MyCrystalLeaves3.cF, 0, 1, 10, 10), new mk(OreSpawnMain.MyCrystalTreeLog.cF, 0, 1, 10, 10), new mk(OreSpawnMain.TigersEye.cF, 0, 1, 10, 5), new mk(OreSpawnMain.MyCrystalWoodSword.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalWoodAxe.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalWoodShovel.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalWoodPickaxe.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalWoodHoe.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalPinkSword.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalPinkAxe.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalPinkShovel.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalPinkPickaxe.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalPinkHoe.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyTigersEyeSword.cv, 0, 1, 1, 5), new mk(OreSpawnMain.MyTigersEyeAxe.cv, 0, 1, 1, 5), new mk(OreSpawnMain.MyTigersEyeShovel.cv, 0, 1, 1, 5), new mk(OreSpawnMain.MyTigersEyePickaxe.cv, 0, 1, 1, 5), new mk(OreSpawnMain.MyTigersEyeHoe.cv, 0, 1, 1, 5), new mk(OreSpawnMain.MyCrystalStoneSword.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalStoneAxe.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalStoneShovel.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalStonePickaxe.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyCrystalStoneHoe.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyTigersEyeIngot.cv, 0, 1, 5, 5), new mk(OreSpawnMain.MyCrystalPinkIngot.cv, 0, 1, 5, 10), new mk(OreSpawnMain.MyCrystalApple.cv, 0, 1, 5, 10), new mk(OreSpawnMain.MyPeacockFeather.cv, 0, 1, 5, 10), new mk(OreSpawnMain.MyPeacock.cv, 0, 1, 10, 20), new mk(OreSpawnMain.MyRawPeacock.cv, 0, 1, 10, 20), new mk(OreSpawnMain.MyRice.cv, 0, 1, 10, 20), new mk(OreSpawnMain.MyQuinoa.cv, 0, 1, 10, 20), new mk(OreSpawnMain.CrystalPinkHelmet.cv, 0, 1, 1, 10), new mk(OreSpawnMain.CrystalPinkBody.cv, 0, 1, 1, 10), new mk(OreSpawnMain.CrystalPinkLegs.cv, 0, 1, 1, 10), new mk(OreSpawnMain.CrystalPinkBoots.cv, 0, 1, 1, 10), new mk(OreSpawnMain.TigersEyeHelmet.cv, 0, 1, 1, 5), new mk(OreSpawnMain.TigersEyeBody.cv, 0, 1, 1, 5), new mk(OreSpawnMain.TigersEyeLegs.cv, 0, 1, 1, 5), new mk(OreSpawnMain.TigersEyeBoots.cv, 0, 1, 1, 5), new mk(OreSpawnMain.PeacockFeatherHelmet.cv, 0, 1, 1, 10), new mk(OreSpawnMain.PeacockFeatherBody.cv, 0, 1, 1, 10), new mk(OreSpawnMain.PeacockFeatherLegs.cv, 0, 1, 1, 10), new mk(OreSpawnMain.PeacockFeatherBoots.cv, 0, 1, 1, 10), new mk(OreSpawnMain.RotatorEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.VortexEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.PeacockEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.DungeonBeastEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.FairyEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.RatEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.FlounderEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.WhaleEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.IrukandjiEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.SkateEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.UrchinEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.GhostEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.GhostSkellyEgg.cv, 0, 1, 5, 10), new mk(OreSpawnMain.MySkateBow.cv, 0, 1, 1, 2), new mk(OreSpawnMain.MyIrukandjiArrow.cv, 0, 5, 10, 2), new mk(OreSpawnMain.MyIrukandji.cv, 0, 2, 8, 5), new mk(OreSpawnMain.MyUltimateBow.cv, 0, 1, 1, 2), new mk(OreSpawnMain.MyUltimateSword.cv, 0, 1, 1, 2), new mk(yc.q.cv, 0, 1, 4, 10), new mk(aqz.O.cF, 0, 1, 4, 10), new mk(yc.av.cv, 0, 1, 5, 2)};

    private void WindTreeBranch(abw world, int x, int y, int z, int length, int dirx, int dirz) {
        for (int i = 1; i <= length; ++i) {
            OreSpawnMain.setBlockFast(world, x + i * dirx, y, z + i * dirz, aqz.O.cF, 0, 2);
            if (0 == world.a(x + i * dirx, y + 1, z + i * dirz)) {
                OreSpawnMain.setBlockFast(world, x + i * dirx, y + 1, z + i * dirz, aqz.P.cF, 0, 2);
            }
            if (i < length / 3 && 0 == world.a(x + i * dirx, y + 2, z + i * dirz)) {
                OreSpawnMain.setBlockFast(world, x + i * dirx, y + 2, z + i * dirz, aqz.P.cF, 0, 2);
            }
            if (i <= length / 3) continue;
            if (0 == world.a(x + i * dirx + dirz, y, z + i * dirz + dirx)) {
                OreSpawnMain.setBlockFast(world, x + i * dirx + dirz, y, z + i * dirz + dirx, aqz.P.cF, 0, 2);
            }
            if (0 != world.a(x + i * dirx - dirz, y, z + i * dirz - dirx)) continue;
            OreSpawnMain.setBlockFast(world, x + i * dirx - dirz, y, z + i * dirz - dirx, aqz.P.cF, 0, 2);
        }
        if (0 == world.a(x + (length + 1) * dirx, y, z + (length + 1) * dirz)) {
            OreSpawnMain.setBlockFast(world, x + (length + 1) * dirx, y, z + (length + 1) * dirz, aqz.P.cF, 0, 2);
        }
        if (0 == world.a(x + (length + 2) * dirx, y, z + (length + 2) * dirz)) {
            OreSpawnMain.setBlockFast(world, x + (length + 2) * dirx, y, z + (length + 2) * dirz, aqz.P.cF, 0, 2);
        }
    }

    public void WindTree(abw world, int x, int y, int z, int dir) {
        int bid;
        if (dir < 0 || dir > 3) {
            return;
        }
        int dirx = 1;
        int dirz = 0;
        if (dir == 1) {
            dirx = -1;
            dirz = 0;
        }
        if (dir == 2) {
            dirx = 0;
            dirz = 1;
        }
        if (dir == 3) {
            dirx = 0;
            dirz = -1;
        }
        if ((bid = world.a(x, y, z)) != aqz.z.cF && bid != aqz.A.cF) {
            return;
        }
        int height = world.s.nextInt(8) + 40;
        int width = world.s.nextInt(4) + 8;
        for (int j = 0; j < height; ++j) {
            OreSpawnMain.setBlockFast(world, x, j + y, z, aqz.O.cF, 0, 2);
            if (j <= height / 5) continue;
            OreSpawnMain.setBlockFast(world, x + dirx, j + y, z + dirz, aqz.P.cF, 0, 2);
            if (j <= height / 4 || j % 4 != 0) continue;
            this.WindTreeBranch(world, x, j + y, z, height - j, dirx, dirz);
        }
        OreSpawnMain.setBlockFast(world, x, y + height, z, aqz.P.cF, 0, 2);
    }

    private void SkyTreeBranch(abw world, int x, int y, int z, int length, int dirx, int dirz) {
        for (int i = 1; i < length; ++i) {
            OreSpawnMain.setBlockFast(world, x + i * dirx, y, z + i * dirz, OreSpawnMain.MySkyTreeLog.cF, 0, 2);
            if (0 == world.a(x + i * dirx, y + 1, z + i * dirz)) {
                OreSpawnMain.setBlockFast(world, x + i * dirx, y + 1, z + i * dirz, aqz.P.cF, 0, 2);
            }
            if (0 == world.a(x + i * dirx + dirz, y, z + i * dirz + dirx)) {
                OreSpawnMain.setBlockFast(world, x + i * dirx + dirz, y, z + i * dirz + dirx, aqz.P.cF, 0, 2);
            }
            if (0 != world.a(x + i * dirx - dirz, y, z + i * dirz - dirx)) continue;
            OreSpawnMain.setBlockFast(world, x + i * dirx - dirz, y, z + i * dirz - dirx, aqz.P.cF, 0, 2);
        }
        if (0 == world.a(x + length * dirx, y, z + length * dirz)) {
            OreSpawnMain.setBlockFast(world, x + length * dirx, y, z + length * dirz, aqz.P.cF, 0, 2);
        }
    }

    public void SkyTree(abw world, int x, int y, int z) {
        int bid = world.a(x, y, z);
        if (bid != aqz.z.cF && bid != aqz.A.cF) {
            return;
        }
        int height = world.s.nextInt(15) + 190;
        if (height - y < 20) {
            return;
        }
        int width = world.s.nextInt(10) + 25;
        for (int j = y; j <= height; ++j) {
            OreSpawnMain.setBlockFast(world, x, j, z, OreSpawnMain.MySkyTreeLog.cF, 0, 2);
        }
        OreSpawnMain.setBlockFast(world, x, height + 1, z, aqz.P.cF, 0, 2);
        this.SkyTreeBranch(world, x, height, z, width, 1, 0);
        this.SkyTreeBranch(world, x, height, z, width, -1, 0);
        this.SkyTreeBranch(world, x, height, z, width, 0, 1);
        this.SkyTreeBranch(world, x, height, z, width, 0, -1);
        height -= 5;
        this.SkyTreeBranch(world, x, height -= world.s.nextInt(4), z, width /= 3, 1, 0);
        this.SkyTreeBranch(world, x, height, z, width, -1, 0);
        this.SkyTreeBranch(world, x, height, z, width, 0, 1);
        this.SkyTreeBranch(world, x, height, z, width, 0, -1);
    }

    public void DuplicatorTree(abw world, int x, int y, int z) {
        int j;
        int i;
        int realy = y;
        int bid = world.a(x, y - 1, z);
        if (bid != aqz.z.cF && bid != aqz.A.cF && bid != aqz.aF.cF) {
            bid = world.a(x, y - 2, z);
            if (bid != aqz.z.cF && bid != aqz.A.cF && bid != aqz.aF.cF) {
                bid = world.a(x, y - 3, z);
                if (bid != aqz.z.cF && bid != aqz.A.cF && bid != aqz.aF.cF) {
                    world.f(x, y, z, 0, 0, 2);
                    return;
                }
                realy = y - 3;
            } else {
                realy = y - 2;
            }
            return;
        }
        realy = y - 1;
        bid = world.a(x, realy + 1, z);
        if (bid != OreSpawnMain.MyDT.cF) {
            OreSpawnMain.setBlockFast(world, x, realy + 1, z, OreSpawnMain.MyDT.cF, 0, 2);
            return;
        }
        bid = world.a(x, realy + 2, z);
        if (bid != OreSpawnMain.MyDT.cF) {
            OreSpawnMain.setBlockFast(world, x, realy + 2, z, OreSpawnMain.MyDT.cF, 0, 2);
            return;
        }
        bid = world.a(x, realy + 3, z);
        if (bid != OreSpawnMain.MyDT.cF) {
            OreSpawnMain.setBlockFast(world, x, realy + 3, z, OreSpawnMain.MyDT.cF, 0, 2);
            return;
        }
        bid = world.a(x, realy + 4, z);
        if (bid != OreSpawnMain.MyAppleLeaves.cF) {
            OreSpawnMain.setBlockFast(world, x, realy + 4, z, OreSpawnMain.MyAppleLeaves.cF, 0, 2);
            return;
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                if (j == 0 && i == 0 || (bid = world.a(x + i, realy + 3, z + j)) == OreSpawnMain.MyAppleLeaves.cF) continue;
                OreSpawnMain.setBlockFast(world, x + i, realy + 3, z + j, OreSpawnMain.MyAppleLeaves.cF, 0, 2);
                return;
            }
        }
        int bidm = 0;
        for (int tries = 0; tries < 20 && (bidm == 0 || bidm == OreSpawnMain.MyDT.cF); ++tries) {
            i = world.s.nextInt(5) - 2;
            j = world.s.nextInt(5) - 2;
            bidm = world.a(x + i, realy + 1, z + j);
            int meta = world.h(x + i, realy + 1, z + j);
            if (bidm == 0 || bidm == OreSpawnMain.MyDT.cF) continue;
            for (int k = 0; k < 20; ++k) {
                i = world.s.nextInt(5) - 2;
                bid = world.a(x + i, realy + 1, z + (j = world.s.nextInt(5) - 2));
                if (bid != 0) continue;
                world.f(x + i, realy + 1, z + j, bidm, meta, 2);
                return;
            }
        }
    }

    private void make_leaves(abw world, int x, int y, int z) {
        for (int l1 = -3; l1 <= 3; ++l1) {
            for (int l2 = -3; l2 <= 3; ++l2) {
                for (int l3 = 0; l3 <= 2; ++l3) {
                    int bid = world.a(x + l1, y + l3, z + l2);
                    if (bid != 0) continue;
                    OreSpawnMain.setBlockFast(world, x + l1, y + l3, z + l2, OreSpawnMain.MyExperienceLeaves.cF, 0, 2);
                }
            }
        }
    }

    private void grow_small_branch(abw world, int x, int y, int z, int xdir, int zdir, int xxdir, int zzdir) {
        int n;
        int i2 = 0;
        int k2 = 0;
        int j2 = 0;
        int i = x;
        int j = y;
        int k = z;
        int grow = 4 + world.s.nextInt(2);
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i, j, k, aqz.O.cF, 0, 2);
            this.make_leaves(world, i, j, k);
            ++j;
            i2 = i += xdir;
            k2 = k += zdir;
        }
        grow = 4 + world.s.nextInt(3);
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i, j, k, aqz.O.cF, 0, 2);
            this.make_leaves(world, i, j, k);
            i += xdir;
            k += zdir;
        }
        grow = 4 + world.s.nextInt(3);
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i2, j, k2, aqz.O.cF, 0, 2);
            this.make_leaves(world, i2, j, k2);
            i2 += xxdir;
            k2 += zzdir;
        }
        j2 = --j;
        grow = 3 + world.s.nextInt(3);
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i, j, k, aqz.O.cF, 0, 2);
            this.make_leaves(world, i, j, k);
            i += xdir;
            k += zdir;
            --j;
        }
        grow = 3 + world.s.nextInt(3);
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i2, j2, k2, aqz.O.cF, 0, 2);
            this.make_leaves(world, i2, j2, k2);
            i2 += xxdir;
            k2 += zzdir;
            --j2;
        }
    }

    private void grow_branch(abw world, int x, int y, int z, int xdir, int zdir, int xxdir, int zzdir) {
        int n;
        int i2 = 0;
        int k2 = 0;
        int j2 = 0;
        int i = x;
        int j = y;
        int k = z;
        int grow = 5 + world.s.nextInt(4);
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i, j, k, aqz.O.cF, 0, 2);
            this.make_leaves(world, i, j, k);
            ++j;
            i2 = i += xdir;
            k2 = k += zdir;
        }
        grow = 6 + world.s.nextInt(5);
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i, j, k, aqz.O.cF, 0, 2);
            this.make_leaves(world, i, j, k);
            i += xdir;
            k += zdir;
        }
        grow = 6 + world.s.nextInt(5);
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i2, j, k2, aqz.O.cF, 0, 2);
            this.make_leaves(world, i2, j, k2);
            i2 += xxdir;
            k2 += zzdir;
        }
        j2 = --j;
        grow = 4 + world.s.nextInt(4);
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i, j, k, aqz.O.cF, 0, 2);
            this.make_leaves(world, i, j, k);
            i += xdir;
            k += zdir;
            --j;
        }
        grow = 4 + world.s.nextInt(4);
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i2, j2, k2, aqz.O.cF, 0, 2);
            this.make_leaves(world, i2, j2, k2);
            i2 += xxdir;
            k2 += zzdir;
            --j2;
        }
    }

    public void ExperienceTree(abw world, int x, int y, int z) {
        int k;
        int i;
        int j;
        int bid = world.a(x, y, z);
        if (bid != aqz.z.cF && bid != aqz.A.cF && bid != aqz.aF.cF) {
            return;
        }
        for (j = 1; j < 6; ++j) {
            for (i = 0; i < 2; ++i) {
                for (k = 0; k < 2; ++k) {
                    OreSpawnMain.setBlockFast(world, x + i, y + j, z + k, aqz.O.cF, 0, 2);
                }
            }
        }
        this.grow_branch(world, x, y + 6, z, 0, 1, 1, 1);
        this.grow_branch(world, x + 1, y + 6, z, 1, 0, 1, -1);
        this.grow_branch(world, x, y + 6, z + 1, -1, 0, -1, 1);
        this.grow_branch(world, x + 1, y + 6, z + 1, 0, -1, -1, -1);
        for (j = 7; j < 19; ++j) {
            for (i = 0; i < 2; ++i) {
                for (k = 0; k < 2; ++k) {
                    OreSpawnMain.setBlockFast(world, x + i, y + j, z + k, aqz.O.cF, 0, 2);
                }
            }
        }
        this.grow_small_branch(world, x, y + 19, z, 0, 1, -1, 1);
        this.grow_small_branch(world, x + 1, y + 19, z, 1, 0, 1, 1);
        this.grow_small_branch(world, x, y + 19, z + 1, -1, 0, -1, -1);
        this.grow_small_branch(world, x + 1, y + 19, z + 1, 0, -1, 1, -1);
        int grow = 5 + world.s.nextInt(6);
        for (j = 19; j < 19 + grow; ++j) {
            for (i = 0; i < 2; ++i) {
                for (k = 0; k < 2; ++k) {
                    OreSpawnMain.setBlockFast(world, x + i, y + j, z + k, aqz.O.cF, 0, 2);
                    this.make_leaves(world, x + i, y + j, z + k);
                }
            }
        }
    }

    public void SmallTree(abw world, int x, int y, int z) {
        int realy = y;
        int bid = world.a(x, y - 1, z);
        if (bid != aqz.z.cF && bid != aqz.A.cF && bid != aqz.aF.cF) {
            bid = world.a(x, y - 2, z);
            if (bid != aqz.z.cF && bid != aqz.A.cF && bid != aqz.aF.cF) {
                bid = world.a(x, y - 3, z);
                if (bid != aqz.z.cF && bid != aqz.A.cF && bid != aqz.aF.cF) {
                    OreSpawnMain.setBlockFast(world, x, y, z, 0, 0, 2);
                    return;
                }
                realy = y - 3;
            } else {
                realy = y - 2;
            }
            return;
        }
        realy = y - 1;
        bid = world.a(x, realy + 1, z);
        if (bid == 0) {
            OreSpawnMain.setBlockFast(world, x, realy + 1, z, OreSpawnMain.MySkyTreeLog.cF, 0, 2);
        }
        if (world.s.nextInt(2) == 1) {
            bid = world.a(x, realy + 2, z);
            if (bid == 0) {
                OreSpawnMain.setBlockFast(world, x, realy + 2, z, OreSpawnMain.MySkyTreeLog.cF, 0, 2);
            }
            if (world.s.nextInt(2) == 1) {
                bid = world.a(x, realy + 3, z);
                if (bid == 0) {
                    OreSpawnMain.setBlockFast(world, x, realy + 3, z, OreSpawnMain.MySkyTreeLog.cF, 0, 2);
                }
            } else {
                --realy;
            }
        } else {
            realy -= 2;
        }
        if ((bid = world.a(x, realy + 4, z)) == 0) {
            OreSpawnMain.setBlockFast(world, x, realy + 4, z, OreSpawnMain.MyAppleLeaves.cF, 0, 2);
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                bid = world.a(x + i, realy + 3, z + j);
                if (bid != 0) continue;
                OreSpawnMain.setBlockFast(world, x + i, realy + 3, z + j, OreSpawnMain.MyAppleLeaves.cF, 0, 2);
            }
        }
    }

    public void makeScragglyBranch(abw world, int x, int y, int z, int len, int biasx, int biasz) {
        for (int k = 0; k < len; ++k) {
            int iy;
            int bid;
            int ix = world.s.nextInt(2) - world.s.nextInt(2) + biasx;
            int iz = world.s.nextInt(2) - world.s.nextInt(2) + biasz;
            if (ix > 1) {
                ix = 1;
            }
            if (ix < -1) {
                ix = -1;
            }
            if (iz > 1) {
                iz = 1;
            }
            if (iz < -1) {
                iz = -1;
            }
            if ((bid = world.a(x += ix, y += (iy = world.s.nextInt(3) > 0 ? 1 : 0), z += iz)) != 0 && bid != aqz.O.cF && bid != OreSpawnMain.MyAppleLeaves.cF) {
                return;
            }
            OreSpawnMain.setBlockFast(world, x, y, z, aqz.O.cF, 0, 2);
            for (int m = -1; m < 2; ++m) {
                for (int n = -1; n < 2; ++n) {
                    if (world.s.nextInt(2) != 1 || (bid = world.a(x + m, y, z + n)) != 0) continue;
                    OreSpawnMain.setBlockFast(world, x + m, y, z + n, OreSpawnMain.MyAppleLeaves.cF, 0, 2);
                }
            }
            if (world.s.nextInt(2) != 1 || (bid = world.a(x, y + 1, z)) != 0) continue;
            OreSpawnMain.setBlockFast(world, x, y + 1, z, OreSpawnMain.MyAppleLeaves.cF, 0, 2);
        }
    }

    public void ScragglyTreeWithBranches(abw world, int x, int y, int z) {
        int bid;
        int k;
        int i = 1 + world.s.nextInt(3);
        int j = i + world.s.nextInt(12);
        for (k = 0; k < i; ++k) {
            bid = world.a(x, y + k, z);
            if (k >= 1 && bid != 0 && bid != aqz.O.cF && bid != OreSpawnMain.MyAppleLeaves.cF) {
                return;
            }
            OreSpawnMain.setBlockFast(world, x, y + k, z, aqz.O.cF, 0, 2);
        }
        y += i - 1;
        for (k = i; k < j; ++k) {
            int ix = world.s.nextInt(2) - world.s.nextInt(2);
            int iz = world.s.nextInt(2) - world.s.nextInt(2);
            int iy = world.s.nextInt(4) > 0 ? 1 : 0;
            bid = world.a(x += ix, y += iy, z += iz);
            if (bid != 0 && bid != aqz.O.cF && bid != OreSpawnMain.MyAppleLeaves.cF) break;
            OreSpawnMain.setBlockFast(world, x, y, z, aqz.O.cF, 0, 2);
            if (world.s.nextInt(4) == 1) {
                this.makeScragglyBranch(world, x, y, z, world.s.nextInt(1 + j - k), world.s.nextInt(2) - world.s.nextInt(2), world.s.nextInt(2) - world.s.nextInt(2));
            }
            for (int m = -1; m < 2; ++m) {
                for (int n = -1; n < 2; ++n) {
                    if (world.s.nextInt(2) != 1 || (bid = world.a(x + m, y, z + n)) != 0) continue;
                    OreSpawnMain.setBlockFast(world, x + m, y, z + n, OreSpawnMain.MyAppleLeaves.cF, 0, 2);
                }
            }
            if (world.s.nextInt(2) != 1 || (bid = world.a(x, y + 1, z)) != 0) continue;
            OreSpawnMain.setBlockFast(world, x, y + 1, z, OreSpawnMain.MyAppleLeaves.cF, 0, 2);
        }
    }

    public void FairyTree(abw world, int x, int y, int z) {
        int k;
        int i;
        int j;
        for (j = 1; j < 6; ++j) {
            for (i = 0; i < 2; ++i) {
                for (k = 0; k < 2; ++k) {
                    OreSpawnMain.setBlockFast(world, x + i, y + j, z + k, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
                }
            }
        }
        this.grow_crystal_branch(world, x, y + 5, z, 0, 1, 1, 1, -1);
        this.grow_crystal_branch(world, x + 1, y + 5, z, 1, 0, 1, -1, -1);
        this.grow_crystal_branch(world, x, y + 5, z + 1, -1, 0, -1, 1, -1);
        this.grow_crystal_branch(world, x + 1, y + 5, z + 1, 0, -1, -1, -1, -1);
        this.grow_crystal_branch(world, x, y + 6, z, 0, 1, -1, 1, -1);
        this.grow_crystal_branch(world, x + 1, y + 6, z, 1, 0, 1, 1, -1);
        this.grow_crystal_branch(world, x, y + 6, z + 1, -1, 0, -1, -1, -1);
        this.grow_crystal_branch(world, x + 1, y + 6, z + 1, 0, -1, 1, -1, -1);
        int grow = 5 + world.s.nextInt(5);
        for (j = 6; j < 6 + grow; ++j) {
            for (i = 0; i < 2; ++i) {
                for (k = 0; k < 2; ++k) {
                    OreSpawnMain.setBlockFast(world, x + i, y + j, z + k, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
                    this.make_crystal_leaves(world, x + i, y + j, z + k);
                }
            }
        }
        world.f(x - 1, y + 1, z, aqz.ax.cF, 0, 2);
        asj tileentitymobspawner = (asj)world.r(x - 1, y + 1, z);
        if (tileentitymobspawner != null) {
            tileentitymobspawner.a().a("Fairy");
        }
        world.f(x + 2, y + 1, z, aqz.az.cF, 0, 2);
        ary chest = (ary)world.r(x + 2, y + 1, z);
        if (chest != null) {
            mk.a((Random)world.s, (mk[])CrystalChestContentsList, (mo)chest, (int)(1 + world.s.nextInt(5)));
        }
    }

    private void make_crystal_leaves(abw world, int x, int y, int z) {
        for (int l1 = -2; l1 <= 2; ++l1) {
            for (int l2 = -2; l2 <= 2; ++l2) {
                for (int l3 = 0; l3 <= 1; ++l3) {
                    int bid = world.a(x + l1, y + l3, z + l2);
                    if (bid != 0) continue;
                    OreSpawnMain.setBlockFast(world, x + l1, y + l3, z + l2, OreSpawnMain.MyCrystalLeaves3.cF, 0, 2);
                }
            }
        }
    }

    private void make_crystal_castle_leaves(abw world, int x, int y, int z) {
        for (int l1 = -1; l1 <= 1; ++l1) {
            for (int l2 = -1; l2 <= 1; ++l2) {
                for (int l3 = 0; l3 <= 1; ++l3) {
                    int bid = world.a(x + l1, y + l3, z + l2);
                    if (bid != 0) continue;
                    if (l3 != 0) {
                        OreSpawnMain.setBlockFast(world, x + l1, y + l3, z + l2, OreSpawnMain.MyCrystalLeaves3.cF, 0, 2);
                        continue;
                    }
                    OreSpawnMain.setBlockFast(world, x + l1, y + l3, z + l2, OreSpawnMain.MyCrystalLeaves2.cF, 0, 2);
                }
            }
        }
    }

    private void grow_crystal_branch(abw world, int x, int y, int z, int xdir, int zdir, int xxdir, int zzdir, int ydir) {
        int n;
        int i2 = 0;
        int k2 = 0;
        int j2 = 0;
        int i = x;
        int j = y;
        int k = z;
        int grow = 4 + world.s.nextInt(4);
        if (OreSpawnMain.LessLag == 1) {
            --grow;
        }
        if (OreSpawnMain.LessLag == 2) {
            grow -= 2;
        }
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i, j, k, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
            this.make_crystal_leaves(world, i, j, k);
            ++j;
            i2 = i += xdir;
            k2 = k += zdir;
        }
        grow = 5 + world.s.nextInt(5);
        if (OreSpawnMain.LessLag == 1) {
            --grow;
        }
        if (OreSpawnMain.LessLag == 2) {
            grow -= 2;
        }
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i, j, k, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
            this.make_crystal_leaves(world, i, j, k);
            i += xdir;
            k += zdir;
        }
        grow = 5 + world.s.nextInt(5);
        if (OreSpawnMain.LessLag == 1) {
            --grow;
        }
        if (OreSpawnMain.LessLag == 2) {
            grow -= 2;
        }
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i2, j, k2, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
            this.make_crystal_leaves(world, i2, j, k2);
            i2 += xxdir;
            k2 += zzdir;
        }
        j2 = --j;
        grow = 4 + world.s.nextInt(4);
        if (OreSpawnMain.LessLag == 1) {
            --grow;
        }
        if (OreSpawnMain.LessLag == 2) {
            grow -= 2;
        }
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i, j, k, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
            this.make_crystal_leaves(world, i, j, k);
            i += xdir;
            k += zdir;
            j += ydir;
        }
        grow = 4 + world.s.nextInt(4);
        if (OreSpawnMain.LessLag == 1) {
            --grow;
        }
        if (OreSpawnMain.LessLag == 2) {
            grow -= 2;
        }
        for (n = 0; n < grow; ++n) {
            OreSpawnMain.setBlockFast(world, i2, j2, k2, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
            this.make_crystal_leaves(world, i2, j2, k2);
            i2 += xxdir;
            k2 += zzdir;
            j2 += ydir;
        }
    }

    public void addSomething(abw world, int x, int y, int z) {
        int i = world.s.nextInt(3);
        if (i == 1) {
            world.f(x, y + 1, z, aqz.ax.cF, 0, 2);
            asj tileentitymobspawner = (asj)world.r(x, y + 1, z);
            if (tileentitymobspawner != null) {
                tileentitymobspawner.a().a("Fairy");
            }
        }
        if (i == 2) {
            world.f(x, y + 1, z, aqz.az.cF, 0, 2);
            ary chest = (ary)world.r(x, y + 1, z);
            if (chest != null) {
                mk.a((Random)world.s, (mk[])CrystalChestContentsList, (mo)chest, (int)(1 + world.s.nextInt(5)));
            }
        }
    }

    public void FairyCastleTree(abw world, int x, int y, int z) {
        int nc = 6;
        if (OreSpawnMain.LessLag == 1) {
            --nc;
        }
        if (OreSpawnMain.LessLag == 2) {
            nc -= 2;
        }
        int j = 3 + world.s.nextInt(3);
        int spread = 0;
        for (int iter = 0; iter < nc; ++iter) {
            int k;
            int i;
            int grow = 4 + world.s.nextInt(3);
            int width = 1 + world.s.nextInt(3);
            int randy = world.s.nextInt(3) - 1;
            for (i = -width; i <= width; ++i) {
                for (k = -width; k <= width; ++k) {
                    OreSpawnMain.setBlockFast(world, x + i + spread, y + j + randy, z + k, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
                    if (i == -width || i == width || k == -width || k == width) {
                        this.make_crystal_castle_leaves(world, x + i + spread, y + j + randy, z + k);
                    }
                    if (iter != 0 && i == 0 && k == 0) {
                        this.addSomething(world, x + i + spread, y + j + randy, z + k);
                    }
                    if (i == -width && (k == -width || k == width)) {
                        OreSpawnMain.setBlockFast(world, x + i + spread, y + j + randy + 1, z + k, OreSpawnMain.CrystalTorch.cF, 0, 2);
                    }
                    if (i != width || k != -width && k != width) continue;
                    OreSpawnMain.setBlockFast(world, x + i + spread, y + j + randy + 1, z + k, OreSpawnMain.CrystalTorch.cF, 0, 2);
                }
            }
            if (iter != 0) {
                width = 1 + world.s.nextInt(3 + iter);
                randy = world.s.nextInt(3) - 1;
                for (i = -width; i <= width; ++i) {
                    for (k = -width; k <= width; ++k) {
                        OreSpawnMain.setBlockFast(world, x + i - spread, y + j + randy, z + k, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
                        if (i == -width || i == width || k == -width || k == width) {
                            this.make_crystal_castle_leaves(world, x + i - spread, y + j + randy, z + k);
                        }
                        if (i == 0 && k == 0) {
                            this.addSomething(world, x + i - spread, y + j + randy, z + k);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            OreSpawnMain.setBlockFast(world, x + i - spread, y + j + randy + 1, z + k, OreSpawnMain.CrystalTorch.cF, 0, 2);
                        }
                        if (i != width || k != -width && k != width) continue;
                        OreSpawnMain.setBlockFast(world, x + i - spread, y + j + randy + 1, z + k, OreSpawnMain.CrystalTorch.cF, 0, 2);
                    }
                }
                width = 1 + world.s.nextInt(3 + iter);
                randy = world.s.nextInt(3) - 1;
                for (i = -width; i <= width; ++i) {
                    for (k = -width; k <= width; ++k) {
                        OreSpawnMain.setBlockFast(world, x + i, y + j + randy, z + k + spread, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
                        if (i == -width || i == width || k == -width || k == width) {
                            this.make_crystal_castle_leaves(world, x + i, y + j + randy, z + k + spread);
                        }
                        if (i == 0 && k == 0) {
                            this.addSomething(world, x + i, y + j + randy, z + k + spread);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            OreSpawnMain.setBlockFast(world, x + i, y + j + randy + 1, z + k + spread, OreSpawnMain.CrystalTorch.cF, 0, 2);
                        }
                        if (i != width || k != -width && k != width) continue;
                        OreSpawnMain.setBlockFast(world, x + i, y + j + randy + 1, z + k + spread, OreSpawnMain.CrystalTorch.cF, 0, 2);
                    }
                }
                width = 1 + world.s.nextInt(3 + iter);
                randy = world.s.nextInt(3) - 1;
                for (i = -width; i <= width; ++i) {
                    for (k = -width; k <= width; ++k) {
                        OreSpawnMain.setBlockFast(world, x + i, y + j + randy, z + k - spread, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
                        if (i == -width || i == width || k == -width || k == width) {
                            this.make_crystal_castle_leaves(world, x + i, y + j + randy, z + k - spread);
                        }
                        if (i == 0 && k == 0) {
                            this.addSomething(world, x + i, y + j + randy, z + k - spread);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            OreSpawnMain.setBlockFast(world, x + i, y + j + randy + 1, z + k - spread, OreSpawnMain.CrystalTorch.cF, 0, 2);
                        }
                        if (i != width || k != -width && k != width) continue;
                        OreSpawnMain.setBlockFast(world, x + i, y + j + randy + 1, z + k - spread, OreSpawnMain.CrystalTorch.cF, 0, 2);
                    }
                }
            }
            if (iter >= 2) {
                width = 1 + world.s.nextInt(3 + iter);
                randy = world.s.nextInt(3) - 1;
                for (i = -width; i <= width; ++i) {
                    for (k = -width; k <= width; ++k) {
                        OreSpawnMain.setBlockFast(world, x + i + spread, y + j + randy, z + k + spread, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
                        if (i == -width || i == width || k == -width || k == width) {
                            this.make_crystal_castle_leaves(world, x + i + spread, y + j + randy, z + k + spread);
                        }
                        if (i == 0 && k == 0) {
                            this.addSomething(world, x + i + spread, y + j + randy, z + k + spread);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            OreSpawnMain.setBlockFast(world, x + i + spread, y + j + randy + 1, z + k + spread, OreSpawnMain.CrystalTorch.cF, 0, 2);
                        }
                        if (i != width || k != -width && k != width) continue;
                        OreSpawnMain.setBlockFast(world, x + i + spread, y + j + randy + 1, z + k + spread, OreSpawnMain.CrystalTorch.cF, 0, 2);
                    }
                }
                width = 1 + world.s.nextInt(3 + iter);
                randy = world.s.nextInt(3) - 1;
                for (i = -width; i <= width; ++i) {
                    for (k = -width; k <= width; ++k) {
                        OreSpawnMain.setBlockFast(world, x + i - spread, y + j + randy, z + k - spread, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
                        if (i == -width || i == width || k == -width || k == width) {
                            this.make_crystal_castle_leaves(world, x + i - spread, y + j + randy, z + k - spread);
                        }
                        if (i == 0 && k == 0) {
                            this.addSomething(world, x + i - spread, y + j + randy, z + k - spread);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            OreSpawnMain.setBlockFast(world, x + i - spread, y + j + randy + 1, z + k - spread, OreSpawnMain.CrystalTorch.cF, 0, 2);
                        }
                        if (i != width || k != -width && k != width) continue;
                        OreSpawnMain.setBlockFast(world, x + i - spread, y + j + randy + 1, z + k - spread, OreSpawnMain.CrystalTorch.cF, 0, 2);
                    }
                }
                width = 1 + world.s.nextInt(3 + iter);
                randy = world.s.nextInt(3) - 1;
                for (i = -width; i <= width; ++i) {
                    for (k = -width; k <= width; ++k) {
                        OreSpawnMain.setBlockFast(world, x + i - spread, y + j + randy, z + k + spread, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
                        if (i == -width || i == width || k == -width || k == width) {
                            this.make_crystal_castle_leaves(world, x + i - spread, y + j + randy, z + k + spread);
                        }
                        if (i == 0 && k == 0) {
                            this.addSomething(world, x + i - spread, y + j + randy, z + k + spread);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            OreSpawnMain.setBlockFast(world, x + i - spread, y + j + randy + 1, z + k + spread, OreSpawnMain.CrystalTorch.cF, 0, 2);
                        }
                        if (i != width || k != -width && k != width) continue;
                        OreSpawnMain.setBlockFast(world, x + i - spread, y + j + randy + 1, z + k + spread, OreSpawnMain.CrystalTorch.cF, 0, 2);
                    }
                }
                width = 1 + world.s.nextInt(3 + iter);
                randy = world.s.nextInt(3) - 1;
                for (i = -width; i <= width; ++i) {
                    for (k = -width; k <= width; ++k) {
                        OreSpawnMain.setBlockFast(world, x + i + spread, y + j + randy, z + k - spread, OreSpawnMain.MyCrystalTreeLog.cF, 0, 2);
                        if (i == -width || i == width || k == -width || k == width) {
                            this.make_crystal_castle_leaves(world, x + i + spread, y + j + randy, z + k - spread);
                        }
                        if (i == 0 && k == 0) {
                            this.addSomething(world, x + i + spread, y + j + randy, z + k - spread);
                        }
                        if (i == -width && (k == -width || k == width)) {
                            OreSpawnMain.setBlockFast(world, x + i + spread, y + j + randy + 1, z + k - spread, OreSpawnMain.CrystalTorch.cF, 0, 2);
                        }
                        if (i != width || k != -width && k != width) continue;
                        OreSpawnMain.setBlockFast(world, x + i + spread, y + j + randy + 1, z + k - spread, OreSpawnMain.CrystalTorch.cF, 0, 2);
                    }
                }
            }
            j += grow;
            if (iter == 0) {
                spread = 3;
            }
            spread += grow;
        }
    }
}

