/*
 * Decompiled with CFR 0.152.
 */
package danger.orespawn;

import cpw.mods.fml.common.IWorldGenerator;
import danger.orespawn.ItemAppleSeed;
import danger.orespawn.ItemMagicApple;
import danger.orespawn.OreSpawnMain;
import danger.orespawn.Trees;
import java.util.Random;

public class OreSpawnWorld
implements IWorldGenerator {
    public static int recently_placed = 50;

    public void generate(Random random, int chunkX, int chunkZ, abw world, ado chunkGenerator, ado chunkProvider) {
        if (world.I) {
            return;
        }
        if (recently_placed > 0) {
            --recently_placed;
        }
        if (world.t.i == OreSpawnMain.DimensionID) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            if (!this.addHugeTree(world, random, chunkX * 16, chunkZ * 16)) {
                if (!this.addAppleTrees(world, random, chunkX * 16, chunkZ * 16) && !this.addOtherTrees(world, random, chunkX * 16, chunkZ * 16) && recently_placed == 0) {
                    this.addKingAltar(world, random, chunkX * 16, chunkZ * 16);
                }
                this.addVeggies(world, random, chunkX * 16, chunkZ * 16);
            }
            boolean rbd = false;
            rbd = this.addRubyDungeon(world, random, chunkX * 16, chunkZ * 16);
            if (!rbd) {
                this.addGenericDungeon(world, random, chunkX * 16, chunkZ * 16);
            }
            return;
        }
        if (world.t.i == OreSpawnMain.DimensionID2) {
            int i;
            this.generateRuby(world, random, chunkX * 16, chunkZ * 16);
            if (OreSpawnMain.LessOre == 0) {
                int randPosZ;
                int randPosY;
                int randPosX;
                this.generateRuby(world, random, chunkX * 16, chunkZ * 16);
                this.generateRuby(world, random, chunkX * 16, chunkZ * 16);
                for (i = 0; i < 45; ++i) {
                    randPosX = chunkX * 16 + random.nextInt(16);
                    randPosY = random.nextInt(128);
                    randPosZ = chunkZ * 16 + random.nextInt(16);
                    if (randPosY >= 50) continue;
                    new afq(aqz.S.cF, 7).a(world, random, randPosX, randPosY, randPosZ);
                }
                for (i = 0; i < 25; ++i) {
                    randPosX = chunkX * 16 + random.nextInt(16);
                    randPosY = random.nextInt(128);
                    randPosZ = chunkZ * 16 + random.nextInt(16);
                    if (randPosY >= 50) continue;
                    new afq(aqz.T.cF, 4).a(world, random, randPosX, randPosY, randPosZ);
                }
            }
            if (recently_placed == 0 && random.nextInt(95) == 1) {
                i = random.nextInt(7);
                if (i == 0) {
                    this.addBasiliskMaze(world, random, chunkX * 16, chunkZ * 16);
                }
                if (i == 1) {
                    this.addKyuubiDungeon(world, random, chunkX * 16, chunkZ * 16);
                }
                if (i == 2) {
                    this.addBeeHive(world, random, chunkX * 16, chunkZ * 16);
                }
                if (i == 3) {
                    this.addShadowDungeon(world, random, chunkX * 16, chunkZ * 16);
                }
                if (i == 4) {
                    this.addAlienWTF(world, random, chunkX * 16, chunkZ * 16);
                }
                if (i == 5) {
                    this.addEnderKnight(world, random, chunkX * 16, chunkZ * 16);
                }
                if (i == 6) {
                    this.addLeonNest(world, random, chunkX * 16, chunkZ * 16);
                }
            } else {
                this.addGenericDungeon(world, random, chunkX * 16, chunkZ * 16);
            }
            this.addLavaAndWater(world, random, chunkX * 16, chunkZ * 16);
            this.addAnts(world, random, chunkX * 16, chunkZ * 16, 2);
            this.addAnts(world, random, chunkX * 16, chunkZ * 16, 2);
            this.addMosquitos(world, random, chunkX * 16, chunkZ * 16);
            this.addMosquitos(world, random, chunkX * 16, chunkZ * 16);
            this.addVeggies(world, random, chunkX * 16, chunkZ * 16);
            this.addRocks(world, random, chunkX * 16, chunkZ * 16);
            return;
        }
        if (world.t.i == OreSpawnMain.DimensionID3) {
            if (OreSpawnMain.MosquitoEnable != 0) {
                this.addMosquitos(world, random, chunkX, chunkZ);
            }
            this.addAnts(world, random, chunkX * 16, chunkZ * 16, 4);
            this.addAppleTrees(world, random, chunkX * 16, chunkZ * 16);
            this.addGenericDungeon(world, random, chunkX * 16, chunkZ * 16);
            if (recently_placed == 0) {
                this.addDamselInDistress(world, random, chunkX * 16, chunkZ * 16);
            }
            if (recently_placed == 0) {
                this.addSpiderHangout(world, random, chunkX * 16, chunkZ * 16);
            }
            if (recently_placed == 0) {
                this.addRedAntHangout(world, random, chunkX * 16, chunkZ * 16);
            }
            return;
        }
        if (world.t.i == OreSpawnMain.DimensionID4) {
            int i;
            if (recently_placed == 0 && random.nextInt(100) == 0 && this.D4BigSpaceCheck(world, chunkX * 16, 7, chunkZ * 16)) {
                i = random.nextInt(19);
                if (i < 3) {
                    this.addD4Castle(world, random, chunkX * 16, chunkZ * 16);
                } else if (i < 7) {
                    this.addD4GenericDungeon(world, random, chunkX * 16, chunkZ * 16);
                } else {
                    if (i == 7) {
                        this.addD4EnderCastle(world, random, chunkX * 16, chunkZ * 16);
                    }
                    if (i == 8) {
                        this.addD4IncaPyramid(world, random, chunkX * 16, chunkZ * 16);
                    }
                    if (i == 9) {
                        this.addD4RobotLab(world, random, chunkX * 16, chunkZ * 16);
                    }
                    if (i == 10) {
                        this.addD4Mini(world, random, chunkX * 16, chunkZ * 16);
                    }
                    if (i == 11) {
                        this.addD4RubyDungeon(world, random, chunkX * 16, chunkZ * 16);
                    }
                    if (i == 12) {
                        this.addD4CephadromeAltar(world, random, chunkX * 16, chunkZ * 16);
                    }
                    if (i == 13) {
                        this.addD4Greenhouse(world, random, chunkX * 16, chunkZ * 16);
                    }
                    if (i == 14) {
                        this.addD4NightmareRookery(world, random, chunkX * 16, chunkZ * 16);
                    }
                    if (i == 15) {
                        this.addD4StinkyHouse(world, random, chunkX * 16, chunkZ * 16);
                    }
                    if (i == 16) {
                        this.addD4WhiteHouse(world, random, chunkX * 16, chunkZ * 16);
                    }
                    if (i == 17) {
                        this.addPumpkin(world, random, chunkX * 16, chunkZ * 16);
                    }
                    if (i == 18) {
                        this.addD4Rainbow(world, random, chunkX * 16, chunkZ * 16);
                    }
                }
            }
            if ((i = random.nextInt(300)) == 0) {
                this.addD4CloudShark(world, random, chunkX * 16, chunkZ * 16);
            }
            this.addUnstableAnts(world, random, chunkX * 16, chunkZ * 16);
            this.addIslands(world, random, chunkX * 16, chunkZ * 16);
            this.addD4Rocks(world, random, chunkX * 16, chunkZ * 16);
            return;
        }
        if (world.t.i == OreSpawnMain.DimensionID5) {
            if (!this.addFairyTree(world, random, chunkX * 16, chunkZ * 16)) {
                this.addCrystalTermites(world, random, chunkX * 16, chunkZ * 16);
                if (recently_placed == 0) {
                    if (!(this.addRotatorStation(world, random, chunkX * 16, chunkZ * 16) || this.addUrchinSpawner(world, random, chunkX * 16, chunkZ * 16) || this.addCrystalHauntedHouse(world, random, chunkX * 16, chunkZ * 16) || this.addRoundRotator(world, random, chunkX * 16, chunkZ * 16))) {
                        this.addCrystalBattleTower(world, random, chunkX * 16, chunkZ * 16);
                    }
                    this.addIrukandji(world, random, chunkX * 16, chunkZ * 16);
                }
            }
            this.addCrystalChestsAndSpawners(world, random, chunkX * 16, chunkZ * 16);
            if (world.s.nextInt(4) == 1) {
                this.addRocks(world, random, chunkX * 16, chunkZ * 16);
            }
            return;
        }
        if (world.t.i == OreSpawnMain.DimensionID6) {
            this.addButterfliesAndMoths(world, random, chunkX * 16, chunkZ * 16);
            this.addVeggies(world, random, chunkX * 16, chunkZ * 16);
            this.addAnts(world, random, chunkX * 16, chunkZ * 16, 2);
            return;
        }
        switch (world.t.i) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                this.generateOres(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
        }
    }

    private void generateEnd(abw world, Random random, int chunkX, int chunkZ) {
        this.addEndAnts(world, random, chunkX, chunkZ);
        int i = world.s.nextInt(4);
        if (i == 0) {
            this.addEndKnights(world, random, chunkX, chunkZ);
        }
        if (i == 1) {
            this.addEndReapers(world, random, chunkX, chunkZ);
        }
        if (i == 2) {
            this.addHospital(world, random, chunkX, chunkZ);
        }
        if (i == 3) {
            this.addEnderCastle(world, random, chunkX, chunkZ);
        }
    }

    private void generateNether(abw world, Random random, int chunkX, int chunkZ) {
        int randPosZ;
        int randPosY;
        int randPosX;
        int i;
        if (OreSpawnMain.MosquitoEnable != 0) {
            this.addNetherMosquitos(world, random, chunkX, chunkZ);
        }
        this.addNetherAnts(world, random, chunkX, chunkZ);
        int patchy = 15 + random.nextInt(10);
        if (OreSpawnMain.LessOre != 0) {
            patchy /= 3;
        }
        for (i = 0; i < patchy; ++i) {
            randPosX = 3 + chunkX + random.nextInt(13);
            randPosY = random.nextInt(108) + 10;
            randPosZ = 3 + chunkZ + random.nextInt(13);
            new afq(OreSpawnMain.MyLavafoamBlock.cF, 6, aqz.bg.cF).a(world, random, randPosX, randPosY, randPosZ);
        }
        patchy = 5 + random.nextInt(5);
        if (OreSpawnMain.LessOre != 0) {
            patchy /= 3;
        }
        for (i = 0; i < patchy; ++i) {
            randPosX = 3 + chunkX + random.nextInt(13);
            randPosY = random.nextInt(108) + 10;
            randPosZ = 3 + chunkZ + random.nextInt(13);
            new afq(OreSpawnMain.MyOreRubyBlock.cF, 2, aqz.bg.cF).a(world, random, randPosX, randPosY, randPosZ);
        }
    }

    public void generateSurface(abw world, Random random, int chunkX, int chunkZ) {
        boolean ahh2 = false;
        this.addStrawberries(world, random, chunkX, chunkZ);
        this.addCorn(world, random, chunkX, chunkZ);
        this.addTomatoes(world, random, chunkX, chunkZ);
        this.addVeggies(world, random, chunkX, chunkZ);
        this.addButterfliesAndMoths(world, random, chunkX, chunkZ);
        if (OreSpawnMain.MosquitoEnable != 0) {
            this.addMosquitos(world, random, chunkX, chunkZ);
        }
        if (OreSpawnMain.DisableOverworldDungeons == 0 && world.t.i == 0 && recently_placed == 0) {
            int i = world.s.nextInt(6);
            if (i == 0) {
                this.addPlayPool(world, random, chunkX, chunkZ);
            }
            if (i == 1) {
                this.addWaterDragonLair(world, random, chunkX, chunkZ);
            }
            if (i == 2) {
                this.addGoldFishBowl(world, random, chunkX, chunkZ);
            }
            if (i == 3) {
                this.addGirlfriendIsland(world, random, chunkX, chunkZ);
            }
            if (i == 4) {
                this.addMonsterIsland(world, random, chunkX, chunkZ);
            }
            if (i == 5) {
                this.addFrogPond(world, random, chunkX, chunkZ);
            }
            if (!(ahh2 = this.addANest(world, random, chunkX, chunkZ))) {
                ahh2 = this.addHauntedHouse(world, random, chunkX, chunkZ);
            }
            if (!ahh2) {
                ahh2 = this.addLeafMonster(world, random, chunkX, chunkZ);
            }
            if (!ahh2) {
                ahh2 = this.addSpitBug(world, random, chunkX, chunkZ);
            }
            if (!ahh2) {
                ahh2 = this.addIgloo(world, random, chunkX, chunkZ);
            }
            if (!ahh2) {
                ahh2 = this.addBouncyCastle(world, random, chunkX, chunkZ);
            }
            if (!ahh2) {
                ahh2 = this.addRubberDuckyPond(world, random, chunkX, chunkZ);
            }
        }
        this.addAnts(world, random, chunkX, chunkZ, 4);
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("River") || b.y.equals("Extreme Hills") || b.y.equals("Desert")) {
            this.addRocks(world, random, chunkX, chunkZ);
        }
    }

    public void generateRuby(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.Ruby_stats.rate <= 0) {
            return;
        }
        int patchy = OreSpawnMain.Ruby_stats.rate + random.nextInt(7);
        block0: for (int i = 0; i < patchy; ++i) {
            int randPosX = 3 + chunkX + random.nextInt(10);
            int randPosY = random.nextInt(128);
            int randPosZ = 3 + chunkZ + random.nextInt(10);
            if (randPosY > OreSpawnMain.Ruby_stats.maxdepth || randPosY < OreSpawnMain.Ruby_stats.mindepth) continue;
            for (int m = randPosY; m > 5; --m) {
                int bid = world.a(randPosX, m, randPosZ);
                if (bid != aqz.I.cF && bid != aqz.H.cF || (bid = world.a(randPosX, m - 1, randPosZ)) != aqz.y.cF) continue;
                OreSpawnMain.setBlockFast(world, randPosX, m - 1, randPosZ, OreSpawnMain.MyOreRubyBlock.cF, 0, 2);
                continue block0;
            }
        }
    }

    public void generateOres(abw world, Random random, int chunkX, int chunkZ) {
        int randPosZ;
        int randPosY;
        int randPosX;
        int i;
        int patchy;
        if (OreSpawnMain.SpawnOres_stats.rate > 0) {
            patchy = OreSpawnMain.SpawnOres_stats.rate + random.nextInt(20);
            if (random.nextInt(20) == 0) {
                patchy += 30;
            }
            if (OreSpawnMain.LessOre != 0) {
                patchy /= 3;
            }
            for (i = 0; i < patchy; ++i) {
                randPosX = 3 + chunkX + random.nextInt(10);
                randPosY = random.nextInt(128);
                randPosZ = 3 + chunkZ + random.nextInt(10);
                if (randPosY > OreSpawnMain.SpawnOres_stats.maxdepth || randPosY < OreSpawnMain.SpawnOres_stats.mindepth) continue;
                if (random.nextInt(104) < 7) {
                    new afq(OreSpawnMain.BaseBlockID + 300 + random.nextInt(7), OreSpawnMain.SpawnOres_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
                    continue;
                }
                new afq(OreSpawnMain.BaseBlockID + 0 + random.nextInt(97), OreSpawnMain.SpawnOres_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
            }
        }
        if (OreSpawnMain.Uranium_stats.rate > 0) {
            patchy = OreSpawnMain.Uranium_stats.rate + random.nextInt(9);
            if (OreSpawnMain.LessOre != 0) {
                patchy /= 3;
            }
            for (i = 0; i < patchy; ++i) {
                randPosX = 3 + chunkX + random.nextInt(10);
                randPosY = random.nextInt(128);
                randPosZ = 3 + chunkZ + random.nextInt(10);
                if (randPosY > OreSpawnMain.Uranium_stats.maxdepth || randPosY < OreSpawnMain.Uranium_stats.mindepth) continue;
                new afq(OreSpawnMain.MyOreUraniumBlock.cF, OreSpawnMain.Uranium_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
            }
        }
        if (OreSpawnMain.Titanium_stats.rate > 0) {
            patchy = OreSpawnMain.Titanium_stats.rate + random.nextInt(9);
            if (OreSpawnMain.LessOre != 0) {
                patchy /= 3;
            }
            for (i = 0; i < patchy; ++i) {
                randPosX = 3 + chunkX + random.nextInt(10);
                randPosY = random.nextInt(128);
                randPosZ = 3 + chunkZ + random.nextInt(10);
                if (randPosY > OreSpawnMain.Titanium_stats.maxdepth || randPosY < OreSpawnMain.Titanium_stats.mindepth) continue;
                new afq(OreSpawnMain.MyOreTitaniumBlock.cF, OreSpawnMain.Titanium_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
            }
        }
        if (OreSpawnMain.Amethyst_stats.rate > 0) {
            patchy = OreSpawnMain.Amethyst_stats.rate + random.nextInt(12);
            if (OreSpawnMain.LessOre != 0) {
                patchy /= 3;
            }
            for (i = 0; i < patchy; ++i) {
                randPosX = 3 + chunkX + random.nextInt(10);
                randPosY = random.nextInt(128);
                randPosZ = 3 + chunkZ + random.nextInt(10);
                if (randPosY > OreSpawnMain.Amethyst_stats.maxdepth || randPosY < OreSpawnMain.Amethyst_stats.mindepth) continue;
                new afq(OreSpawnMain.MyOreAmethystBlock.cF, OreSpawnMain.Amethyst_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
            }
        }
        if (OreSpawnMain.Salt_stats.rate > 0) {
            patchy = OreSpawnMain.Salt_stats.rate + random.nextInt(9);
            if (OreSpawnMain.LessOre != 0) {
                patchy /= 3;
            }
            for (i = 0; i < patchy; ++i) {
                randPosX = 3 + chunkX + random.nextInt(10);
                randPosY = random.nextInt(128);
                randPosZ = 3 + chunkZ + random.nextInt(10);
                if (randPosY > OreSpawnMain.Salt_stats.maxdepth || randPosY < OreSpawnMain.Salt_stats.mindepth) continue;
                new afq(OreSpawnMain.MyOreSaltBlock.cF, OreSpawnMain.Salt_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
            }
        }
        patchy = 4 + random.nextInt(4);
        if (OreSpawnMain.LessOre != 0) {
            patchy /= 2;
        }
        for (i = 0; i < patchy; ++i) {
            randPosX = 3 + chunkX + random.nextInt(10);
            randPosY = random.nextInt(128);
            randPosZ = 3 + chunkZ + random.nextInt(10);
            if (randPosY > 50 || randPosY < 5) continue;
            new afq(OreSpawnMain.RedAntTroll.cF, 4).a(world, random, randPosX, randPosY, randPosZ);
        }
        patchy = 4 + random.nextInt(4);
        if (OreSpawnMain.LessOre != 0) {
            patchy /= 2;
        }
        for (i = 0; i < patchy; ++i) {
            randPosX = 3 + chunkX + random.nextInt(10);
            randPosY = random.nextInt(128);
            randPosZ = 3 + chunkZ + random.nextInt(10);
            if (randPosY > 50 || randPosY < 5) continue;
            new afq(OreSpawnMain.TermiteTroll.cF, 4).a(world, random, randPosX, randPosY, randPosZ);
        }
        if (OreSpawnMain.Ruby_stats.rate > 0) {
            patchy = OreSpawnMain.Ruby_stats.rate + random.nextInt(5);
            block7: for (i = 0; i < patchy; ++i) {
                randPosX = 3 + chunkX + random.nextInt(10);
                randPosY = random.nextInt(128);
                randPosZ = 3 + chunkZ + random.nextInt(10);
                if (randPosY > OreSpawnMain.Ruby_stats.maxdepth || randPosY < OreSpawnMain.Ruby_stats.mindepth) continue;
                for (int m = randPosY; m > 5; --m) {
                    int bid = world.a(randPosX, m, randPosZ);
                    if (bid != aqz.I.cF && bid != aqz.H.cF || (bid = world.a(randPosX, m - 1, randPosZ)) != aqz.y.cF) continue;
                    OreSpawnMain.setBlockFast(world, randPosX, m - 1, randPosZ, OreSpawnMain.MyOreRubyBlock.cF, 0, 2);
                    continue block7;
                }
            }
        }
        if (OreSpawnMain.LessOre == 0) {
            if (OreSpawnMain.Diamond_stats.rate > 0) {
                for (i = 0; i < OreSpawnMain.Diamond_stats.rate; ++i) {
                    randPosX = 3 + chunkX + random.nextInt(10);
                    randPosY = random.nextInt(128);
                    randPosZ = 3 + chunkZ + random.nextInt(10);
                    if (randPosY > OreSpawnMain.Diamond_stats.maxdepth || randPosY < OreSpawnMain.Diamond_stats.mindepth) continue;
                    new afq(aqz.aB.cF, OreSpawnMain.Diamond_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
                }
            }
            if (OreSpawnMain.BlkDiamond_stats.rate > 0) {
                for (i = 0; i < OreSpawnMain.BlkDiamond_stats.rate; ++i) {
                    randPosX = 3 + chunkX + random.nextInt(10);
                    randPosY = random.nextInt(128);
                    randPosZ = 3 + chunkZ + random.nextInt(10);
                    if (randPosY > OreSpawnMain.BlkDiamond_stats.maxdepth || randPosY < OreSpawnMain.BlkDiamond_stats.mindepth) continue;
                    new afq(aqz.aC.cF, OreSpawnMain.BlkDiamond_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
                }
            }
            if (OreSpawnMain.Emerald_stats.rate > 0) {
                for (i = 0; i < OreSpawnMain.Emerald_stats.rate; ++i) {
                    randPosX = 3 + chunkX + random.nextInt(10);
                    randPosY = random.nextInt(128);
                    randPosZ = 3 + chunkZ + random.nextInt(10);
                    if (randPosY > OreSpawnMain.Emerald_stats.maxdepth || randPosY < OreSpawnMain.Emerald_stats.mindepth) continue;
                    new afq(aqz.bW.cF, OreSpawnMain.Emerald_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
                }
            }
            if (OreSpawnMain.BlkEmerald_stats.rate > 0) {
                for (i = 0; i < OreSpawnMain.BlkEmerald_stats.rate; ++i) {
                    randPosX = 3 + chunkX + random.nextInt(10);
                    randPosY = random.nextInt(128);
                    randPosZ = 3 + chunkZ + random.nextInt(10);
                    if (randPosY > OreSpawnMain.BlkEmerald_stats.maxdepth || randPosY < OreSpawnMain.BlkEmerald_stats.mindepth) continue;
                    new afq(aqz.ca.cF, OreSpawnMain.BlkEmerald_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
                }
            }
            if (OreSpawnMain.Gold_stats.rate > 0) {
                for (i = 0; i < OreSpawnMain.Gold_stats.rate; ++i) {
                    randPosX = 3 + chunkX + random.nextInt(10);
                    randPosY = random.nextInt(128);
                    randPosZ = 3 + chunkZ + random.nextInt(10);
                    if (randPosY > OreSpawnMain.Gold_stats.maxdepth || randPosY < OreSpawnMain.Gold_stats.mindepth) continue;
                    new afq(aqz.L.cF, OreSpawnMain.Gold_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
                }
            }
            if (OreSpawnMain.BlkGold_stats.rate > 0) {
                for (i = 0; i < OreSpawnMain.BlkGold_stats.rate; ++i) {
                    randPosX = 3 + chunkX + random.nextInt(10);
                    randPosY = random.nextInt(128);
                    randPosZ = 3 + chunkZ + random.nextInt(10);
                    if (randPosY > OreSpawnMain.BlkGold_stats.maxdepth || randPosY < OreSpawnMain.BlkGold_stats.mindepth) continue;
                    new afq(aqz.am.cF, OreSpawnMain.BlkGold_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
                }
            }
            if (OreSpawnMain.BlkRuby_stats.rate > 0) {
                for (i = 0; i < OreSpawnMain.BlkRuby_stats.rate; ++i) {
                    randPosX = 3 + chunkX + random.nextInt(10);
                    randPosY = random.nextInt(128);
                    randPosZ = 3 + chunkZ + random.nextInt(10);
                    if (randPosY > OreSpawnMain.BlkRuby_stats.maxdepth || randPosY < OreSpawnMain.BlkRuby_stats.mindepth) continue;
                    new afq(OreSpawnMain.MyBlockRubyBlock.cF, OreSpawnMain.BlkRuby_stats.clumpsize).a(world, random, randPosX, randPosY, randPosZ);
                }
            }
        }
    }

    public void addStrawberries(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(20) != 0) {
            return;
        }
        acq b = world.a(chunkX, chunkZ);
        if (world.t.i == OreSpawnMain.DimensionID || b.y.equals("Forest") || b.y.equals("ForestHills")) {
            block0: for (int i = 0; i < 5; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                for (int posY = 100; posY > 40 && world.c(posX, posY, posZ); --posY) {
                    if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyStrawberryPlant.cF, 0, 2);
                    continue block0;
                }
            }
        }
    }

    public boolean addHauntedHouse(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(285) != 0) {
            return false;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Plains") || b.y.equals("Taiga") || b.y.equals("Swampland")) {
            for (int i = 0; i < 5; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                for (int posY = 100; posY > 40 && world.c(posX, posY, posZ); --posY) {
                    if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    OreSpawnMain.MyDungeon.makeHauntedHouse(world, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean addANest(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(230) != 0) {
            return false;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Forest") || b.y.equals("ForestHills") || b.y.equals("Jungle") || b.y.equals("JungleHills")) {
            for (int i = 0; i < 5; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                for (int posY = 128; posY > 40 && world.c(posX, posY, posZ); --posY) {
                    if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    if (random.nextInt(2) == 0) {
                        OreSpawnMain.MyDungeon.makeSmallBeeHive(world, posX, posY, posZ);
                    } else {
                        OreSpawnMain.MyDungeon.makeMantisHive(world, posX, posY, posZ);
                    }
                    recently_placed = 50;
                    return true;
                }
            }
        }
        return false;
    }

    public void addCorn(abw world, Random random, int chunkX, int chunkZ) {
        boolean is_all_air = true;
        int nc = 6;
        if (random.nextInt(35) != 1) {
            return;
        }
        if (OreSpawnMain.LessLag == 1) {
            nc = 5;
        }
        if (OreSpawnMain.LessLag == 2) {
            nc = 3;
        }
        acq b = world.a(chunkX, chunkZ);
        if (world.t.i == OreSpawnMain.DimensionID || world.t.i == OreSpawnMain.DimensionID3 || b.y.equals("Plains")) {
            block0: for (int j = 0; j < nc; ++j) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                is_all_air = true;
                for (int posY = 100; posY > 40 && world.c(posX, posY, posZ); --posY) {
                    int i;
                    if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    for (i = 1; i < 10; ++i) {
                        if (world.c(posX, posY + i, posZ)) continue;
                        is_all_air = false;
                    }
                    if (!is_all_air) continue block0;
                    int corn_height = random.nextInt(5);
                    if (++corn_height == 1) {
                        OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyCornPlant1.cF, 0, 2);
                    }
                    if (corn_height == 2) {
                        OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyCornPlant2.cF, 0, 2);
                        OreSpawnMain.setBlockFast(world, posX, posY + 1, posZ, OreSpawnMain.MyCornPlant1.cF, 0, 2);
                    }
                    if (corn_height <= 2) continue block0;
                    OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyCornPlant2.cF, 0, 2);
                    for (i = 1; i < corn_height; ++i) {
                        OreSpawnMain.setBlockFast(world, posX, posY + i, posZ, OreSpawnMain.MyCornPlant4.cF, 0, 2);
                    }
                    OreSpawnMain.setBlockFast(world, posX, posY + corn_height, posZ, OreSpawnMain.MyCornPlant1.cF, 0, 2);
                    continue block0;
                }
            }
        }
    }

    public void addTomatoes(abw world, Random random, int chunkX, int chunkZ) {
        boolean is_all_air = true;
        if (random.nextInt(70) != 1) {
            return;
        }
        acq b = world.a(chunkX, chunkZ);
        if (world.t.i == OreSpawnMain.DimensionID || world.t.i == OreSpawnMain.DimensionID3 || b.y.equals("Plains")) {
            block0: for (int j = 0; j < 5; ++j) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                is_all_air = true;
                for (int posY = 100; posY > 40 && world.c(posX, posY, posZ); --posY) {
                    int i;
                    if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    for (i = 1; i < 10; ++i) {
                        if (world.c(posX, posY + i, posZ)) continue;
                        is_all_air = false;
                    }
                    if (!is_all_air) continue block0;
                    int corn_height = random.nextInt(3);
                    if (++corn_height == 1) {
                        OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyTomatoPlant1.cF, 0, 2);
                    }
                    if (corn_height == 2) {
                        OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyTomatoPlant2.cF, 0, 2);
                        OreSpawnMain.setBlockFast(world, posX, posY + 1, posZ, OreSpawnMain.MyTomatoPlant1.cF, 0, 2);
                    }
                    if (corn_height <= 2) continue block0;
                    OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyTomatoPlant3.cF, 0, 2);
                    for (i = 1; i < corn_height; ++i) {
                        OreSpawnMain.setBlockFast(world, posX, posY + i, posZ, OreSpawnMain.MyTomatoPlant4.cF, 0, 2);
                    }
                    OreSpawnMain.setBlockFast(world, posX, posY + corn_height, posZ, OreSpawnMain.MyTomatoPlant1.cF, 0, 2);
                    continue block0;
                }
            }
        }
    }

    public void addButterfliesAndMoths(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(10 + OreSpawnMain.LessLag * 2) != 0) {
            return;
        }
        acq b = world.a(chunkX, chunkZ);
        if (world.t.i == OreSpawnMain.DimensionID || world.t.i == OreSpawnMain.DimensionID6 || b.y.equals("Forest") || b.y.equals("ForestHills") || b.y.equals("River") || b.y.equals("Jungle") || b.y.equals("JungleHills") || b.y.equals("Swampland")) {
            block0: for (int i = 0; i < 4; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                int which = 0;
                for (int posY = 100; posY > 40 && world.c(posX, posY, posZ); --posY) {
                    if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    which = random.nextInt(3);
                    if (which == 0) {
                        OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyButterflyPlant.cF, 0, 2);
                        continue block0;
                    }
                    if (which == 1) {
                        OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyMothPlant.cF, 0, 2);
                        continue block0;
                    }
                    OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyFireflyPlant.cF, 0, 2);
                    continue block0;
                }
            }
        }
    }

    public void addPlayPool(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(350) != 0) {
            return;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Ocean")) {
            for (int i = 0; i < 4; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                boolean which = false;
                for (int posY = 100; posY > 40; --posY) {
                    if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.G.cF) continue;
                    OreSpawnMain.MyDungeon.makePlayPool(world, posX, posY, posZ);
                    recently_placed = 50;
                    return;
                }
            }
        }
    }

    public void addFrogPond(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(350) != 0) {
            return;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Plains")) {
            for (int i = 0; i < 4; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                boolean which = false;
                for (int posY = 100; posY > 40; --posY) {
                    if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    OreSpawnMain.MyDungeon.makeFrogPond(world, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return;
                }
            }
        }
    }

    public void addGoldFishBowl(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(350) != 0) {
            return;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Ocean")) {
            for (int i = 0; i < 4; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                boolean which = false;
                for (int posY = 100; posY > 40; --posY) {
                    if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.G.cF) continue;
                    OreSpawnMain.MyDungeon.makeGoldFishBowl(world, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return;
                }
            }
        }
    }

    public boolean addLeafMonster(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(275) != 0) {
            return false;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Plains")) {
            for (int i = 0; i < 4; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                boolean which = false;
                for (int posY = 100; posY > 40; --posY) {
                    if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    OreSpawnMain.MyDungeon.makeLeafMonsterDungeon(world, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean addRubberDuckyPond(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(275) != 0) {
            return false;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Plains")) {
            for (int i = 0; i < 4; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                boolean which = false;
                for (int posY = 100; posY > 40; --posY) {
                    if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    OreSpawnMain.MyDungeon.makeRubberDuckyPond(world, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean addSpitBug(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(190) != 0) {
            return false;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Swampland")) {
            for (int i = 0; i < 4; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                boolean which = false;
                for (int posY = 100; posY > 40; --posY) {
                    if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    OreSpawnMain.MyDungeon.makeSpitBugLair(world, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean addIgloo(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(220) != 0) {
            return false;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Ice Plains")) {
            for (int i = 0; i < 4; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                boolean which = false;
                for (int posY = 100; posY > 40; --posY) {
                    if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.aX.cF) continue;
                    OreSpawnMain.MyDungeon.makeIgloo(world, posX, posY - 2, posZ);
                    recently_placed = 50;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean addBouncyCastle(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(230) != 0) {
            return false;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Desert")) {
            for (int i = 0; i < 4; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                boolean which = false;
                for (int posY = 100; posY > 40; --posY) {
                    if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.J.cF) continue;
                    OreSpawnMain.MyDungeon.makeBouncyCastle(world, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean addDamselInDistress(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(250) != 0) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            boolean which = false;
            for (int posY = 100; posY > 40; --posY) {
                if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.z.cF || !this.quickSpaceCheck(world, posX, posY - 1, posZ)) continue;
                OreSpawnMain.MyDungeon.makeDamselInDistress(world, posX, posY - 1, posZ);
                recently_placed = 50;
                return true;
            }
        }
        return false;
    }

    public boolean addSpiderHangout(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(350) != 0) {
            return false;
        }
        if (OreSpawnMain.SpiderDriverEnable == 0) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            boolean which = false;
            for (int posY = 100; posY > 40; --posY) {
                if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.z.cF || !this.quickSpaceCheck(world, posX, posY - 1, posZ)) continue;
                OreSpawnMain.MyDungeon.makeSpiderHangout(world, posX, posY - 1, posZ);
                recently_placed = 50;
                return true;
            }
        }
        return false;
    }

    public boolean addRedAntHangout(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(250) != 0) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            boolean which = false;
            for (int posY = 100; posY > 40; --posY) {
                if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.z.cF || !this.quickSpaceCheck(world, posX, posY - 1, posZ)) continue;
                OreSpawnMain.MyDungeon.makeRedAntHangout(world, posX, posY - 1, posZ);
                recently_placed = 50;
                return true;
            }
        }
        return false;
    }

    public void addWaterDragonLair(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(350) != 0) {
            return;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Ocean")) {
            for (int i = 0; i < 4; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                boolean which = false;
                for (int posY = 100; posY > 40; --posY) {
                    if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.G.cF) continue;
                    OreSpawnMain.MyDungeon.makeWaterDragonLair(world, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return;
                }
            }
        }
    }

    public void addGirlfriendIsland(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(300) != 0) {
            return;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Ocean")) {
            for (int i = 0; i < 4; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                boolean which = false;
                for (int posY = 100; posY > 40; --posY) {
                    if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.G.cF) continue;
                    OreSpawnMain.MyDungeon.makeGirlfriendIsland(world, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return;
                }
            }
        }
    }

    public void addMonsterIsland(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(300) != 0) {
            return;
        }
        acq b = world.a(chunkX, chunkZ);
        if (b.y.equals("Ocean")) {
            for (int i = 0; i < 4; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                boolean which = false;
                for (int posY = 100; posY > 40; --posY) {
                    if (world.a(posX, posY, posZ) != 0 || world.a(posX, posY - 1, posZ) != aqz.G.cF) continue;
                    OreSpawnMain.MyDungeon.makeMonsterIsland(world, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return;
                }
            }
        }
    }

    public void addMosquitos(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(25 + OreSpawnMain.LessLag * 2) != 0) {
            return;
        }
        if ((world.t.i == OreSpawnMain.DimensionID || world.t.i == OreSpawnMain.DimensionID3) && random.nextInt(3) != 0) {
            return;
        }
        acq b = world.a(chunkX, chunkZ);
        if (world.t.i == OreSpawnMain.DimensionID || world.t.i == OreSpawnMain.DimensionID2 || world.t.i == OreSpawnMain.DimensionID3 || b.y.equals("Jungle") || b.y.equals("Swampland")) {
            block0: for (int i = 0; i < 2; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                for (int posY = 100; posY > 40 && world.c(posX, posY, posZ); --posY) {
                    if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyMosquitoPlant.cF, 0, 2);
                    continue block0;
                }
            }
        }
    }

    public void addNetherMosquitos(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(25) != 0) {
            return;
        }
        block0: for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 90; posY > 20; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != aqz.bg.cF) continue;
                OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyMosquitoPlant.cF, 0, 2);
                continue block0;
            }
        }
    }

    public void addNetherAnts(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.RedAntEnable == 0) {
            return;
        }
        if (random.nextInt(25) != 0) {
            return;
        }
        block0: for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 90; posY > 20; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != aqz.bg.cF) continue;
                OreSpawnMain.setBlockFast(world, posX, posY - 1, posZ, OreSpawnMain.MyRedAntBlock.cF, 0, 2);
                continue block0;
            }
        }
    }

    public void addAnts(abw world, Random random, int chunkX, int chunkZ, int redfreq) {
        if (OreSpawnMain.RedAntEnable == 0 && OreSpawnMain.BlackAntEnable == 0 && OreSpawnMain.RainbowAntEnable == 0 && OreSpawnMain.UnstableAntEnable == 0) {
            return;
        }
        if (redfreq < 2) {
            redfreq = 2;
        }
        if (random.nextInt(30 + OreSpawnMain.LessLag * 4) != 0) {
            return;
        }
        block0: for (int i = 0; i < 4; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 100; posY > 40 && world.c(posX, posY, posZ); --posY) {
                if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                if (random.nextInt(redfreq) == 0) {
                    int which = random.nextInt(4);
                    if (which == 0 && OreSpawnMain.RedAntEnable != 0) {
                        OreSpawnMain.setBlockFast(world, posX, posY - 1, posZ, OreSpawnMain.MyRedAntBlock.cF, 0, 2);
                    }
                    if (which == 1 && OreSpawnMain.RainbowAntEnable != 0) {
                        OreSpawnMain.setBlockFast(world, posX, posY - 1, posZ, OreSpawnMain.MyRainbowAntBlock.cF, 0, 2);
                    }
                    if (which == 2 && OreSpawnMain.UnstableAntEnable != 0) {
                        OreSpawnMain.setBlockFast(world, posX, posY - 1, posZ, OreSpawnMain.MyUnstableAntBlock.cF, 0, 2);
                    }
                    if (which != 3 || OreSpawnMain.TermiteEnable == 0) continue block0;
                    OreSpawnMain.setBlockFast(world, posX, posY - 1, posZ, OreSpawnMain.TermiteBlock.cF, 0, 2);
                    continue block0;
                }
                if (OreSpawnMain.BlackAntEnable == 0) continue block0;
                OreSpawnMain.setBlockFast(world, posX, posY - 1, posZ, OreSpawnMain.MyAntBlock.cF, 0, 2);
                continue block0;
            }
        }
    }

    public void addEndAnts(abw world, Random random, int chunkX, int chunkZ) {
    }

    public void addEndKnights(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(25) != 0) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 90; posY > 10; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != aqz.bO.cF || !this.quickSpaceCheck(world, posX, posY, posZ)) continue;
                OreSpawnMain.MyDungeon.makeEnderKnightDungeon(world, posX, posY, posZ);
                return;
            }
        }
    }

    public void addEndReapers(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(25) != 0) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 90; posY > 10; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != aqz.bO.cF || !this.quickSpaceCheck(world, posX, posY, posZ)) continue;
                OreSpawnMain.MyDungeon.makeEnderReaperGraveyard(world, posX, posY, posZ);
                return;
            }
        }
    }

    public void addHospital(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(25) != 0) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 90; posY > 10; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != aqz.bO.cF || !this.quickSpaceCheck(world, posX, posY, posZ)) continue;
                OreSpawnMain.MyDungeon.makeEnderDragonHospital(world, posX, posY, posZ);
                return;
            }
        }
    }

    public void addEnderCastle(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(50) != 0) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 90; posY > 10; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != aqz.bO.cF || !this.quickBigSpaceCheck(world, posX, posY, posZ)) continue;
                OreSpawnMain.MyDungeon.makeEnderCastle(world, posX, posY, posZ);
                return;
            }
        }
    }

    public void addUnstableAnts(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.UnstableAntEnable == 0) {
            return;
        }
        if (random.nextInt(30) != 0) {
            return;
        }
        block0: for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 20; posY > 2 && world.c(posX, posY, posZ); --posY) {
                if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                OreSpawnMain.setBlockFast(world, posX, posY - 1, posZ, OreSpawnMain.MyUnstableAntBlock.cF, 0, 2);
                continue block0;
            }
        }
    }

    public void addCrystalTermites(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.TermiteEnable == 0) {
            return;
        }
        if (random.nextInt(40) != 0) {
            return;
        }
        block0: for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 100; posY > 50; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != OreSpawnMain.CrystalGrass.cF) continue;
                OreSpawnMain.setBlockFast(world, posX, posY - 1, posZ, OreSpawnMain.CrystalTermiteBlock.cF, 0, 2);
                continue block0;
            }
        }
    }

    public boolean addRotatorStation(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.RotatorEnable == 0) {
            return false;
        }
        if (random.nextInt(150) != 0) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 100; posY > 50; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != OreSpawnMain.CrystalGrass.cF) continue;
                OreSpawnMain.MyDungeon.makeRotatorStation(world, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
        }
        return false;
    }

    public boolean addRoundRotator(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.RotatorEnable == 0) {
            return false;
        }
        if (random.nextInt(150) != 0) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 100; posY > 50; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != OreSpawnMain.CrystalGrass.cF) continue;
                OreSpawnMain.MyDungeon.makeRoundRotator(world, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
        }
        return false;
    }

    public boolean addUrchinSpawner(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.UrchinEnable == 0) {
            return false;
        }
        if (random.nextInt(180) != 0) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 100; posY > 50; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != OreSpawnMain.CrystalGrass.cF) continue;
                OreSpawnMain.MyDungeon.makeUrchinSpawner(world, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
        }
        return false;
    }

    public boolean addCrystalHauntedHouse(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(230) != 0) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 100; posY > 50; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != OreSpawnMain.CrystalGrass.cF) continue;
                OreSpawnMain.MyDungeon.makeCrystalHauntedHouse(world, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
        }
        return false;
    }

    public boolean addCrystalBattleTower(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(280) != 0) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 100; posY > 50; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != OreSpawnMain.CrystalGrass.cF) continue;
                OreSpawnMain.MyDungeon.makeCrystalBattleTower(world, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
        }
        return false;
    }

    public void addIrukandji(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.IrukandjiEnable == 0) {
            return;
        }
        if (random.nextInt(80) != 0) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 100; posY > 50; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != aqz.G.cF) continue;
                OreSpawnMain.setBlockFast(world, posX, posY, posZ, aqz.ax.cF, 0, 2);
                asj tileentitymobspawner = (asj)world.r(posX, posY, posZ);
                if (tileentitymobspawner != null) {
                    tileentitymobspawner.a().a("Irukandji");
                }
                return;
            }
        }
    }

    public void addCrystalChestsAndSpawners(abw world, Random random, int chunkX, int chunkZ) {
        int bid = 0;
        for (int i = 0; i < 3; ++i) {
            int posZ;
            int posY;
            int posX = 1 + chunkX + random.nextInt(14);
            if (!world.c(posX, posY = 25, posZ = 1 + chunkZ + random.nextInt(14))) continue;
            bid = world.a(posX, posY, posZ);
            if (bid != 0) break;
            bid = world.a(posX + 1, posY, posZ);
            if (bid == 0) {
                this.addCrystalChest(world, posX, posY, posZ, 5);
                break;
            }
            bid = world.a(posX - 1, posY, posZ);
            if (bid == 0) {
                this.addCrystalChest(world, posX, posY, posZ, 4);
                break;
            }
            bid = world.a(posX, posY, posZ + 1);
            if (bid == 0) {
                this.addCrystalChest(world, posX, posY, posZ, 2);
                break;
            }
            bid = world.a(posX, posY, posZ - 1);
            if (bid != 0) break;
            this.addCrystalChest(world, posX, posY, posZ, 3);
            break;
        }
    }

    public void addCrystalChest(abw world, int x, int y, int z, int dir) {
        int i = world.s.nextInt(3);
        if (i == 0) {
            OreSpawnMain.setBlockFast(world, x, y, z, aqz.az.cF, 0, 2);
            world.b(x, y, z, dir, 3);
            ary chest = (ary)world.r(x, y, z);
            if (chest != null) {
                mk.a((Random)world.s, (mk[])Trees.CrystalChestContentsList, (mo)chest, (int)(1 + world.s.nextInt(3)));
            }
        } else {
            OreSpawnMain.setBlockFast(world, x, y, z, aqz.ax.cF, 0, 2);
            asj tileentitymobspawner = (asj)world.r(x, y, z);
            if (tileentitymobspawner != null) {
                int t2 = world.s.nextInt(2);
                if (t2 == 0) {
                    tileentitymobspawner.a().a("Dungeon Beast");
                }
                if (t2 == 1) {
                    tileentitymobspawner.a().a("Rat");
                }
            }
        }
    }

    public void addIslands(abw world, Random random, int chunkX, int chunkZ) {
        int posX = 2 + chunkX + random.nextInt(12);
        int posZ = 2 + chunkZ + random.nextInt(12);
        if (random.nextInt(10 + OreSpawnMain.LessLag * 2) != 1) {
            return;
        }
        for (int posY = 20; posY > 2 && world.c(posX, posY, posZ); --posY) {
            if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
            OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyIslandBlock.cF, 0, 2);
            break;
        }
    }

    public boolean addAppleTrees(abw world, Random random, int chunkX, int chunkZ) {
        int freq = Math.abs(chunkX / 16) + Math.abs(chunkZ / 16);
        int howmany = 2;
        int which = 0;
        boolean added = false;
        howmany += random.nextInt(2 + (15 - (freq %= 15)) / 2);
        which = random.nextInt(10);
        if (random.nextInt(15 + freq) != 0) {
            return false;
        }
        if (OreSpawnMain.LessLag == 1) {
            howmany /= 2;
        }
        if (OreSpawnMain.LessLag == 2 && (howmany /= 4) < 1) {
            return false;
        }
        block0: for (int i = 0; i < howmany; ++i) {
            int posX = 2 + chunkX + random.nextInt(12);
            int posZ = 2 + chunkZ + random.nextInt(12);
            for (int posY = 100; posY > 50 && world.c(posX, posY, posZ); --posY) {
                if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                ItemAppleSeed a = (ItemAppleSeed)OreSpawnMain.MyAppleSeed;
                if (which < 8) {
                    a.makeTree(world, posX, posY - 1, posZ, OreSpawnMain.MyAppleLeaves.cF);
                }
                if (which == 8) {
                    a.makeTree(world, posX, posY - 1, posZ, OreSpawnMain.MyCherryLeaves.cF);
                }
                if (which == 9) {
                    a.makeTree(world, posX, posY - 1, posZ, OreSpawnMain.MyPeachLeaves.cF);
                }
                added = true;
                continue block0;
            }
        }
        return added;
    }

    public boolean addHugeTree(abw world, Random random, int chunkX, int chunkZ) {
        boolean made_one = false;
        if (random.nextInt(50) != 0) {
            return false;
        }
        if (OreSpawnMain.LessLag == 1 && random.nextInt(2) != 0) {
            return false;
        }
        if (OreSpawnMain.LessLag == 2 && random.nextInt(4) != 0) {
            return false;
        }
        block0: for (int i = 0; i < 3 && !made_one; ++i) {
            int posX = 4 + chunkX + random.nextInt(8);
            int posZ = 4 + chunkZ + random.nextInt(8);
            for (int posY = 127; posY > 50 && !made_one; --posY) {
                int rand_treetype;
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                ItemMagicApple a = (ItemMagicApple)OreSpawnMain.MagicApple;
                int tree_type = random.nextInt(4);
                int tree_radius = 6 - random.nextInt(2);
                boolean no_critters = false;
                int leaf_type = aqz.P.cF;
                if (random.nextInt(100) > 25) {
                    no_critters = true;
                }
                if ((rand_treetype = random.nextInt(100)) > 75) {
                    if (tree_type != 3 && random.nextInt(20) == 0) {
                        leaf_type = OreSpawnMain.MyAppleLeaves.cF;
                    }
                    a.MakeBigSquareTree(world, posX, posY - 1, posZ, aqz.O.cF, leaf_type, aqz.at.cF, tree_type, tree_radius, no_critters);
                } else if (rand_treetype == 0) {
                    tree_radius = 6;
                    no_critters = true;
                    if (random.nextInt(2) == 0) {
                        a.MakeBigSquareTree(world, posX, posY - 1, posZ, aqz.am.cF, aqz.ca.cF, aqz.aC.cF, -1, tree_radius, no_critters);
                    } else {
                        a.MakeBigSquareTree(world, posX, posY - 1, posZ, aqz.au.cF, OreSpawnMain.MyBlockRubyBlock.cF, OreSpawnMain.MyBlockAmethystBlock.cF, -1, tree_radius, no_critters);
                    }
                } else if (rand_treetype > 15) {
                    tree_radius = 6 - random.nextInt(3);
                    a.MakeBigCircularTree(world, posX, posY - 1, posZ, aqz.O.cF, leaf_type, aqz.at.cF, tree_type, tree_radius, no_critters);
                } else {
                    tree_radius = 6 - random.nextInt(3);
                    a.MakeBigRoundTree(world, posX, posY - 1, posZ, aqz.O.cF, leaf_type, aqz.at.cF, tree_type, tree_radius);
                }
                made_one = true;
                continue block0;
            }
        }
        return made_one;
    }

    public void addVeggies(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(15) != 0) {
            return;
        }
        acq b = world.a(chunkX, chunkZ);
        if (world.t.i == OreSpawnMain.DimensionID || world.t.i == OreSpawnMain.DimensionID2 || world.t.i == OreSpawnMain.DimensionID6 || b.y.equals("River") || b.y.equals("Swampland")) {
            block0: for (int i = 0; i < 8; ++i) {
                int posX = chunkX + random.nextInt(16);
                int posZ = chunkZ + random.nextInt(16);
                for (int posY = 100; posY > 40 && world.c(posX, posY, posZ); --posY) {
                    if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    int what = random.nextInt(6);
                    if (what == 0) {
                        OreSpawnMain.setBlockFast(world, posX, posY, posZ, aqz.ci.cF, 0, 2);
                        continue block0;
                    }
                    if (what == 1) {
                        OreSpawnMain.setBlockFast(world, posX, posY, posZ, aqz.cj.cF, 0, 2);
                        continue block0;
                    }
                    if (what == 2) {
                        OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyRadishPlant.cF, 0, 2);
                        continue block0;
                    }
                    if (what == 3) {
                        OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyLettucePlant1.cF, 0, 2);
                        continue block0;
                    }
                    if (what == 4) {
                        if (random.nextInt(10) != 0) continue block0;
                        OreSpawnMain.setBlockFast(world, posX, posY, posZ, aqz.bw.cF, 0, 2);
                        continue block0;
                    }
                    if (random.nextInt(50) != 1 || OreSpawnMain.enableduplicatortree == 0) continue block0;
                    OreSpawnMain.setBlockFast(world, posX, posY, posZ, OreSpawnMain.MyDT.cF, 0, 2);
                    continue block0;
                }
            }
        }
    }

    public void addRocks(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(5) != 0) {
            return;
        }
        if (OreSpawnMain.RockEnable == 0) {
            return;
        }
        int howmany = 3 + random.nextInt(10);
        block0: for (int i = 0; i < howmany; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 110; posY > 40 && world.a(posX, posY, posZ) == 0; --posY) {
                int bid = world.a(posX, posY - 1, posZ);
                if (bid != aqz.z.cF && bid != aqz.J.cF && bid != OreSpawnMain.CrystalGrass.cF) continue;
                this.spawnCreature(world, "Rock", posX, posY, posZ);
                continue block0;
            }
        }
    }

    public void addD4Rocks(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(7) != 0) {
            return;
        }
        if (OreSpawnMain.RockEnable == 0) {
            return;
        }
        int howmany = 3 + random.nextInt(10);
        block0: for (int i = 0; i < howmany; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 20; posY > 5 && world.a(posX, posY, posZ) == 0; --posY) {
                if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                this.spawnCreature(world, "Rock", posX, posY, posZ);
                continue block0;
            }
        }
    }

    public boolean addFairyTree(abw world, Random random, int chunkX, int chunkZ) {
        int posX = chunkX + 8;
        int posZ = chunkZ + 8;
        if (random.nextInt(5) != 0) {
            return false;
        }
        for (int posY = 128; posY > 40; --posY) {
            int bid;
            int j;
            int i;
            if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != OreSpawnMain.CrystalGrass.cF) continue;
            for (i = -8; i <= 8; ++i) {
                for (j = -8; j <= 8; ++j) {
                    bid = world.a(posX + i, posY, posZ + j);
                    if (bid == 0) continue;
                    return false;
                }
            }
            for (i = -2; i <= 2; ++i) {
                for (j = -2; j <= 2; ++j) {
                    bid = world.a(posX + i, posY - 1, posZ + j);
                    if (bid == OreSpawnMain.CrystalGrass.cF) continue;
                    return false;
                }
            }
            if (random.nextInt(5) != 1) {
                OreSpawnMain.OreSpawnTrees.FairyTree(world, posX, posY - 1, posZ);
            } else {
                OreSpawnMain.OreSpawnTrees.FairyCastleTree(world, posX, posY, posZ);
            }
            recently_placed = 50;
            break;
        }
        return true;
    }

    public boolean addRubyDungeon(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(15) != 0) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            int posX = chunkX + random.nextInt(8);
            int posZ = chunkZ + random.nextInt(8);
            for (int posY = 50; posY > 5; --posY) {
                if (world.a(posX, posY, posZ) != aqz.I.cF) continue;
                OreSpawnMain.RubyDungeon.makeDungeon(world, posX, posY, posZ);
                return true;
            }
        }
        return false;
    }

    public boolean addGenericDungeon(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(16) != 0) {
            return false;
        }
        if (OreSpawnMain.LessLag == 1 && random.nextInt(2) != 0) {
            return false;
        }
        if (OreSpawnMain.LessLag == 2 && random.nextInt(4) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(4);
        int posZ = chunkZ + random.nextInt(4);
        int posY = 5 + random.nextInt(40);
        OreSpawnMain.MyDungeon.makeDungeon(world, posX, posY, posZ);
        return true;
    }

    public boolean addBeeHive(abw world, Random random, int chunkX, int chunkZ) {
        int lowestY = 128;
        int lowestX = chunkX;
        int lowestZ = chunkZ;
        boolean found = false;
        for (int i = 0; i < 16; i += 3) {
            block1: for (int j = 0; j < 16; j += 3) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                for (int posY = 128; posY > 30; --posY) {
                    if (world.a(posX, posY + 1, posZ) != 0 || world.a(posX, posY, posZ) != aqz.z.cF) continue;
                    if (posY >= lowestY) continue block1;
                    lowestY = posY;
                    lowestX = posX;
                    lowestZ = posZ;
                    found = true;
                    continue block1;
                }
            }
        }
        if (found && lowestY > 40) {
            OreSpawnMain.MyDungeon.makeBeeHive(world, lowestX, lowestY + 3, lowestZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addAlienWTF(abw world, Random random, int chunkX, int chunkZ) {
        int lowestY = 128;
        int lowestX = chunkX;
        int lowestZ = chunkZ;
        boolean found = false;
        for (int i = 0; i < 16; i += 3) {
            block1: for (int j = 0; j < 16; j += 3) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                for (int posY = 128; posY > 30; --posY) {
                    if (world.a(posX, posY + 1, posZ) != 0 || world.a(posX, posY, posZ) != aqz.z.cF) continue;
                    if (posY >= lowestY) continue block1;
                    lowestY = posY;
                    lowestX = posX;
                    lowestZ = posZ;
                    found = true;
                    continue block1;
                }
            }
        }
        if (found && lowestY > 40) {
            OreSpawnMain.MyDungeon.makeAlienWTFDungeon(world, lowestX, lowestY, lowestZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addEnderKnight(abw world, Random random, int chunkX, int chunkZ) {
        int lowestY = 128;
        int lowestX = chunkX;
        int lowestZ = chunkZ;
        boolean found = false;
        for (int i = 0; i < 16; i += 3) {
            block1: for (int j = 0; j < 16; j += 3) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                for (int posY = 128; posY > 30; --posY) {
                    if (world.a(posX, posY + 1, posZ) != 0 || world.a(posX, posY, posZ) != aqz.z.cF) continue;
                    if (posY >= lowestY) continue block1;
                    lowestY = posY;
                    lowestX = posX;
                    lowestZ = posZ;
                    found = true;
                    continue block1;
                }
            }
        }
        if (found && lowestY > 40) {
            OreSpawnMain.MyDungeon.makeEnderKnightDungeon(world, lowestX, lowestY, lowestZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addLeonNest(abw world, Random random, int chunkX, int chunkZ) {
        int highestY = 30;
        int highestX = chunkX;
        int highestZ = chunkZ;
        boolean found = false;
        for (int i = 0; i < 16; i += 3) {
            block1: for (int j = 0; j < 16; j += 3) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                for (int posY = 128; posY > 80; --posY) {
                    if (world.a(posX, posY + 1, posZ) != 0 || world.a(posX, posY, posZ) != aqz.z.cF) continue;
                    if (posY <= highestY) continue block1;
                    highestY = posY + 1;
                    highestX = posX;
                    highestZ = posZ;
                    found = true;
                    continue block1;
                }
            }
        }
        if (found && highestY > 80) {
            OreSpawnMain.MyDungeon.makeLeonNest(world, highestX, highestY, highestZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addShadowDungeon(abw world, Random random, int chunkX, int chunkZ) {
        int lowestY = 128;
        int lowestX = chunkX;
        int lowestZ = chunkZ;
        boolean found = false;
        for (int i = 0; i < 16; i += 3) {
            block1: for (int j = 0; j < 16; j += 3) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                for (int posY = 128; posY > 30; --posY) {
                    if (world.a(posX, posY + 1, posZ) != 0 || world.a(posX, posY, posZ) != aqz.z.cF) continue;
                    if (posY >= lowestY) continue block1;
                    lowestY = posY;
                    lowestX = posX;
                    lowestZ = posZ;
                    found = true;
                    continue block1;
                }
            }
        }
        if (found && lowestY > 40) {
            OreSpawnMain.MyDungeon.makeShadowDungeon(world, lowestX, lowestY, lowestZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4RubyDungeon(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(2) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            OreSpawnMain.RubyDungeon.makeDungeon(world, posX, posY, posZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4CephadromeAltar(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(2) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            OreSpawnMain.MyDungeon.makeCephadromeAltar(world, posX, posY, posZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4Castle(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(2) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            for (int x = -20; x < 33; ++x) {
                for (int z = -4; z < 33; ++z) {
                    bid = world.a(posX + x, posY + 18, posZ + z);
                    if (bid == 0) continue;
                    return false;
                }
            }
            if (random.nextInt(2) == 1) {
                OreSpawnMain.MyDungeon.makeEnormousCastle(world, posX, posY, posZ);
            } else {
                OreSpawnMain.MyDungeon.makeEnormousCastleQ(world, posX, posY, posZ);
            }
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4Greenhouse(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(2) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            for (int x = -2; x < 25; ++x) {
                for (int z = -4; z < 25; ++z) {
                    bid = world.a(posX + x, posY + 18, posZ + z);
                    if (bid == 0) continue;
                    return false;
                }
            }
            OreSpawnMain.MyDungeon.makeGreenhouseDungeon(world, posX, posY, posZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4NightmareRookery(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(2) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            for (int x = -5; x < 25; ++x) {
                for (int z = -4; z < 5; ++z) {
                    bid = world.a(posX + x, posY + 18, posZ + z);
                    if (bid == 0) continue;
                    return false;
                }
            }
            OreSpawnMain.MyDungeon.makeNightmareRookery(world, posX, posY, posZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4StinkyHouse(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(2) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            for (int x = -8; x < 20; ++x) {
                for (int z = -8; z < 20; ++z) {
                    bid = world.a(posX + x, posY + 18, posZ + z);
                    if (bid == 0) continue;
                    return false;
                }
            }
            OreSpawnMain.MyDungeon.makeStinkyHouse(world, posX, posY, posZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4WhiteHouse(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(2) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            for (int x = -20; x < 30; ++x) {
                for (int z = -20; z < 300; ++z) {
                    bid = world.a(posX + x, posY + 18, posZ + z);
                    if (bid == 0) continue;
                    return false;
                }
            }
            OreSpawnMain.MyDungeon.makeWhiteHouse(world, posX, posY, posZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4EnderCastle(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(2) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            for (int x = -5; x < 25; ++x) {
                for (int z = -5; z < 25; ++z) {
                    bid = world.a(posX + x, posY + 18, posZ + z);
                    if (bid == 0) continue;
                    return false;
                }
            }
            OreSpawnMain.MyDungeon.makeEnderCastle(world, posX, posY, posZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4IncaPyramid(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(2) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            for (int x = -10; x < 50; ++x) {
                for (int z = -10; z < 40; ++z) {
                    bid = world.a(posX + x, posY + 18, posZ + z);
                    if (bid == 0) continue;
                    return false;
                }
            }
            OreSpawnMain.MyDungeon.makeIncaPyramid(world, posX, posY, posZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4RobotLab(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(2) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            for (int x = -5; x < 60; ++x) {
                for (int z = -5; z < 70; ++z) {
                    bid = world.a(posX + x, posY + 4, posZ + z);
                    if (bid == 0 || bid == aqz.O.cF || bid == OreSpawnMain.MyAppleLeaves.cF || bid == OreSpawnMain.MyScaryLeaves.cF || bid == 0) continue;
                    return false;
                }
            }
            OreSpawnMain.MyDungeon.makeRobotLab(world, posX, posY, posZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4Mini(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(2) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            OreSpawnMain.MyDungeon.makeMiniDungeon(world, posX, posY, posZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addPumpkin(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(2) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            OreSpawnMain.MyDungeon.makePumpkin(world, posX, posY + 1, posZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4CloudShark(abw world, Random random, int chunkX, int chunkZ) {
        int posX = 4 + chunkX + random.nextInt(8);
        int posZ = 4 + chunkZ + random.nextInt(8);
        OreSpawnMain.MyDungeon.makeCloudSharkDungeon(world, posX, 150 + world.s.nextInt(10), posZ);
        return true;
    }

    public boolean addD4Rainbow(abw world, Random random, int chunkX, int chunkZ) {
        int posX = 4 + chunkX + random.nextInt(8);
        int posZ = 4 + chunkZ + random.nextInt(8);
        OreSpawnMain.MyDungeon.makeRainbow(world, posX, 70 + world.s.nextInt(20), posZ);
        recently_placed = 50;
        return true;
    }

    public boolean addD4GenericDungeon(abw world, Random random, int chunkX, int chunkZ) {
        if (OreSpawnMain.LessLag != 0 && random.nextInt(4) != 0) {
            return false;
        }
        int posX = chunkX + random.nextInt(8);
        int posZ = chunkZ + random.nextInt(8);
        for (int posY = 20; posY > 4; --posY) {
            int bid = world.a(posX, posY, posZ);
            if (bid != aqz.z.cF) continue;
            OreSpawnMain.MyDungeon.makeDungeon(world, posX, posY, posZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public void addLavaAndWater(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(5) != 0) {
            return;
        }
        block0: for (int i = 0; i < 6; ++i) {
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            for (int posY = 128; posY > 75 && world.c(posX, posY, posZ); --posY) {
                if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                int bid = world.a(posX, posY - 2, posZ);
                if (bid != aqz.A.cF && bid != aqz.y.cF) continue block0;
                int air = 0;
                int non_air = 0;
                bid = world.a(posX + 1, posY - 1, posZ);
                if (bid == 0) {
                    ++air;
                }
                if (bid == aqz.A.cF || bid == aqz.y.cF || bid == aqz.z.cF) {
                    ++non_air;
                }
                if ((bid = world.a(posX - 1, posY - 1, posZ)) == 0) {
                    ++air;
                }
                if (bid == aqz.A.cF || bid == aqz.y.cF || bid == aqz.z.cF) {
                    ++non_air;
                }
                if ((bid = world.a(posX, posY - 1, posZ + 1)) == 0) {
                    ++air;
                }
                if (bid == aqz.A.cF || bid == aqz.y.cF || bid == aqz.z.cF) {
                    ++non_air;
                }
                if ((bid = world.a(posX, posY - 1, posZ - 1)) == 0) {
                    ++air;
                }
                if (bid == aqz.A.cF || bid == aqz.y.cF || bid == aqz.z.cF) {
                    ++non_air;
                }
                if (air == 0 || non_air == 0) continue block0;
                int what = random.nextInt(2);
                if (what == 0) {
                    OreSpawnMain.setBlockFast(world, posX, posY, posZ, aqz.F.cF, 0, 3);
                    OreSpawnMain.setBlockFast(world, posX, posY - 1, posZ, aqz.G.cF, 0, 3);
                    OreSpawnMain.setBlockFast(world, posX, posY - 2, posZ, aqz.G.cF, 0, 3);
                } else {
                    OreSpawnMain.setBlockFast(world, posX, posY, posZ, aqz.H.cF, 0, 3);
                    OreSpawnMain.setBlockFast(world, posX, posY - 1, posZ, aqz.I.cF, 0, 3);
                    OreSpawnMain.setBlockFast(world, posX, posY - 2, posZ, aqz.I.cF, 0, 3);
                }
                return;
            }
        }
    }

    public boolean addOtherTrees(abw world, Random random, int chunkX, int chunkZ) {
        int nc = 5;
        int count = 0;
        if (random.nextInt(30) != 0) {
            return false;
        }
        if (OreSpawnMain.LessLag == 1) {
            if (random.nextInt(2) != 0) {
                return false;
            }
            nc = 4;
        }
        if (OreSpawnMain.LessLag == 2) {
            if (random.nextInt(4) != 0) {
                return false;
            }
            nc = 3;
        }
        if (world.t.i == OreSpawnMain.DimensionID) {
            int dir = 0;
            int what = random.nextInt(2);
            block0: for (int i = 0; i < nc; ++i) {
                int posX = 3 + chunkX + random.nextInt(10);
                int posZ = 3 + chunkZ + random.nextInt(10);
                for (int posY = 100; posY > 50 && world.c(posX, posY, posZ); --posY) {
                    if (world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                    ++count;
                    if (what == 0) {
                        OreSpawnMain.OreSpawnTrees.WindTree(world, posX, posY - 1, posZ, dir);
                        if (count < 4) continue block0;
                        return true;
                    }
                    OreSpawnMain.OreSpawnTrees.SkyTree(world, posX, posY - 1, posZ);
                    if (count < 3) continue block0;
                    return true;
                }
            }
        }
        return count > 0;
    }

    public boolean addKingAltar(abw world, Random random, int chunkX, int chunkZ) {
        if (random.nextInt(2000) != 1) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            int posX = 3 + chunkX + random.nextInt(10);
            int posZ = 3 + chunkZ + random.nextInt(10);
            for (int posY = 100; posY > 50; --posY) {
                if (!world.c(posX, posY, posZ) || world.a(posX, posY - 1, posZ) != aqz.z.cF) continue;
                if (!this.quickReallyBigSpaceCheck(world, posX, posY - 1, posZ)) {
                    return false;
                }
                if (random.nextInt(2) == 0) {
                    OreSpawnMain.MyDungeon.makeKingAltar(world, posX, posY - 1, posZ);
                } else {
                    OreSpawnMain.MyDungeon.makeQueenAltar(world, posX, posY - 1, posZ);
                }
                recently_placed = 100;
                return true;
            }
        }
        return false;
    }

    public void addBasiliskMaze(abw world, Random random, int chunkX, int chunkZ) {
        int lowestY = 128;
        int lowestX = chunkX;
        int lowestZ = chunkZ;
        boolean found = false;
        for (int i = 0; i < 16; i += 3) {
            block1: for (int j = 0; j < 16; j += 3) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                for (int posY = 128; posY > 30; --posY) {
                    if (world.a(posX, posY + 1, posZ) != 0 || world.a(posX, posY, posZ) == 0) continue;
                    if (posY >= lowestY) continue block1;
                    lowestY = posY;
                    lowestX = posX;
                    lowestZ = posZ;
                    found = true;
                    continue block1;
                }
            }
        }
        if (found && lowestY > 40) {
            OreSpawnMain.BMaze.buildBasiliskMaze(world, lowestX, lowestY - 2, lowestZ);
            recently_placed = 50;
        }
    }

    public void addKyuubiDungeon(abw world, Random random, int chunkX, int chunkZ) {
        int lowestY = 128;
        int lowestX = chunkX;
        int lowestZ = chunkZ;
        boolean found = false;
        for (int i = 0; i < 16; i += 3) {
            block1: for (int j = 0; j < 16; j += 3) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                for (int posY = 128; posY > 30; --posY) {
                    if (world.a(posX, posY + 1, posZ) != 0 || world.a(posX, posY, posZ) == 0) continue;
                    if (posY >= lowestY) continue block1;
                    lowestY = posY;
                    lowestX = posX;
                    lowestZ = posZ;
                    found = true;
                    continue block1;
                }
            }
        }
        if (found && lowestY > 40) {
            OreSpawnMain.MyDungeon.makeKyuubiDungeon(world, lowestX, lowestY - 2, lowestZ);
            recently_placed = 50;
        }
    }

    private boolean quickSpaceCheck(abw world, int posX, int posY, int posZ) {
        for (int i = -2; i < 10; ++i) {
            for (int k = -2; k < 10; ++k) {
                if (world.a(posX + i, posY + 4, posZ + k) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean quickBigSpaceCheck(abw world, int posX, int posY, int posZ) {
        for (int i = -5; i < 25; ++i) {
            for (int k = -5; k < 25; ++k) {
                if (world.a(posX + i, posY + 8, posZ + k) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean quickReallyBigSpaceCheck(abw world, int posX, int posY, int posZ) {
        for (int i = -5; i < 55; ++i) {
            for (int k = -5; k < 55; ++k) {
                if (world.a(posX + i, posY + 8, posZ + k) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean D4BigSpaceCheck(abw world, int posX, int posY, int posZ) {
        for (int i = -25; i < 40; ++i) {
            for (int k = -25; k < 30; ++k) {
                int bid = world.a(posX + i, posY + 4, posZ + k);
                if (bid == 0 || bid == aqz.O.cF || bid == OreSpawnMain.MyAppleLeaves.cF || bid == OreSpawnMain.MyScaryLeaves.cF) continue;
                return false;
            }
        }
        return true;
    }

    private nn spawnCreature(abw par0World, String par1, double par2, double par4, double par6) {
        nn var8 = null;
        var8 = nt.a((String)par1, (abw)par0World);
        if (var8 != null) {
            if (par2 > 0.0) {
                par2 += 0.5;
            }
            if (par2 < 0.0) {
                par2 -= 0.5;
            }
            if (par6 > 0.0) {
                par6 += 0.5;
            }
            if (par6 < 0.0) {
                par6 -= 0.5;
            }
            var8.b(par2, par4 + 0.01, par6, par0World.s.nextFloat() * 360.0f, 0.0f);
            par0World.d(var8);
            ((og)var8).p();
        }
        return var8;
    }
}

