/*
 * Decompiled with CFR 0.152.
 */
package danger.orespawn;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import danger.orespawn.IPacketHandlerSubscriber;
import danger.orespawn.MovementInputProxy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MovementInputPacketHandler
implements IPacketHandlerSubscriber {
    public static final String CHANNEL = "PlayerMoveInput";
    private static final MovementInputPacketHandler INSTANCE = new MovementInputPacketHandler();
    private Map<uf, MovementInputProxy> moveMap = new HashMap<uf, MovementInputProxy>();

    public static MovementInputPacketHandler getInstance() {
        return INSTANCE;
    }

    private MovementInputPacketHandler() {
    }

    public void onPacketData(cm manager, ea packet, Player player) {
        MovementInputProxy input;
        if (!packet.a.equals(CHANNEL)) {
            throw new IllegalArgumentException("Wrong channel");
        }
        uf playerEnt = (uf)player;
        if (!this.moveMap.containsKey(playerEnt)) {
            input = new MovementInputProxy();
            this.moveMap.put(playerEnt, input);
        } else {
            input = this.moveMap.get(playerEnt);
        }
        this.unpack(packet.c, input);
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerMovementChanged(bex player) {
        byte[] data = this.pack(player.c);
        ea packet = new ea(CHANNEL, data);
        PacketDispatcher.sendPacketToServer((ey)packet);
    }

    @Override
    public String getChannel() {
        return CHANNEL;
    }

    public MovementInputProxy getMovementInputForPlayer(uf player) {
        return this.moveMap.get(player);
    }

    @SideOnly(value=Side.CLIENT)
    public byte[] pack(bev input) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        byte[] b = null;
        try {
            dos.writeFloat(input.b);
            dos.writeFloat(input.a);
            dos.writeBoolean(input.c);
            dos.writeBoolean(input.d);
            dos.close();
            b = bos.toByteArray();
            bos.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return b;
    }

    public MovementInputProxy unpack(byte[] data, MovementInputProxy input) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bis);
        try {
            input.moveForward = dis.readFloat();
            input.moveStrafe = dis.readFloat();
            input.jump = dis.readBoolean();
            input.sneak = dis.readBoolean();
            float f = input.moveForward < -1.0f ? -1.0f : (input.moveForward = input.moveForward > 1.0f ? 1.0f : input.moveForward);
            input.moveStrafe = input.moveStrafe < -1.0f ? -1.0f : (input.moveStrafe > 1.0f ? 1.0f : input.moveStrafe);
            dis.close();
            bis.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return input;
    }
}

