/*
 * Decompiled with CFR 0.152.
 */
package danger.orespawn;

import danger.orespawn.Basilisk;
import danger.orespawn.OreSpawnMain;
import java.awt.Point;
import java.util.Random;
import java.util.Vector;

public class BasiliskMaze {
    public static final int WTOP = 1;
    public static final int WRGT = 2;
    public static final int WBOT = 4;
    public static final int WLFT = 8;
    private final mk[] chestContentsList;

    public BasiliskMaze() {
        this.chestContentsList = new mk[]{new mk(yc.bp.cv, 0, 3, 6, 15), new mk(yc.p.cv, 0, 15, 25, 20), new mk(yc.bq.cv, 0, 4, 12, 15), new mk(OreSpawnMain.CageEmpty.cv, 0, 3, 10, 20), new mk(OreSpawnMain.CagedGirlfriend.cv, 0, 2, 4, 15), new mk(yc.q.cv, 0, 2, 20, 20), new mk(yc.r.cv, 0, 4, 16, 20), new mk(OreSpawnMain.MyIngotUranium.cv, 0, 1, 2, 5), new mk(OreSpawnMain.MyIngotTitanium.cv, 0, 1, 2, 5), new mk(OreSpawnMain.MySunFish.cv, 0, 2, 8, 20), new mk(OreSpawnMain.MyFireFish.cv, 0, 3, 8, 20), new mk(OreSpawnMain.MyLavaEel.cv, 0, 5, 24, 20), new mk(OreSpawnMain.MyCornDog.cv, 0, 6, 12, 20), new mk(yc.D.cv, 0, 1, 1, 15), new mk(yc.B.cv, 0, 1, 1, 15), new mk(OreSpawnMain.MyUltimatePickaxe.cv, 0, 1, 1, 15), new mk(OreSpawnMain.MyUltimateSword.cv, 0, 1, 1, 15), new mk(OreSpawnMain.MyUltimateFishingRod.cv, 0, 1, 1, 15), new mk(OreSpawnMain.MyUltimateBow.cv, 0, 1, 1, 15), new mk(yc.ak.cv, 0, 1, 1, 15), new mk(yc.aj.cv, 0, 1, 1, 15), new mk(yc.al.cv, 0, 1, 1, 15), new mk(yc.am.cv, 0, 1, 1, 15), new mk(OreSpawnMain.UltimateBody.cv, 0, 1, 1, 10), new mk(OreSpawnMain.UltimateLegs.cv, 0, 1, 1, 10), new mk(OreSpawnMain.UltimateHelmet.cv, 0, 1, 1, 10), new mk(OreSpawnMain.UltimateBoots.cv, 0, 1, 1, 10), new mk(OreSpawnMain.MyRuby.cv, 0, 1, 1, 5), new mk(OreSpawnMain.MyThunderStaff.cv, 0, 1, 1, 5), new mk(OreSpawnMain.MagicApple.cv, 0, 1, 1, 15), new mk(yc.av.cv, 0, 2, 4, 15)};
    }

    public void buildBasiliskMaze(abw world, int x, int y, int z) {
        int depth = 20 + world.s.nextInt(10);
        this.clearArea(world, x + 3, y - depth - 4, z - 20);
        this.makeMaze(world, x + 3, y - depth - 3, z - 20, 10, 10, 3, 0);
        this.openMaze(world, x + 3, y - depth - 3, z - 20, 10, 10, 3);
        this.buildCastle(world, x + 3, y - depth - 4, z - 20);
        this.makeEntrance(world, x, y, z, depth);
    }

    private void makeMaze(abw world, int xx2, int yy2, int zz, int xw, int zw, int csz, int b) {
        int y;
        int x;
        int gridw = xw;
        int gridh = zw;
        int cellsize = csz;
        if (cellsize < 3) {
            cellsize = 3;
        }
        int[][] cells = new int[gridw][gridh];
        int full = 15;
        for (x = 0; x < gridw; ++x) {
            for (y = 0; y < gridh; ++y) {
                cells[x][y] = full;
            }
        }
        int left = 128;
        int right = 32;
        y = 0;
        while (y < gridh) {
            int[] nArray = cells[0];
            int n = y;
            nArray[n] = nArray[n] | left;
            int[] nArray2 = cells[gridw - 1];
            int n2 = y++;
            nArray2[n2] = nArray2[n2] | right;
        }
        int top = 16;
        int bottom = 64;
        for (x = 0; x < gridw; ++x) {
            int[] nArray = cells[x];
            nArray[0] = nArray[0] | top;
            int[] nArray3 = cells[x];
            int n = gridh - 1;
            nArray3[n] = nArray3[n] | bottom;
        }
        Vector<Point> outlist = new Vector<Point>(gridw * gridh);
        Vector<Point> inlist = new Vector<Point>(10, 10);
        Vector frontlist = new Vector(10, 10);
        for (x = 0; x < gridw; ++x) {
            for (y = 0; y < gridh; ++y) {
                outlist.addElement(new Point(x, y));
            }
        }
        Point current_cell = (Point)this.rndElement(outlist);
        inlist.addElement(current_cell);
        this.moveNbrs(current_cell, cells, outlist, frontlist);
        while (!frontlist.isEmpty()) {
            current_cell = (Point)this.rndElement(frontlist);
            inlist.addElement(current_cell);
            this.moveNbrs(current_cell, cells, outlist, frontlist);
            int dir = this.findInNbr(current_cell, cells, inlist);
            this.removeWall(current_cell, dir, cells);
        }
        current_cell = null;
        for (x = 0; x < gridw; ++x) {
            for (y = 0; y < gridh; ++y) {
                int val = cells[x][y];
                if ((val & 1) != 0) {
                    this.drawSide(world, x * cellsize, y * cellsize, (x + 1) * cellsize, y * cellsize, xx2, yy2, zz, cellsize, gridh, gridw, b);
                }
                if ((val & 2) != 0) {
                    this.drawSide(world, (x + 1) * cellsize - 1, y * cellsize, (x + 1) * cellsize - 1, (y + 1) * cellsize, xx2, yy2, zz, cellsize, gridh, gridw, b);
                }
                if ((val & 4) != 0) {
                    this.drawSide(world, x * cellsize, (y + 1) * cellsize - 1, (x + 1) * cellsize, (y + 1) * cellsize - 1, xx2, yy2, zz, cellsize, gridh, gridw, b);
                }
                if ((val & 8) == 0) continue;
                this.drawSide(world, x * cellsize, y * cellsize, x * cellsize, (y + 1) * cellsize, xx2, yy2, zz, cellsize, gridh, gridw, b);
            }
        }
    }

    private void drawSide(abw world, int fromx, int fromz, int tox, int toz, int x, int y, int z, int cellsize, int gridh, int gridw, int bb) {
        int i;
        int blk = aqz.au.cF;
        if (bb != 0) {
            blk = aqz.E.cF;
        }
        if (fromx > tox) {
            i = fromx;
            fromx = tox;
            tox = i;
        }
        if (fromz > toz) {
            i = fromz;
            fromz = toz;
            toz = i;
        }
        if (fromx == tox) {
            i = fromx;
            for (int j = fromz; j <= toz; ++j) {
                if (j >= cellsize * gridh) continue;
                OreSpawnMain.setBlockFast(world, i + x, y, j + z, blk, 0, 2);
                OreSpawnMain.setBlockFast(world, i + x, y + 1, j + z, blk, 0, 2);
                OreSpawnMain.setBlockFast(world, i + x, y + 2, j + z, blk, 0, 2);
            }
        } else {
            int j = fromz;
            for (i = fromx; i <= tox; ++i) {
                if (i >= cellsize * gridw) continue;
                OreSpawnMain.setBlockFast(world, i + x, y, j + z, blk, 0, 2);
                OreSpawnMain.setBlockFast(world, i + x, y + 1, j + z, blk, 0, 2);
                OreSpawnMain.setBlockFast(world, i + x, y + 2, j + z, blk, 0, 2);
            }
        }
    }

    private int findInNbr(Point p, int[][] cells, Vector inlist) {
        int d = this.rnd(4) - 1;
        for (int k = 0; k < 4; ++k) {
            switch (d) {
                case 0: {
                    if ((cells[p.x][p.y] & 0x10) != 0 || inlist.indexOf(new Point(p.x, p.y - 1)) < 0) break;
                    return 1;
                }
                case 1: {
                    if ((cells[p.x][p.y] & 0x20) != 0 || inlist.indexOf(new Point(p.x + 1, p.y)) < 0) break;
                    return 2;
                }
                case 2: {
                    if ((cells[p.x][p.y] & 0x40) != 0 || inlist.indexOf(new Point(p.x, p.y + 1)) < 0) break;
                    return 4;
                }
                case 3: {
                    if ((cells[p.x][p.y] & 0x80) != 0 || inlist.indexOf(new Point(p.x - 1, p.y)) < 0) break;
                    return 8;
                }
            }
            d = (d + 1) % 4;
        }
        return 0;
    }

    private void moveNbrs(Point p, int[][] cells, Vector outlist, Vector frontlist) {
        Point s;
        if ((cells[p.x][p.y] & 0x10) == 0) {
            s = new Point(p.x, p.y - 1);
            this.movePoint(s, outlist, frontlist);
        }
        if ((cells[p.x][p.y] & 0x20) == 0) {
            s = new Point(p.x + 1, p.y);
            this.movePoint(s, outlist, frontlist);
        }
        if ((cells[p.x][p.y] & 0x40) == 0) {
            s = new Point(p.x, p.y + 1);
            this.movePoint(s, outlist, frontlist);
        }
        if ((cells[p.x][p.y] & 0x80) == 0) {
            s = new Point(p.x - 1, p.y);
            this.movePoint(s, outlist, frontlist);
        }
    }

    private void movePoint(Point p, Vector v, Vector w) {
        int i = v.indexOf(p);
        if (i >= 0) {
            v.removeElementAt(i);
            w.addElement(p);
        }
    }

    private void removeWall(Point p, int d, int[][] cells) {
        int[] nArray = cells[p.x];
        int n = p.y;
        nArray[n] = nArray[n] ^ d;
        switch (d) {
            case 1: {
                int[] nArray2 = cells[p.x];
                int n2 = p.y - 1;
                nArray2[n2] = nArray2[n2] ^ 4;
                break;
            }
            case 2: {
                int[] nArray3 = cells[p.x + 1];
                int n3 = p.y;
                nArray3[n3] = nArray3[n3] ^ 8;
                break;
            }
            case 4: {
                int[] nArray4 = cells[p.x];
                int n4 = p.y + 1;
                nArray4[n4] = nArray4[n4] ^ 1;
                break;
            }
            case 8: {
                int[] nArray5 = cells[p.x - 1];
                int n5 = p.y;
                nArray5[n5] = nArray5[n5] ^ 2;
            }
        }
    }

    private int rnd(int n) {
        return (int)(Math.random() * (double)n + 1.0);
    }

    private Object rndElement(Vector v) {
        int i = this.rnd(v.size()) - 1;
        Object s = v.elementAt(i);
        v.removeElementAt(i);
        return s;
    }

    private nn spawnCreature(abw par0World, String par1, double par2, double par4, double par6) {
        nn var8 = null;
        var8 = nt.a((String)par1, (abw)par0World);
        if (var8 != null) {
            var8.b(par2, par4, par6, par0World.s.nextFloat() * 360.0f, 0.0f);
            par0World.d(var8);
            ((og)var8).p();
        }
        return var8;
    }

    private void clearArea(abw world, int x, int y, int z) {
        int k;
        int j;
        int i;
        for (i = 0; i < 60; ++i) {
            int hi = 5;
            if (i >= 30) {
                hi = 7;
            }
            for (j = 0; j < hi; ++j) {
                for (k = 0; k < 30; ++k) {
                    OreSpawnMain.setBlockFast(world, x + i, y + j, z + k, 0, 0, 2);
                }
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 6; ++j) {
                for (k = 0; k < 30; ++k) {
                    OreSpawnMain.setBlockFast(world, x - i, y + j, z + k, 0, 0, 2);
                }
            }
        }
    }

    private void openMaze(abw world, int xx2, int yy2, int zz, int xw, int zw, int csz) {
        int bid;
        int i;
        for (i = 0; i < zw * csz; ++i) {
            bid = world.a(xx2 + 1, yy2, zz + i);
            if (bid != 0) continue;
            OreSpawnMain.setBlockFast(world, xx2, yy2, zz + i, 0, 0, 2);
            OreSpawnMain.setBlockFast(world, xx2, yy2 + 1, zz + i, 0, 0, 2);
            OreSpawnMain.setBlockFast(world, xx2, yy2 + 2, zz + i, 0, 0, 2);
            break;
        }
        for (i = zw * csz - 1; i >= 0; --i) {
            bid = world.a(xx2 + xw * csz - 2, yy2, zz + i);
            if (bid != 0) continue;
            OreSpawnMain.setBlockFast(world, xx2 + xw * csz - 1, yy2, zz + i, 0, 0, 2);
            OreSpawnMain.setBlockFast(world, xx2 + xw * csz - 1, yy2 + 1, zz + i, 0, 0, 2);
            OreSpawnMain.setBlockFast(world, xx2 + xw * csz - 1, yy2 + 2, zz + i, 0, 0, 2);
            break;
        }
    }

    private void buildCastle(abw world, int x, int y, int z) {
        Basilisk b;
        int k;
        int i;
        for (i = 0; i < 60; ++i) {
            for (k = 0; k < 30; ++k) {
                OreSpawnMain.setBlockFast(world, x + i, y, z + k, aqz.au.cF, 0, 2);
            }
        }
        for (i = 0; i < 80; ++i) {
            OreSpawnMain.setBlockFast(world, x + world.s.nextInt(28) + 1, y, z + world.s.nextInt(28) + 1, aqz.I.cF, 0, 2);
        }
        for (i = 0; i < 20; ++i) {
            OreSpawnMain.setBlockFast(world, x + 30 + world.s.nextInt(28) + 1, y, z + world.s.nextInt(28) + 1, OreSpawnMain.MyRTPBlock.cF, 0, 2);
        }
        for (i = 0; i < 30; ++i) {
            for (k = 0; k < 30; ++k) {
                OreSpawnMain.setBlockFast(world, x + i, y + 4, z + k, aqz.E.cF, 0, 2);
            }
        }
        for (i = 0; i < 30; ++i) {
            for (k = 0; k < 30; ++k) {
                OreSpawnMain.setBlockFast(world, x + i + 30, y + 6, z + k, aqz.E.cF, 0, 2);
            }
        }
        for (i = 0; i < 30; ++i) {
            for (k = 0; k < 5; ++k) {
                OreSpawnMain.setBlockFast(world, x + 59, y + k + 1, z + i, aqz.au.cF, 0, 2);
                OreSpawnMain.setBlockFast(world, x + 60, y + k + 1, z + i, aqz.E.cF, 0, 2);
                OreSpawnMain.setBlockFast(world, x + 61, y + k + 1, z + i, aqz.E.cF, 0, 2);
            }
        }
        for (i = 0; i < 30; ++i) {
            for (k = 0; k < 5; ++k) {
                OreSpawnMain.setBlockFast(world, x + 30 + i, y + k + 1, z, aqz.au.cF, 0, 2);
                OreSpawnMain.setBlockFast(world, x + 30 + i, y + k + 1, z - 1, aqz.E.cF, 0, 2);
                OreSpawnMain.setBlockFast(world, x + 30 + i, y + k + 1, z - 2, aqz.E.cF, 0, 2);
            }
        }
        for (i = 0; i < 30; ++i) {
            for (k = 0; k < 5; ++k) {
                OreSpawnMain.setBlockFast(world, x + 30 + i, y + k + 1, z + 29, aqz.au.cF, 0, 2);
                OreSpawnMain.setBlockFast(world, x + 30 + i, y + k + 1, z + 30, aqz.E.cF, 0, 2);
                OreSpawnMain.setBlockFast(world, x + 30 + i, y + k + 1, z + 31, aqz.E.cF, 0, 2);
            }
        }
        for (i = 0; i < 30; ++i) {
            OreSpawnMain.setBlockFast(world, x + 30, y + 5, z + i, aqz.au.cF, 0, 2);
        }
        for (i = 0; i < 30; ++i) {
            for (k = 0; k < 4; ++k) {
                OreSpawnMain.setBlockFast(world, x - 4 + k, y, z + i, aqz.V.cF, 0, 2);
            }
        }
        for (i = 0; i < 30; ++i) {
            for (k = 0; k < 4; ++k) {
                OreSpawnMain.setBlockFast(world, x - 4 + k, y + 5, z + i, aqz.au.cF, 0, 2);
            }
        }
        for (i = 0; i < 30; ++i) {
            for (k = 1; k < 5; ++k) {
                OreSpawnMain.setBlockFast(world, x - 5, y + k, z + i, aqz.M.cF, 0, 2);
            }
        }
        for (i = 0; i < 5; ++i) {
            for (k = 1; k < 5; ++k) {
                OreSpawnMain.setBlockFast(world, x - 4 + i, y + k, z - 1, aqz.M.cF, 0, 2);
            }
        }
        for (i = 0; i < 5; ++i) {
            for (k = 1; k < 5; ++k) {
                OreSpawnMain.setBlockFast(world, x - 4 + i, y + k, z + 30, aqz.M.cF, 0, 2);
            }
        }
        for (k = 0; k < 4; ++k) {
            OreSpawnMain.setBlockFast(world, x - 4, y + 1 + k, z, aqz.V.cF, 0, 2);
        }
        for (k = 0; k < 4; ++k) {
            OreSpawnMain.setBlockFast(world, x - 4, y + 1 + k, z + 15, aqz.V.cF, 0, 2);
        }
        for (k = 0; k < 4; ++k) {
            OreSpawnMain.setBlockFast(world, x - 4, y + 1 + k, z + 29, aqz.V.cF, 0, 2);
        }
        OreSpawnMain.setBlockFast(world, x - 3, y + 3, z, OreSpawnMain.ExtremeTorch.cF, 0, 2);
        OreSpawnMain.setBlockFast(world, x - 3, y + 3, z + 15, OreSpawnMain.ExtremeTorch.cF, 0, 2);
        OreSpawnMain.setBlockFast(world, x - 3, y + 3, z + 29, OreSpawnMain.ExtremeTorch.cF, 0, 2);
        OreSpawnMain.setBlockFast(world, x + 30, y + 4, z + 2, aqz.aV.cF, 0, 2);
        OreSpawnMain.setBlockFast(world, x + 30, y + 4, z + 15, aqz.aV.cF, 0, 2);
        OreSpawnMain.setBlockFast(world, x + 30, y + 4, z + 27, aqz.aV.cF, 0, 2);
        ary chest = null;
        i = 2 + world.s.nextInt(3);
        for (k = 0; k < i; ++k) {
            OreSpawnMain.setBlockFast(world, x + 58, y + 4, z + 2 + k * 2, aqz.av.cF, 0, 2);
            OreSpawnMain.setBlockFast(world, x + 58, y + 1, z + 2 + k * 2, aqz.az.cF, 0, 2);
            chest = (ary)world.r(x + 58, y + 1, z + 2 + k * 2);
            if (chest == null) continue;
            mk.a((Random)world.s, (mk[])this.chestContentsList, (mo)chest, (int)(4 + world.s.nextInt(4)));
        }
        nn ent = null;
        ent = this.spawnCreature(world, "Basilisk", (double)x + 45.0, (double)y + 1.01, (double)z + 15.0);
        if (ent != null) {
            b = (Basilisk)ent;
            b.bz();
        }
        if ((ent = this.spawnCreature(world, "Basilisk", (double)x + 46.0, (double)y + 1.01, (double)z + 15.0)) != null) {
            b = (Basilisk)ent;
            b.bz();
        }
        if ((ent = this.spawnCreature(world, "Basilisk", (double)x + 47.0, (double)y + 1.01, (double)z + 15.0)) != null) {
            b = (Basilisk)ent;
            b.bz();
        }
    }

    public void makeEntrance(abw world, int x, int y, int z, int depth) {
        int i;
        int width;
        int j;
        for (j = width = 8; j >= 0; --j) {
            for (i = 0; i < j * 2 + 4; ++i) {
                OreSpawnMain.setBlockFast(world, x + i - j, y + width - j, z - j, aqz.V.cF, 0, 2);
                OreSpawnMain.setBlockFast(world, x + i - j, y + width - j, z + j + 3, aqz.V.cF, 0, 2);
                OreSpawnMain.setBlockFast(world, x - j, y + width - j, z + i - j, aqz.V.cF, 0, 2);
                OreSpawnMain.setBlockFast(world, x + j + 3, y + width - j, z + i - j, aqz.V.cF, 0, 2);
            }
        }
        int k = 0;
        for (j = width; j > -depth; --j) {
            for (i = 0; i < 4; ++i) {
                OreSpawnMain.setBlockFast(world, x + i, y + j, z, aqz.E.cF, 0, 2);
                OreSpawnMain.setBlockFast(world, x + i, y + j, z + 3, aqz.E.cF, 0, 2);
                OreSpawnMain.setBlockFast(world, x, y + j, z + i, aqz.E.cF, 0, 2);
                OreSpawnMain.setBlockFast(world, x + 3, y + j, z + i, aqz.E.cF, 0, 2);
            }
            for (int l = 0; l < 2; ++l) {
                for (int m = 0; m < 2; ++m) {
                    OreSpawnMain.setBlockFast(world, x + 1 + l, y + j, z + 1 + m, 0, 0, 2);
                }
            }
            switch (k) {
                case 0: {
                    OreSpawnMain.setBlockFast(world, x + 1, y + j, z + 1, aqz.au.cF, 0, 2);
                    break;
                }
                case 1: {
                    OreSpawnMain.setBlockFast(world, x + 2, y + j, z + 1, aqz.au.cF, 0, 2);
                    break;
                }
                case 2: {
                    OreSpawnMain.setBlockFast(world, x + 2, y + j, z + 2, aqz.au.cF, 0, 2);
                    break;
                }
                default: {
                    OreSpawnMain.setBlockFast(world, x + 1, y + j, z + 2, aqz.au.cF, 0, 2);
                }
            }
            if (++k <= 3) continue;
            k = 0;
        }
    }
}

