/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafwidget.ant;

import java.awt.Graphics;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.pushingpixels.lafwidget.ant.AugmentException;
import org.pushingpixels.lafwidget.ant.InfoClassVisitor;
import org.pushingpixels.lafwidget.ant.Utils;

public class UiDelegateUpdateAugmenter {
    private boolean isVerbose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void augmentClass(String dir, String name) {
        byte[] b;
        if (this.isVerbose) {
            System.out.println("Working on " + name);
        }
        String resource = dir + File.separator + name.replace('.', '/') + ".class";
        Method updateMethod = null;
        try {
            Class<?> clazz;
            URLClassLoader cl = new URLClassLoader(new URL[]{new File(dir).toURL()}, UiDelegateUpdateAugmenter.class.getClassLoader());
            if (!ComponentUI.class.isAssignableFrom(clazz)) {
                if (this.isVerbose) {
                    System.out.println("Not augmenting resource, doesn't extend ComponentUI");
                }
                return;
            }
            for (clazz = cl.loadClass(name); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    updateMethod = clazz.getDeclaredMethod("update", Graphics.class, JComponent.class);
                }
                catch (NoSuchMethodException nsme) {
                    // empty catch block
                }
                if (updateMethod == null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new AugmentException(name, e);
        }
        Set<String> existingMethods = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(resource);
            ClassReader cr = new ClassReader(is);
            InfoClassVisitor infoAdapter = new InfoClassVisitor();
            cr.accept(infoAdapter, false);
            existingMethods = infoAdapter.getMethods();
        }
        catch (Exception e) {
            throw new AugmentException(name, e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException ioe) {}
        }
        try {
            is = new FileInputStream(resource);
            ClassReader cr = new ClassReader(is);
            ClassWriter cw = new ClassWriter(false);
            AugmentClassAdapter cv = new AugmentClassAdapter(cw, existingMethods, updateMethod);
            cr.accept(cv, false);
            b = cw.toByteArray();
        }
        catch (Exception e) {
            throw new AugmentException(name, e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException ioe) {}
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(resource);
            fos.write(b);
            if (this.isVerbose) {
                System.out.println("Updated resource " + resource);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void process(String toStrip, File file, Pattern pattern) throws AugmentException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.process(toStrip, children[i], pattern);
            }
        } else {
            Matcher m = pattern.matcher(file.getName());
            if (m.matches()) {
                String className = file.getAbsolutePath().substring(toStrip.length() + 1);
                className = className.replace(File.separatorChar, '.');
                this.augmentClass(toStrip, className.substring(0, className.length() - 6));
            }
        }
    }

    public void setVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public static void main(String[] args) throws AugmentException {
        if (args.length == 0) {
            System.out.println("Usage : java ... UiDelegateUpdateAugmenter [-verbose] [-pattern class_pattern] file_resource");
            System.out.println("\tIf -verbose option is specified, the augmenter prints out its actions.");
            System.out.println("\tIf -pattern option is specified, its value is used as a wildcard for matching the classes for augmentation.");
            System.out.println("\tThe last parameter can point to either a file or a directory. The directory should be the root directory for classes.");
            return;
        }
        UiDelegateUpdateAugmenter uiDelegateAugmenter = new UiDelegateUpdateAugmenter();
        int argNum = 0;
        String pattern = ".*UI.class";
        while (true) {
            String currArg;
            if ("-verbose".equals(currArg = args[argNum])) {
                uiDelegateAugmenter.setVerbose(true);
                ++argNum;
                continue;
            }
            if (!"-pattern".equals(currArg)) break;
            pattern = args[++argNum];
            ++argNum;
        }
        Pattern p = Pattern.compile(pattern);
        File starter = new File(args[argNum]);
        uiDelegateAugmenter.process(starter.getAbsolutePath(), starter, p);
    }

    protected class AugmentClassAdapter
    extends ClassAdapter
    implements Opcodes {
        private Set<String> existingMethods;
        private Method updateMethod;
        private String prefix;

        public AugmentClassAdapter(ClassVisitor cv, Set<String> existingMethods, Method updateMethod) {
            super(cv);
            this.existingMethods = existingMethods;
            this.updateMethod = updateMethod;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.prefix = "__" + name.replaceAll("/", "__") + "__";
            super.visit(version, access, name, signature, superName, interfaces);
            boolean hasOriginal = this.existingMethods.contains("update");
            boolean hasDelegate = this.existingMethods.contains(this.prefix + "update");
            String methodSignature = Utils.getMethodDesc(this.updateMethod);
            int paramCount = this.updateMethod.getParameterTypes().length;
            if (UiDelegateUpdateAugmenter.this.isVerbose) {
                System.out.println("... Augmenting update " + methodSignature + " : original - " + hasOriginal + ", delegate - " + hasDelegate + ", " + paramCount + " params");
            }
            if (!hasDelegate) {
                this.augmentUpdateMethod(!hasOriginal, name, superName, methodSignature);
            }
        }

        public void augmentUpdateMethod(boolean toSynthOriginal, String className, String superClassName, String functionDesc) {
            MethodVisitor mv;
            if (toSynthOriginal) {
                mv = this.cv.visitMethod(1, this.prefix + "update", "(Ljava/awt/Graphics;Ljavax/swing/JComponent;)V", null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(183, superClassName, "update", "(Ljava/awt/Graphics;Ljavax/swing/JComponent;)V");
                mv.visitInsn(177);
                mv.visitMaxs(3, 3);
                mv.visitEnd();
            }
            mv = this.cv.visitMethod(1, "update", "(Ljava/awt/Graphics;Ljavax/swing/JComponent;)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "java/awt/Graphics", "create", "()Ljava/awt/Graphics;");
            mv.visitTypeInsn(192, "java/awt/Graphics2D");
            mv.visitVarInsn(58, 3);
            mv.visitVarInsn(25, 3);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(184, "org/pushingpixels/lafwidget/utils/RenderingUtils", "installDesktopHints", "(Ljava/awt/Graphics2D;Ljava/awt/Component;)V");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 3);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, className, this.prefix + "update", "(Ljava/awt/Graphics;Ljavax/swing/JComponent;)V");
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(182, "java/awt/Graphics2D", "dispose", "()V");
            mv.visitInsn(177);
            mv.visitMaxs(3, 4);
            mv.visitEnd();
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ("update".equals(name) && !this.existingMethods.contains(this.prefix + name)) {
                if (UiDelegateUpdateAugmenter.this.isVerbose) {
                    System.out.println("... renaming '" + name + "(" + desc + ")' to '" + this.prefix + name + "'");
                }
                return this.cv.visitMethod(access, this.prefix + name, desc, signature, exceptions);
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

