/*
 * Decompiled with CFR 0.152.
 */
package org.neocities.dangerzonegame.zombietown;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class Textures {
    private static HashMap<String, Integer> idMap = new HashMap();

    public static void bindNearest(String tex) {
        GL11.glBindTexture(3553, Textures.loadTexture(tex, 9728));
    }

    public static int loadTexture(String resourceName, int mode) {
        return Textures.loadTexture(resourceName, mode, Textures.class.getClassLoader());
    }

    public static int loadTexture(String resourceName, int mode, ClassLoader classLoader) {
        try {
            if (idMap.containsKey(resourceName)) {
                return idMap.get(resourceName);
            }
            IntBuffer e = BufferUtils.createIntBuffer(1);
            e.clear();
            GL11.glGenTextures(e);
            int id = e.get(0);
            idMap.put(resourceName, id);
            System.out.println(String.valueOf(resourceName) + " -> " + id);
            GL11.glBindTexture(3553, id);
            GL11.glTexParameteri(3553, 10241, mode);
            GL11.glTexParameteri(3553, 10240, mode);
            InputStream stream = classLoader.getResourceAsStream(resourceName.startsWith("/") ? resourceName.substring(1) : resourceName);
            if (stream == null) {
                throw new IOException("Resource not found: " + resourceName);
            }
            BufferedImage img = ImageIO.read(stream);
            stream.close();
            int w = img.getWidth();
            int h = img.getHeight();
            ByteBuffer pixels = BufferUtils.createByteBuffer(w * h * 4);
            int[] rawPixels = new int[w * h];
            img.getRGB(0, 0, w, h, rawPixels, 0, w);
            int i = 0;
            while (i < rawPixels.length) {
                int a = rawPixels[i] >> 24 & 0xFF;
                int r = rawPixels[i] >> 16 & 0xFF;
                int g = rawPixels[i] >> 8 & 0xFF;
                int b = rawPixels[i] & 0xFF;
                rawPixels[i] = a << 24 | b << 16 | g << 8 | r;
                ++i;
            }
            pixels.asIntBuffer().put(rawPixels);
            GLU.gluBuild2DMipmaps(3553, 6408, w, h, 6408, 5121, pixels);
            return id;
        }
        catch (IOException var14) {
            throw new RuntimeException("Failed to load texture: " + resourceName, var14);
        }
    }

    public static boolean isTextureLoaded(String resourceName) {
        return idMap.containsKey(resourceName);
    }

    public static int getTextureId(String resourceName) {
        return idMap.getOrDefault(resourceName, -1);
    }
}

