/*
 * Decompiled with CFR 0.152.
 */
package org.neocities.dangerzonegame.zombietown;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.neocities.dangerzonegame.zombietown.ZombieTown;

public class Screenshot {
    public static void takeScreenshot(String fileName) {
        int width = Display.getWidth();
        int height = Display.getHeight();
        ByteBuffer buffer = BufferUtils.createByteBuffer(width * height * 4);
        GL11.glReadPixels(0, 0, width, height, 6408, 5121, buffer);
        BufferedImage image = new BufferedImage(width, height, 2);
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = (x + (height - y - 1) * width) * 4;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                int a = buffer.get(i + 3) & 0xFF;
                int argb = a << 24 | r << 16 | g << 8 | b;
                image.setRGB(x, y, argb);
                ++x;
            }
            ++y;
        }
        try {
            File file = new File(fileName);
            file.getParentFile().mkdirs();
            boolean success = ImageIO.write((RenderedImage)image, "PNG", file);
            if (success) {
                System.out.println("Screenshot saved: " + file.getAbsolutePath());
            } else {
                System.err.println("Failed to save screenshot (ImageIO.write returned false)");
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save screenshot!");
            e.printStackTrace();
        }
    }

    public static void takeScreenshotDated() {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        Screenshot.takeScreenshot("screenshots/" + ZombieTown.titleName.replace(' ', '_') + "_" + timestamp + ".png");
    }

    public static void screenshot() {
        Screenshot.takeScreenshotDated();
    }
}

