/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.applet;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.lwjgl.LWJGLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletLoader
extends Applet
implements Runnable,
AppletStub {
    public static final int STATE_INIT = 1;
    public static final int STATE_CHECK_JRE_VERSION = 2;
    public static final int STATE_DETERMINING_PACKAGES = 3;
    public static final int STATE_CHECKING_CACHE = 4;
    public static final int STATE_CHECKING_FOR_UPDATES = 5;
    public static final int STATE_DOWNLOADING = 6;
    public static final int STATE_EXTRACTING_PACKAGES = 7;
    public static final int STATE_VALIDATING_PACKAGES = 8;
    public static final int STATE_UPDATING_CLASSPATH = 9;
    public static final int STATE_SWITCHING_APPLET = 10;
    public static final int STATE_INITIALIZE_REAL_APPLET = 11;
    public static final int STATE_START_REAL_APPLET = 12;
    public static final int STATE_DONE = 13;
    protected volatile int percentage;
    protected int totalDownloadSize;
    protected int currentSizeExtract;
    protected int totalSizeExtract;
    protected Image logo;
    protected Image logoBuffer;
    protected Image progressbar;
    protected Image progressbarBuffer;
    protected Image offscreen;
    protected boolean painting;
    protected Color bgColor = Color.white;
    protected Color fgColor = Color.black;
    protected URL[] urlList;
    protected ClassLoader classLoader;
    protected Thread loaderThread;
    protected Thread animationThread;
    protected Applet lwjglApplet;
    protected boolean debugMode;
    protected boolean prependHost;
    protected HashMap<String, Long> filesLastModified;
    protected int[] fileSizes;
    protected int nativeJarCount;
    protected boolean cacheEnabled;
    protected String subtaskMessage = "";
    protected volatile int state = 1;
    protected boolean lzmaSupported;
    protected boolean pack200Supported;
    protected boolean headless = false;
    protected boolean headlessWaiting = true;
    protected String[] headlessMessage;
    protected int concurrentLookupThreads;
    protected boolean fatalError;
    protected boolean certificateRefused;
    protected boolean minimumJreNotFound;
    protected String[] genericErrorMessage = new String[]{"An error occured while loading the applet.", "Please contact support to resolve this issue.", "<placeholder for error message>"};
    protected String[] certificateRefusedMessage = new String[]{"Permissions for Applet Refused.", "Please accept the permissions dialog to allow", "the applet to continue the loading process."};
    protected String[] minimumJREMessage = new String[]{"Your version of Java is out of date.", "Visit java.com to get the latest version.", "Java <al_min_jre> or greater is required."};
    protected String[] errorMessage;
    protected static boolean natives_loaded;

    @Override
    public void init() {
        String[] requiredArgs;
        this.setState(1);
        for (String requiredArg : requiredArgs = new String[]{"al_main", "al_jars"}) {
            if (this.getParameter(requiredArg) != null) continue;
            this.fatalErrorOccured("missing required applet parameter: " + requiredArg, null);
            return;
        }
        this.cacheEnabled = this.getBooleanParameter("al_cache", true);
        this.debugMode = this.getBooleanParameter("al_debug", false);
        this.prependHost = this.getBooleanParameter("al_prepend_host", true);
        this.headless = this.getBooleanParameter("al_headless", false);
        this.concurrentLookupThreads = this.getIntParameter("al_lookup_threads", 1);
        this.bgColor = this.getColor("boxbgcolor", Color.white);
        this.setBackground(this.bgColor);
        this.fgColor = this.getColor("boxfgcolor", Color.black);
        if (!this.headless) {
            this.logo = this.getImage(this.getStringParameter("al_logo", "appletlogo.gif"));
            this.progressbar = this.getImage(this.getStringParameter("al_progressbar", "appletprogress.gif"));
        }
        try {
            Class.forName("LZMA.LzmaInputStream");
            this.lzmaSupported = true;
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            Pack200.class.getSimpleName();
            this.pack200Supported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String generateStacktrace(Exception exception) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        exception.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    @Override
    public void start() {
        if (this.lwjglApplet != null) {
            this.lwjglApplet.start();
        } else if (this.loaderThread == null && !this.fatalError) {
            this.loaderThread = new Thread(this);
            this.loaderThread.setName("AppletLoader.loaderThread");
            this.loaderThread.start();
            if (!this.headless) {
                this.animationThread = new Thread(){

                    public void run() {
                        while (AppletLoader.this.loaderThread != null) {
                            AppletLoader.this.repaint();
                            AppletLoader.this.sleep(100L);
                        }
                        AppletLoader.this.animationThread = null;
                    }
                };
                this.animationThread.setName("AppletLoader.animationthread");
                this.animationThread.start();
            }
        }
    }

    @Override
    public void stop() {
        if (this.lwjglApplet != null) {
            this.lwjglApplet.stop();
        }
    }

    @Override
    public void destroy() {
        if (this.lwjglApplet != null) {
            this.lwjglApplet.destroy();
        }
    }

    protected void cleanUp() {
        this.progressbar = null;
        this.logo = null;
        this.logoBuffer = null;
        this.progressbarBuffer = null;
        this.offscreen = null;
    }

    public Applet getApplet() {
        return this.lwjglApplet;
    }

    public int getStatus() {
        if (this.fatalError) {
            this.headlessMessage = this.errorMessage;
            if (this.certificateRefused) {
                return -2;
            }
            if (this.minimumJreNotFound) {
                return -3;
            }
            return -1;
        }
        if (this.percentage == 100 && this.headlessWaiting) {
            this.headlessWaiting = false;
        }
        if (this.percentage == 95) {
            this.percentage = 100;
        }
        String[] message = new String[]{this.getDescriptionForState(), this.subtaskMessage};
        this.headlessMessage = message;
        return this.percentage;
    }

    public String[] getMessages() {
        return this.headlessMessage;
    }

    @Override
    public void appletResize(int width, int height) {
        this.resize(width, height);
    }

    @Override
    public final void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.state == 13) {
            this.cleanUp();
            return;
        }
        if (this.headless) {
            return;
        }
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.getWidth(), this.getHeight());
            if (this.logo != null) {
                this.logoBuffer = this.createImage(this.logo.getWidth(null), this.logo.getHeight(null));
                this.offscreen.getGraphics().drawImage(this.logo, 0, 0, this);
                this.imageUpdate(this.logo, 16, 0, 0, 0, 0);
            }
            if (this.progressbar != null) {
                this.progressbarBuffer = this.createImage(this.progressbar.getWidth(null), this.progressbar.getHeight(null));
                this.offscreen.getGraphics().drawImage(this.progressbar, 0, 0, this);
                this.imageUpdate(this.progressbar, 16, 0, 0, 0, 0);
            }
        }
        Graphics og = this.offscreen.getGraphics();
        FontMetrics fm = og.getFontMetrics();
        og.setColor(this.bgColor);
        og.fillRect(0, 0, this.offscreen.getWidth(null), this.offscreen.getHeight(null));
        og.setColor(this.fgColor);
        if (this.fatalError) {
            for (int i = 0; i < this.errorMessage.length; ++i) {
                if (this.errorMessage[i] == null) continue;
                int messageX = (this.offscreen.getWidth(null) - fm.stringWidth(this.errorMessage[i])) / 2;
                int messageY = (this.offscreen.getHeight(null) - fm.getHeight() * this.errorMessage.length) / 2;
                og.drawString(this.errorMessage[i], messageX, messageY + i * fm.getHeight());
            }
        } else {
            og.setColor(this.fgColor);
            this.painting = true;
            int x = this.offscreen.getWidth(null) / 2;
            int y = this.offscreen.getHeight(null) / 2;
            if (this.logo != null) {
                og.drawImage(this.logoBuffer, x - this.logo.getWidth(null) / 2, y - this.logo.getHeight(null) / 2, this);
            }
            String message = this.getDescriptionForState();
            int messageX = (this.offscreen.getWidth(null) - fm.stringWidth(message)) / 2;
            int messageY = y + 20;
            if (this.logo != null) {
                messageY += this.logo.getHeight(null) / 2;
            } else if (this.progressbar != null) {
                messageY += this.progressbar.getHeight(null) / 2;
            }
            og.drawString(message, messageX, messageY);
            if (this.subtaskMessage.length() > 0) {
                messageX = (this.offscreen.getWidth(null) - fm.stringWidth(this.subtaskMessage)) / 2;
                og.drawString(this.subtaskMessage, messageX, messageY + 20);
            }
            if (this.progressbar != null) {
                int barSize = this.progressbar.getWidth(null) * this.percentage / 100;
                og.clipRect(x - this.progressbar.getWidth(null) / 2, 0, barSize, this.offscreen.getHeight(null));
                og.drawImage(this.progressbarBuffer, x - this.progressbar.getWidth(null) / 2, y - this.progressbar.getHeight(null) / 2, this);
            }
            this.painting = false;
        }
        og.dispose();
        g.drawImage(this.offscreen, (this.getWidth() - this.offscreen.getWidth(null)) / 2, (this.getHeight() - this.offscreen.getHeight(null)) / 2, null);
    }

    @Override
    public boolean imageUpdate(Image img, int flag, int x, int y, int width, int height) {
        if (this.state == 13) {
            return false;
        }
        if (flag == 16 && !this.painting) {
            Image buffer = img == this.logo ? this.logoBuffer : this.progressbarBuffer;
            Graphics g = buffer.getGraphics();
            g.setColor(this.bgColor);
            g.fillRect(0, 0, buffer.getWidth(null), buffer.getHeight(null));
            if (img == this.progressbar && this.logo != null) {
                g.drawImage(this.logoBuffer, this.progressbar.getWidth(null) / 2 - this.logo.getWidth(null) / 2, this.progressbar.getHeight(null) / 2 - this.logo.getHeight(null) / 2, null);
            }
            g.drawImage(img, 0, 0, this);
            g.dispose();
            this.repaint();
        }
        return true;
    }

    protected String getDescriptionForState() {
        switch (this.state) {
            case 1: {
                return "Initializing loader";
            }
            case 2: {
                return "Checking version";
            }
            case 3: {
                return "Determining packages to load";
            }
            case 4: {
                return "Calculating download size";
            }
            case 5: {
                return "Checking for updates";
            }
            case 6: {
                return "Downloading packages";
            }
            case 7: {
                return "Extracting downloaded packages";
            }
            case 8: {
                return "Validating packages";
            }
            case 9: {
                return "Updating classpath";
            }
            case 10: {
                return "Switching applet";
            }
            case 11: {
                return "Initializing real applet";
            }
            case 12: {
                return "Starting real applet";
            }
            case 13: {
                return "Done loading";
            }
        }
        return "unknown state";
    }

    protected String trimExtensionByCapabilities(String file) {
        if (!this.pack200Supported) {
            file = file.replace(".pack", "");
        }
        if (!this.lzmaSupported && file.endsWith(".lzma")) {
            file = file.replace(".lzma", "");
            System.out.println("LZMA decoder (lzma.jar) not found, trying " + file + " without lzma extension.");
        }
        return file;
    }

    protected void loadJarURLs() throws Exception {
        int i;
        this.setState(3);
        String jarList = this.getParameter("al_jars");
        String nativeJarList = null;
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Win")) {
            nativeJarList = System.getProperty("os.arch").endsWith("64") ? this.getParameter("al_windows64") : this.getParameter("al_windows32");
            if (nativeJarList == null) {
                nativeJarList = this.getParameter("al_windows");
            }
        } else if (osName.startsWith("Linux") || osName.startsWith("Unix")) {
            nativeJarList = System.getProperty("os.arch").endsWith("64") ? this.getParameter("al_linux64") : this.getParameter("al_linux32");
            if (nativeJarList == null) {
                nativeJarList = this.getParameter("al_linux");
            }
        } else if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
            nativeJarList = System.getProperty("os.arch").endsWith("64") ? this.getParameter("al_mac64") : (System.getProperty("os.arch").contains("ppc") ? this.getParameter("al_macppc") : this.getParameter("al_mac32"));
            if (nativeJarList == null) {
                nativeJarList = this.getParameter("al_mac");
            }
        } else if (osName.startsWith("Solaris") || osName.startsWith("SunOS")) {
            nativeJarList = this.getParameter("al_solaris");
        } else if (osName.startsWith("FreeBSD")) {
            nativeJarList = this.getParameter("al_freebsd");
        } else if (osName.startsWith("OpenBSD")) {
            nativeJarList = this.getParameter("al_openbsd");
        } else {
            this.fatalErrorOccured("OS (" + osName + ") not supported", null);
            return;
        }
        if (nativeJarList == null) {
            this.fatalErrorOccured("no lwjgl natives files found", null);
            return;
        }
        jarList = this.trimExtensionByCapabilities(jarList);
        StringTokenizer jars = new StringTokenizer(jarList, ", ");
        nativeJarList = this.trimExtensionByCapabilities(nativeJarList);
        StringTokenizer nativeJars = new StringTokenizer(nativeJarList, ", ");
        int jarCount = jars.countTokens();
        this.nativeJarCount = nativeJars.countTokens();
        this.urlList = new URL[jarCount + this.nativeJarCount];
        URL path = this.getCodeBase();
        for (i = 0; i < jarCount; ++i) {
            this.urlList[i] = new URL(path, jars.nextToken());
        }
        for (i = jarCount; i < jarCount + this.nativeJarCount; ++i) {
            this.urlList[i] = new URL(path, nativeJars.nextToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.percentage = 5;
        try {
            this.debug_sleep(2000L);
            if (!this.isMinJREVersionAvailable()) {
                this.minimumJreNotFound = true;
                this.fatalErrorOccured("Java " + this.getStringParameter("al_min_jre", "1.5") + " or greater is required.", null);
                return;
            }
            this.loadJarURLs();
            String path = this.getCacheDirectory();
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File versionFile = new File(dir, "version");
            boolean versionAvailable = false;
            String version = this.getParameter("al_version");
            if (version != null) {
                versionAvailable = this.compareVersion(versionFile, version.toLowerCase());
            }
            if (!versionAvailable) {
                this.getJarInfo(dir);
                this.downloadJars(path);
                this.extractJars(path);
                this.extractNatives(path);
                this.validateJars(path);
                if (version != null) {
                    this.percentage = 90;
                    this.writeObjectFile(versionFile, version.toLowerCase());
                }
                this.writeObjectFile(new File(dir, "timestamps"), this.filesLastModified);
            }
            this.updateClassPath(path);
            this.setLWJGLProperties();
            if (this.headless) {
                while (this.headlessWaiting) {
                    Thread.sleep(100L);
                }
            }
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        AppletLoader.this.switchApplet();
                    }
                    catch (Exception e) {
                        AppletLoader.this.fatalErrorOccured("This occurred while '" + AppletLoader.this.getDescriptionForState() + "'", e);
                    }
                    AppletLoader.this.setState(13);
                    AppletLoader.this.repaint();
                }
            });
        }
        catch (Exception e) {
            this.certificateRefused = e instanceof AccessControlException;
            this.fatalErrorOccured("This occurred while '" + this.getDescriptionForState() + "'", e);
        }
        finally {
            this.loaderThread = null;
        }
    }

    public boolean isMinJREVersionAvailable() throws Exception {
        int i;
        this.setState(2);
        String minimumVersion = this.getStringParameter("al_min_jre", "1.5");
        String javaVersion = System.getProperty("java.version");
        minimumVersion = javaVersion.split("-")[0];
        javaVersion = minimumVersion.split("-")[0];
        String[] jvmVersionData = javaVersion.split("[_\\.]");
        String[] minVersionData = minimumVersion.split("[_\\.]");
        int maxLength = Math.max(jvmVersionData.length, minVersionData.length);
        int[] jvmVersion = new int[maxLength];
        int[] minVersion = new int[maxLength];
        for (i = 0; i < jvmVersionData.length; ++i) {
            jvmVersion[i] = Integer.parseInt(jvmVersionData[i]);
        }
        for (i = 0; i < minVersionData.length; ++i) {
            minVersion[i] = Integer.parseInt(minVersionData[i]);
        }
        for (i = 0; i < maxLength; ++i) {
            if (jvmVersion[i] >= minVersion[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean compareVersion(File versionFile, String version) {
        String s;
        if (versionFile.exists() && (s = this.readStringFile(versionFile)) != null && s.equals(version)) {
            this.percentage = 90;
            if (this.debugMode) {
                System.out.println("Loading Cached Applet Version: " + version);
            }
            this.debug_sleep(2000L);
            return true;
        }
        return false;
    }

    protected void setLWJGLProperties() {
        String lwjglArguments = this.getParameter("lwjgl_arguments");
        if (lwjglArguments != null && lwjglArguments.length() > 0) {
            int start = lwjglArguments.indexOf("-Dorg.lwjgl");
            while (start != -1) {
                int end = lwjglArguments.indexOf(" ", start);
                if (end == -1) {
                    end = lwjglArguments.length();
                }
                String[] keyValue = lwjglArguments.substring(start + 2, end).split("=");
                System.setProperty(keyValue[0], keyValue[1]);
                if (this.debugMode) {
                    System.out.println("Setting property " + keyValue[0] + " to " + keyValue[1]);
                }
                start = lwjglArguments.indexOf("-Dorg.lwjgl", end);
            }
        }
    }

    protected String getCacheDirectory() throws Exception {
        String path = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                String codebase = "";
                if (AppletLoader.this.prependHost) {
                    codebase = AppletLoader.this.getCodeBase().getHost();
                    if (codebase == null || codebase.length() == 0) {
                        codebase = "localhost";
                    }
                    codebase = codebase + File.separator;
                }
                return AppletLoader.this.getLWJGLCacheDir() + File.separator + codebase + AppletLoader.this.getParameter("al_title") + File.separator;
            }
        });
        return path;
    }

    protected String getLWJGLCacheDir() {
        String cacheDir = System.getProperty("deployment.user.cachedir");
        if (cacheDir == null || System.getProperty("os.name").startsWith("Win")) {
            cacheDir = System.getProperty("java.io.tmpdir");
        }
        return cacheDir + File.separator + "lwjglcache";
    }

    protected String readStringFile(File file) {
        try {
            return (String)this.readObjectFile(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected HashMap<String, Long> readHashMapFile(File file) {
        try {
            return (HashMap)this.readObjectFile(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, Long>();
        }
    }

    protected Object readObjectFile(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        try {
            ObjectInputStream dis = new ObjectInputStream(fis);
            Object object = dis.readObject();
            dis.close();
            Object object2 = object;
            return object2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeObjectFile(File file, Object object) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            ObjectOutputStream dos = new ObjectOutputStream(fos);
            dos.writeObject(object);
            dos.close();
        }
        finally {
            fos.close();
        }
    }

    protected void updateClassPath(final String path) throws Exception {
        this.setState(9);
        this.percentage = 95;
        URL[] urls = new URL[this.urlList.length];
        for (int i = 0; i < this.urlList.length; ++i) {
            String file = new File(path, this.getJarName(this.urlList[i])).toURI().toString();
            file = file.replace("!", "%21");
            urls[i] = new URL(file);
        }
        final Certificate[] certs = AppletLoader.getCurrentCertificates();
        String osName = System.getProperty("os.name");
        boolean isMacOS = osName.startsWith("Mac") || osName.startsWith("Darwin");
        this.classLoader = new URLClassLoader(urls){

            protected PermissionCollection getPermissions(CodeSource codesource) {
                Permissions perms = null;
                try {
                    perms = new Permissions();
                    if (AppletLoader.certificatesMatch(certs, codesource.getCertificates())) {
                        ((PermissionCollection)perms).add(new AllPermission());
                        return perms;
                    }
                    String host = AppletLoader.this.getCodeBase().getHost();
                    if (host != null && host.length() > 0) {
                        ((PermissionCollection)perms).add(new SocketPermission(host, "connect,accept"));
                    } else if ("file".equals(codesource.getLocation().getProtocol())) {
                        String path2 = codesource.getLocation().getFile().replace('/', File.separatorChar);
                        ((PermissionCollection)perms).add(new FilePermission(path2, "read"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return perms;
            }

            protected String findLibrary(String libname) {
                String libPath = path + "natives" + File.separator + LWJGLUtil.mapLibraryName(libname);
                if (new File(libPath).exists()) {
                    return libPath;
                }
                return super.findLibrary(libname);
            }
        };
        this.debug_sleep(2000L);
        this.unloadNatives(path);
        System.setProperty("org.lwjgl.librarypath", path + "natives");
        System.setProperty("net.java.games.input.librarypath", path + "natives");
        System.setProperty("java.library.path", path + "natives");
        natives_loaded = true;
    }

    private void unloadNatives(String nativePath) {
        if (!natives_loaded) {
            return;
        }
        try {
            Field field = ClassLoader.class.getDeclaredField("loadedLibraryNames");
            field.setAccessible(true);
            Vector libs = (Vector)field.get(this.getClass().getClassLoader());
            String path = new File(nativePath).getCanonicalPath();
            for (int i = 0; i < libs.size(); ++i) {
                String s = (String)libs.get(i);
                if (!s.startsWith(path)) continue;
                libs.remove(i);
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void switchApplet() throws Exception {
        this.setState(10);
        this.percentage = 100;
        this.debug_sleep(2000L);
        Thread.currentThread().setContextClassLoader(this.classLoader);
        Class<?> appletClass = this.classLoader.loadClass(this.getParameter("al_main"));
        this.lwjglApplet = (Applet)appletClass.newInstance();
        this.lwjglApplet.setStub(this);
        this.lwjglApplet.setSize(this.getWidth(), this.getHeight());
        this.setLayout(new BorderLayout());
        this.add(this.lwjglApplet);
        this.validate();
        this.setState(11);
        this.lwjglApplet.init();
        this.setState(12);
        this.lwjglApplet.start();
    }

    protected void getJarInfo(File dir) throws Exception {
        this.setState(4);
        this.filesLastModified = new HashMap();
        this.fileSizes = new int[this.urlList.length];
        File timestampsFile = new File(dir, "timestamps");
        if (timestampsFile.exists()) {
            this.setState(5);
            this.filesLastModified = this.readHashMapFile(timestampsFile);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(this.concurrentLookupThreads);
        LinkedList requests = new LinkedList();
        final Integer sync = new Integer(1);
        int j = 0;
        while (j < this.urlList.length) {
            final int i = j++;
            Future<?> request = executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        long savedLastModified;
                        URLConnection urlconnection = AppletLoader.this.urlList[i].openConnection();
                        urlconnection.setDefaultUseCaches(false);
                        if (urlconnection instanceof HttpURLConnection) {
                            ((HttpURLConnection)urlconnection).setRequestMethod("HEAD");
                        }
                        AppletLoader.this.fileSizes[i] = urlconnection.getContentLength();
                        long lastModified = urlconnection.getLastModified();
                        String fileName = AppletLoader.this.getFileName(AppletLoader.this.urlList[i]);
                        if (AppletLoader.this.cacheEnabled && lastModified != 0L && AppletLoader.this.filesLastModified.containsKey(fileName) && (savedLastModified = AppletLoader.this.filesLastModified.get(fileName).longValue()) == lastModified) {
                            AppletLoader.this.fileSizes[i] = -2;
                        }
                        if (AppletLoader.this.fileSizes[i] >= 0) {
                            Object object = sync;
                            synchronized (object) {
                                AppletLoader.this.totalDownloadSize += AppletLoader.this.fileSizes[i];
                            }
                        }
                        AppletLoader.this.filesLastModified.put(fileName, lastModified);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to fetch information for " + AppletLoader.this.urlList[i], e);
                    }
                }
            });
            requests.add(request);
        }
        while (!requests.isEmpty()) {
            Iterator iterator = requests.iterator();
            while (iterator.hasNext()) {
                Future request = (Future)iterator.next();
                if (!request.isDone()) continue;
                request.get();
                iterator.remove();
                this.percentage = 5 + (int)((float)(10 * (this.urlList.length - requests.size())) / (float)this.urlList.length);
            }
            Thread.sleep(10L);
        }
        executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadJars(String path) throws Exception {
        this.setState(6);
        this.percentage = 15;
        int initialPercentage = 15;
        int amountDownloaded = 0;
        byte[] buffer = new byte[65536];
        for (int i = 0; i < this.urlList.length; ++i) {
            if (this.fileSizes[i] == -2) continue;
            int unsuccessfulAttempts = 0;
            int maxUnsuccessfulAttempts = 3;
            boolean downloadFile = true;
            String currentFile = this.getFileName(this.urlList[i]);
            while (downloadFile) {
                downloadFile = false;
                this.debug_sleep(2000L);
                try {
                    URLConnection urlconnection = this.urlList[i].openConnection();
                    urlconnection.setUseCaches(false);
                    if (urlconnection instanceof HttpURLConnection) {
                        urlconnection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
                        urlconnection.connect();
                    }
                    InputStream inputstream = this.getJarInputStream(currentFile, urlconnection);
                    FileOutputStream fos = new FileOutputStream(path + currentFile);
                    int currentDownload = 0;
                    long downloadStartTime = System.currentTimeMillis();
                    int downloadedAmount = 0;
                    String downloadSpeedMessage = "";
                    try {
                        int bufferSize;
                        while ((bufferSize = inputstream.read(buffer, 0, buffer.length)) != -1) {
                            this.debug_sleep(10L);
                            fos.write(buffer, 0, bufferSize);
                            int totalDownloaded = amountDownloaded + (currentDownload += bufferSize);
                            this.percentage = initialPercentage + totalDownloaded * 45 / this.totalDownloadSize;
                            this.subtaskMessage = "Retrieving: " + currentFile + " " + totalDownloaded * 100 / this.totalDownloadSize + "%";
                            downloadedAmount += bufferSize;
                            long timeLapse = System.currentTimeMillis() - downloadStartTime;
                            if (timeLapse >= 1000L) {
                                float downloadSpeed = (float)downloadedAmount / (float)timeLapse;
                                downloadSpeed = (float)((int)(downloadSpeed * 100.0f)) / 100.0f;
                                downloadSpeedMessage = " - " + downloadSpeed + " KB/sec";
                                downloadedAmount = 0;
                                downloadStartTime = System.currentTimeMillis();
                            }
                            this.subtaskMessage = this.subtaskMessage + downloadSpeedMessage;
                        }
                    }
                    finally {
                        inputstream.close();
                        fos.close();
                    }
                    if (urlconnection instanceof HttpURLConnection && currentDownload != this.fileSizes[i] && (this.fileSizes[i] > 0 || currentDownload == 0)) {
                        throw new Exception("size mismatch on download of " + currentFile + " expected " + this.fileSizes[i] + " got " + currentDownload);
                    }
                    amountDownloaded += this.fileSizes[i];
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (++unsuccessfulAttempts < maxUnsuccessfulAttempts) {
                        downloadFile = true;
                        Thread.sleep(100L);
                        continue;
                    }
                    throw new Exception("failed to download " + currentFile + " after " + maxUnsuccessfulAttempts + " attempts");
                }
            }
        }
        this.subtaskMessage = "";
    }

    protected InputStream getJarInputStream(String currentFile, final URLConnection urlconnection) throws Exception {
        final InputStream[] is = new InputStream[1];
        for (int j = 0; j < 3 && is[0] == null; ++j) {
            Thread t = new Thread(){

                public void run() {
                    try {
                        is[0] = urlconnection.getInputStream();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            t.setName("JarInputStreamThread");
            t.start();
            int iterationCount = 0;
            while (is[0] == null && iterationCount++ < 5) {
                try {
                    t.join(1000L);
                }
                catch (InterruptedException inte) {}
            }
            if (is[0] != null) continue;
            try {
                t.interrupt();
                t.join();
                continue;
            }
            catch (InterruptedException inte) {
                // empty catch block
            }
        }
        if (is[0] == null) {
            throw new Exception("Unable to get input stream for " + currentFile);
        }
        return is[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractLZMA(String in, String out) throws Exception {
        File f = new File(in);
        FileInputStream fileInputHandle = new FileInputStream(f);
        Class<?> clazz = Class.forName("LZMA.LzmaInputStream");
        Constructor<?> constructor = clazz.getDeclaredConstructor(InputStream.class);
        InputStream inputHandle = (InputStream)constructor.newInstance(fileInputHandle);
        FileOutputStream outputHandle = new FileOutputStream(out);
        byte[] buffer = new byte[16384];
        try {
            int ret = inputHandle.read(buffer);
            while (ret >= 1) {
                ((OutputStream)outputHandle).write(buffer, 0, ret);
                ret = inputHandle.read(buffer);
            }
        }
        finally {
            inputHandle.close();
            ((OutputStream)outputHandle).close();
        }
        f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractGZip(String in, String out) throws Exception {
        File f = new File(in);
        FileInputStream fileInputHandle = new FileInputStream(f);
        GZIPInputStream inputHandle = new GZIPInputStream(fileInputHandle);
        FileOutputStream outputHandle = new FileOutputStream(out);
        try {
            byte[] buffer = new byte[16384];
            int ret = ((InputStream)inputHandle).read(buffer);
            while (ret >= 1) {
                ((OutputStream)outputHandle).write(buffer, 0, ret);
                ret = ((InputStream)inputHandle).read(buffer);
            }
        }
        finally {
            ((InputStream)inputHandle).close();
            ((OutputStream)outputHandle).close();
        }
        f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractPack(String in, String out) throws Exception {
        File f = new File(in);
        FileOutputStream fostream = new FileOutputStream(out);
        JarOutputStream jostream = new JarOutputStream(fostream);
        try {
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            unpacker.unpack(f, jostream);
        }
        finally {
            jostream.close();
            fostream.close();
        }
        f.delete();
    }

    protected void extractJars(String path) throws Exception {
        this.setState(7);
        float increment = 10.0f / (float)this.urlList.length;
        for (int i = 0; i < this.urlList.length; ++i) {
            if (this.fileSizes[i] == -2) continue;
            this.percentage = 55 + (int)(increment * (float)(i + 1));
            String filename = this.getFileName(this.urlList[i]);
            if (filename.endsWith(".pack.lzma")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + this.replaceLast(filename, ".lzma", "");
                this.debug_sleep(1000L);
                this.extractLZMA(path + filename, path + this.replaceLast(filename, ".lzma", ""));
                this.subtaskMessage = "Extracting: " + this.replaceLast(filename, ".lzma", "") + " to " + this.replaceLast(filename, ".pack.lzma", "");
                this.debug_sleep(1000L);
                this.extractPack(path + this.replaceLast(filename, ".lzma", ""), path + this.replaceLast(filename, ".pack.lzma", ""));
                continue;
            }
            if (filename.endsWith(".pack.gz")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + this.replaceLast(filename, ".gz", "");
                this.debug_sleep(1000L);
                this.extractGZip(path + filename, path + this.replaceLast(filename, ".gz", ""));
                this.subtaskMessage = "Extracting: " + this.replaceLast(filename, ".gz", "") + " to " + this.replaceLast(filename, ".pack.gz", "");
                this.debug_sleep(1000L);
                this.extractPack(path + this.replaceLast(filename, ".gz", ""), path + this.replaceLast(filename, ".pack.gz", ""));
                continue;
            }
            if (filename.endsWith(".pack")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + this.replaceLast(filename, ".pack", "");
                this.debug_sleep(1000L);
                this.extractPack(path + filename, path + this.replaceLast(filename, ".pack", ""));
                continue;
            }
            if (filename.endsWith(".lzma")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + this.replaceLast(filename, ".lzma", "");
                this.debug_sleep(1000L);
                this.extractLZMA(path + filename, path + this.replaceLast(filename, ".lzma", ""));
                continue;
            }
            if (!filename.endsWith(".gz")) continue;
            this.subtaskMessage = "Extracting: " + filename + " to " + this.replaceLast(filename, ".gz", "");
            this.debug_sleep(1000L);
            this.extractGZip(path + filename, path + this.replaceLast(filename, ".gz", ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractNatives(String path) throws Exception {
        this.setState(7);
        float percentageParts = 15.0f / (float)this.nativeJarCount;
        File nativeFolder = new File(path + "natives");
        if (!nativeFolder.exists()) {
            nativeFolder.mkdir();
        }
        Certificate[] certificate = AppletLoader.getCurrentCertificates();
        for (int i = this.urlList.length - this.nativeJarCount; i < this.urlList.length; ++i) {
            JarEntry entry;
            if (this.fileSizes[i] == -2) continue;
            String nativeJar = this.getJarName(this.urlList[i]);
            JarFile jarFile = new JarFile(path + nativeJar, true);
            Enumeration<JarEntry> entities = jarFile.entries();
            this.totalSizeExtract = 0;
            int jarNum = i - (this.urlList.length - this.nativeJarCount);
            while (entities.hasMoreElements()) {
                entry = entities.nextElement();
                if (entry.isDirectory() || entry.getName().indexOf(47) != -1) continue;
                this.totalSizeExtract = (int)((long)this.totalSizeExtract + entry.getSize());
            }
            this.currentSizeExtract = 0;
            entities = jarFile.entries();
            while (entities.hasMoreElements()) {
                File f;
                entry = entities.nextElement();
                if (entry.isDirectory() || entry.getName().indexOf(47) != -1 || (f = new File(path + "natives" + File.separator + entry.getName())).exists() && !f.delete()) continue;
                this.debug_sleep(1000L);
                InputStream in = jarFile.getInputStream(jarFile.getEntry(entry.getName()));
                FileOutputStream out = new FileOutputStream(path + "natives" + File.separator + entry.getName());
                try {
                    int bufferSize;
                    byte[] buffer = new byte[65536];
                    while ((bufferSize = in.read(buffer, 0, buffer.length)) != -1) {
                        this.debug_sleep(10L);
                        ((OutputStream)out).write(buffer, 0, bufferSize);
                        this.currentSizeExtract += bufferSize;
                        this.percentage = 65 + (int)(percentageParts * ((float)jarNum + (float)this.currentSizeExtract / (float)this.totalSizeExtract));
                        this.subtaskMessage = "Extracting: " + entry.getName() + " " + this.currentSizeExtract * 100 / this.totalSizeExtract + "%";
                    }
                }
                finally {
                    in.close();
                    ((OutputStream)out).close();
                }
                if (AppletLoader.certificatesMatch(certificate, entry.getCertificates())) continue;
                f.delete();
                throw new Exception("The certificate(s) in " + nativeJar + " do not match the AppletLoader!");
            }
            this.subtaskMessage = "";
            jarFile.close();
            File f = new File(path + nativeJar);
            f.delete();
        }
    }

    protected static boolean certificatesMatch(Certificate[] certs1, Certificate[] certs2) throws Exception {
        if (certs1 == null || certs2 == null) {
            return false;
        }
        if (certs1.length != certs2.length) {
            System.out.println("Certificate chain differs in length [" + certs1.length + " vs " + certs2.length + "]!");
            return false;
        }
        for (int i = 0; i < certs1.length; ++i) {
            if (certs1[i].equals(certs2[i])) continue;
            System.out.println("Certificate mismatch found!");
            return false;
        }
        return true;
    }

    protected static Certificate[] getCurrentCertificates() throws Exception {
        Certificate[] certificate = AppletLoader.class.getProtectionDomain().getCodeSource().getCertificates();
        if (certificate == null) {
            URL location = AppletLoader.class.getProtectionDomain().getCodeSource().getLocation();
            JarURLConnection jurl = (JarURLConnection)new URL("jar:" + location.toString() + "!/org/lwjgl/util/applet/AppletLoader.class").openConnection();
            jurl.setDefaultUseCaches(true);
            certificate = jurl.getCertificates();
            jurl.setDefaultUseCaches(false);
        }
        return certificate;
    }

    protected void validateJars(String path) throws Exception {
        this.setState(8);
        this.percentage = 80;
        float percentageParts = 10.0f / (float)this.urlList.length;
        for (int i = 0; i < this.urlList.length - this.nativeJarCount; ++i) {
            this.debug_sleep(1000L);
            if (this.fileSizes[i] == -2) continue;
            this.subtaskMessage = "Validating: " + this.getJarName(this.urlList[i]);
            File file = new File(path, this.getJarName(this.urlList[i]));
            if (!this.isZipValid(file)) {
                throw new Exception("The file " + this.getJarName(this.urlList[i]) + " is corrupt!");
            }
            this.percentage = 80 + (int)(percentageParts * (float)i);
        }
        this.subtaskMessage = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isZipValid(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            try {
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                byte[] buffer = new byte[4096];
                while (e.hasMoreElements()) {
                    ZipEntry zipEntry = e.nextElement();
                    CRC32 crc = new CRC32();
                    BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                    CheckedInputStream cis = new CheckedInputStream(bis, crc);
                    while (cis.read(buffer, 0, buffer.length) != -1) {
                    }
                    if (crc.getValue() == zipEntry.getCrc()) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                zipFile.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Image getImage(String s) {
        if (s.length() == 0) {
            return null;
        }
        Image image = null;
        try {
            image = this.getImage(new URL(this.getCodeBase(), s));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (image == null) {
            image = this.getImage(Thread.currentThread().getContextClassLoader().getResource(s));
        }
        if (image != null) {
            return image;
        }
        this.fatalErrorOccured("Unable to load the logo/progressbar image: " + s, null);
        return null;
    }

    @Override
    public Image getImage(URL url) {
        try {
            MediaTracker tracker = new MediaTracker(this);
            Image image = super.getImage(url);
            tracker.addImage(image, 0);
            tracker.waitForAll();
            if (!tracker.isErrorAny()) {
                return image;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected String getJarName(URL url) {
        String fileName = url.getFile();
        if (fileName.endsWith(".pack.lzma")) {
            fileName = this.replaceLast(fileName, ".pack.lzma", "");
        } else if (fileName.endsWith(".pack.gz")) {
            fileName = this.replaceLast(fileName, ".pack.gz", "");
        } else if (fileName.endsWith(".pack")) {
            fileName = this.replaceLast(fileName, ".pack", "");
        } else if (fileName.endsWith(".lzma")) {
            fileName = this.replaceLast(fileName, ".lzma", "");
        } else if (fileName.endsWith(".gz")) {
            fileName = this.replaceLast(fileName, ".gz", "");
        }
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    protected String getFileName(URL url) {
        String fileName = url.getFile();
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    protected Color getColor(String param, Color defaultColor) {
        String color = this.getParameter(param);
        if (color == null) {
            return defaultColor;
        }
        if (color.indexOf(",") != -1) {
            StringTokenizer st = new StringTokenizer(color, ",");
            try {
                return new Color(Integer.parseInt(st.nextToken().trim()), Integer.parseInt(st.nextToken().trim()), Integer.parseInt(st.nextToken().trim()));
            }
            catch (Exception e) {
                return defaultColor;
            }
        }
        try {
            return Color.decode(color);
        }
        catch (NumberFormatException e) {
            try {
                return (Color)Color.class.getField(color).get(null);
            }
            catch (Exception e2) {
                return defaultColor;
            }
        }
    }

    public String replaceLast(String original, String target, String replacement) {
        int index = original.lastIndexOf(target);
        if (index == -1) {
            return original;
        }
        return original.substring(0, index) + replacement + original.substring(index + target.length());
    }

    protected String getStringParameter(String name, String defaultValue) {
        String parameter = this.getParameter(name);
        if (parameter != null) {
            return parameter;
        }
        return defaultValue;
    }

    protected boolean getBooleanParameter(String name, boolean defaultValue) {
        String parameter = this.getParameter(name);
        if (parameter != null) {
            return Boolean.parseBoolean(parameter);
        }
        return defaultValue;
    }

    protected int getIntParameter(String name, int defaultValue) {
        String parameter = this.getParameter(name);
        if (parameter != null) {
            return Integer.parseInt(parameter);
        }
        return defaultValue;
    }

    protected void fatalErrorOccured(String error, Exception e) {
        this.fatalError = true;
        if (this.minimumJreNotFound) {
            this.errorMessage = this.minimumJREMessage;
            this.errorMessage[this.errorMessage.length - 1] = error;
        } else if (this.certificateRefused) {
            this.errorMessage = this.certificateRefusedMessage;
        } else {
            this.errorMessage = this.genericErrorMessage;
            this.errorMessage[this.errorMessage.length - 1] = error;
        }
        System.out.println(error);
        if (e != null) {
            System.out.println(e.getMessage());
            System.out.println(AppletLoader.generateStacktrace(e));
        }
        this.repaint();
    }

    protected void setState(int state) {
        this.state = state;
        if (this.debugMode) {
            System.out.println(this.getDescriptionForState());
        }
    }

    protected void debug_sleep(long ms) {
        if (this.debugMode) {
            this.sleep(ms);
        }
    }

    protected void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

