/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.shaders;

import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.test.opengl.shaders.Shader;
import org.lwjgl.test.opengl.shaders.ShadersTest;

final class ShaderVSH
extends Shader {
    final String file;
    final String source;
    final int shaderID;
    final int programID;
    final int uniformLocation;

    ShaderVSH(String shaderFile) {
        this.file = shaderFile;
        this.source = ShaderVSH.getShaderText(shaderFile);
        this.shaderID = ARBShaderObjects.glCreateShaderObjectARB(35633);
        ARBShaderObjects.glShaderSourceARB(this.shaderID, this.source);
        ARBShaderObjects.glCompileShaderARB(this.shaderID);
        ShaderVSH.printShaderObjectInfoLog(this.file, this.shaderID);
        if (ARBShaderObjects.glGetObjectParameteriARB(this.shaderID, 35713) == 0) {
            ShadersTest.kill("A compilation error occured in a vertex shader.");
        }
        this.programID = ARBShaderObjects.glCreateProgramObjectARB();
        ARBShaderObjects.glAttachObjectARB(this.programID, this.shaderID);
        ARBShaderObjects.glLinkProgramARB(this.programID);
        ShaderVSH.printShaderProgramInfoLog(this.programID);
        if (ARBShaderObjects.glGetObjectParameteriARB(this.programID, 35714) == 0) {
            ShadersTest.kill("A linking error occured in a shader program.");
        }
        this.uniformLocation = ShaderVSH.getUniformLocation(this.programID, "UNIFORMS");
    }

    void render() {
        ARBShaderObjects.glUseProgramObjectARB(this.programID);
        ARBShaderObjects.glUniform2fARB(this.uniformLocation, ShadersTest.getSin(), (float)ShadersTest.getSpecularity() * 8.0f);
        ShadersTest.renderObject();
        ARBShaderObjects.glUseProgramObjectARB(0);
    }

    void cleanup() {
        ARBShaderObjects.glDetachObjectARB(this.programID, this.shaderID);
        ARBShaderObjects.glDeleteObjectARB(this.shaderID);
        ARBShaderObjects.glDeleteObjectARB(this.programID);
    }
}

