/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.shaders;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.test.opengl.shaders.ShadersTest;

abstract class Shader {
    protected static ByteBuffer fileBuffer = BufferUtils.createByteBuffer(10240);

    protected Shader() {
    }

    abstract void render();

    abstract void cleanup();

    protected static String getShaderText(String file) {
        String shader = null;
        try {
            byte character;
            InputStream source = ShadersTest.class.getResourceAsStream(file);
            if (source == null) {
                source = new FileInputStream("src/java/org/lwjgl/test/opengl/shaders/" + file);
            }
            BufferedInputStream stream = new BufferedInputStream(source);
            while ((character = (byte)stream.read()) != -1) {
                fileBuffer.put(character);
            }
            stream.close();
            fileBuffer.flip();
            byte[] array = new byte[fileBuffer.remaining()];
            fileBuffer.get(array);
            shader = new String(array);
            fileBuffer.clear();
        }
        catch (IOException e) {
            ShadersTest.kill("Failed to read the shader source file: " + file, e);
        }
        return shader;
    }

    protected static void checkProgramError(String programFile, String programSource) {
        if (GL11.glGetError() == 1282) {
            int errorPos = GL11.glGetInteger(34379);
            int lineStart = 0;
            int lineEnd = -1;
            for (int i = 0; i < programSource.length(); ++i) {
                if (programSource.charAt(i) != '\n') continue;
                if (i <= errorPos) {
                    lineStart = i + 1;
                    continue;
                }
                lineEnd = i;
                break;
            }
            if (lineEnd == -1) {
                lineEnd = programSource.length();
            }
            ShadersTest.kill("Low-level program error in file: " + programFile + "\n\tError line: " + programSource.substring(lineStart, lineEnd) + "\n\tError message: " + GL11.glGetString(34932));
        }
    }

    protected static int getUniformLocation(int ID, String name) {
        int location = ARBShaderObjects.glGetUniformLocationARB(ID, name);
        if (location == -1) {
            throw new IllegalArgumentException("The uniform \"" + name + "\" does not exist in the Shader Program.");
        }
        return location;
    }

    protected static void printShaderObjectInfoLog(String file, int ID) {
        int logLength = ARBShaderObjects.glGetObjectParameteriARB(ID, 35716);
        if (logLength <= 1) {
            return;
        }
        System.out.println("\nInfo Log of Shader Object: " + file);
        System.out.println("--------------------------");
        System.out.println(ARBShaderObjects.glGetInfoLogARB(ID, logLength));
    }

    protected static void printShaderProgramInfoLog(int ID) {
        int logLength = ARBShaderObjects.glGetObjectParameteriARB(ID, 35716);
        if (logLength <= 1) {
            return;
        }
        System.out.println("\nShader Program Info Log: ");
        System.out.println("--------------------------");
        System.out.println(ARBShaderObjects.glGetInfoLogARB(ID, logLength));
    }
}

