/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.awt;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.FloatBuffer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.ARBTransposeMatrix;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class DemoBox
extends Frame {
    private DemoBoxGLCanvas demoCanvas;
    private Panel selectionPanel;
    private Hashtable<String, Demo> selectableDemos = new Hashtable();

    public DemoBox() {
        this.selectableDemos.put("default", new NullDemoBox());
        this.selectableDemos.put("clear_color", new ClearColorDemoBox());
        this.selectableDemos.put("gears", new GearsDemoBox());
    }

    public boolean initialize() {
        this.setTitle("LWJGL - Demo Box");
        this.setSize(640, 480);
        this.setLayout(new GridBagLayout());
        this.selectionPanel = new Panel();
        this.selectionPanel.setLayout(new BorderLayout());
        this.selectionPanel.add((Component)new Label("Demo", 1), "North");
        Button fullScreen = new Button("Fullscreen");
        fullScreen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DemoBox.this.toggleFullscreen();
            }
        });
        this.selectionPanel.add((Component)fullScreen, "South");
        List demos = new List();
        Enumeration<String> e = this.selectableDemos.keys();
        while (e.hasMoreElements()) {
            demos.add(e.nextElement().toString());
        }
        this.selectionPanel.add((Component)demos, "Center");
        demos.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                DemoBox.this.demoSelected(event.getItemSelectable().getSelectedObjects()[0].toString());
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 0.05;
        gbc.weighty = 1.0;
        this.add((Component)this.selectionPanel, gbc);
        try {
            this.demoCanvas = new DemoBoxGLCanvas(this);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.fill = 1;
            gbc.weightx = 0.95;
            gbc.weighty = 1.0;
            this.add((Component)this.demoCanvas, gbc);
        }
        catch (LWJGLException le) {
            le.printStackTrace();
            return false;
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DemoBox.this.demoCanvas.destroyCanvas();
                DemoBox.this.dispose();
                System.exit(0);
            }
        });
        return true;
    }

    public void updateFPS(float fps) {
        if (fps != -1.0f) {
            this.setTitle("LWJGL - Demo Box (FPS: " + fps + ")");
        } else {
            this.setTitle("LWJGL - Demo Box");
        }
    }

    protected void toggleFullscreen() {
        System.out.println("Toggle Fullscreen");
    }

    protected void demoSelected(String demo) {
        System.out.println("Selecting demo: " + demo);
        this.demoCanvas.setActiveDemo(this.selectableDemos.get(demo));
    }

    public static void main(String[] args) throws LWJGLException {
        DemoBox demo = new DemoBox();
        demo.initialize();
        demo.setVisible(true);
    }

    public class GearsDemoBox
    implements Demo {
        private boolean initialized;
        private float view_rotx = 20.0f;
        private float view_roty = 30.0f;
        private float view_rotz;
        private int gear1;
        private int gear2;
        private int gear3;
        private float angle;

        public boolean isInitialized() {
            return this.initialized;
        }

        public boolean initialize() {
            FloatBuffer pos = BufferUtils.createFloatBuffer(4).put(new float[]{5.0f, 5.0f, 10.0f, 0.0f});
            FloatBuffer red = BufferUtils.createFloatBuffer(4).put(new float[]{0.8f, 0.1f, 0.0f, 1.0f});
            FloatBuffer green = BufferUtils.createFloatBuffer(4).put(new float[]{0.0f, 0.8f, 0.2f, 1.0f});
            FloatBuffer blue = BufferUtils.createFloatBuffer(4).put(new float[]{0.2f, 0.2f, 1.0f, 1.0f});
            pos.flip();
            red.flip();
            green.flip();
            blue.flip();
            GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            GL11.glLight(16384, 4611, pos);
            GL11.glEnable(2884);
            GL11.glEnable(2896);
            GL11.glEnable(16384);
            GL11.glEnable(2929);
            this.gear1 = GL11.glGenLists(1);
            GL11.glNewList(this.gear1, 4864);
            GL11.glMaterial(1028, 5634, red);
            this.gear(1.0f, 4.0f, 1.0f, 20, 0.7f);
            GL11.glEndList();
            this.gear2 = GL11.glGenLists(1);
            GL11.glNewList(this.gear2, 4864);
            GL11.glMaterial(1028, 5634, green);
            this.gear(0.5f, 2.0f, 2.0f, 10, 0.7f);
            GL11.glEndList();
            this.gear3 = GL11.glGenLists(1);
            GL11.glNewList(this.gear3, 4864);
            GL11.glMaterial(1028, 5634, blue);
            this.gear(1.3f, 2.0f, 0.5f, 10, 0.7f);
            GL11.glEndList();
            GL11.glEnable(2977);
            GL11.glMatrixMode(5889);
            System.err.println("GL_VENDOR: " + GL11.glGetString(7936));
            System.err.println("GL_RENDERER: " + GL11.glGetString(7937));
            System.err.println("GL_VERSION: " + GL11.glGetString(7938));
            System.err.println();
            System.err.println("glLoadTransposeMatrixfARB() supported: " + GLContext.getCapabilities().GL_ARB_transpose_matrix);
            if (!GLContext.getCapabilities().GL_ARB_transpose_matrix) {
                GL11.glLoadIdentity();
            } else {
                FloatBuffer identityTranspose = BufferUtils.createFloatBuffer(16).put(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
                identityTranspose.flip();
                ARBTransposeMatrix.glLoadTransposeMatrixARB(identityTranspose);
            }
            float h = 1.0f;
            GL11.glFrustum(-1.0, 1.0, -h, h, 5.0, 60.0);
            GL11.glMatrixMode(5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef(0.0f, 0.0f, -40.0f);
            this.initialized = true;
            return true;
        }

        public void render() {
            this.angle += 2.0f;
            GL11.glClear(16640);
            GL11.glPushMatrix();
            GL11.glRotatef(this.view_rotx, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(this.view_roty, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(this.view_rotz, 0.0f, 0.0f, 1.0f);
            GL11.glPushMatrix();
            GL11.glTranslatef(-3.0f, -2.0f, 0.0f);
            GL11.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
            GL11.glCallList(this.gear1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef(3.1f, -2.0f, 0.0f);
            GL11.glRotatef(-2.0f * this.angle - 9.0f, 0.0f, 0.0f, 1.0f);
            GL11.glCallList(this.gear2);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef(-3.1f, 4.2f, 0.0f);
            GL11.glRotatef(-2.0f * this.angle - 25.0f, 0.0f, 0.0f, 1.0f);
            GL11.glCallList(this.gear3);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }

        private void gear(float inner_radius, float outer_radius, float width, int teeth, float tooth_depth) {
            float angle;
            int i;
            float r0 = inner_radius;
            float r1 = outer_radius - tooth_depth / 2.0f;
            float r2 = outer_radius + tooth_depth / 2.0f;
            float da = (float)Math.PI * 2 / (float)teeth / 4.0f;
            GL11.glShadeModel(7424);
            GL11.glNormal3f(0.0f, 0.0f, 1.0f);
            GL11.glBegin(8);
            for (i = 0; i <= teeth; ++i) {
                angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
                GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), width * 0.5f);
                GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), width * 0.5f);
                if (i >= teeth) continue;
                GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), width * 0.5f);
                GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), width * 0.5f);
            }
            GL11.glEnd();
            GL11.glBegin(7);
            for (i = 0; i < teeth; ++i) {
                angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
                GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), width * 0.5f);
                GL11.glVertex3f(r2 * (float)Math.cos(angle + da), r2 * (float)Math.sin(angle + da), width * 0.5f);
                GL11.glVertex3f(r2 * (float)Math.cos(angle + 2.0f * da), r2 * (float)Math.sin(angle + 2.0f * da), width * 0.5f);
                GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), width * 0.5f);
            }
            GL11.glEnd();
            GL11.glBegin(8);
            for (i = 0; i <= teeth; ++i) {
                angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
                GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), -width * 0.5f);
                GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), -width * 0.5f);
                GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), -width * 0.5f);
                GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), -width * 0.5f);
            }
            GL11.glEnd();
            GL11.glBegin(7);
            for (i = 0; i < teeth; ++i) {
                angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
                GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), -width * 0.5f);
                GL11.glVertex3f(r2 * (float)Math.cos(angle + 2.0f * da), r2 * (float)Math.sin(angle + 2.0f * da), -width * 0.5f);
                GL11.glVertex3f(r2 * (float)Math.cos(angle + da), r2 * (float)Math.sin(angle + da), -width * 0.5f);
                GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), -width * 0.5f);
            }
            GL11.glEnd();
            GL11.glBegin(8);
            for (i = 0; i < teeth; ++i) {
                angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
                GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), width * 0.5f);
                GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), -width * 0.5f);
                float u = r2 * (float)Math.cos(angle + da) - r1 * (float)Math.cos(angle);
                float v = r2 * (float)Math.sin(angle + da) - r1 * (float)Math.sin(angle);
                float len = (float)Math.sqrt(u * u + v * v);
                GL11.glNormal3f(v /= len, -(u /= len), 0.0f);
                GL11.glVertex3f(r2 * (float)Math.cos(angle + da), r2 * (float)Math.sin(angle + da), width * 0.5f);
                GL11.glVertex3f(r2 * (float)Math.cos(angle + da), r2 * (float)Math.sin(angle + da), -width * 0.5f);
                GL11.glNormal3f((float)Math.cos(angle), (float)Math.sin(angle), 0.0f);
                GL11.glVertex3f(r2 * (float)Math.cos(angle + 2.0f * da), r2 * (float)Math.sin(angle + 2.0f * da), width * 0.5f);
                GL11.glVertex3f(r2 * (float)Math.cos(angle + 2.0f * da), r2 * (float)Math.sin(angle + 2.0f * da), -width * 0.5f);
                u = r1 * (float)Math.cos(angle + 3.0f * da) - r2 * (float)Math.cos(angle + 2.0f * da);
                v = r1 * (float)Math.sin(angle + 3.0f * da) - r2 * (float)Math.sin(angle + 2.0f * da);
                GL11.glNormal3f(v, -u, 0.0f);
                GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), width * 0.5f);
                GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), -width * 0.5f);
                GL11.glNormal3f((float)Math.cos(angle), (float)Math.sin(angle), 0.0f);
            }
            GL11.glVertex3f(r1 * (float)Math.cos(0.0), r1 * (float)Math.sin(0.0), width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(0.0), r1 * (float)Math.sin(0.0), -width * 0.5f);
            GL11.glEnd();
            GL11.glShadeModel(7425);
            GL11.glBegin(8);
            for (i = 0; i <= teeth; ++i) {
                angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
                GL11.glNormal3f(-((float)Math.cos(angle)), -((float)Math.sin(angle)), 0.0f);
                GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), -width * 0.5f);
                GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), width * 0.5f);
            }
            GL11.glEnd();
        }

        public void destroy() {
            GL11.glDeleteLists(this.gear1, 1);
            GL11.glDeleteLists(this.gear2, 1);
            GL11.glDeleteLists(this.gear3, 1);
            this.initialized = false;
        }
    }

    public class NullDemoBox
    implements Demo {
        private boolean initialized;

        public boolean isInitialized() {
            return this.initialized;
        }

        public boolean initialize() {
            GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            return true;
        }

        public void render() {
            GL11.glClear(16384);
        }

        public void destroy() {
            this.initialized = false;
        }
    }

    public class ClearColorDemoBox
    implements Demo {
        private boolean initialized;
        int direction = 1;
        float color;

        public boolean isInitialized() {
            return this.initialized;
        }

        public boolean initialize() {
            this.initialized = true;
            return true;
        }

        public void render() {
            GL11.glClearColor(this.color, this.color, this.color, 1.0f);
            GL11.glClear(16384);
            this.color += (float)this.direction * 0.05f;
            if (this.color > 1.0f) {
                this.color = 1.0f;
                this.direction = -1 * this.direction;
            } else if (this.color < 0.0f) {
                this.direction = -1 * this.direction;
                this.color = 0.0f;
            }
        }

        public void destroy() {
            this.initialized = false;
        }
    }

    private class DemoBoxGLCanvas
    extends AWTGLCanvas
    implements Runnable {
        DemoBox parent;
        Demo activeDemo;
        Demo lastActiveDemo;
        private Thread renderThread;
        long startTime;
        long fps;

        private DemoBoxGLCanvas(DemoBox parent) throws LWJGLException {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintGL() {
            DemoBoxGLCanvas demoBoxGLCanvas = this;
            synchronized (demoBoxGLCanvas) {
                if (this.lastActiveDemo != null && this.lastActiveDemo != this.activeDemo) {
                    this.lastActiveDemo.destroy();
                    this.lastActiveDemo = null;
                    if (this.activeDemo != null) {
                        this.activeDemo.initialize();
                        this.startTime = System.currentTimeMillis() + 5000L;
                    } else {
                        this.parent.updateFPS(-1.0f);
                    }
                }
                if (this.activeDemo != null) {
                    if (!this.activeDemo.isInitialized()) {
                        this.activeDemo.initialize();
                    }
                    this.activeDemo.render();
                    try {
                        this.swapBuffers();
                    }
                    catch (LWJGLException le) {
                        le.printStackTrace();
                    }
                    if (this.startTime > System.currentTimeMillis()) {
                        ++this.fps;
                    } else {
                        long timeUsed = 5000L + (this.startTime - System.currentTimeMillis());
                        this.startTime = System.currentTimeMillis() + 5000L;
                        this.parent.updateFPS((float)this.fps / ((float)timeUsed / 1000.0f));
                        this.fps = 0L;
                    }
                }
            }
        }

        public void destroyCanvas() {
            this.setActiveDemo(null);
            this.renderThread = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setActiveDemo(Demo activeDemo) {
            DemoBoxGLCanvas demoBoxGLCanvas = this;
            synchronized (demoBoxGLCanvas) {
                if (activeDemo == null) {
                    this.lastActiveDemo = this.activeDemo;
                    this.activeDemo = null;
                    return;
                }
                this.lastActiveDemo = this.activeDemo;
                this.activeDemo = activeDemo;
            }
            if (this.renderThread == null) {
                this.renderThread = new Thread(this);
                this.renderThread.setName("DemoBox-Renderer");
                this.renderThread.start();
            }
        }

        private DemoBoxGLCanvas() throws LWJGLException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long sleep_time = 1000L;
            while (this.renderThread != null) {
                DemoBoxGLCanvas demoBoxGLCanvas = this;
                synchronized (demoBoxGLCanvas) {
                    if (this.activeDemo == null) {
                        sleep_time = 1000L;
                    } else {
                        sleep_time = 16L;
                        this.repaint();
                    }
                }
                this.sleep(sleep_time);
            }
            System.out.println("dead");
        }

        private void sleep(long time) {
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static interface Demo {
        public boolean isInitialized();

        public boolean initialize();

        public void render();

        public void destroy();
    }
}

