/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Util;

public final class VersionTest {
    private VersionTest() {
    }

    public static void main(String[] args) {
        VersionTest.initialize(args);
        VersionTest.cleanup();
        System.exit(0);
    }

    private static void initialize(String[] args) {
        boolean coreProfile;
        boolean compatibilityProfile;
        if (args.length < 2) {
            VersionTest.argsError("Insufficient number of arguments");
        }
        int majorInput = 1;
        int minorInput = 0;
        try {
            majorInput = Integer.parseInt(args[0]);
            minorInput = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            VersionTest.argsError("Invalid number format");
        }
        ContextAttribs ca = new ContextAttribs(majorInput, minorInput);
        if (2 < args.length) {
            for (int i = 2; i < args.length; ++i) {
                if ("core".equalsIgnoreCase(args[i])) {
                    ca = ca.withProfileCore(true);
                    continue;
                }
                if ("compatibility".equalsIgnoreCase(args[i])) {
                    ca = ca.withProfileCompatibility(true);
                    continue;
                }
                if ("es".equalsIgnoreCase(args[i])) {
                    ca = ca.withProfileES(true);
                    continue;
                }
                if ("debug".equalsIgnoreCase(args[i])) {
                    ca = ca.withDebug(true);
                    continue;
                }
                if ("fc".equalsIgnoreCase(args[i])) {
                    ca = ca.withForwardCompatible(true);
                    continue;
                }
                if ("robust".equalsIgnoreCase(args[i])) {
                    ca = ca.withRobustAccess(true);
                    continue;
                }
                if ("reset_isolation".equalsIgnoreCase(args[i])) {
                    ca = ca.withContextResetIsolation(true);
                    continue;
                }
                if ("reset_lose".equalsIgnoreCase(args[i])) {
                    ca = ca.withResetNotificationStrategy(33362);
                    continue;
                }
                if ("release_none".equalsIgnoreCase(args[i])) {
                    ca = ca.withContextReleaseBehavior(0);
                    continue;
                }
                if (Pattern.matches("[0-9]+", args[i])) {
                    ca = ca.withLayer(Integer.parseInt(args[i]));
                    continue;
                }
                VersionTest.argsError("Unknown argument: '" + args[i] + "'");
            }
        }
        try {
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            DisplayMode displayMode = VersionTest.chooseMode(modes, 1024, 768);
            if (displayMode == null) {
                displayMode = VersionTest.chooseMode(modes, 800, 600);
            }
            if (displayMode == null) {
                displayMode = VersionTest.chooseMode(modes, 640, 480);
            }
            if (displayMode == null) {
                VersionTest.kill("Failed to set an appropriate display mode.");
            }
            System.out.println("Setting display mode to: " + displayMode);
            Display.setDisplayMode(displayMode);
            Display.create(new PixelFormat(8, 24, 0), ca);
        }
        catch (LWJGLException e) {
            VersionTest.kill(e.getMessage());
        }
        System.out.println("\n---------\n");
        System.out.println("Requested " + ca);
        String version = GL11.glGetString(7938);
        boolean deprecated = false;
        try {
            GL11.glVertex3f(0.0f, 0.0f, 0.0f);
            Util.checkGLError();
            deprecated = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        StringTokenizer version_tokenizer = new StringTokenizer(version, ". ");
        int majorVersion = Integer.parseInt(version_tokenizer.nextToken());
        int minorVersion = Integer.parseInt(version_tokenizer.nextToken());
        if (3 < majorVersion || majorVersion == 3 && 2 <= minorVersion) {
            int profileMask = GL11.glGetInteger(37158);
            compatibilityProfile = (profileMask & 2) != 0;
            coreProfile = (profileMask & 1) != 0;
        } else {
            compatibilityProfile = false;
            coreProfile = false;
        }
        System.out.println("\nGL_VERSION returned : " + version);
        System.out.println("\tCore profile: " + coreProfile);
        System.out.println("\tCompatibility profile: " + compatibilityProfile);
        System.out.println("ARB_compatibility present: " + GLContext.getCapabilities().GL_ARB_compatibility);
        System.out.println("Deprecated functionality present: " + deprecated);
        if (!deprecated && GLContext.getCapabilities().GL_ARB_compatibility) {
            System.out.println("\tARB_compatibility is present, but LWJGL has enabled pseudo-forward compatible mode.");
        }
        System.out.println("\n---------");
        boolean success = false;
        if (majorInput < 3 || majorInput == 3 && minorInput == 0) {
            System.out.println("\nA version less than or equal to 3.0 is requested, the context\nreturned may implement any of the following versions:");
            System.out.println("\n1) Any version no less than that requested and no greater than 3.0.");
            boolean check = (majorInput < majorVersion || majorInput == majorVersion && minorInput <= minorVersion) && (majorVersion < 3 || majorVersion == 3 && minorVersion == 0);
            System.out.println("\t" + check);
            success |= check;
            System.out.println("\n2) Version 3.1, if the GL_ARB_compatibility extension is also implemented.");
            check = majorVersion == 3 && minorVersion == 1 && GLContext.getCapabilities().GL_ARB_compatibility;
            System.out.println("\t" + check);
            success |= check;
            System.out.println("\n3) The compatibility profile of version 3.2 or greater.");
            check = compatibilityProfile;
            System.out.println("\t" + check);
            System.out.println("\nTEST " + ((success |= check) ? "SUCCEEDED" : "FAILED"));
            if (!success && ca.isForwardCompatible()) {
                System.out.println("\t(probably because the forward compatible flag was set)");
            }
        } else if (majorInput == 3 && minorInput == 1) {
            System.out.println("\nVersion 3.1 is requested, the context returned may implement\nany of the following versions:");
            System.out.println("\n1) Version 3.1. The GL_ARB_compatibility extension may or may not\nbe implemented, as determined by the implementation.");
            boolean check = majorVersion == 3 && minorVersion == 1;
            System.out.println("\t" + check);
            success |= check;
            System.out.println("\n2) The core profile of version 3.2 or greater.");
            check = coreProfile;
            System.out.println("\t" + check);
            System.out.println("\nTEST " + ((success |= check) ? "SUCCEEDED" : "FAILED"));
        } else {
            System.out.println("\nVersion 3.2 or greater is requested, the context returned may\nimplement any of the following versions:");
            System.out.println("\n1) The requested profile of the requested version.");
            boolean check = !(majorInput != majorVersion || minorInput != minorVersion || ca.isProfileCompatibility() && !compatibilityProfile || ca.isProfileCore() && !coreProfile);
            System.out.println("\t" + check);
            success |= check;
            System.out.println("\n2) The requested profile of any later version, so long as no\nfeatures have been removed from that later version and profile.");
            check = majorInput < majorVersion || majorInput == majorVersion && minorInput < minorVersion && (!ca.isProfileCompatibility() || compatibilityProfile) && (!ca.isProfileCore() || coreProfile);
            System.out.println("\t" + check);
            System.out.println("\nTEST " + ((success |= check) ? "SUCCEEDED" : "FAILED"));
        }
    }

    private static DisplayMode chooseMode(DisplayMode[] modes, int width, int height) {
        DisplayMode bestMode = null;
        for (DisplayMode mode : modes) {
            if (mode.getWidth() != width || mode.getHeight() != height || mode.getFrequency() > 85 || bestMode != null && (mode.getBitsPerPixel() < bestMode.getBitsPerPixel() || mode.getFrequency() <= bestMode.getFrequency())) continue;
            bestMode = mode;
        }
        return bestMode;
    }

    private static void cleanup() {
        if (Display.isCreated()) {
            Display.destroy();
        }
    }

    private static void argsError(String msg) {
        System.out.println("\nInvalid arguments error: " + msg);
        System.out.println("\nUsage: VersionTest <majorVersion> <minorVersion> {'core'|'compatibility'|'es', 'debug', 'fc', 'robust', 'reset_isolation', 'reset_lose', 'release_none', <layer>}:\n");
        System.out.println("<majorVersion>\t- Major OpenGL version.");
        System.out.println("<majorVersion>\t- Minor OpenGL version.");
        System.out.println("core\t- Sets the Core Profile bit (optional, requires 3.2+).");
        System.out.println("compatibility\t- Sets the Compatibility Profile bit (optional, requires 3.2+).");
        System.out.println("es\t- Sets the OpenGL ES Profile bit (optional, requires 2.0).");
        System.out.println("debug\t- Enables debug mode (optional).");
        System.out.println("fc\t- Enables forward compatibility mode (optional, requires 3.0+).");
        System.out.println("robust\t- Enables robust access (optional).");
        System.out.println("reset_isolation\t- Enables reset isolation (optional).");
        System.out.println("reset_lose\t- Enables lose context on reset (optional).");
        System.out.println("release_none\t- Enables release behavior = none (optional).");
        System.out.println("<layer>\t- Layer plane (optional).");
        VersionTest.cleanup();
        System.exit(-1);
    }

    static void kill(String reason) {
        System.out.println("The VersionTest program was terminated because an error occured.\n");
        System.out.println("Reason: " + (reason == null ? "Unknown" : reason));
        VersionTest.cleanup();
        System.exit(-1);
    }
}

