/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public final class VBOIndexTest {
    private static boolean finished;
    private static float angle;
    private static int buffer_id;
    private static int indices_buffer_id;
    private static FloatBuffer vertices;
    private static ByteBuffer mapped_buffer;
    private static FloatBuffer mapped_float_buffer;
    private static IntBuffer indices;
    private static ByteBuffer mapped_indices_buffer;
    private static IntBuffer mapped_indices_int_buffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arguments) {
        try {
            VBOIndexTest.init();
            while (!finished) {
                Display.update();
                if (!Display.isVisible()) {
                    Thread.sleep(200L);
                } else if (Display.isCloseRequested()) {
                    System.exit(0);
                }
                VBOIndexTest.mainLoop();
                VBOIndexTest.render();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            VBOIndexTest.cleanup();
        }
        System.exit(0);
    }

    private static void mainLoop() {
        int i;
        if ((angle += 1.0f) > 360.0f) {
            angle = 0.0f;
        }
        if (Mouse.getDX() != 0 || Mouse.getDY() != 0 || Mouse.getDWheel() != 0) {
            System.out.println("Mouse moved " + Mouse.getDX() + " " + Mouse.getDY() + " " + Mouse.getDWheel());
        }
        for (i = 0; i < Mouse.getButtonCount(); ++i) {
            if (!Mouse.isButtonDown(i)) continue;
            System.out.println("Button " + i + " down");
        }
        if (Keyboard.isKeyDown(1)) {
            finished = true;
        }
        for (i = 0; i < Keyboard.getNumKeyboardEvents(); ++i) {
            Keyboard.next();
            if (Keyboard.getEventKey() == 1 && Keyboard.getEventKeyState()) {
                finished = true;
            }
            if (Keyboard.getEventKey() != 20 || !Keyboard.getEventKeyState()) continue;
            System.out.println("Current time: " + Sys.getTime());
        }
    }

    private static void render() {
        GL11.glClear(16384);
        GL11.glPushMatrix();
        GL11.glTranslatef(Display.getDisplayMode().getWidth() / 2, Display.getDisplayMode().getHeight() / 2, 0.0f);
        GL11.glRotatef(angle, 0.0f, 0.0f, 1.0f);
        ByteBuffer new_mapped_buffer = ARBVertexBufferObject.glMapBufferARB(34962, 35001, mapped_buffer);
        if (new_mapped_buffer != mapped_buffer) {
            mapped_float_buffer = new_mapped_buffer.order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        mapped_buffer = new_mapped_buffer;
        new_mapped_buffer = ARBVertexBufferObject.glMapBufferARB(34963, 35001, mapped_indices_buffer);
        if (new_mapped_buffer != mapped_indices_buffer) {
            mapped_indices_int_buffer = new_mapped_buffer.order(ByteOrder.nativeOrder()).asIntBuffer();
        }
        mapped_indices_buffer = new_mapped_buffer;
        mapped_float_buffer.rewind();
        vertices.rewind();
        mapped_float_buffer.put(vertices);
        mapped_indices_int_buffer.rewind();
        indices.rewind();
        mapped_indices_int_buffer.put(indices);
        if (ARBVertexBufferObject.glUnmapBufferARB(34962) && ARBVertexBufferObject.glUnmapBufferARB(34963)) {
            GL11.glDrawElements(7, 4, 5125, 0L);
        }
        GL11.glPopMatrix();
    }

    private static void init() throws Exception {
        System.out.println("Timer resolution: " + Sys.getTimerResolution());
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D(0.0f, Display.getDisplayMode().getWidth(), 0.0f, Display.getDisplayMode().getHeight());
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glViewport(0, 0, Display.getDisplayMode().getWidth(), Display.getDisplayMode().getHeight());
        if (!GLContext.getCapabilities().GL_ARB_vertex_buffer_object) {
            System.out.println("ARB VBO not supported!");
            System.exit(1);
        }
        IntBuffer int_buffer = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder()).asIntBuffer();
        ARBVertexBufferObject.glGenBuffersARB(int_buffer);
        buffer_id = int_buffer.get(0);
        indices_buffer_id = int_buffer.get(1);
        ARBVertexBufferObject.glBindBufferARB(34962, buffer_id);
        ARBVertexBufferObject.glBindBufferARB(34963, indices_buffer_id);
        vertices = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
        vertices.put(-50.0f).put(-50.0f).put(50.0f).put(-50.0f).put(50.0f).put(50.0f).put(-50.0f).put(50.0f);
        vertices.rewind();
        indices = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asIntBuffer();
        indices.put(0).put(1).put(2).put(3);
        indices.rewind();
        ARBVertexBufferObject.glBufferDataARB(34962, 32L, 35040);
        ARBVertexBufferObject.glBufferDataARB(34963, 16L, 35040);
        GL11.glEnableClientState(32884);
        GL11.glVertexPointer(2, 5126, 0, 0L);
    }

    private static void cleanup() {
        IntBuffer int_buffer = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder()).asIntBuffer();
        int_buffer.put(0, buffer_id);
        int_buffer.put(1, indices_buffer_id);
        ARBVertexBufferObject.glDeleteBuffersARB(int_buffer);
        Display.destroy();
    }

    static {
        try {
            int mode = -1;
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            for (int i = 0; i < modes.length; ++i) {
                if (modes[i].getWidth() != 640 || modes[i].getHeight() != 480 || modes[i].getBitsPerPixel() < 16) continue;
                mode = i;
                break;
            }
            if (mode != -1) {
                System.out.println("Setting display mode to " + modes[mode]);
                Display.setDisplayMode(modes[mode]);
                System.out.println("Created display.");
            }
        }
        catch (Exception e) {
            System.err.println("Failed to create display due to " + e);
        }
        try {
            Display.create();
            System.out.println("Created OpenGL.");
        }
        catch (Exception e) {
            System.err.println("Failed to create OpenGL due to " + e);
            System.exit(1);
        }
    }
}

