/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.zombietown;

import com.mojang.zombietown.Entity;
import com.mojang.zombietown.ZombieModel;
import org.lwjgl.opengl.GL11;
import org.neocities.dangerzonegame.zombietown.Textures;
import org.neocities.dangerzonegame.zombietown.Town;

public class Pawn
extends Entity {
    public float rot;
    public float timeOffs;
    public float speed;
    public float rotA = (float)(Math.random() + 1.0) * 0.01f;
    ZombieModel model;

    public Pawn(Town town, float x, float y, float z) {
        super(town);
        this.resetPos();
        this.x = x;
        this.y = y;
        this.z = z;
        this.model = new ZombieModel();
        this.timeOffs = (float)Math.random() * 1239813.0f;
        this.rot = (float)(Math.random() * Math.PI * 2.0);
        this.speed = 1.0f;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        float xa = 0.0f;
        float ya = 0.0f;
        this.rot += this.rotA;
        this.rotA = (float)((double)this.rotA * 0.99);
        this.rotA = (float)((double)this.rotA + (Math.random() - Math.random()) * Math.random() * Math.random() * (double)0.01f);
        xa = (float)Math.sin(this.rot);
        ya = (float)Math.cos(this.rot);
        if (this.onGround && Math.random() < 0.01) {
            this.yd = 0.12f;
        }
        this.moveRelative(xa, ya, this.onGround ? 0.02f : 0.005f);
        this.yd = (float)((double)this.yd - 0.005);
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.91f;
        this.yd *= 0.98f;
        this.zd *= 0.91f;
        if (this.onGround) {
            this.xd *= 0.8f;
            this.zd *= 0.8f;
        }
    }

    @Override
    public void render(float a) {
        GL11.glEnable(3553);
        Textures.bindNearest("/pawn.png");
        GL11.glPushMatrix();
        double time = (double)System.nanoTime() / 1.0E9 * 10.0 * (double)this.speed + (double)this.timeOffs;
        float size = 0.058333334f;
        float yy = (float)(-Math.abs(Math.sin(time * 0.6662)) * 5.0 - 23.0);
        GL11.glTranslatef(this.xo + (this.x - this.xo) * a, this.yo + (this.y - this.yo) * a, this.zo + (this.z - this.zo) * a);
        GL11.glScalef(1.0f, -1.0f, 1.0f);
        GL11.glScalef(size, size, size);
        GL11.glTranslatef(0.0f, yy, 0.0f);
        float c = 57.29578f;
        GL11.glRotatef(this.rot * c + 180.0f, 0.0f, 1.0f, 0.0f);
        this.model.render(a);
        GL11.glPopMatrix();
        GL11.glDisable(3553);
    }
}

