/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.zombietown;

import com.mojang.zombietown.AABB;
import java.util.ArrayList;
import org.neocities.dangerzonegame.zombietown.Town;

public class Entity {
    public float xo;
    public float yo;
    public float zo;
    public float x;
    public float y;
    public float z;
    public float xd;
    public float yd;
    public float zd;
    public float xRot;
    public float yRot;
    public AABB bb;
    public boolean onGround = false;
    protected float heightOffset = 0.0f;
    protected Town town;

    public Entity(Town town) {
        this.town = town;
    }

    public void resetPos() {
        float x = 0.0f;
        float y = 2.0f;
        float z = 0.0f;
        this.setPos(x, y, z);
    }

    protected void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        float w = 0.3f;
        float h = 0.9f;
        this.bb = new AABB(x - w, y - h, z - w, x + w, y + h, z + w);
    }

    public void turn(float xo, float yo) {
        this.yRot = (float)((double)this.yRot + (double)xo * 0.15);
        this.xRot = (float)((double)this.xRot - (double)yo * 0.15);
        if (this.xRot < -90.0f) {
            this.xRot = -90.0f;
        }
        if (this.xRot > 90.0f) {
            this.xRot = 90.0f;
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
    }

    public void move(float xa, float ya, float za) {
        float xaOrg = xa;
        float yaOrg = ya;
        float zaOrg = za;
        ArrayList<AABB> aABBs = this.town.getGroundBB();
        int i = 0;
        while (i < aABBs.size()) {
            ya = aABBs.get(i).clipYCollide(this.bb, ya);
            ++i;
        }
        this.bb.move(0.0f, ya, 0.0f);
        i = 0;
        while (i < aABBs.size()) {
            xa = aABBs.get(i).clipXCollide(this.bb, xa);
            ++i;
        }
        this.bb.move(xa, 0.0f, 0.0f);
        i = 0;
        while (i < aABBs.size()) {
            za = aABBs.get(i).clipZCollide(this.bb, za);
            ++i;
        }
        this.bb.move(0.0f, 0.0f, za);
        boolean bl = this.onGround = yaOrg != ya && yaOrg < 0.0f;
        if (xaOrg != xa) {
            this.xd = 0.0f;
        }
        if (yaOrg != ya) {
            this.yd = 0.0f;
        }
        if (zaOrg != za) {
            this.zd = 0.0f;
        }
        this.x = (this.bb.x0 + this.bb.x1) / 2.0f;
        this.y = this.bb.y0 + this.heightOffset;
        this.z = (this.bb.z0 + this.bb.z1) / 2.0f;
    }

    public void moveRelative(float xa, float za, float speed) {
        float dist = xa * xa + za * za;
        if (dist >= 0.01f) {
            dist = speed / (float)Math.sqrt(dist);
            float sin = (float)Math.sin((double)this.yRot * Math.PI / 180.0);
            float cos = (float)Math.cos((double)this.yRot * Math.PI / 180.0);
            this.xd += (xa *= dist) * cos - (za *= dist) * sin;
            this.zd += za * cos + xa * sin;
        }
    }

    public void render(float a) {
    }
}

