/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.zombietown;

import com.mojang.zombietown.Polygon;
import com.mojang.zombietown.Vertex;
import org.lwjgl.opengl.GL11;

public class Cube {
    private Vertex[] vertices;
    private Polygon[] polygons;
    private int xTexOffs;
    private int yTexOffs;
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;

    public Cube(int xTexOffs, int yTexOffs) {
        this.xTexOffs = xTexOffs;
        this.yTexOffs = yTexOffs;
    }

    public void setTexOffs(int xTexOffs, int yTexOffs) {
        this.xTexOffs = xTexOffs;
        this.yTexOffs = yTexOffs;
    }

    public void addBox(float x0, float y0, float z0, int x, int y, int z) {
        this.vertices = new Vertex[8];
        this.polygons = new Polygon[6];
        float x1 = x0 + (float)x;
        float y1 = y0 + (float)y;
        float z1 = z0 + (float)z;
        Vertex u0 = new Vertex(x0, y0, z0, 0.0f, 0.0f);
        Vertex u1 = new Vertex(x1, y0, z0, 0.0f, 8.0f);
        Vertex u2 = new Vertex(x1, y1, z0, 8.0f, 8.0f);
        Vertex u3 = new Vertex(x0, y1, z0, 8.0f, 0.0f);
        Vertex l0 = new Vertex(x0, y0, z1, 0.0f, 0.0f);
        Vertex l1 = new Vertex(x1, y0, z1, 0.0f, 8.0f);
        Vertex l2 = new Vertex(x1, y1, z1, 8.0f, 8.0f);
        Vertex l3 = new Vertex(x0, y1, z1, 8.0f, 0.0f);
        this.vertices[0] = u0;
        this.vertices[1] = u1;
        this.vertices[2] = u2;
        this.vertices[3] = u3;
        this.vertices[4] = l0;
        this.vertices[5] = l1;
        this.vertices[6] = l2;
        this.vertices[7] = l3;
        this.polygons[0] = new Polygon(new Vertex[]{l1, u1, u2, l2}, this.xTexOffs + z + x, this.yTexOffs + z, this.xTexOffs + z + x + z, this.yTexOffs + z + y);
        this.polygons[1] = new Polygon(new Vertex[]{u0, l0, l3, u3}, this.xTexOffs + 0, this.yTexOffs + z, this.xTexOffs + z, this.yTexOffs + z + y);
        this.polygons[2] = new Polygon(new Vertex[]{l1, l0, u0, u1}, this.xTexOffs + z, this.yTexOffs + 0, this.xTexOffs + z + x, this.yTexOffs + z);
        this.polygons[3] = new Polygon(new Vertex[]{u2, u3, l3, l2}, this.xTexOffs + z + x, this.yTexOffs + 0, this.xTexOffs + z + x + x, this.yTexOffs + z);
        this.polygons[4] = new Polygon(new Vertex[]{u1, u0, u3, u2}, this.xTexOffs + z, this.yTexOffs + z, this.xTexOffs + z + x, this.yTexOffs + z + y);
        this.polygons[5] = new Polygon(new Vertex[]{l0, l1, l2, l3}, this.xTexOffs + z + x + z, this.yTexOffs + z, this.xTexOffs + z + x + z + x, this.yTexOffs + z + y);
    }

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void render() {
        float c = 57.29578f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)this.z);
        GL11.glRotatef((float)(this.zRot * c), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(this.yRot * c), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(this.xRot * c), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glBegin((int)7);
        int i = 0;
        while (i < this.polygons.length) {
            this.polygons[i].render();
            ++i;
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }
}

