/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.DesertRainFrog;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Frog
extends EntityLiving {
    private int singing = 0;
    private int jumpcount = 0;
    Texture texture2 = null;
    Texture texture3 = null;
    Texture texture4 = null;
    Texture texture5 = null;
    Texture texture6 = null;
    Texture texture7 = null;
    Texture texture8 = null;
    Texture texture9 = null;
    Texture texture10 = null;
    Texture texture11 = null;
    Texture texture12 = null;
    Texture texture13 = null;
    Texture texture14 = null;
    Texture texture15 = null;
    Texture texture16 = null;
    Texture texture17 = null;
    Texture texture18 = null;
    Texture texture19 = null;
    Texture texture20 = null;
    Texture texture21 = null;
    Texture texture22 = null;
    Texture texture23 = null;
    Texture texture24 = null;

    public Frog(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = "DangerZone:Frog";
        this.moveSpeed = 0.16f;
        this.setMaxHealth(2.0f);
        this.setHealth(2.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(2.0f);
        this.movefrequency = 40;
        this.setExperience(1);
        this.canSwim = true;
        this.takesFallDamage = false;
        this.attackRange = 1.0f;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.searchDistance = 8.0f;
        this.enable_droppedfood = true;
        this.foodsearchDistance = 10;
        this.enable_hostile = true;
        this.canridemaglevcart = true;
    }

    @Override
    public void init() {
        super.init();
        this.setSinging(false);
        if (this.getBID() == 0) {
            this.setBID(DangerZone.rand.nextInt(2) + 1);
            if (DangerZone.rand.nextInt(3) == 1) {
                this.setBID(DangerZone.rand.nextInt(2) + 3);
                if (DangerZone.rand.nextInt(3) == 1) {
                    this.setBID(DangerZone.rand.nextInt(2) + 5);
                }
            }
            if (DangerZone.rand.nextInt(10) > 5) {
                if (DangerZone.rand.nextInt(2) == 1) {
                    this.setBID(this.getBID() + 6);
                } else {
                    this.setBID(this.getBID() + 12);
                    if (DangerZone.rand.nextInt(2) == 1) {
                        this.setBID(this.getBID() + 6);
                    }
                }
            }
        }
    }

    @Override
    public boolean isFoodItem(int foodid) {
        return foodid == Items.deadbug.itemID;
    }

    @Override
    public void onKill(Entity e) {
        this.heal(1.0f);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Frog) {
            return false;
        }
        if (e instanceof DesertRainFrog) {
            return false;
        }
        if (e.getWidth() * e.getHeight() > 0.53f) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            if (this.singing > 0) {
                --this.singing;
                if (this.singing <= 0) {
                    this.setSinging(false);
                }
            }
            if (this.jumpcount > 0) {
                --this.jumpcount;
            }
            if (this.jumpcount == 0 && this.world.rand.nextInt(50) == 1) {
                this.jumpAround();
                this.jumpcount = 50;
            }
            if (this.world.rand.nextInt(10000) == 10 && this.getCanDespawn()) {
                this.deadflag = true;
            }
        }
        super.update(deltaT);
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(2) == 1) {
            return null;
        }
        this.setSinging(true);
        this.singing = 20;
        if (this.world.rand.nextInt(2) == 1) {
            return "DangerZone:frog2";
        }
        return "DangerZone:frog1";
    }

    @Override
    public float getLivingSoundPitch() {
        return 1.5f;
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public void doDeathDrops() {
        int i = this.getBID();
        if (i == 1) {
            Utils.doDropRand(this.world, 0, Items.frog_speed1.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 2) {
            Utils.doDropRand(this.world, 0, Items.frog_slowness1.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 3) {
            Utils.doDropRand(this.world, 0, Items.frog_speed2.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 4) {
            Utils.doDropRand(this.world, 0, Items.frog_slowness2.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 5) {
            Utils.doDropRand(this.world, 0, Items.frog_speed3.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 6) {
            Utils.doDropRand(this.world, 0, Items.frog_slowness3.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 7) {
            Utils.doDropRand(this.world, 0, Items.frog_strength1.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 8) {
            Utils.doDropRand(this.world, 0, Items.frog_weakness1.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 9) {
            Utils.doDropRand(this.world, 0, Items.frog_strength2.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 10) {
            Utils.doDropRand(this.world, 0, Items.frog_weakness2.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 11) {
            Utils.doDropRand(this.world, 0, Items.frog_strength3.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 12) {
            Utils.doDropRand(this.world, 0, Items.frog_weakness3.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 13) {
            Utils.doDropRand(this.world, 0, Items.frog_regen1.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 14) {
            Utils.doDropRand(this.world, 0, Items.frog_poison1.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 15) {
            Utils.doDropRand(this.world, 0, Items.frog_regen2.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 16) {
            Utils.doDropRand(this.world, 0, Items.frog_poison2.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 17) {
            Utils.doDropRand(this.world, 0, Items.frog_regen3.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 18) {
            Utils.doDropRand(this.world, 0, Items.frog_poison3.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 19) {
            Utils.doDropRand(this.world, 0, Items.frog_confusion1.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 20) {
            Utils.doDropRand(this.world, 0, Items.frog_confusion2.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 21) {
            Utils.doDropRand(this.world, 0, Items.frog_confusion3.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 22) {
            Utils.doDropRand(this.world, 0, Items.frog_morph1.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 23) {
            Utils.doDropRand(this.world, 0, Items.frog_morph2.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (i == 24) {
            Utils.doDropRand(this.world, 0, Items.frog_morph3.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
    }

    private void jumpAround() {
        this.target = null;
        this.motiony += 0.85f + Math.abs(this.world.rand.nextFloat() * 0.85f);
        this.posy += (double)0.33f;
        float f = 0.88f + Math.abs(this.world.rand.nextFloat() * 0.95f);
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        this.motionx = (float)((double)this.motionx + (double)f * Math.sin(cdir));
        this.motionz = (float)((double)this.motionz + (double)f * Math.cos(cdir));
    }

    @Override
    public Texture getTexture() {
        int i;
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/FrogtextureSpeed1.png");
            this.texture2 = TextureMapper.getTexture("res/skins/FrogtextureSlowness1.png");
            this.texture3 = TextureMapper.getTexture("res/skins/FrogtextureSpeed2.png");
            this.texture4 = TextureMapper.getTexture("res/skins/FrogtextureSlowness2.png");
            this.texture5 = TextureMapper.getTexture("res/skins/FrogtextureSpeed3.png");
            this.texture6 = TextureMapper.getTexture("res/skins/FrogtextureSlowness3.png");
            this.texture7 = TextureMapper.getTexture("res/skins/FrogtextureStrength1.png");
            this.texture8 = TextureMapper.getTexture("res/skins/FrogtextureWeakness1.png");
            this.texture9 = TextureMapper.getTexture("res/skins/FrogtextureStrength2.png");
            this.texture10 = TextureMapper.getTexture("res/skins/FrogtextureWeakness2.png");
            this.texture11 = TextureMapper.getTexture("res/skins/FrogtextureStrength3.png");
            this.texture12 = TextureMapper.getTexture("res/skins/FrogtextureWeakness3.png");
            this.texture13 = TextureMapper.getTexture("res/skins/FrogtextureRegen1.png");
            this.texture14 = TextureMapper.getTexture("res/skins/FrogtexturePoison1.png");
            this.texture15 = TextureMapper.getTexture("res/skins/FrogtextureRegen2.png");
            this.texture16 = TextureMapper.getTexture("res/skins/FrogtexturePoison2.png");
            this.texture17 = TextureMapper.getTexture("res/skins/FrogtextureRegen3.png");
            this.texture18 = TextureMapper.getTexture("res/skins/FrogtexturePoison3.png");
            this.texture19 = TextureMapper.getTexture("res/skins/FrogtextureConfusion1.png");
            this.texture20 = TextureMapper.getTexture("res/skins/FrogtextureConfusion2.png");
            this.texture21 = TextureMapper.getTexture("res/skins/FrogtextureConfusion3.png");
            this.texture22 = TextureMapper.getTexture("res/skins/FrogtextureMorph1.png");
            this.texture23 = TextureMapper.getTexture("res/skins/FrogtextureMorph2.png");
            this.texture24 = TextureMapper.getTexture("res/skins/FrogtextureMorph3.png");
        }
        if ((i = this.getBID()) == 2) {
            return this.texture2;
        }
        if (i == 3) {
            return this.texture3;
        }
        if (i == 4) {
            return this.texture4;
        }
        if (i == 5) {
            return this.texture5;
        }
        if (i == 6) {
            return this.texture6;
        }
        if (i == 7) {
            return this.texture7;
        }
        if (i == 8) {
            return this.texture8;
        }
        if (i == 9) {
            return this.texture9;
        }
        if (i == 10) {
            return this.texture10;
        }
        if (i == 11) {
            return this.texture11;
        }
        if (i == 12) {
            return this.texture12;
        }
        if (i == 13) {
            return this.texture13;
        }
        if (i == 14) {
            return this.texture14;
        }
        if (i == 15) {
            return this.texture15;
        }
        if (i == 16) {
            return this.texture16;
        }
        if (i == 17) {
            return this.texture17;
        }
        if (i == 18) {
            return this.texture18;
        }
        if (i == 19) {
            return this.texture19;
        }
        if (i == 20) {
            return this.texture20;
        }
        if (i == 21) {
            return this.texture21;
        }
        if (i == 22) {
            return this.texture22;
        }
        if (i == 23) {
            return this.texture23;
        }
        if (i == 24) {
            return this.texture24;
        }
        return this.texture;
    }
}

