/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityShredder;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class BlockShredder
extends Block {
    Texture ttop = null;
    Texture tbottom = null;
    Texture tleft = null;
    String topname = "res/blocks/shredder_top.png";
    String bottomname = "res/blocks/shredder_bottom.png";
    String leftname = "res/blocks/shredder_side.png";
    StitchedTexture sttop = new StitchedTexture();
    StitchedTexture stbottom = new StitchedTexture();
    StitchedTexture stleft = new StitchedTexture();

    public BlockShredder(String n) {
        super(n, "");
        this.maxstack = 1;
        this.isWood = false;
        this.burntime = 0;
    }

    @Override
    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int s) {
        if (p == null || p.world.isServer) {
            return false;
        }
        List<Entity> nearby_list = null;
        EntityShredder ec = null;
        nearby_list = DangerZone.entityManager.findEntitiesInRange(2.0f, dimension, x, y, z);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof EntityShredder) || (int)e.posx != x || (int)e.posy != y || (int)e.posz != z) continue;
                ec = (EntityShredder)e;
                break;
            }
        }
        if (ec == null) {
            Entity eb = p.world.createEntityByName("DangerZone:EntityShredder", dimension, (double)x + 0.5, (double)y + (double)0.05f, (double)z + 0.5);
            if (eb != null) {
                eb.init();
                p.world.spawnEntityInWorld(eb);
            }
            return false;
        }
        DangerZone.shreddergui.ec = ec;
        DangerZone.setActiveGui(DangerZone.shreddergui);
        return false;
    }

    @Override
    public void onBlockPlaced(World w, int dimension, int x, int y, int z) {
        Entity eb;
        if (w.isServer && (eb = w.createEntityByName("DangerZone:EntityShredder", dimension, (double)x + 0.5, (double)y + (double)0.05f, (double)z + 0.5)) != null) {
            eb.init();
            w.spawnEntityInWorld(eb);
        }
    }

    @Override
    public Texture getTexture(int side) {
        if (this.ttop == null) {
            this.ttop = this.initBlockTexture(this.topname);
        }
        if (this.tbottom == null) {
            this.tbottom = this.initBlockTexture(this.bottomname);
        }
        if (this.tleft == null) {
            this.tleft = this.initBlockTexture(this.leftname);
        }
        if (side == 0) {
            return this.ttop;
        }
        if (side == 5) {
            return this.tbottom;
        }
        if (side == 3) {
            return this.tleft;
        }
        if (side == 4) {
            return this.tleft;
        }
        if (side == 1) {
            return this.tleft;
        }
        if (side == 2) {
            return this.tleft;
        }
        return null;
    }

    @Override
    public StitchedTexture getStitchedTexture(int side) {
        if (side == 0) {
            return this.sttop;
        }
        if (side == 5) {
            return this.stbottom;
        }
        if (side == 3) {
            return this.stleft;
        }
        if (side == 4) {
            return this.stleft;
        }
        if (side == 1) {
            return this.stleft;
        }
        return this.stleft;
    }

    @Override
    public String getStitchedTextureName(int side) {
        if (side == 0) {
            return this.topname;
        }
        if (side == 5) {
            return this.bottomname;
        }
        if (side == 3) {
            return this.leftname;
        }
        if (side == 4) {
            return this.leftname;
        }
        if (side == 1) {
            return this.leftname;
        }
        return this.leftname;
    }
}

