/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlockItem;

public class BlockLeaves
extends Block {
    public BlockLeaves(String n, String txt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.breaksound = "DangerZone:leavesbreak";
        this.placesound = "DangerZone:leavesplace";
        this.hitsound = "DangerZone:leaves_hit";
        this.isLeaves = true;
        this.randomtick = true;
        this.maxdamage = 5;
        this.burntime = 10;
    }

    @Override
    public String getStepSound() {
        int i = DangerZone.rand.nextInt(4);
        if (i == 0) {
            return "DangerZone:leaves1";
        }
        if (i == 1) {
            return "DangerZone:leaves2";
        }
        if (i == 2) {
            return "DangerZone:leaves3";
        }
        return "DangerZone:leaves4";
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        EntityBlockItem e;
        if (w.getblock(d, x, y - 1, z) == 0 && w.rand.nextInt(30) == 0) {
            Utils.spawnParticlesFromServer(w, "DangerZone:ParticleLeaves", 1, d, x, (double)y - (double)0.1f, z, this.blockID);
        }
        int i = -2;
        while (i <= 2) {
            int j = -2;
            while (j <= 0) {
                int k = -2;
                while (k <= 2) {
                    int t = Math.abs(i) + Math.abs(j) + Math.abs(k);
                    if (t <= 3 && Blocks.canLeavesGrow(w.getblock(d, x + i, y + j, z + k))) {
                        return;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        w.setblock(d, x, y, z, 0);
        if (w.getblock(d, x, y - 1, z) == 0) {
            Utils.spawnParticlesFromServer(w, "DangerZone:ParticleLeaves", 5, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.blockID);
        }
        if (w.rand.nextInt(500) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
            e.fill(this, 1);
            w.spawnEntityInWorld(e);
        }
    }

    @Override
    public void onBlockBroken(Player p, int dimension, int x, int y, int z, int s) {
        EntityBlockItem e;
        super.onBlockBroken(p, dimension, x, y, z, s);
        if (p == null) {
            return;
        }
        if (DangerZone.rand.nextInt(10) != 1) {
            return;
        }
        int bid = 0;
        int which = DangerZone.rand.nextInt(10);
        if (this.blockID == Blocks.willowleaves.blockID) {
            if (which == 0 && DangerZone.rand.nextInt(5) == 2) {
                bid = Blocks.sapling_bigroundwillow.blockID;
            }
            if (which == 1) {
                bid = Blocks.sapling_umbrella.blockID;
            }
            if (which == 2) {
                bid = Blocks.sapling_bulb.blockID;
            }
            if (which == 3) {
                bid = Blocks.sapling_looplowspiral.blockID;
            }
            if (which == 4) {
                bid = Blocks.sapling_loop.blockID;
            }
            if (which == 5) {
                bid = Blocks.sapling_tallwillow.blockID;
            }
        } else if (this.blockID == Blocks.redwoodleaves.blockID) {
            if (which == 0) {
                bid = Blocks.sapling_scragglyredwood.blockID;
            }
            if (which == 1 && DangerZone.rand.nextInt(5) == 2) {
                bid = Blocks.sapling_bigroundredwood.blockID;
            }
            if (which == 2) {
                bid = Blocks.sapling_vase.blockID;
            }
            if (which == 3) {
                bid = Blocks.sapling_spiral.blockID;
            }
            if (which == 4) {
                bid = Blocks.sapling_loopspiral.blockID;
            }
            if (which == 5) {
                bid = Blocks.sapling_bowl.blockID;
            }
            if (which == 6) {
                bid = Blocks.sapling_doublebowl.blockID;
            }
        } else if (this.blockID == Blocks.leaves.blockID) {
            if (which == 0) {
                bid = Blocks.sapling_tallwood.blockID;
            }
            if (which == 1) {
                bid = Blocks.sapling_scraggly.blockID;
            }
            if (which == 2) {
                bid = Blocks.sapling_scrub.blockID;
            }
            if (which == 3) {
                bid = Blocks.sapling_generic.blockID;
            }
        } else if (this.blockID == Blocks.redleaves.blockID || this.blockID == Blocks.orangeleaves.blockID || this.blockID == Blocks.yellowleaves.blockID || this.blockID == Blocks.greenleaves.blockID) {
            if (which == 0) {
                bid = Blocks.sapling_flower.blockID;
            }
            if (which == 1) {
                bid = Blocks.sapling_flowertwo.blockID;
            }
            if (which == 2) {
                bid = Blocks.sapling_flowernormal.blockID;
            }
        }
        if (bid != 0 && (e = (EntityBlockItem)p.world.createEntityByName(DangerZone.blockitemname, dimension, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
            e.fill(bid, 0, 1);
            p.world.spawnEntityInWorld(e);
        }
    }
}

