/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.biomes;

import dangerzone.Chunk;
import dangerzone.DangerZone;
import dangerzone.DangerZoneBase;
import dangerzone.Ores;
import dangerzone.World;
import dangerzone.biomes.Biome;
import dangerzone.biomes.OverWorldBiomeManager;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Blocks;

public class OverWorldBiome
extends Biome {
    Trees tr = new Trees();

    public OverWorldBiome(String n) {
        super(n);
    }

    @Override
    public void generateheightmaps(World w, int d, Chunk c, int cx, int cz, int[][] dirtheight, int[][] stoneheight, int[][] baseheight) {
        OverWorldBiomeManager obm = DangerZoneBase.overworld_biomemanager;
        obm.localgenerateheightmaps(w, d, c, cx, cz, dirtheight, stoneheight, baseheight);
    }

    @Override
    public void generate(World w, int d, Chunk c, int cx, int cz, int[][] dirtheight, int[][] stoneheight, int[][] bottomheight) {
        int j = 0;
        while (j < 200) {
            int i = 0;
            while (i < 16) {
                int k = 0;
                while (k < 16) {
                    if (j < stoneheight[i][k]) {
                        c.setblock(i, j, k, Blocks.stone.blockID);
                    } else if (j <= this.waterlevel) {
                        c.setblock(i, j, k, Blocks.waterstatic.blockID);
                        if (j == this.waterlevel && c.getblock(i, j - 1, k) == Blocks.stone.blockID) {
                            c.setblock(i, j - 1, k, Blocks.sand.blockID);
                        }
                    } else {
                        if (j < dirtheight[i][k] && c.getblock(i, j - 1, k) != 0 && c.getblock(i, j - 1, k) != Blocks.waterstatic.blockID && j < 150) {
                            if (j < 100) {
                                c.setblock(i, j, k, Blocks.dirt.blockID);
                            } else if (DangerZone.rand.nextInt(150 - j) > 5) {
                                c.setblock(i, j, k, Blocks.dirt.blockID);
                            }
                        }
                        if (j == dirtheight[i][k] && c.getblock(i, j - 1, k) == Blocks.dirt.blockID && j < 130) {
                            if (j < 100) {
                                c.setblock(i, j, k, Blocks.grassblock.blockID);
                                c.setblockmeta(i, j, k, w.rand.nextInt(4) << 12);
                            } else if (DangerZone.rand.nextInt(130 - j) > 5) {
                                c.setblock(i, j, k, Blocks.grassblock.blockID);
                                c.setblockmeta(i, j, k, w.rand.nextInt(4) << 12);
                            }
                        }
                    }
                    if (j == 0) {
                        c.setblock(i, j, k, Blocks.stopblock.blockID);
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        Ores.generate(w, d, this, c, cx, cz);
    }

    @Override
    public void decorate(World world, int d, Chunk c, int chunkx, int chunkz) {
        this.tr.addGrass(world, d, chunkx << 4, chunkz << 4, c);
    }
}

