/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.gui;

import dangerzone.DangerZone;
import dangerzone.TextureMapper;
import dangerzone.blocks.Blocks;
import dangerzone.gui.GuiInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.newdawn.slick.opengl.Texture;

public class PlayerColoringGUI
extends GuiInterface {
    List<MyButtonHandler> buttons;
    float[][][] colordata = null;
    boolean leftdown = false;
    int thisbid = 0;
    int cred = 138;
    int cgreen = 128;
    int cblue = 118;
    int dimension;
    int px;
    int py;
    int pz;

    public void init(int tb, int d, int x, int y, int z) {
        this.colordata = new float[16][16][4];
        this.thisbid = tb;
        this.dimension = d;
        this.px = x;
        this.py = y;
        this.pz = z;
        byte[] b = Blocks.getTexture(this.thisbid).getTextureData();
        int k = 0;
        int j = 0;
        while (j < 16) {
            int i = 0;
            while (i < 16) {
                int cl = b[k];
                ++k;
                if (cl < 0) {
                    cl += 256;
                }
                this.colordata[i][15 - j][0] = cl;
                cl = b[k];
                ++k;
                if (cl < 0) {
                    cl += 256;
                }
                this.colordata[i][15 - j][1] = cl;
                cl = b[k];
                ++k;
                if (cl < 0) {
                    cl += 256;
                }
                this.colordata[i][15 - j][2] = cl;
                this.colordata[i][15 - j][3] = 255.0f;
                ++i;
            }
            ++j;
        }
    }

    @Override
    public void process() {
        Texture backtexture = null;
        Texture buttontexture = null;
        MyButtonHandler mb = null;
        MyButtonHandler fb = null;
        int starty = DangerZone.screen_height - 200;
        int startx = DangerZone.screen_width / 2 + 300;
        backtexture = TextureMapper.getTexture("res/menus/back.png");
        buttontexture = TextureMapper.getTexture("res/menus/button.png");
        this.buttons = new ArrayList<MyButtonHandler>();
        this.buttons.add(new MyButtonHandler(DangerZone.screen_width / 2 - 150, starty, 100, 100, backtexture, null, 0));
        this.drawcoloredsquare(DangerZone.screen_width / 2 - 2, DangerZone.screen_height / 2 - 102, 260, 260, 255.0f, 255.0f, 255.0f, 255.0f);
        this.drawcoloredsquare(DangerZone.screen_width / 2 - 1, DangerZone.screen_height / 2 - 101, 258, 258, 0.0f, 0.0f, 0.0f, 255.0f);
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                this.drawcoloredsquare(DangerZone.screen_width / 2 + i * 16, DangerZone.screen_height / 2 + j * 16 - 100, 16, 16, this.colordata[i][j][0] / 256.0f, this.colordata[i][j][1] / 256.0f, this.colordata[i][j][2] / 256.0f, this.colordata[i][j][3] / 256.0f);
                this.buttons.add(new MyButtonHandler(DangerZone.screen_width / 2 + i * 16, DangerZone.screen_height / 2 + j * 16 - 100, 16, 16, null, null, i * 16 + j + 1));
                ++j;
            }
            ++i;
        }
        starty = DangerZone.screen_height / 2;
        this.drawcoloredsquare(startx, starty - 100, 32, 256, 1.0f, 1.0f, 1.0f, 1.0f);
        this.drawcoloredsquare(startx + 8, starty - 100, 16, this.cred, 1.0f, 0.0f, 0.0f, 1.0f);
        this.buttons.add(new MyButtonHandler(startx, starty - 150, 32, 32, buttontexture, "+", 258));
        this.buttons.add(new MyButtonHandler(startx, starty - 190, 32, 32, buttontexture, "-", 259));
        this.drawcoloredsquare(startx + 50, starty - 100, 32, 256, 1.0f, 1.0f, 1.0f, 1.0f);
        this.drawcoloredsquare(startx + 58, starty - 100, 16, this.cgreen, 0.0f, 1.0f, 0.0f, 1.0f);
        this.buttons.add(new MyButtonHandler(startx + 50, starty - 150, 32, 32, buttontexture, "+", 260));
        this.buttons.add(new MyButtonHandler(startx + 50, starty - 190, 32, 32, buttontexture, "-", 261));
        this.drawcoloredsquare(startx + 100, starty - 100, 32, 256, 1.0f, 1.0f, 1.0f, 1.0f);
        this.drawcoloredsquare(startx + 108, starty - 100, 16, this.cblue, 0.0f, 0.0f, 1.0f, 1.0f);
        this.buttons.add(new MyButtonHandler(startx + 100, starty - 150, 32, 32, buttontexture, "+", 262));
        this.buttons.add(new MyButtonHandler(startx + 100, starty - 190, 32, 32, buttontexture, "-", 263));
        this.drawcoloredsquare(startx, starty + 200, 132, 32, (float)this.cred / 256.0f, (float)this.cgreen / 256.0f, (float)this.cblue / 256.0f, 1.0f);
        this.buttons.add(new MyButtonHandler(DangerZone.screen_width / 2 + 75, starty + 200, 100, 40, buttontexture, "Save", 257));
        Iterator<MyButtonHandler> bb = this.buttons.iterator();
        while (bb.hasNext()) {
            bb.next().draw();
        }
        while (this.K_next()) {
            if (this.K_getEventKey() != 1 || !this.K_isKeyDown(1)) continue;
            this.ImAllDone();
            return;
        }
        while (this.M_next()) {
            int clickx = this.M_getEventX();
            int clicky = this.M_getEventY();
            if (this.M_getEventButtonState()) {
                if (this.M_getEventButton() < 0) continue;
                bb = this.buttons.iterator();
                fb = null;
                while (bb.hasNext()) {
                    mb = bb.next();
                    if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                    fb = mb;
                    break;
                }
                if (this.M_getEventButton() == 0) {
                    if (fb != null) {
                        fb.leftclickhandler();
                    }
                    this.leftdown = true;
                }
                if (this.M_getEventButton() != 1 || fb == null) continue;
                fb.rightclickhandler();
                continue;
            }
            if (this.M_getEventButton() != 0) continue;
            this.leftdown = false;
        }
        int cx = this.M_getX();
        int cy = this.M_getY();
        bb = this.buttons.iterator();
        fb = null;
        while (bb.hasNext()) {
            mb = bb.next();
            if (cx < mb.x || cx > mb.x + mb.xsize || cy < mb.y || cy > mb.y + mb.ysize) continue;
            if (this.leftdown && mb.buttonid >= 1 && mb.buttonid <= 256) {
                mb.leftclickhandler();
            }
            if (!this.leftdown || mb.buttonid < 258 || mb.buttonid > 263) continue;
            mb.leftclickhandler();
        }
    }

    public void doSaveBlock() {
        String blkname = Blocks.getUniqueName(this.thisbid);
        if (blkname == null) {
            return;
        }
        DangerZone.player.server_connection.sendColoringBlock(this.thisbid, this.dimension, this.px, this.py, this.pz, this.colordata);
    }

    private class MyButtonHandler
    extends GuiInterface.ButtonHandler {
        public int buttonid;

        MyButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int i) {
            super(xpos, ypos, bxsize, bysize, tx, ot);
            this.buttonid = i;
        }

        @Override
        public void leftclickhandler() {
            if (this.buttonid == 0) {
                PlayerColoringGUI.this.ImAllDone();
                return;
            }
            if (this.buttonid >= 1 && this.buttonid <= 256) {
                int i = this.buttonid - 1;
                PlayerColoringGUI.this.colordata[i / 16][i % 16][0] = PlayerColoringGUI.this.cred;
                PlayerColoringGUI.this.colordata[i / 16][i % 16][1] = PlayerColoringGUI.this.cgreen;
                PlayerColoringGUI.this.colordata[i / 16][i % 16][2] = PlayerColoringGUI.this.cblue;
                return;
            }
            DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);
            if (this.buttonid == 257) {
                PlayerColoringGUI.this.doSaveBlock();
                return;
            }
            if (this.buttonid == 258) {
                ++PlayerColoringGUI.this.cred;
                if (PlayerColoringGUI.this.cred > 255) {
                    PlayerColoringGUI.this.cred = 255;
                }
                return;
            }
            if (this.buttonid == 259) {
                --PlayerColoringGUI.this.cred;
                if (PlayerColoringGUI.this.cred < 0) {
                    PlayerColoringGUI.this.cred = 0;
                }
                return;
            }
            if (this.buttonid == 260) {
                ++PlayerColoringGUI.this.cgreen;
                if (PlayerColoringGUI.this.cgreen > 255) {
                    PlayerColoringGUI.this.cgreen = 255;
                }
                return;
            }
            if (this.buttonid == 261) {
                --PlayerColoringGUI.this.cgreen;
                if (PlayerColoringGUI.this.cgreen < 0) {
                    PlayerColoringGUI.this.cgreen = 0;
                }
                return;
            }
            if (this.buttonid == 262) {
                ++PlayerColoringGUI.this.cblue;
                if (PlayerColoringGUI.this.cblue > 255) {
                    PlayerColoringGUI.this.cblue = 255;
                }
                return;
            }
            if (this.buttonid == 263) {
                --PlayerColoringGUI.this.cblue;
                if (PlayerColoringGUI.this.cblue < 0) {
                    PlayerColoringGUI.this.cblue = 0;
                }
                return;
            }
        }

        @Override
        public void rightclickhandler() {
            this.leftclickhandler();
        }
    }
}

