/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.BreakChecks;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.Utils;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlockItem;
import dangerzone.threads.VBODataBuilderThread;
import org.lwjgl.opengl.GL11;

public class LightStick
extends Block {
    private boolean compiled = false;
    private int myrenderid = 0;
    private float blockrenderwidth = 16.0f;

    public LightStick(String n, String txt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.alwaysRender = true;
        this.hasOwnRenderer = true;
        this.brightness = 0.75f;
        this.maxdamage = 1;
        this.randomtick = true;
        this.burntime = 30;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = 0;
        int meta = w.getblockmeta(d, x, y, z);
        if (!w.isServer) {
            return;
        }
        if (w.getblock(d, x, y, z) != this.blockID) {
            return;
        }
        switch (meta >> 8) {
            case 1: {
                bid = w.getblock(d, x, y, z - 1);
                break;
            }
            case 2: {
                bid = w.getblock(d, x, y, z + 1);
                break;
            }
            case 3: {
                bid = w.getblock(d, x + 1, y, z);
                break;
            }
            case 4: {
                bid = w.getblock(d, x - 1, y, z);
                break;
            }
            case 5: {
                bid = w.getblock(d, x, y + 1, z);
                break;
            }
            default: {
                bid = w.getblock(d, x, y - 1, z);
            }
        }
        if (!Blocks.isSolid(bid)) {
            if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
                return;
            }
            w.setblock(d, x, y, z, 0);
            EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            if (e != null) {
                e.fill(this, 1);
                w.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        Utils.spawnParticlesFromServer(w, "DangerZone:ParticleFire", w.rand.nextInt(3) + 3, d, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        int brw = (int)(this.blockrenderwidth / 2.0f);
        st = VBODataBuilderThread.findVBOtextureforblockside(0, bid);
        v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v != null) {
            switch (meta >> 8) {
                case 1: {
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    break;
                }
                case 2: {
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    break;
                }
                case 3: {
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    break;
                }
                case 4: {
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    break;
                }
                case 5: {
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    break;
                }
                default: {
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
                }
            }
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            this.myrenderid = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)this.myrenderid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glEnd();
            GL11.glEndList();
            this.compiled = true;
        }
        switch (meta >> 8) {
            case 1: {
                GL11.glPushMatrix();
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glPushMatrix();
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glPushMatrix();
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case 4: {
                GL11.glPushMatrix();
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case 5: {
                GL11.glPushMatrix();
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        wr.loadtextureforblockside(0, bid, false);
        GL11.glCallList((int)this.myrenderid);
        switch (meta >> 8) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    public boolean doPlaceBlock(int focusbid, Player p, World w, int dimension, int x, int y, int z, int side) {
        if (!Blocks.isSolid(focusbid)) {
            return false;
        }
        if (Blocks.isLeaves(focusbid)) {
            return false;
        }
        if (!Blocks.isSolidThisSide(focusbid, w, dimension, x, y, z, side)) {
            return false;
        }
        if (!BreakChecks.canChangeBlock(p, dimension, x, y, z, this.blockID, 0)) {
            return false;
        }
        switch (side) {
            case 0: {
                w.setblockandmeta(dimension, x, y + 1, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y + 1, z);
                break;
            }
            case 1: {
                w.setblockandmeta(dimension, x, y, z + 1, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y, z + 1);
                break;
            }
            case 2: {
                w.setblockandmeta(dimension, x, y, z - 1, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y, z - 1);
                break;
            }
            case 3: {
                w.setblockandmeta(dimension, x - 1, y, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x - 1, y, z);
                break;
            }
            case 4: {
                w.setblockandmeta(dimension, x + 1, y, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x + 1, y, z);
                break;
            }
            case 5: {
                w.setblockandmeta(dimension, x, y - 1, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y - 1, z);
            }
        }
        w.playSound(Blocks.getPlaceSound(this.blockID), dimension, x, y, z, 0.5f, 1.0f);
        return true;
    }
}

