/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.BreakChecks;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.threads.VBODataBuilderThread;
import org.lwjgl.opengl.GL11;

public class ButterflyPlant
extends Block {
    private boolean compiled = false;
    private int myrenderid = 0;
    private float blockrenderwidth = 12.0f;

    public ButterflyPlant(String n, String txt) {
        super(n, txt);
        this.breaksound = "DangerZone:leavesbreak";
        this.placesound = "DangerZone:leavesplace";
        this.hitsound = "DangerZone:leaves_hit";
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.randomtick = true;
        this.isLeaves = true;
        this.maxdamage = 1;
        this.burntime = 10;
        this.showInInventory = true;
        if (!n.equals("DangerZone:Butterfly Plant")) {
            this.showInInventory = false;
        }
    }

    @Override
    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return Blocks.butterfly_plant.blockID;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            EntityBlockItem e;
            w.setblock(d, x, y, z, 0);
            if (w.rand.nextInt(4) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                e.fill(Blocks.butterfly_plant, 1);
                w.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return;
        }
        if (w.getblock(d, x, y + 1, z) != 0) {
            w.setblock(d, x, y, z, 0);
            return;
        }
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            w.setblock(d, x, y, z, 0);
            return;
        }
        if (w.isDaytime() && w.rand.nextInt(15) == 1) {
            int howmany = 1 + w.rand.nextInt(3);
            if (this.blockID == Blocks.butterfly_plant1.blockID) {
                ++howmany;
            }
            if (this.blockID == Blocks.butterfly_plant2.blockID) {
                howmany += 2;
            }
            if (this.blockID == Blocks.butterfly_plant3.blockID) {
                howmany += 3;
            }
            int i = 0;
            while (i < howmany) {
                Entity eb = w.createEntityByName("DangerZone:Butterfly", d, (double)x + 0.5, (double)y + (double)1.05f, (double)z + 0.5);
                if (eb != null) {
                    eb.init();
                    w.spawnEntityInWorld(eb);
                }
                ++i;
            }
            if (w.rand.nextInt(5) == 1) {
                int growto = 0;
                if (this.blockID == Blocks.butterfly_plant.blockID) {
                    growto = Blocks.butterfly_plant1.blockID;
                }
                if (this.blockID == Blocks.butterfly_plant1.blockID) {
                    growto = Blocks.butterfly_plant2.blockID;
                }
                if (this.blockID == Blocks.butterfly_plant2.blockID) {
                    growto = Blocks.butterfly_plant3.blockID;
                }
                if (growto != 0) {
                    if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
                        return;
                    }
                    w.setblock(d, x, y, z, growto);
                }
            }
        }
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        float brw = this.blockrenderwidth / 2.0f;
        st = VBODataBuilderThread.findVBOtextureforblockside(0, bid);
        v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo - 2.0f, brw + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo - 2.0f, brw + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo - 2.0f, brw + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo - 2.0f, brw + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo - 2.0f, -brw + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo - 2.0f, -brw + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo - 2.0f, -brw + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo - 2.0f, -brw + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo - 2.0f, brw + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo - 2.0f, -brw + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo - 2.0f, -brw + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo - 2.0f, brw + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo - 2.0f, -brw + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo - 2.0f, brw + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo - 2.0f, brw + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo - 2.0f, -brw + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            this.myrenderid = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)this.myrenderid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f - 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f - 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f - 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f - 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f - 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f - 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f - 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f - 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f - 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f - 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f - 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f - 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f - 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f - 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f - 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f - 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glEnd();
            GL11.glEndList();
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        GL11.glCallList((int)this.myrenderid);
    }
}

