/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.ModelBetterFence;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.threads.FastBlockTicker;
import dangerzone.threads.VBODataBuilderThread;
import java.util.List;
import java.util.ListIterator;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.Texture;

public class BlockBarrier
extends Block {
    private static ModelBetterFence mbf = null;
    private String fulltexturestring = null;
    private Texture fulltexture = null;

    public BlockBarrier(String n, String txt, String fulltxt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.isSolid = true;
        this.hasOwnRenderer = true;
        this.renderAllSides = true;
        this.renderSmaller = true;
        this.alwaysRender = true;
        this.alwaystick = true;
        this.maxdamage = 10;
        this.burntime = 30;
        this.fulltexturestring = fulltxt;
        if (mbf == null) {
            mbf = new ModelBetterFence();
        }
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid;
        if (w.isServer && !Blocks.isSolid(bid = w.getblock(d, x, y - 1, z))) {
            w.setblock(d, x, y, z, 0);
        }
    }

    @Override
    public void tickMeFast(World w, int d, int x, int y, int z) {
        this.tickMe(w, d, x, y, z);
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (w.isServer) {
            int bid = w.getblock(d, x, y - 1, z);
            if (!Blocks.isSolid(bid)) {
                w.setblock(d, x, y, z, 0);
                return;
            }
            int meta = 0;
            if (Blocks.isSolid(w.getblock(d, x + 1, y, z))) {
                meta |= 1;
            }
            if (Blocks.isSolid(w.getblock(d, x - 1, y, z))) {
                meta |= 2;
            }
            if (Blocks.isSolid(w.getblock(d, x, y, z + 1))) {
                meta |= 4;
            }
            if (Blocks.isSolid(w.getblock(d, x, y, z - 1))) {
                meta |= 8;
            }
            w.setblockandmeta(d, x, y, z, this.blockID, meta);
            if (bid == Blocks.autofence.blockID) {
                return;
            }
            FastBlockTicker.addFastTick(d, x, y, z, 2);
            List<Entity> nearby_list = null;
            Entity e = null;
            int maxh = 0;
            nearby_list = DangerZone.server.entityManager.findEntitiesInRange(16.0f, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            if (nearby_list != null && !nearby_list.isEmpty()) {
                ListIterator<Entity> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    Player p;
                    InventoryContainer ic;
                    float dist;
                    e = li.next();
                    if (!(e instanceof EntityLiving)) continue;
                    if (maxh < 2) {
                        maxh = 2;
                    }
                    if (e.getHeight() * 2.0f + 0.9f > (float)maxh) {
                        maxh = (int)(e.getHeight() * 2.0f + 0.9f);
                    }
                    if (!(e instanceof Player) || !((double)(dist = (float)Math.sqrt((e.posx - ((double)x + 0.5)) * (e.posx - ((double)x + 0.5)) + (e.posz - ((double)z + 0.5)) * (e.posz - ((double)z + 0.5)))) < 1.5) || (ic = (p = (Player)e).getHotbar(p.gethotbarindex())) == null || ic.iid != Items.autofencekey.itemID) continue;
                    maxh = 0;
                    break;
                }
            }
            if (maxh > 1) {
                int i = 1;
                while (i < maxh) {
                    if (w.getblock(d, x, y + i, z) == 0) {
                        w.setblock(d, x, y + i, z, this.blockID);
                    }
                    ++i;
                }
                if (w.rand.nextInt(2000) == 1) {
                    w.playSound("DangerZone:arc", d, x, y, z, 0.1f, 1.0f);
                }
            } else if (w.getblock(d, x, y + 1, z) == this.blockID) {
                w.setblock(d, x, y + 1, z, 0);
            }
        }
    }

    @Override
    public float getBrightness(World w, int d, int x, int y, int z) {
        if (w.getblock(d, x, y + 1, z) == this.blockID) {
            return 0.45f;
        }
        return 0.0f;
    }

    @Override
    public int getBlockDrop(Player p, World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y - 1, z);
        if (bid == this.blockID) {
            return 0;
        }
        return this.blockID;
    }

    @Override
    public Texture getTexture(int side) {
        if (this.texture == null || this.fulltexture == null) {
            this.texture = this.initBlockTexture(this.texturepath);
            this.fulltexture = this.initBlockTexture(this.fulltexturestring);
        }
        if (side == 5) {
            return this.fulltexture;
        }
        return this.texture;
    }

    @Override
    public String getStitchedTextureName(int side) {
        return this.fulltexturestring;
    }

    @Override
    public void renderMeHeld(WorldRenderer wr, Entity e, int bid, boolean isdisplay) {
        if (e == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)4.0f, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        this.renderMe(wr, e.world, e.dimension, (int)e.posx, (int)e.posy, (int)e.posz, bid, 0, 0, false);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glPopMatrix();
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        st = VBODataBuilderThread.findVBOtextureforblockside(5, bid);
        if (st == null) {
            return;
        }
        v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v == null) {
            return;
        }
        BlockBarrier.mbf.post.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockBarrier.mbf.postA.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        if ((meta & 1) == 1) {
            BlockBarrier.mbf.side1.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
            BlockBarrier.mbf.side2.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
            BlockBarrier.mbf.side3.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
            BlockBarrier.mbf.side1A.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        }
        if ((meta & 2) == 2) {
            BlockBarrier.mbf.side1.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 180);
            BlockBarrier.mbf.side2.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 180);
            BlockBarrier.mbf.side3.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 180);
            BlockBarrier.mbf.side1A.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 180);
        }
        if ((meta & 4) == 4) {
            BlockBarrier.mbf.side1.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 90);
            BlockBarrier.mbf.side2.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 90);
            BlockBarrier.mbf.side3.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 90);
            BlockBarrier.mbf.side1A.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 90);
        }
        if ((meta & 8) == 8) {
            BlockBarrier.mbf.side1.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, -90);
            BlockBarrier.mbf.side2.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, -90);
            BlockBarrier.mbf.side3.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, -90);
            BlockBarrier.mbf.side1A.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, -90);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        wr.loadtextureforblockside(5, bid, false);
        GL11.glTranslatef((float)0.0f, (float)-8.0f, (float)0.0f);
        BlockBarrier.mbf.post.render(1.0f);
        BlockBarrier.mbf.postA.render(1.0f);
        if ((meta & 1) == 1) {
            BlockBarrier.mbf.side1.render(1.0f);
            BlockBarrier.mbf.side2.render(1.0f);
            BlockBarrier.mbf.side3.render(1.0f);
            BlockBarrier.mbf.side1A.render(1.0f);
        }
        if ((meta & 2) == 2) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            BlockBarrier.mbf.side1.render(1.0f);
            BlockBarrier.mbf.side2.render(1.0f);
            BlockBarrier.mbf.side3.render(1.0f);
            BlockBarrier.mbf.side1A.render(1.0f);
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((meta & 4) == 4) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            BlockBarrier.mbf.side1.render(1.0f);
            BlockBarrier.mbf.side2.render(1.0f);
            BlockBarrier.mbf.side3.render(1.0f);
            BlockBarrier.mbf.side1A.render(1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((meta & 8) == 8) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            BlockBarrier.mbf.side1.render(1.0f);
            BlockBarrier.mbf.side2.render(1.0f);
            BlockBarrier.mbf.side3.render(1.0f);
            BlockBarrier.mbf.side1A.render(1.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }
}

