/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.biomes;

import dangerzone.Chunk;
import dangerzone.World;
import dangerzone.blocks.Blocks;

public class Trees {
    public void addHighTrees(World world, int d, int cx, int cz, Chunk chunk) {
        if (world.rand.nextInt(8) != 0) {
            return;
        }
        int howmany = 0;
        int what = world.rand.nextInt(6);
        howmany = world.rand.nextInt(3);
        if (what != 0) {
            howmany *= 2;
        }
        int i = 0;
        while (i < howmany) {
            int posX = cx + world.rand.nextInt(16);
            int posZ = cz + world.rand.nextInt(16);
            int posY = 220;
            while (posY > 100) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    if (what == 0) {
                        this.TallWoodTree(world, d, posX, posY, posZ);
                        break;
                    }
                    if (what == 1) {
                        this.makeFruitTree(world, d, posX, posY - 1, posZ, Blocks.cherryleaves.blockID);
                        break;
                    }
                    this.ScragglyRedwoodTree(world, d, posX, posY, posZ);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addTrees(World world, int d, int chunkX, int chunkZ) {
        if (world.rand.nextInt(5) != 0) {
            return;
        }
        int howmany = 0;
        int what = world.rand.nextInt(5);
        howmany = world.rand.nextInt(5);
        if (what != 0) {
            howmany *= 2;
        }
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    if (what == 0) {
                        this.ScragglyTreeWithBranches(world, d, posX, posY, posZ);
                        break;
                    }
                    if (what == 1) {
                        this.makeFruitTree(world, d, posX, posY - 1, posZ, Blocks.peachleaves.blockID);
                        break;
                    }
                    if (world.rand.nextInt(20) == 0) {
                        this.MakeBigRoundTree(world, d, posX, posY, posZ, Blocks.redwoodlog.blockID, Blocks.redwoodleaves.blockID, 6);
                    }
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addFlowerTrees(World world, int d, int chunkX, int chunkZ) {
        if (world.rand.nextInt(3) != 0) {
            return;
        }
        int howmany = 0;
        howmany = world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    this.flowerTree(world, d, posX, posY - 1, posZ);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addFlowerTwoTrees(World world, int d, int chunkX, int chunkZ) {
        if (world.rand.nextInt(3) != 0) {
            return;
        }
        int howmany = 0;
        howmany = world.rand.nextInt(6);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    this.flowerTreeTwo(world, d, posX, posY - 1, posZ);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addScrubTrees(World world, int d, int chunkX, int chunkZ) {
        if (world.rand.nextInt(5) != 0) {
            return;
        }
        int howmany = 0;
        howmany = world.rand.nextInt(5);
        int which = world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.sand.blockID) {
                    this.scrubTree(world, d, posX, posY - 1, posZ, which);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addForestTrees(World world, int d, int chunkX, int chunkZ) {
        int howmany = 0;
        howmany = 1 + world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    this.flowerTreeNormal(world, d, posX, posY - 1, posZ);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addUmbrellaTrees(World world, int d, int chunkX, int chunkZ) {
        int howmany = 0;
        howmany = world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    this.umbrellaTree(world, d, posX, posY - 1, posZ);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addBulbTrees(World world, int d, int chunkX, int chunkZ) {
        int howmany = 0;
        howmany = world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    this.bulbTree(world, d, posX, posY - 1, posZ);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addlooplowspiralTree(World world, int d, int chunkX, int chunkZ) {
        int howmany = 0;
        howmany = world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    this.looplowspiralTree(world, d, posX, posY - 1, posZ);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addloopTree(World world, int d, int chunkX, int chunkZ) {
        int howmany = 0;
        howmany = 1 + world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    this.loopTree(world, d, posX, posY - 1, posZ);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public boolean addBigRoundLightTree(World world, int d, int chunkX, int chunkZ) {
        if (world.rand.nextInt(5) != 0) {
            return false;
        }
        int posX = chunkX + world.rand.nextInt(16);
        int posZ = chunkZ + world.rand.nextInt(16);
        int posY = 128;
        while (posY > 40) {
            if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                if (world.rand.nextInt(20) == 0) {
                    this.MakeBigRoundTree(world, d, posX, posY, posZ, Blocks.willowlog.blockID, Blocks.willowleaves.blockID, 6);
                    return true;
                }
                return false;
            }
            --posY;
        }
        return false;
    }

    public boolean addGenericTrees(World world, int d, int chunkX, int chunkZ) {
        if (world.rand.nextInt(5) != 0) {
            return false;
        }
        int howmany = 0;
        boolean added = false;
        howmany = 2 + world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    this.makeGenericTree(world, d, posX, posY - 1, posZ);
                    added = true;
                    break;
                }
                --posY;
            }
            ++i;
        }
        return added;
    }

    public boolean addTallWillowTrees(World world, int d, int chunkX, int chunkZ) {
        if (world.rand.nextInt(5) != 0) {
            return false;
        }
        int howmany = 0;
        boolean added = false;
        howmany = 2 + world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    this.TallWillowTree(world, d, posX, posY - 1, posZ);
                    added = true;
                    break;
                }
                --posY;
            }
            ++i;
        }
        return added;
    }

    public void addGrass(World world, int d, int chunkX, int chunkZ, Chunk chunk) {
        int howmany = 0;
        howmany = 5 + world.rand.nextInt(10);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    world.setblock(d, posX, posY, posZ, Blocks.grass.blockID);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addGrassHigh(World world, int d, int chunkX, int chunkZ, Chunk chunk) {
        int howmany = 0;
        howmany = 5 + world.rand.nextInt(10);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 228;
            while (posY > 80) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    world.setblock(d, posX, posY, posZ, Blocks.grass.blockID);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public void makeScragglyRedwoodTreeBranch(World world, int d, int x, int y, int z, int len, int biasx, int biasz) {
        int k = 0;
        while (k < len) {
            int iy;
            int bid;
            int ix = world.rand.nextInt(2) - world.rand.nextInt(2) + biasx;
            int iz = world.rand.nextInt(2) - world.rand.nextInt(2) + biasz;
            if (ix > 1) {
                ix = 1;
            }
            if (ix < -1) {
                ix = -1;
            }
            if (iz > 1) {
                iz = 1;
            }
            if (iz < -1) {
                iz = -1;
            }
            if ((bid = world.getblock(d, x += ix, y += (iy = world.rand.nextInt(3) > 0 ? 1 : 0), z += iz)) != 0 && bid != Blocks.redwoodlog.blockID && bid != Blocks.redwoodleaves.blockID) {
                return;
            }
            world.setblocknonotify(d, x, y, z, Blocks.redwoodlog.blockID);
            int m = -1;
            while (m < 2) {
                int n = -1;
                while (n < 2) {
                    if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                        world.setblocknonotify(d, x + m, y, z + n, Blocks.redwoodleaves.blockID);
                    }
                    ++n;
                }
                ++m;
            }
            if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x, y + 1, z)) == 0) {
                world.setblocknonotify(d, x, y + 1, z, Blocks.redwoodleaves.blockID);
            }
            ++k;
        }
    }

    public void ScragglyRedwoodTree(World world, int d, int x, int y, int z) {
        int bid;
        int i = 1 + world.rand.nextInt(3);
        int j = i + world.rand.nextInt(12);
        int k = 0;
        while (k < i) {
            bid = world.getblock(d, x, y + k, z);
            if (k >= 1 && bid != 0 && bid != Blocks.redwoodlog.blockID && bid != Blocks.redwoodleaves.blockID) {
                return;
            }
            world.setblocknonotify(d, x, y + k, z, Blocks.redwoodlog.blockID);
            ++k;
        }
        y += i - 1;
        k = i;
        while (k < j) {
            int ix = world.rand.nextInt(2) - world.rand.nextInt(2);
            int iz = world.rand.nextInt(2) - world.rand.nextInt(2);
            int iy = world.rand.nextInt(4) > 0 ? 1 : 0;
            bid = world.getblock(d, x += ix, y += iy, z += iz);
            if (bid != 0 && bid != Blocks.redwoodlog.blockID && bid != Blocks.redwoodleaves.blockID) break;
            world.setblock(d, x, y, z, Blocks.redwoodlog.blockID);
            if (world.rand.nextInt(4) == 1) {
                this.makeScragglyRedwoodTreeBranch(world, d, x, y, z, world.rand.nextInt(1 + j - k), world.rand.nextInt(2) - world.rand.nextInt(2), world.rand.nextInt(2) - world.rand.nextInt(2));
            }
            int m = -1;
            while (m < 2) {
                int n = -1;
                while (n < 2) {
                    if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                        world.setblocknonotify(d, x + m, y, z + n, Blocks.redwoodleaves.blockID);
                    }
                    ++n;
                }
                ++m;
            }
            if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x, y + 1, z)) == 0) {
                world.setblocknonotify(d, x, y + 1, z, Blocks.redwoodleaves.blockID);
            }
            ++k;
        }
    }

    public void TallWillowTree(World world, int d, int x, int y, int z) {
        int n;
        int m;
        int bid;
        int i = 10 + world.rand.nextInt(12);
        int j = i + world.rand.nextInt(18);
        int k = 0;
        while (k < i) {
            bid = world.getblock(d, x, y + k, z);
            if (k >= 1 && bid != 0 && bid != Blocks.willowlog.blockID && bid != Blocks.willowleaves.blockID) {
                return;
            }
            world.setblocknonotify(d, x, y + k, z, Blocks.willowlog.blockID);
            ++k;
        }
        y += i - 1;
        k = i;
        while (k < j) {
            if ((bid = world.getblock(d, x, ++y, z)) != 0 && bid != Blocks.willowlog.blockID && bid != Blocks.willowleaves.blockID) break;
            world.setblocknonotify(d, x, y, z, Blocks.willowlog.blockID);
            if (k % 4 == 0) {
                m = -1;
                while (m < 2) {
                    n = -1;
                    while (n < 2) {
                        if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                            world.setblocknonotify(d, x + m, y, z + n, Blocks.willowleaves.blockID);
                        }
                        ++n;
                    }
                    ++m;
                }
            }
            ++k;
        }
        ++y;
        m = -1;
        while (m < 2) {
            n = -1;
            while (n < 2) {
                if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                    world.setblocknonotify(d, x + m, y, z + n, Blocks.willowlog.blockID);
                }
                ++n;
            }
            ++m;
        }
        m = -3;
        while (m < 4) {
            n = -3;
            while (n < 4) {
                bid = world.getblock(d, x + m, y, z + n);
                if (bid == 0) {
                    world.setblocknonotify(d, x + m, y, z + n, Blocks.willowleaves.blockID);
                }
                ++n;
            }
            ++m;
        }
        ++y;
        m = -1;
        while (m < 2) {
            n = -1;
            while (n < 2) {
                bid = world.getblock(d, x + m, y, z + n);
                if (bid == 0) {
                    world.setblocknonotify(d, x + m, y, z + n, Blocks.willowleaves.blockID);
                }
                ++n;
            }
            ++m;
        }
    }

    public void TallWoodTree(World world, int d, int x, int y, int z) {
        int n;
        int m;
        int bid;
        int i = 5 + world.rand.nextInt(6);
        int j = 2 + i + world.rand.nextInt(12);
        int k = 0;
        while (k < i) {
            bid = world.getblock(d, x, y + k, z);
            if (k >= 1 && bid != 0 && bid != Blocks.log.blockID && bid != Blocks.leaves.blockID) {
                return;
            }
            world.setblocknonotify(d, x, y + k, z, Blocks.log.blockID);
            ++k;
        }
        y += i - 1;
        k = i;
        while (k < j) {
            if ((bid = world.getblock(d, x, ++y, z)) != 0 && bid != Blocks.log.blockID && bid != Blocks.leaves.blockID) break;
            world.setblocknonotify(d, x, y, z, Blocks.log.blockID);
            if (k % 4 == 0) {
                m = -1;
                while (m < 2) {
                    n = -1;
                    while (n < 2) {
                        if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                            world.setblocknonotify(d, x + m, y, z + n, Blocks.leaves.blockID);
                        }
                        ++n;
                    }
                    ++m;
                }
            }
            ++k;
        }
        ++y;
        m = -1;
        while (m < 2) {
            n = -1;
            while (n < 2) {
                if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                    world.setblocknonotify(d, x + m, y, z + n, Blocks.log.blockID);
                }
                ++n;
            }
            ++m;
        }
        m = -3;
        while (m < 4) {
            n = -3;
            while (n < 4) {
                bid = world.getblock(d, x + m, y, z + n);
                if (bid == 0) {
                    world.setblocknonotify(d, x + m, y, z + n, Blocks.leaves.blockID);
                }
                ++n;
            }
            ++m;
        }
        ++y;
        m = -1;
        while (m < 2) {
            n = -1;
            while (n < 2) {
                bid = world.getblock(d, x + m, y, z + n);
                if (bid == 0) {
                    world.setblocknonotify(d, x + m, y, z + n, Blocks.leaves.blockID);
                }
                ++n;
            }
            ++m;
        }
    }

    public void ScragglyTreeWithBranches(World world, int d, int x, int y, int z) {
        int bid;
        int i = 1 + world.rand.nextInt(2);
        int j = i + world.rand.nextInt(10);
        int k = 0;
        while (k < i) {
            bid = world.getblock(d, x, y + k, z);
            if (k >= 1 && bid != 0 && bid != Blocks.log.blockID && bid != Blocks.leaves.blockID) {
                return;
            }
            world.setblocknonotify(d, x, y + k, z, Blocks.log.blockID);
            ++k;
        }
        y += i - 1;
        k = i;
        while (k < j) {
            int ix = world.rand.nextInt(2) - world.rand.nextInt(2);
            int iz = world.rand.nextInt(2) - world.rand.nextInt(2);
            int iy = world.rand.nextInt(4) > 0 ? 1 : 0;
            bid = world.getblock(d, x += ix, y += iy, z += iz);
            if (bid != 0 && bid != Blocks.log.blockID && bid != Blocks.leaves.blockID) break;
            world.setblocknonotify(d, x, y, z, Blocks.log.blockID);
            if (world.rand.nextInt(4) == 1) {
                this.makeScragglyBranch(world, d, x, y, z, world.rand.nextInt(1 + j - k), world.rand.nextInt(2) - world.rand.nextInt(2), world.rand.nextInt(2) - world.rand.nextInt(2));
            }
            int m = -1;
            while (m < 2) {
                int n = -1;
                while (n < 2) {
                    if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                        world.setblocknonotify(d, x + m, y, z + n, Blocks.leaves.blockID);
                    }
                    ++n;
                }
                ++m;
            }
            if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x, y + 1, z)) == 0) {
                world.setblocknonotify(d, x, y + 1, z, Blocks.leaves.blockID);
            }
            ++k;
        }
    }

    public void makeScragglyBranch(World world, int d, int x, int y, int z, int len, int biasx, int biasz) {
        int k = 0;
        while (k < len) {
            int iy;
            int bid;
            int ix = world.rand.nextInt(2) - world.rand.nextInt(2) + biasx;
            int iz = world.rand.nextInt(2) - world.rand.nextInt(2) + biasz;
            if (ix > 1) {
                ix = 1;
            }
            if (ix < -1) {
                ix = -1;
            }
            if (iz > 1) {
                iz = 1;
            }
            if (iz < -1) {
                iz = -1;
            }
            if ((bid = world.getblock(d, x += ix, y += (iy = world.rand.nextInt(3) > 0 ? 1 : 0), z += iz)) != 0 && bid != Blocks.log.blockID && bid != Blocks.leaves.blockID) {
                return;
            }
            world.setblocknonotify(d, x, y, z, Blocks.log.blockID);
            int m = -1;
            while (m < 2) {
                int n = -1;
                while (n < 2) {
                    if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                        world.setblocknonotify(d, x + m, y, z + n, Blocks.leaves.blockID);
                    }
                    ++n;
                }
                ++m;
            }
            if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x, y + 1, z)) == 0) {
                world.setblocknonotify(d, x, y + 1, z, Blocks.leaves.blockID);
            }
            ++k;
        }
    }

    public boolean isBoringBaseBlock(World world, int d, int x, int y, int z) {
        int b = world.getblock(d, x, y, z);
        if (b == 0) {
            return true;
        }
        if (b == Blocks.dirt.blockID) {
            return true;
        }
        if (b == Blocks.grassblock.blockID) {
            return true;
        }
        if (b == Blocks.stone.blockID) {
            return false;
        }
        return false;
    }

    public boolean isBoringBlock(World world, int d, int x, int y, int z) {
        int b = world.getblock(d, x, y, z);
        if (b == 0) {
            return true;
        }
        return Blocks.isLeaves(b);
    }

    public void MakeBigRoundTree(World world, int dimension, int inx, int y, int inz, int ID, int leafID, int t_radius) {
        double fcurz;
        double fcurx;
        double dt;
        double rad = t_radius;
        int cury = 0;
        int ibranch = 0;
        double fx = inx;
        fx += 0.5;
        double fz = inz;
        fz += 0.5;
        cury = y;
        int i = 0;
        while (i < 360) {
            dt = rad * Math.sin(Math.toRadians(i));
            fcurx = (float)dt;
            fcurz = (float)(dt = rad * Math.cos(Math.toRadians(i)));
            if (this.isBoringBaseBlock(world, dimension, (int)(fx + fcurx), cury, (int)(fz + fcurz))) {
                int j = 0;
                while (j < 20) {
                    if (cury - j > 0) {
                        if (!this.isBoringBaseBlock(world, dimension, (int)(fx + fcurx), cury - j, (int)(fz + fcurz))) break;
                        world.setblocknonotify(dimension, (int)(fx + fcurx), cury - j, (int)(fz + fcurz), ID);
                    }
                    ++j;
                }
            }
            ++i;
        }
        cury = 1;
        while (rad > 0.0) {
            i = 0;
            while (i < 360) {
                dt = rad * Math.sin(Math.toRadians(i));
                fcurx = (float)dt;
                fcurz = (float)(dt = rad * Math.cos(Math.toRadians(i)));
                if (this.isBoringBaseBlock(world, dimension, (int)(fx + fcurx), y + cury, (int)(fz + fcurz))) {
                    world.setblocknonotify(dimension, (int)(fx + fcurx), y + cury, (int)(fz + fcurz), ID);
                }
                ++i;
            }
            if (cury > (int)rad) {
                if ((ibranch += 80 + world.rand.nextInt(80)) > 360) {
                    ibranch -= 360;
                }
                int ibranchlen = (int)(rad * 5.0) + world.rand.nextInt((int)rad + 2);
                dt = rad * Math.sin(Math.toRadians(ibranch));
                fcurx = (float)dt;
                dt = rad * Math.cos(Math.toRadians(ibranch));
                fcurz = (float)dt;
                this.MakeRoundBranch(world, dimension, ibranch, ibranchlen, (int)rad + 1, fx + fcurx, y + cury, fz + fcurz, ID, leafID);
            }
            if (cury % 6 == 0 && rad > 3.0) {
                double dr = rad - 0.25;
                while (dr > 0.0) {
                    i = 0;
                    while (i < 360) {
                        dt = dr * Math.sin(Math.toRadians(i));
                        fcurx = (float)dt;
                        fcurz = (float)(dt = dr * Math.cos(Math.toRadians(i)));
                        if (this.isBoringBaseBlock(world, dimension, (int)(fx + fcurx), y + cury, (int)(fz + fcurz))) {
                            world.setblocknonotify(dimension, (int)(fx + fcurx), y + cury, (int)(fz + fcurz), ID);
                        }
                        ++i;
                    }
                    dr -= 0.25;
                }
            }
            ++cury;
            rad -= 0.01 * (double)world.rand.nextInt(15);
        }
    }

    private void MakeRoundBranch(World world, int dimension, int iangle, int branchlen, int width, double startx, int starty, double startz, int ID, int leafID) {
        double deltadir = 0.06283185200000001;
        double deltamag = 0.35f;
        int ixlast = 0;
        int izlast = 0;
        int radius = branchlen / 2;
        double centerx = startx + (double)radius * Math.sin(Math.toRadians(iangle));
        double centerz = startz + (double)radius * Math.cos(Math.toRadians(iangle));
        izlast = 0;
        ixlast = 0;
        double curdir = -3.1415926;
        while (curdir < 3.1415926) {
            double h = 0.75;
            while (h < (double)radius) {
                int ix = (int)(centerx + Math.cos(curdir) * h);
                int iz = (int)(centerz + Math.sin(curdir) * h);
                if (ix != ixlast || iz != izlast) {
                    ixlast = ix;
                    izlast = iz;
                    int id = ID;
                    if ((double)radius - h < 2.0) {
                        id = leafID;
                    }
                    if (this.isBoringBlock(world, dimension, ix, starty, iz)) {
                        world.setblocknonotify(dimension, ix, starty, iz, id);
                    }
                }
                h += deltamag;
            }
            curdir += deltadir;
        }
    }

    public void makeFruitTree(World world, int dimension, int x, int y, int z, int blkid) {
        int var = 0;
        int bid = world.getblock(dimension, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        int h1 = 12;
        int h2 = 6;
        int h3 = 9;
        int h4 = 6;
        int h5 = 14;
        int w1 = 5;
        int w2 = 3;
        if (blkid == Blocks.peachleaves.blockID) {
            h1 = 10;
            h2 = 5;
            h3 = 7;
            h4 = 5;
            h5 = 12;
            w1 = 4;
            w2 = 2;
        }
        if (blkid == Blocks.cherryleaves.blockID) {
            h1 = 8;
            h2 = 3;
            h3 = 5;
            h4 = 3;
            h5 = 10;
            w1 = 3;
            w2 = 1;
        }
        w2 += world.rand.nextInt(2) - world.rand.nextInt(2);
        w1 += world.rand.nextInt(3) - world.rand.nextInt(3);
        int j = 1;
        while (j < h1) {
            world.setblocknonotify(dimension, x, y + j, z, Blocks.log.blockID);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w1 + var) {
            world.setblocknonotify(dimension, x + j, y + h2, z, Blocks.log.blockID);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w1 + var) {
            world.setblocknonotify(dimension, x - j, y + h2, z, Blocks.log.blockID);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w1 + var) {
            world.setblocknonotify(dimension, x, y + h2, z + j, Blocks.log.blockID);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w1 + var) {
            world.setblocknonotify(dimension, x, y + h2, z - j, Blocks.log.blockID);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w2 + var) {
            world.setblocknonotify(dimension, x + j, y + h3, z, Blocks.log.blockID);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w2 + var) {
            world.setblocknonotify(dimension, x - j, y + h3, z, Blocks.log.blockID);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w2 + var) {
            world.setblocknonotify(dimension, x, y + h3, z + j, Blocks.log.blockID);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w2 + var) {
            world.setblocknonotify(dimension, x, y + h3, z - j, Blocks.log.blockID);
            ++j;
        }
        int i = h4;
        while (i < h5) {
            int width = 6;
            if (i > 8) {
                width = 5;
            }
            if (i > 10) {
                width = 4;
            }
            if (blkid != Blocks.appleleaves.blockID) {
                --width;
            }
            j = -width;
            while (j <= width) {
                int k = -width;
                while (k <= width) {
                    bid = world.getblock(dimension, x + k, y + i, z + j);
                    if (bid == 0 && Trees.canGrowHere(world, dimension, x + k, y + i, z + j)) {
                        world.setblocknonotify(dimension, x + k, y + i, z + j, blkid);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static boolean canGrowHere(World w, int d, int x, int y, int z) {
        int i = -2;
        while (i <= 2) {
            int j = -2;
            while (j <= 0) {
                int k = -2;
                while (k <= 2) {
                    int t = Math.abs(i) + Math.abs(j) + Math.abs(k);
                    if (t <= 3 && Blocks.canLeavesGrow(w.getblock(d, x + i, y + j, z + k))) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void makeGenericTree(World world, int dimension, int x, int y, int z) {
        int var = 0;
        int bid = world.getblock(dimension, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        int logid = Blocks.log.blockID;
        int leafid = Blocks.leaves.blockID;
        int tmp = world.rand.nextInt(3);
        if (tmp == 1) {
            logid = Blocks.willowlog.blockID;
        }
        if (tmp == 2) {
            logid = Blocks.redwoodlog.blockID;
        }
        if ((tmp = world.rand.nextInt(3)) == 1) {
            leafid = Blocks.willowleaves.blockID;
        }
        if (tmp == 2) {
            leafid = Blocks.redwoodleaves.blockID;
        }
        int h1 = 8 + world.rand.nextInt(6);
        int h2 = 4 + world.rand.nextInt(2);
        int h3 = 6 + world.rand.nextInt(2);
        int h4 = h2;
        int h5 = h1 + 2;
        int w1 = 5;
        int w2 = 3;
        w2 += world.rand.nextInt(2) - world.rand.nextInt(2);
        w1 += world.rand.nextInt(3) - world.rand.nextInt(3);
        int j = 1;
        while (j < h1) {
            world.setblocknonotify(dimension, x, y + j, z, logid);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w1 + var) {
            world.setblocknonotify(dimension, x + j, y + h2, z, logid);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w1 + var) {
            world.setblocknonotify(dimension, x - j, y + h2, z, logid);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w1 + var) {
            world.setblocknonotify(dimension, x, y + h2, z + j, logid);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w1 + var) {
            world.setblocknonotify(dimension, x, y + h2, z - j, logid);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w2 + var) {
            world.setblocknonotify(dimension, x + j, y + h3, z, logid);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w2 + var) {
            world.setblocknonotify(dimension, x - j, y + h3, z, logid);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w2 + var) {
            world.setblocknonotify(dimension, x, y + h3, z + j, logid);
            ++j;
        }
        var = world.rand.nextInt(2) - world.rand.nextInt(2);
        j = 1;
        while (j < w2 + var) {
            world.setblocknonotify(dimension, x, y + h3, z - j, logid);
            ++j;
        }
        int i = h4;
        while (i < h5) {
            int width = 7;
            if (i > 8) {
                width = 6;
            }
            if (i > 10) {
                width = 5;
            }
            j = -width;
            while (j <= width) {
                int k = -width;
                while (k <= width) {
                    bid = world.getblock(dimension, x + k, y + i, z + j);
                    if (bid == 0 && Trees.canGrowHere(world, dimension, x + k, y + i, z + j)) {
                        world.setblocknonotify(dimension, x + k, y + i, z + j, leafid);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void scrubTree(World world, int d, int x, int y, int z, int type) {
        if (type == 0) {
            world.setblocknonotify(d, x, y + 1, z, Blocks.willowlog.blockID);
            world.setblocknonotify(d, x, y + 2, z, Blocks.willowleaves.blockID);
        } else if (type == 1) {
            world.setblocknonotify(d, x, y + 1, z, Blocks.log.blockID);
            world.setblocknonotify(d, x, y + 2, z, Blocks.leaves.blockID);
        } else if (type == 2) {
            world.setblocknonotify(d, x, y + 1, z, Blocks.redwoodlog.blockID);
            world.setblocknonotify(d, x, y + 2, z, Blocks.redwoodleaves.blockID);
        } else {
            int logtype = 0;
            int lt = world.rand.nextInt(3);
            if (lt == 0) {
                logtype = Blocks.log.blockID;
            }
            if (lt == 1) {
                logtype = Blocks.willowlog.blockID;
            }
            if (lt == 2) {
                logtype = Blocks.redwoodlog.blockID;
            }
            int leaftype = 0;
            int lft = world.rand.nextInt(3);
            if (lft == 0) {
                leaftype = Blocks.leaves.blockID;
            }
            if (lft == 1) {
                leaftype = Blocks.willowleaves.blockID;
            }
            if (lft == 2) {
                leaftype = Blocks.redwoodleaves.blockID;
            }
            world.setblocknonotify(d, x, y + 1, z, logtype);
            world.setblocknonotify(d, x, y + 2, z, leaftype);
        }
    }

    public void bulbTree(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        float dy = world.rand.nextFloat();
        float rad = 3 + world.rand.nextInt(5);
        float ht = 1.0f;
        int irad = 0;
        while (irad < 180) {
            float dd = (float)((double)rad * Math.sin(Math.toRadians(irad)));
            int idir = 0;
            while (idir < 360) {
                double dx = (float)((double)dd * Math.sin(Math.toRadians(idir)));
                double dz = (float)((double)dd * Math.cos(Math.toRadians(idir)));
                world.setblocknonotify(d, x + (int)dx, y + (int)ht, z + (int)dz, Blocks.willowlog.blockID);
                idir += 10;
            }
            ht += dy;
            irad += 10;
        }
        int iht = 0;
        int i = 0;
        while (i < (int)rad) {
            iht = y + (int)ht + i;
            world.setblocknonotify(d, x, iht, z, Blocks.willowlog.blockID);
            ++i;
        }
        world.setblocknonotify(d, x + 1, iht, z + 1, Blocks.willowleaves.blockID);
        world.setblocknonotify(d, x - 1, iht, z - 1, Blocks.willowleaves.blockID);
        world.setblocknonotify(d, x + 1, iht, z - 1, Blocks.willowleaves.blockID);
        world.setblocknonotify(d, x - 1, iht, z + 1, Blocks.willowleaves.blockID);
    }

    public void vaseTree(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        float ddr = world.rand.nextFloat();
        int height = 5 + world.rand.nextInt(15);
        float dd = 0.0f;
        bid = Blocks.log.blockID;
        int i = 0;
        while (i < height) {
            if (i == height - 1) {
                bid = Blocks.leaves.blockID;
            }
            int idir = 0;
            while (idir < 360) {
                float dx = (float)((double)dd * Math.sin(Math.toRadians(idir)));
                float dz = (float)((double)dd * Math.cos(Math.toRadians(idir)));
                world.setblocknonotify(d, x + (int)dx, y + i + 1, z + (int)dz, bid);
                if (world.rand.nextInt(10) == 1) {
                    dx = (float)((double)(dd + 1.0f) * Math.sin(Math.toRadians(idir)));
                    dz = (float)((double)(dd + 1.0f) * Math.cos(Math.toRadians(idir)));
                    world.setblocknonotify(d, x + (int)dx, y + i + 1, z + (int)dz, Blocks.cherryleaves.blockID);
                }
                idir += 10;
            }
            dd += ddr;
            ++i;
        }
    }

    public void spiralTree(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        float ddr = 0.05f + world.rand.nextFloat() / 8.0f;
        int height = 5 + world.rand.nextInt(30);
        float dd = 0.0f;
        bid = Blocks.log.blockID;
        float ht = 0.0f;
        float htx = 0.15f + world.rand.nextFloat() / 3.0f;
        int ioff = world.rand.nextInt(360);
        block0: while (ht < (float)height) {
            int idir = 0;
            while (idir < 360) {
                if (ht > (float)height) continue block0;
                float dx = (float)((double)dd * Math.sin(Math.toRadians(idir + ioff)));
                float dz = (float)((double)dd * Math.cos(Math.toRadians(idir + ioff)));
                world.setblocknonotify(d, x + (int)dx, y + (int)ht + 1, z + (int)dz, bid);
                if (world.rand.nextInt(3) == 1) {
                    world.setblocknonotify(d, x + (int)dx, y + (int)ht + 2, z + (int)dz, Blocks.leaves.blockID);
                }
                if (world.rand.nextInt(10) == 1) {
                    dx = (float)((double)(dd + 1.0f) * Math.sin(Math.toRadians(idir + ioff)));
                    dz = (float)((double)(dd + 1.0f) * Math.cos(Math.toRadians(idir + ioff)));
                    world.setblocknonotify(d, x + (int)dx, y + (int)ht + 1, z + (int)dz, Blocks.leaves.blockID);
                }
                dd += ddr;
                ht += htx;
                idir += 5;
            }
        }
    }

    public void loopTree(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        float rad = 3 + world.rand.nextInt(5);
        int ioff = world.rand.nextInt(360);
        int idir = 0;
        while (idir < 360) {
            float dx = (float)((double)rad * Math.cos(Math.toRadians(idir)));
            float dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
            dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)));
            float dy = (float)((double)rad * Math.sin(Math.toRadians(idir)));
            world.setblocknonotify(d, x + (int)dx, y + (int)(dy + rad) + 1, z + (int)dz, Blocks.willowlog.blockID);
            dx = (float)((double)(rad + 1.0f) * Math.cos(Math.toRadians(idir)));
            dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
            dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)));
            dy = (float)((double)(rad + 1.0f) * Math.sin(Math.toRadians(idir)));
            if (world.getblock(d, x + (int)dx, y + (int)(dy + rad) + 1, z + (int)dz) == 0) {
                world.setblocknonotify(d, x + (int)dx, y + (int)(dy + rad) + 1, z + (int)dz, Blocks.willowleaves.blockID);
            }
            idir += 5;
        }
    }

    public void loopspiralTree(World world, int d, int x, int y, int z) {
        float rad;
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        float orad = rad = (float)(8 + world.rand.nextInt(5));
        int ioff = world.rand.nextInt(360);
        float ddr = 0.05f + world.rand.nextFloat() / 50.0f;
        int idir = 0;
        while (rad > 3.0f) {
            float dx = (float)((double)rad * Math.sin(Math.toRadians(idir)));
            float dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
            dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)));
            float dy = -((float)((double)rad * Math.cos(Math.toRadians(idir))));
            world.setblocknonotify(d, x + (int)dx, y + (int)(dy + orad) + 1, z + (int)dz, Blocks.redwoodlog.blockID);
            if (world.getblock(d, x + (int)dx, y + (int)(dy + orad) + 2, z + (int)dz) == 0) {
                world.setblocknonotify(d, x + (int)dx, y + (int)(dy + orad) + 2, z + (int)dz, Blocks.leaves.blockID);
            }
            rad -= ddr;
            idir += 5;
        }
    }

    public void looplowspiralTree(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        float rad = 8 + world.rand.nextInt(5);
        int ioff = world.rand.nextInt(360);
        float ddr = 0.01f + world.rand.nextFloat() / 50.0f;
        int idir = 0;
        while (rad > 3.0f) {
            float dx = (float)((double)rad * Math.sin(Math.toRadians(idir)));
            float dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
            dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)));
            float dy = -((float)((double)rad * Math.cos(Math.toRadians(idir))));
            world.setblocknonotify(d, x + (int)dx, y + (int)(dy + rad) + 1, z + (int)dz, Blocks.willowlog.blockID);
            if (world.rand.nextInt(6) == 1) {
                dx = (float)((double)(rad + 1.0f) * Math.sin(Math.toRadians(idir)));
                dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
                if (world.getblock(d, x + (int)(dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)))), y + (int)((dy = -((float)((double)(rad + 1.0f) * Math.cos(Math.toRadians(idir))))) + rad) + 1, z + (int)dz) == 0) {
                    world.setblocknonotify(d, x + (int)dx, y + (int)(dy + rad) + 1, z + (int)dz, Blocks.redwoodleaves.blockID);
                }
            }
            rad -= ddr;
            idir += 5;
        }
    }

    public void bowlTree(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        int howmany = 8 + world.rand.nextInt(10);
        int i = 0;
        while (i < howmany) {
            float rad = 6 + world.rand.nextInt(12);
            int ioff = world.rand.nextInt(360);
            int idir = 0;
            while (idir < 90) {
                float dx = (float)((double)rad * Math.sin(Math.toRadians(idir)));
                float dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
                dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)));
                float dy = -((float)((double)rad * Math.cos(Math.toRadians(idir))));
                world.setblocknonotify(d, x + (int)dx, y + (int)(dy + rad) + 1, z + (int)dz, Blocks.redwoodlog.blockID);
                if (world.getblock(d, x + (int)dx, y + (int)(dy + rad) + 2, z + (int)dz) == 0) {
                    world.setblocknonotify(d, x + (int)dx, y + (int)(dy + rad) + 2, z + (int)dz, Blocks.willowleaves.blockID);
                }
                idir += 5;
            }
            ++i;
        }
    }

    public void doublebowlTree(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        int howmany = 8 + world.rand.nextInt(10);
        int i = 0;
        while (i < howmany) {
            float rad = 6 + world.rand.nextInt(12);
            int ioff = world.rand.nextInt(360);
            int idir = 0;
            while (idir < 90) {
                float dx = (float)((double)rad * Math.sin(Math.toRadians(idir)));
                float dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
                dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)));
                float dy = -((float)((double)rad * Math.cos(Math.toRadians(idir))));
                world.setblocknonotify(d, x + (int)dx, y + (int)(dy + rad) + 1, z + (int)dz, Blocks.redwoodlog.blockID);
                if (world.getblock(d, x + (int)dx, y + (int)(dy + rad) + 2, z + (int)dz) == 0) {
                    world.setblocknonotify(d, x + (int)dx, y + (int)(dy + rad) + 2, z + (int)dz, Blocks.willowleaves.blockID);
                }
                if (idir == 85) {
                    this.doublebowlTreeTop(world, d, x + (int)dx, y + (int)(dy + rad) + 2, z + (int)dz);
                }
                idir += 5;
            }
            ++i;
        }
    }

    public void doublebowlTreeTop(World world, int d, int x, int y, int z) {
        int howmany = 3 + world.rand.nextInt(6);
        int i = 0;
        while (i < howmany) {
            float rad = 3 + world.rand.nextInt(8);
            int ioff = world.rand.nextInt(360);
            int idir = 0;
            while (idir < 90) {
                float dx = (float)((double)rad * Math.sin(Math.toRadians(idir)));
                float dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
                dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)));
                float dy = -((float)((double)rad * Math.cos(Math.toRadians(idir))));
                world.setblocknonotify(d, x + (int)dx, y + (int)(dy + rad) + 1, z + (int)dz, Blocks.redwoodlog.blockID);
                if (world.getblock(d, x + (int)dx, y + (int)(dy + rad) + 2, z + (int)dz) == 0) {
                    world.setblocknonotify(d, x + (int)dx, y + (int)(dy + rad) + 2, z + (int)dz, Blocks.willowleaves.blockID);
                }
                idir += 5;
            }
            ++i;
        }
    }

    public void flowerTree(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        int leafcolor = Blocks.redwoodleaves.blockID;
        int howmany = 8 + world.rand.nextInt(10);
        int i = 0;
        while (i < howmany) {
            float rad = 6 + world.rand.nextInt(12);
            int ioff = world.rand.nextInt(360);
            float xoff = (world.rand.nextFloat() - world.rand.nextFloat()) * 2.0f;
            float zoff = (world.rand.nextFloat() - world.rand.nextFloat()) * 2.0f;
            int leafstart = 35 + world.rand.nextInt(20);
            int idir = 0;
            while (idir < 90) {
                float dx = rad - (float)((double)rad * Math.cos(Math.toRadians(idir)));
                float dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
                dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)));
                float dy = (float)((double)rad * Math.sin(Math.toRadians(idir)));
                world.setblocknonotify(d, x + (int)dx + (int)xoff, y + (int)dy + 1, z + (int)dz + (int)zoff, Blocks.log.blockID);
                if (idir >= leafstart) {
                    this.makeflowerleaves(world, d, x + (int)dx + (int)xoff, y + (int)dy + 1, z + (int)dz + (int)zoff, leafcolor);
                }
                idir += 2;
            }
            ++i;
        }
        int lf = world.rand.nextInt(4);
        if (lf == 0) {
            leafcolor = Blocks.greenleaves.blockID;
        }
        if (lf == 1) {
            leafcolor = Blocks.redleaves.blockID;
        }
        if (lf == 2) {
            leafcolor = Blocks.orangeleaves.blockID;
        }
        if (lf == 3) {
            leafcolor = Blocks.yellowleaves.blockID;
        }
        howmany = 6 + world.rand.nextInt(6);
        i = 0;
        while (i < howmany) {
            float rad = 4 + world.rand.nextInt(8);
            int ioff = world.rand.nextInt(360);
            float xoff = (world.rand.nextFloat() - world.rand.nextFloat()) * 2.0f;
            float zoff = (world.rand.nextFloat() - world.rand.nextFloat()) * 2.0f;
            int leafstart = 25 + world.rand.nextInt(20);
            int idir = 0;
            while (idir < 90) {
                float dx = rad - (float)((double)rad * Math.cos(Math.toRadians(idir)));
                float dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
                dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)));
                float dy = (float)((double)rad * Math.sin(Math.toRadians(idir)));
                world.setblocknonotify(d, x + (int)dx + (int)xoff, y + (int)dy + 8, z + (int)dz + (int)zoff, Blocks.log.blockID);
                if (idir >= leafstart) {
                    this.makeflowerleaves(world, d, x + (int)dx + (int)xoff, y + (int)dy + 8, z + (int)dz + (int)zoff, leafcolor);
                }
                idir += 5;
            }
            ++i;
        }
    }

    public void flowerTreeNormal(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        int leafcolor = Blocks.redwoodleaves.blockID;
        int howmany = 8 + world.rand.nextInt(10);
        int i = 0;
        while (i < howmany) {
            float rad = 6 + world.rand.nextInt(12);
            int ioff = world.rand.nextInt(360);
            float xoff = (world.rand.nextFloat() - world.rand.nextFloat()) * 2.0f;
            float zoff = (world.rand.nextFloat() - world.rand.nextFloat()) * 2.0f;
            int leafstart = 35 + world.rand.nextInt(20);
            int idir = 0;
            while (idir < 90) {
                float dx = rad - (float)((double)rad * Math.cos(Math.toRadians(idir)));
                float dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
                dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)));
                float dy = (float)((double)rad * Math.sin(Math.toRadians(idir)));
                world.setblocknonotify(d, x + (int)dx + (int)xoff, y + (int)dy + 1, z + (int)dz + (int)zoff, Blocks.log.blockID);
                if (idir >= leafstart) {
                    this.makeflowerleaves(world, d, x + (int)dx + (int)xoff, y + (int)dy + 1, z + (int)dz + (int)zoff, leafcolor);
                }
                idir += 2;
            }
            ++i;
        }
    }

    public void makeflowerleaves(World world, int d, int x, int y, int z, int leafcolor) {
        int i = -1;
        while (i <= 1) {
            int j = 0;
            while (j <= 1) {
                int k = -1;
                while (k <= 1) {
                    if (world.getblock(d, x + i, y + j, z + k) == 0) {
                        world.setblocknonotify(d, x + i, y + j, z + k, leafcolor);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void flowerTreeTwo(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        int leafcolor = Blocks.redwoodleaves.blockID;
        float rad = 10 + world.rand.nextInt(10);
        int ioff = world.rand.nextInt(360);
        double startx = x;
        double starty = y;
        double startz = z;
        int leafstart = 5 + world.rand.nextInt(5);
        int idir = 0;
        while ((float)idir < rad) {
            world.setblocknonotify(d, x, y + idir + 1, z, Blocks.willowlog.blockID);
            if (idir >= leafstart) {
                this.makeflowerleaves(world, d, x, y + idir + 1, z, leafcolor);
            }
            starty = y + idir + 1;
            ++idir;
        }
        int howmany = 6 + world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            rad = 4 + world.rand.nextInt(8);
            ioff = world.rand.nextInt(360);
            int idir2 = 0;
            while (idir2 < 50) {
                float dx = (float)((double)rad * Math.sin(Math.toRadians(idir2)));
                float dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
                dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)));
                float dy = -((float)((double)rad * Math.cos(Math.toRadians(idir2))));
                world.setblocknonotify(d, (int)startx + (int)dx, (int)starty + (int)dy + (int)rad, (int)startz + (int)dz, Blocks.willowlog.blockID);
                this.makeflowerleaves(world, d, (int)startx + (int)dx, (int)starty + (int)dy + (int)rad, (int)startz + (int)dz, Blocks.yellowleaves.blockID);
                idir2 += 2;
            }
            ++i;
        }
    }

    public void umbrellaTree(World world, int d, int x, int y, int z) {
        int bid = world.getblock(d, x, y, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            return;
        }
        int howmany = 16 + world.rand.nextInt(10);
        int i = 0;
        while (i < howmany) {
            float rad = 8 + world.rand.nextInt(12);
            int ioff = world.rand.nextInt(360);
            float xoff = (world.rand.nextFloat() - world.rand.nextFloat()) * 2.0f;
            float zoff = (world.rand.nextFloat() - world.rand.nextFloat()) * 2.0f;
            int leafstart = 35 + world.rand.nextInt(20);
            int idir = 0;
            while (idir < 130) {
                float dx = rad - (float)((double)rad * Math.cos(Math.toRadians(idir)));
                float dz = (float)((double)dx * Math.cos(Math.toRadians(ioff)));
                dx = (float)((double)dx * Math.sin(Math.toRadians(ioff)));
                float dy = (float)((double)rad * Math.sin(Math.toRadians(idir)));
                world.setblocknonotify(d, x + (int)dx + (int)xoff, y + (int)dy + 1, z + (int)dz + (int)zoff, Blocks.log.blockID);
                if (idir >= leafstart) {
                    this.makeflowerleaves(world, d, x + (int)dx + (int)xoff, y + (int)dy + 1, z + (int)dz + (int)zoff, Blocks.willowleaves.blockID);
                }
                idir += 2;
            }
            ++i;
        }
    }

    public void TallPineTree(World world, int d, int x, int y, int z) {
        int height;
        int i = height = world.rand.nextInt(20) + 10;
        while (i > 0) {
            int width = (height - i) / 4;
            if (width < 1) {
                world.setblock(d, x, y + i, z, Blocks.pineleaves.blockID);
            } else {
                int j = -width;
                while (j <= width) {
                    int k = -width;
                    while (k <= width) {
                        int bid = Blocks.pineleaves.blockID;
                        if (Math.abs(j) == Math.abs(k) && Math.abs(j) > 1 && Math.abs(j) < width) {
                            bid = Blocks.log.blockID;
                        }
                        if (j == 0 && Math.abs(k) > 1 && Math.abs(k) < width) {
                            bid = Blocks.log.blockID;
                        }
                        if (k == 0 && Math.abs(j) > 1 && Math.abs(j) < width) {
                            bid = Blocks.log.blockID;
                        }
                        if (k == 0 && j == 0) {
                            bid = Blocks.log.blockID;
                        }
                        world.setblock(d, x + j, y + i, z + k, bid);
                        ++k;
                    }
                    ++j;
                }
            }
            --i;
        }
    }

    public void PineTree(World world, int d, int x, int y, int z) {
        int height;
        int i = height = world.rand.nextInt(8) + 4;
        while (i > 0) {
            int width = (height - i) / 2;
            if (width < 1) {
                world.setblock(d, x, y + i, z, Blocks.pineleaves.blockID);
            } else {
                int j = -width;
                while (j <= width) {
                    int k = -width;
                    while (k <= width) {
                        int bid = Blocks.pineleaves.blockID;
                        if (Math.abs(j) == Math.abs(k) && Math.abs(j) > 1 && Math.abs(j) < width) {
                            bid = Blocks.log.blockID;
                        }
                        if (j == 0 && Math.abs(k) > 1 && Math.abs(k) < width) {
                            bid = Blocks.log.blockID;
                        }
                        if (k == 0 && Math.abs(j) > 1 && Math.abs(j) < width) {
                            bid = Blocks.log.blockID;
                        }
                        if (k == 0 && j == 0) {
                            bid = Blocks.log.blockID;
                        }
                        world.setblock(d, x + j, y + i, z + k, bid);
                        ++k;
                    }
                    ++j;
                }
            }
            --i;
        }
    }

    public boolean addTallPineTrees(World world, int d, int chunkX, int chunkZ) {
        if (world.rand.nextInt(5) != 0) {
            return false;
        }
        int howmany = 0;
        boolean added = false;
        howmany = 2 + world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    this.TallPineTree(world, d, posX, posY - 1, posZ);
                    added = true;
                    break;
                }
                --posY;
            }
            ++i;
        }
        return added;
    }

    public boolean addPineTrees(World world, int d, int chunkX, int chunkZ) {
        if (world.rand.nextInt(5) != 0) {
            return false;
        }
        int howmany = 0;
        boolean added = false;
        howmany = 2 + world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    this.PineTree(world, d, posX, posY - 1, posZ);
                    added = true;
                    break;
                }
                --posY;
            }
            ++i;
        }
        return added;
    }
}

