/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.Chunk;
import dangerzone.CreatureTypes;
import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.Player;
import dangerzone.ServerHooker;
import dangerzone.Spawnlist;
import dangerzone.SpawnlistEntry;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;

public class SpawnerThread
implements Runnable {
    public int spawnmax = 12;
    public int spawnmin = 2;

    @Override
    public void run() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while (DangerZone.gameover == 0) {
            Entity eb;
            Player p;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (DangerZone.f12_on) continue;
            int i = DangerZone.server_world.rand.nextInt(this.spawnmax - this.spawnmin);
            int j = DangerZone.server_world.rand.nextInt(this.spawnmax - this.spawnmin);
            i += this.spawnmin;
            j += this.spawnmin;
            if (DangerZone.server_world.rand.nextInt(2) == 0) {
                i = -i;
            }
            if (DangerZone.server_world.rand.nextInt(2) == 0) {
                j = -j;
            }
            if ((p = DangerZone.server.getRandomPlayer(DangerZone.server_world.rand)) == null) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.tickChunk(DangerZone.server_world, p.dimension, (i << 4) + (int)p.posx, (j << 4) + (int)p.posz, CreatureTypes.TRANSIENT);
            i = DangerZone.server_world.rand.nextInt(DangerZone.entityupdatedist / 16 - 1);
            j = DangerZone.server_world.rand.nextInt(DangerZone.entityupdatedist / 16 - 1);
            if (DangerZone.server_world.rand.nextBoolean()) {
                i = -i;
            }
            if (DangerZone.server_world.rand.nextBoolean()) {
                j = -j;
            }
            if (!Dimensions.DimensionArray[p.dimension].cloud_enable || DangerZone.rand.nextInt(10) != 1 || (eb = DangerZone.server_world.createEntityByName("DangerZone:Cloud", p.dimension, (i << 4) + (int)p.posx, 200.0, (j << 4) + (int)p.posz)) == null) continue;
            eb.init();
            DangerZone.server_world.spawnEntityInWorld(eb);
        }
    }

    public void tickChunk(World w, int dim, int xrel, int zrel, int perm) {
        Chunk c = w.serverchunkcache.getDecoratedChunk(dim, xrel, 0, zrel);
        if (c == null) {
            return;
        }
        SpawnerThread.doSpawnChunk(c, w, dim, xrel, zrel, perm);
    }

    public static void doSpawnChunk(Chunk c, World w, int dim, int xrel, int zrel, int perm) {
        for (SpawnlistEntry st : Spawnlist.spawnlist) {
            if (st.permanence != perm || st.more_rare && w.rand.nextInt(16) != 1 || st.chance < w.rand.nextInt(1000) || st.dimensionname != null && !Dimensions.DimensionArray[dim].isNameMatch(st.dimensionname, c.chunkX, c.chunkZ) || st.biomename != null && !st.biomename.equals(w.getBiome((int)c.dimension, (int)xrel, (int)0, (int)zrel).uniquename) || !ServerHooker.canSpawnHere(w, dim, c.chunkX << 4, c.chunkZ << 4, st) || !Dimensions.DimensionArray[dim].canSpawnHere(w, dim, c.chunkX << 4, c.chunkZ << 4, st)) continue;
            int tries = 0;
            while (tries < st.tries) {
                Entity eb;
                int j;
                boolean fits;
                int bid;
                int iy;
                int ih;
                int xpos = 2 + w.rand.nextInt(14);
                int zpos = 2 + w.rand.nextInt(14);
                if (st.type == CreatureTypes.LAND) {
                    ih = (int)(st.whatToSpawn.getHeight() + 1.0f);
                    iy = st.maxy;
                    while (iy > st.miny) {
                        bid = w.getblock(c.dimension, (c.chunkX << 4) + xpos, iy, (c.chunkZ << 4) + zpos);
                        if (Blocks.isLiquid(bid)) break;
                        if (bid != 0 && !Blocks.isLeaves(bid) && (Blocks.isDirt(bid) || Blocks.isStone(bid)) && Blocks.isSolid(bid) && SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy, (c.chunkZ << 4) + zpos, st.whatToSpawn.getWidth())) {
                            if (SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy + 1, (c.chunkZ << 4) + zpos, st.whatToSpawn.getWidth())) break;
                            fits = true;
                            if (ih > 1) {
                                j = 2;
                                while (j <= ih && fits) {
                                    if (SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy + j, (c.chunkZ << 4) + zpos, st.whatToSpawn.getWidth())) {
                                        fits = false;
                                    }
                                    ++j;
                                }
                            }
                            if (!fits || st.permanence != CreatureTypes.PERMANENT && !st.whatToSpawn.getCanSpawnHereNow(w, c.dimension, (c.chunkX << 4) + xpos, (int)((float)iy + 1.01f), (c.chunkZ << 4) + zpos) || (eb = w.createEntityByName(st.whatToSpawn.uniquename, c.dimension, (c.chunkX << 4) + xpos, (double)iy + (double)1.01f, (c.chunkZ << 4) + zpos)) == null) break;
                            eb.init();
                            w.spawnEntityInWorld(eb);
                            break;
                        }
                        --iy;
                    }
                } else if (st.type == CreatureTypes.AIR) {
                    Entity eb2;
                    iy = w.rand.nextInt(st.maxy - st.miny + 1);
                    iy += st.miny;
                    int iw = (int)(st.whatToSpawn.getWidth() / 2.0f + 0.5f);
                    int ih2 = (int)(st.whatToSpawn.getHeight() + 1.0f);
                    boolean fits2 = true;
                    int i = -iw;
                    while (i <= iw && fits2) {
                        int k = -iw;
                        while (k <= iw && fits2) {
                            j = 0;
                            while (j <= ih2 && fits2) {
                                bid = w.getblock(c.dimension, (c.chunkX << 4) + xpos + i, iy + j, (c.chunkZ << 4) + zpos + k);
                                if (Blocks.isSolid(bid) || Blocks.isLiquid(bid)) {
                                    fits2 = false;
                                }
                                ++j;
                            }
                            ++k;
                        }
                        ++i;
                    }
                    if (fits2 && (st.permanence == CreatureTypes.PERMANENT || st.whatToSpawn.getCanSpawnHereNow(w, c.dimension, (c.chunkX << 4) + xpos, (int)((float)iy + 0.5f), (c.chunkZ << 4) + zpos)) && (eb2 = w.createEntityByName(st.whatToSpawn.uniquename, c.dimension, (c.chunkX << 4) + xpos, (double)iy + 0.5, (c.chunkZ << 4) + zpos)) != null) {
                        eb2.init();
                        w.spawnEntityInWorld(eb2);
                    }
                } else if (st.type == CreatureTypes.WATER) {
                    ih = (int)(st.whatToSpawn.getHeight() + 1.0f);
                    iy = st.maxy;
                    while (iy > st.miny) {
                        bid = w.getblock(c.dimension, (c.chunkX << 4) + xpos, iy, (c.chunkZ << 4) + zpos);
                        if ((bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID) && w.getblock(c.dimension, (c.chunkX << 4) + xpos, iy + 1, (c.chunkZ << 4) + zpos) == 0) {
                            fits = true;
                            if (ih > 1) {
                                j = 2;
                                while (j <= ih && fits) {
                                    if (SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy + j, (c.chunkZ << 4) + zpos, st.whatToSpawn.getWidth())) {
                                        fits = false;
                                    }
                                    ++j;
                                }
                            }
                            if (!fits || st.permanence != CreatureTypes.PERMANENT && !st.whatToSpawn.getCanSpawnHereNow(w, c.dimension, (c.chunkX << 4) + xpos, (int)((float)iy + 1.01f), (c.chunkZ << 4) + zpos) || (eb = w.createEntityByName(st.whatToSpawn.uniquename, c.dimension, (c.chunkX << 4) + xpos, (double)iy + (double)1.01f, (c.chunkZ << 4) + zpos)) == null) break;
                            eb.init();
                            w.spawnEntityInWorld(eb);
                            break;
                        }
                        --iy;
                    }
                } else if (st.type == CreatureTypes.UNDERGROUND) {
                    ih = (int)(st.whatToSpawn.getHeight() + 1.0f);
                    iy = st.miny;
                    while (iy < st.maxy) {
                        if (SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy, (c.chunkZ << 4) + zpos, st.whatToSpawn.getWidth()) && !SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy + 1, (c.chunkZ << 4) + zpos, st.whatToSpawn.getWidth()) && !Blocks.isLiquid(w.getblock(c.dimension, (c.chunkX << 4) + xpos, iy + 1, (c.chunkZ << 4) + zpos))) {
                            fits = true;
                            if (ih > 1) {
                                j = 2;
                                while (j <= ih && fits) {
                                    if (SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy + j, (c.chunkZ << 4) + zpos, st.whatToSpawn.getWidth())) {
                                        fits = false;
                                    }
                                    ++j;
                                }
                            }
                            if (fits) {
                                if (st.permanence != CreatureTypes.PERMANENT && !st.whatToSpawn.getCanSpawnHereNow(w, c.dimension, (c.chunkX << 4) + xpos, (int)((float)iy + 1.01f), (c.chunkZ << 4) + zpos) || (eb = w.createEntityByName(st.whatToSpawn.uniquename, c.dimension, (c.chunkX << 4) + xpos, (double)iy + (double)1.01f, (c.chunkZ << 4) + zpos)) == null) break;
                                eb.init();
                                w.spawnEntityInWorld(eb);
                                break;
                            }
                        }
                        ++iy;
                    }
                }
                ++tries;
            }
        }
    }

    public static boolean isSolidAtLevel(World w, int d, int x, int y, int z, float width) {
        int intwidth = (int)(width / 2.0f + 0.5f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isSolid(w.getblock(d, x + i, y, z + j))) {
                    int itemp = x + i;
                    double dx = (double)x - ((double)itemp + 0.5);
                    if ((dx = Math.abs(dx)) < (double)(0.49f + width / 2.0f)) {
                        itemp = z + j;
                        double dz = (double)z - ((double)itemp + 0.5);
                        if ((dz = Math.abs(dz)) < (double)(0.49f + width / 2.0f)) {
                            return true;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

