/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.gui;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.blocks.Blocks;
import dangerzone.items.Item;
import dangerzone.items.ItemArmor;
import dangerzone.items.Items;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.opengl.Texture;

public class GuiInterface {
    public boolean escaped = false;
    public boolean entered = false;
    public boolean arrow_up = false;
    public boolean arrow_down = false;
    boolean caps = false;
    public InventoryContainer mousebite = null;
    public boolean grab_mouse = false;
    public List<ButtonHandler> buttons = null;
    public int clickx;
    public int clicky;
    public int startx;
    public int starty;
    public int middle;
    public int bottom_of_display;
    public int top_of_display;
    public int left_of_display;
    public float scalex = (float)DangerZone.screen_width / 1920.0f;
    public float scaley = (float)DangerZone.screen_height / 1080.0f;
    public boolean leftdown = false;
    public boolean rightdown = false;
    public String guimessagestring = null;
    public int guimessagetimer = 0;

    public void process() {
        while (this.K_next()) {
        }
        while (this.M_next()) {
        }
    }

    public void ImAllDone() {
        while (this.K_next()) {
        }
        while (this.M_next()) {
        }
        DangerZone.clearActiveGui();
        DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);
    }

    public void textAt(float xpos, float ypos, String text) {
        DangerZone.wr.loadtexture(Blocks.stone.getTexture(0));
        GL11.glPushMatrix();
        GL11.glScalef(this.scalex, this.scaley, 1.0f);
        GL11.glTranslatef(xpos, ypos + (float)DangerZone.font.getHeight(), 0.0f);
        GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
        DangerZone.font.drawString(0.0f, 0.0f, text, Color.white);
        GL11.glPopMatrix();
    }

    public void smallTextAt(float xpos, float ypos, String text) {
        DangerZone.wr.loadtexture(Blocks.stone.getTexture(0));
        GL11.glPushMatrix();
        GL11.glScalef(this.scalex, this.scaley, 1.0f);
        GL11.glTranslatef(xpos, ypos + (float)DangerZone.font16.getHeight(), 0.0f);
        GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
        DangerZone.font16.drawString(0.0f, 0.0f, text, Color.white);
        GL11.glPopMatrix();
    }

    public void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize) {
        DangerZone.wr.forceloadtexture(t);
        float w = t.getWidth();
        float h = t.getHeight();
        GL11.glPushMatrix();
        GL11.glScalef(this.scalex, this.scaley, 1.0f);
        GL11.glTranslatef(xpos, ypos, 0.0f);
        GL11.glScalef(xsize / t.getWidth(), ysize / t.getHeight(), 1.0f);
        GL11.glBegin(7);
        GL11.glTexCoord2f(w, 0.0f);
        GL11.glVertex3f(1.0f, 1.0f, 0.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(0.0f, 1.0f, 0.0f);
        GL11.glTexCoord2f(0.0f, h);
        GL11.glVertex3f(0.0f, 0.0f, 0.0f);
        GL11.glTexCoord2f(w, h);
        GL11.glVertex3f(1.0f, 0.0f, 0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize, float zrot) {
        DangerZone.wr.forceloadtexture(t);
        float w = t.getWidth();
        float h = t.getHeight();
        GL11.glPushMatrix();
        GL11.glScalef(this.scalex, this.scaley, 1.0f);
        GL11.glTranslatef(xpos, ypos, 0.0f);
        GL11.glRotatef(zrot, 0.0f, 0.0f, 1.0f);
        GL11.glScalef(xsize / t.getWidth(), ysize / t.getHeight(), 1.0f);
        GL11.glBegin(7);
        GL11.glTexCoord2f(w, 0.0f);
        GL11.glVertex3f(1.0f, 1.0f, 0.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-1.0f, 1.0f, 0.0f);
        GL11.glTexCoord2f(0.0f, h);
        GL11.glVertex3f(-1.0f, -1.0f, 0.0f);
        GL11.glTexCoord2f(w, h);
        GL11.glVertex3f(1.0f, -1.0f, 0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void drawRectangleWithTextureTwo(Texture t, float xpos, float ypos, float xsize, float ysize, float zrot, float extrascale) {
        DangerZone.wr.forceloadtexture(t);
        float w = t.getWidth();
        float h = t.getHeight();
        GL11.glPushMatrix();
        GL11.glScalef(this.scalex, this.scaley, 1.0f);
        GL11.glTranslatef(xpos, ypos, 0.0f);
        GL11.glScalef(extrascale * xsize / t.getWidth(), extrascale * ysize / t.getHeight(), 1.0f);
        GL11.glRotatef(zrot, 0.0f, 0.0f, 1.0f);
        GL11.glBegin(7);
        GL11.glTexCoord2f(w, 0.0f);
        GL11.glVertex3f(1.0f, 1.0f, 0.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-1.0f, 1.0f, 0.0f);
        GL11.glTexCoord2f(0.0f, h);
        GL11.glVertex3f(-1.0f, -1.0f, 0.0f);
        GL11.glTexCoord2f(w, h);
        GL11.glVertex3f(1.0f, -1.0f, 0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void drawUsed(float used, float xpos, float ypos, float xsize, float ysize) {
        float xs;
        if (used > 1.0f) {
            used = 1.0f;
        }
        if (used < 0.0f) {
            used = 0.0f;
        }
        if ((xs = xsize * (1.0f - used)) < 1.0f) {
            xs = 1.0f;
        }
        GL11.glPushMatrix();
        GL11.glScalef(this.scalex, this.scaley, 1.0f);
        GL11.glDisable(3553);
        GL11.glTranslatef(xpos, ypos, 0.0f);
        GL11.glScalef(1.0f, 1.0f, 1.0f);
        GL11.glBegin(7);
        GL11.glColor3f(used, 1.0f - used, 0.0f);
        GL11.glVertex3f(xs, ysize, 0.0f);
        GL11.glColor3f(used, 1.0f - used, 0.0f);
        GL11.glVertex3f(0.0f, ysize, 0.0f);
        GL11.glColor3f(used, 1.0f - used, 0.0f);
        GL11.glVertex3f(0.0f, 0.0f, 0.0f);
        GL11.glColor3f(used, 1.0f - used, 0.0f);
        GL11.glVertex3f(xs, 0.0f, 0.0f);
        GL11.glEnd();
        GL11.glEnable(3553);
        GL11.glPopMatrix();
    }

    public void drawcoloredsquare(int xpos, int ypos, int xsize, int ysize, float r, float g, float b, float a) {
        GL11.glPushMatrix();
        GL11.glScalef(this.scalex, this.scaley, 1.0f);
        GL11.glDisable(3553);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glTranslatef(xpos, ypos, 0.0f);
        GL11.glBegin(7);
        GL11.glColor4f(r, g, b, a);
        GL11.glVertex3f(xsize, ysize, 0.0f);
        GL11.glColor4f(r, g, b, a);
        GL11.glVertex3f(0.0f, ysize, 0.0f);
        GL11.glColor4f(r, g, b, a);
        GL11.glVertex3f(0.0f, 0.0f, 0.0f);
        GL11.glColor4f(r, g, b, a);
        GL11.glVertex3f(xsize, 0.0f, 0.0f);
        GL11.glEnd();
        GL11.glDisable(3042);
        GL11.glEnable(3553);
        GL11.glPopMatrix();
    }

    public boolean K_next() {
        return DangerZone.K_next();
    }

    public int K_getEventKey() {
        return DangerZone.K_getEventKey();
    }

    public boolean K_isEventKeyDown() {
        return DangerZone.K_getEventKeyState();
    }

    public boolean K_isKeyDown(int key) {
        return DangerZone.K_isKeyDown(key);
    }

    public boolean M_next() {
        return DangerZone.M_next();
    }

    public int M_getEventButton() {
        return DangerZone.M_getEventButton();
    }

    public boolean M_getEventButtonState() {
        return DangerZone.M_getEventButtonState();
    }

    public int M_getEventX() {
        return DangerZone.M_getEventX();
    }

    public int M_getEventY() {
        return DangerZone.M_getEventY();
    }

    public int M_getCurX() {
        return DangerZone.M_getX();
    }

    public int M_getCurY() {
        return DangerZone.M_getY();
    }

    public String getTextChar() {
        this.escaped = false;
        this.entered = false;
        this.arrow_up = false;
        this.arrow_down = false;
        while (this.K_next()) {
            int currk = this.K_getEventKey();
            if (currk == 1) {
                this.escaped = this.K_isEventKeyDown();
            }
            if (currk == 28) {
                this.entered = this.K_isEventKeyDown();
            }
            if (currk == 200) {
                this.arrow_up = this.K_isEventKeyDown();
            }
            if (currk == 208) {
                this.arrow_down = this.K_isEventKeyDown();
            }
            if (currk == 42 || currk == 54) {
                this.caps = this.K_isEventKeyDown();
            }
            if (!this.K_isEventKeyDown()) continue;
            switch (currk) {
                case 211: {
                    return "delete";
                }
                case 14: {
                    return "delete";
                }
                case 11: {
                    if (this.caps) {
                        return ")";
                    }
                    return "0";
                }
                case 2: {
                    if (this.caps) {
                        return "!";
                    }
                    return "1";
                }
                case 3: {
                    if (this.caps) {
                        return "@";
                    }
                    return "2";
                }
                case 4: {
                    if (this.caps) {
                        return "#";
                    }
                    return "3";
                }
                case 5: {
                    if (this.caps) {
                        return "$";
                    }
                    return "4";
                }
                case 6: {
                    if (this.caps) {
                        return "%";
                    }
                    return "5";
                }
                case 7: {
                    if (this.caps) {
                        return "^";
                    }
                    return "6";
                }
                case 8: {
                    if (this.caps) {
                        return "&";
                    }
                    return "7";
                }
                case 9: {
                    if (this.caps) {
                        return "*";
                    }
                    return "8";
                }
                case 10: {
                    if (this.caps) {
                        return "(";
                    }
                    return "9";
                }
                case 30: {
                    if (this.caps) {
                        return "A";
                    }
                    return "a";
                }
                case 48: {
                    if (this.caps) {
                        return "B";
                    }
                    return "b";
                }
                case 46: {
                    if (this.caps) {
                        return "C";
                    }
                    return "c";
                }
                case 32: {
                    if (this.caps) {
                        return "D";
                    }
                    return "d";
                }
                case 18: {
                    if (this.caps) {
                        return "E";
                    }
                    return "e";
                }
                case 33: {
                    if (this.caps) {
                        return "F";
                    }
                    return "f";
                }
                case 34: {
                    if (this.caps) {
                        return "G";
                    }
                    return "g";
                }
                case 35: {
                    if (this.caps) {
                        return "H";
                    }
                    return "h";
                }
                case 23: {
                    if (this.caps) {
                        return "I";
                    }
                    return "i";
                }
                case 36: {
                    if (this.caps) {
                        return "J";
                    }
                    return "j";
                }
                case 37: {
                    if (this.caps) {
                        return "K";
                    }
                    return "k";
                }
                case 38: {
                    if (this.caps) {
                        return "L";
                    }
                    return "l";
                }
                case 50: {
                    if (this.caps) {
                        return "M";
                    }
                    return "m";
                }
                case 49: {
                    if (this.caps) {
                        return "N";
                    }
                    return "n";
                }
                case 24: {
                    if (this.caps) {
                        return "O";
                    }
                    return "o";
                }
                case 25: {
                    if (this.caps) {
                        return "P";
                    }
                    return "p";
                }
                case 16: {
                    if (this.caps) {
                        return "Q";
                    }
                    return "q";
                }
                case 19: {
                    if (this.caps) {
                        return "R";
                    }
                    return "r";
                }
                case 31: {
                    if (this.caps) {
                        return "S";
                    }
                    return "s";
                }
                case 20: {
                    if (this.caps) {
                        return "T";
                    }
                    return "t";
                }
                case 22: {
                    if (this.caps) {
                        return "U";
                    }
                    return "u";
                }
                case 47: {
                    if (this.caps) {
                        return "V";
                    }
                    return "v";
                }
                case 17: {
                    if (this.caps) {
                        return "W";
                    }
                    return "w";
                }
                case 45: {
                    if (this.caps) {
                        return "X";
                    }
                    return "x";
                }
                case 21: {
                    if (this.caps) {
                        return "Y";
                    }
                    return "y";
                }
                case 44: {
                    if (this.caps) {
                        return "Z";
                    }
                    return "z";
                }
                case 52: {
                    if (this.caps) {
                        return ">";
                    }
                    return ".";
                }
                case 51: {
                    if (this.caps) {
                        return "<";
                    }
                    return ",";
                }
                case 53: {
                    if (this.caps) {
                        return "?";
                    }
                    return "/";
                }
                case 39: {
                    if (this.caps) {
                        return ":";
                    }
                    return ";";
                }
                case 40: {
                    if (this.caps) {
                        return "\"";
                    }
                    return "'";
                }
                case 15: 
                case 57: {
                    return " ";
                }
                case 43: {
                    if (this.caps) {
                        return "|";
                    }
                    return "\\";
                }
                case 26: {
                    if (this.caps) {
                        return "{";
                    }
                    return "[";
                }
                case 27: {
                    if (this.caps) {
                        return "}";
                    }
                    return "]";
                }
                case 12: {
                    if (this.caps) {
                        return "_";
                    }
                    return "-";
                }
                case 13: {
                    if (this.caps) {
                        return "+";
                    }
                    return "=";
                }
            }
        }
        return null;
    }

    public void showArmorValue(int which, int x, int y) {
        Item it;
        InventoryContainer ic = DangerZone.player.getArmor(which);
        if (ic != null && ic.count == 1 && (it = ic.getItem()) instanceof ItemArmor) {
            ItemArmor ia = (ItemArmor)it;
            String s = String.format("%3.1f", Float.valueOf(ia.protection));
            this.textAt(x, y, s);
            GL11.glColor3f(1.0f, 1.0f, 1.0f);
        }
    }

    public void ClickedHotBar(int which, int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(0, which, leftrightmid, shifted ? 1 : 0, 0);
    }

    public void ClickedInventory(int which, int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(1, which, leftrightmid, shifted ? 1 : 0, 0);
    }

    public void ClickedEntityInventory(int eid, int which, int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(2, eid, which, leftrightmid, shifted ? 1 : 0);
    }

    public void ClickedCreativeInventory(int iid, int bid, boolean shifted) {
        DangerZone.server_connection.handleInventory(3, iid, bid, shifted ? 1 : 0, 0);
    }

    public void ClickedCrafted(int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(4, leftrightmid, shifted ? 1 : 0, 0, 0);
    }

    public void ClickedCrafting(int which, int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(5, which, leftrightmid, shifted ? 1 : 0, 0);
    }

    public void SpreadListAdd(int which, int iid, int bid) {
        DangerZone.server_connection.handleInventory(6, which, iid, bid, 0);
    }

    public void SpreadListClear() {
        DangerZone.server_connection.handleInventory(7, 0, 0, 0, 0);
    }

    public void ClearTable() {
        DangerZone.server_connection.handleInventory(8, 0, 0, 0, 0);
    }

    public void ClickedArmor(int which, int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(9, which, leftrightmid, shifted ? 1 : 0, 0);
    }

    public void DeleteMouseBite() {
        DangerZone.server_connection.handleInventory(10, 0, 0, 0, 0);
    }

    public void SpitMouseBite() {
        DangerZone.server_connection.handleInventory(11, 0, 0, 0, 0);
    }

    public void ClickedInventoryWithEntity(int which, int leftrightmid, boolean shifted, int eid) {
        DangerZone.server_connection.handleInventory(12, which, leftrightmid, shifted ? 1 : 0, eid);
    }

    public void SpitOneHotbar() {
        DangerZone.server_connection.handleInventory(13, 0, 0, 0, 0);
    }

    public void SellToEntity(int eid) {
        DangerZone.server_connection.handleInventory(14, eid, 0, 0, 0);
    }

    public void BuyFromEntity(int which, int eid) {
        DangerZone.server_connection.handleInventory(15, which, eid, 0, 0);
    }

    public void UnStayEntity(int eid) {
        DangerZone.server_connection.handleInventory(16, eid, 0, 0, 0);
    }

    public void MouseBiteToEntity(int eid) {
        DangerZone.server_connection.handleInventory(17, eid, 0, 0, 0);
    }

    public void std_setup() {
        this.scalex = (float)DangerZone.screen_width / 1920.0f;
        this.scaley = (float)DangerZone.screen_height / 1080.0f;
        this.starty = 1080;
        this.middle = 960;
        this.startx = 0;
        this.bottom_of_display = 0;
        this.startx += 100;
        this.top_of_display = this.starty;
        this.left_of_display = this.startx;
    }

    public int std_draw() {
        Texture tx = null;
        String s = null;
        this.clickx = 0;
        this.clicky = 0;
        int high_button = this.findHighlightedButton();
        if (this.guimessagetimer > 0) {
            --this.guimessagetimer;
            if (this.guimessagestring != null) {
                this.drawRectangleWithTexture(DangerZone.textinputtexture, this.middle - 5 * this.guimessagestring.length() - 50, this.bottom_of_display + 95, 13 * this.guimessagestring.length() + 20, 30.0f);
                this.textAt(this.middle - 5 * this.guimessagestring.length() - 30, this.bottom_of_display + 95, this.guimessagestring);
            }
            if (this.guimessagetimer <= 0) {
                this.guimessagestring = null;
            }
        }
        if (this.buttons != null) {
            Iterator<ButtonHandler> bb = this.buttons.iterator();
            ButtonHandler thisbutton = null;
            float diff = 0.55f;
            diff = 0.75f;
            while (bb.hasNext()) {
                thisbutton = bb.next();
                thisbutton.draw(thisbutton.buttonid == high_button ? 1.0f : diff);
            }
        }
        this.mousebite = DangerZone.player.getMouseBite();
        if (this.mousebite != null) {
            float x = this.M_getCurX();
            float y = this.M_getCurY();
            x /= this.scalex;
            y /= this.scaley;
            tx = this.mousebite.getTexture();
            s = null;
            if (this.mousebite.count > 1) {
                s = String.format("%d", this.mousebite.count);
            }
            if (tx != null) {
                GL11.glColor3f(1.0f, 1.0f, 1.0f);
                this.drawRectangleWithTexture(tx, x - 24.0f, y - 24.0f, 48.0f, 48.0f);
            }
            if (s != null && !s.equals("")) {
                this.textAt(x - 18.0f, y - 24.0f, s);
                GL11.glColor3f(1.0f, 1.0f, 1.0f);
            }
        }
        return high_button;
    }

    public int findHighlightedButton() {
        if (this.buttons == null) {
            return -1;
        }
        float x = this.M_getCurX();
        float y = this.M_getCurY();
        this.clickx = (int)(x /= this.scalex);
        this.clicky = (int)(y /= this.scaley);
        Iterator<ButtonHandler> bb = this.buttons.iterator();
        ButtonHandler thisbutton = null;
        while (bb.hasNext()) {
            thisbutton = bb.next();
            if (this.clickx < thisbutton.x || this.clickx > thisbutton.x + thisbutton.xsize || this.clicky < thisbutton.y || this.clicky > thisbutton.y + thisbutton.ysize) continue;
            return thisbutton.buttonid;
        }
        return -1;
    }

    public void std_clicker(int high_button) {
        ButtonHandler fb = null;
        ButtonHandler mb = null;
        while (this.K_next()) {
            if (this.K_getEventKey() != 1 || !this.K_isKeyDown(1)) continue;
            this.ImAllDone();
            return;
        }
        if (this.buttons == null) {
            return;
        }
        Iterator<ButtonHandler> bb = this.buttons.iterator();
        while (this.M_next()) {
            float x = this.M_getEventX();
            float y = this.M_getEventY();
            this.clickx = (int)(x /= this.scalex);
            this.clicky = (int)(y /= this.scaley);
            if (this.M_getEventButtonState()) {
                if (this.M_getEventButton() < 0) continue;
                bb = this.buttons.iterator();
                fb = null;
                while (bb.hasNext()) {
                    mb = bb.next();
                    if (this.clickx < mb.x || this.clickx > mb.x + mb.xsize || this.clicky < mb.y || this.clicky > mb.y + mb.ysize) continue;
                    fb = mb;
                    break;
                }
                if (this.M_getEventButton() == 0) {
                    if (fb != null) {
                        fb.leftclickhandler();
                    }
                    this.leftdown = true;
                }
                if (this.M_getEventButton() != 1) continue;
                if (fb != null) {
                    fb.rightclickhandler();
                }
                this.rightdown = true;
                continue;
            }
            if (this.M_getEventButton() == 0) {
                this.leftdown = false;
            }
            if (this.M_getEventButton() != 1) continue;
            this.rightdown = false;
        }
    }

    public void std_text(int high_button) {
        ButtonHandler mb2 = null;
        while (this.K_next()) {
            if (this.K_getEventKey() == 18 && this.K_isKeyDown(18)) {
                this.ImAllDone();
                return;
            }
            if (this.K_getEventKey() != 1 || !this.K_isKeyDown(1)) continue;
            this.ImAllDone();
            return;
        }
        if (this.buttons == null) {
            return;
        }
        Iterator<ButtonHandler> bb = this.buttons.iterator();
        InventoryContainer ic = null;
        float x = this.M_getCurX();
        float y = this.M_getCurY();
        int cx = (int)(x /= this.scalex);
        int cy = (int)(y /= this.scaley);
        for (ButtonHandler mb2 : this.buttons) {
            if (cx < mb2.x || cx > mb2.x + mb2.xsize || cy < mb2.y || cy > mb2.y + mb2.ysize || (ic = mb2.ic) == null) continue;
            String hotstring = null;
            String[] hss = null;
            if (ic.bid != 0) {
                hotstring = Blocks.getUniqueName(ic.bid);
            }
            if (ic.iid != 0) {
                hotstring = Items.getUniqueName(ic.iid);
            }
            if (hotstring == null || (hss = hotstring.split(":")).length < 2) continue;
            this.guimessagestring = hss[1];
            this.guimessagetimer = 10;
        }
    }

    public String std_keypad_get(int high_button) {
        this.entered = false;
        this.escaped = false;
        this.arrow_up = false;
        this.arrow_down = false;
        return this.getTextChar();
    }

    public class ButtonHandler {
        public Texture t;
        public int x;
        public int y;
        public int xsize;
        public int ysize;
        public String s;
        public InventoryContainer ic;
        public int buttonid = 0;

        public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int bid) {
            this.x = xpos;
            this.y = ypos;
            this.xsize = bxsize;
            this.ysize = bysize;
            this.t = tx;
            this.s = ot;
            this.ic = null;
            this.buttonid = bid;
        }

        public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, InventoryContainer iic, int bid) {
            this.x = xpos;
            this.y = ypos;
            this.xsize = bxsize;
            this.ysize = bysize;
            this.t = null;
            this.s = null;
            this.ic = iic;
            this.buttonid = bid;
        }

        public void leftclickhandler() {
        }

        public void rightclickhandler() {
        }

        public void middleclickhandler() {
        }

        public void draw() {
            if (this.ic != null) {
                int md;
                Item it;
                this.t = this.ic.getTexture();
                this.s = null;
                if (this.ic.count > 1) {
                    this.s = String.format("%d", this.ic.count);
                }
                if (this.t != null) {
                    GL11.glColor3f(1.0f, 1.0f, 1.0f);
                    GuiInterface.this.drawRectangleWithTexture(this.t, this.x, this.y, this.xsize, this.ysize);
                }
                if (this.s != null && !this.s.equals("")) {
                    GuiInterface.this.textAt(this.x + 6, this.y, this.s);
                    GL11.glColor3f(1.0f, 1.0f, 1.0f);
                }
                if (this.ic.count == 1 && this.ic.currentuses > 0 && this.ic.getMaxStack() == 1 && (it = this.ic.getItem()) != null && (md = it.maxuses) > 0) {
                    float pu = (float)this.ic.currentuses / (float)md;
                    GuiInterface.this.drawUsed(pu, this.x, this.y, this.xsize, 2.0f);
                }
            } else {
                if (this.t != null) {
                    GL11.glColor3f(1.0f, 1.0f, 1.0f);
                    GuiInterface.this.drawRectangleWithTexture(this.t, this.x, this.y, this.xsize, this.ysize);
                }
                if (this.s != null && !this.s.equals("")) {
                    GuiInterface.this.textAt(this.x + 6, this.y, this.s);
                    GL11.glColor3f(1.0f, 1.0f, 1.0f);
                }
            }
        }

        public void draw(float tcolor) {
            if (this.ic != null) {
                int md;
                Item it;
                this.t = this.ic.getTexture();
                this.s = null;
                if (this.ic.count > 1) {
                    this.s = String.format("%d", this.ic.count);
                }
                if (this.t != null) {
                    GL11.glColor3f(tcolor, tcolor, tcolor);
                    GuiInterface.this.drawRectangleWithTexture(this.t, this.x, this.y, this.xsize, this.ysize);
                }
                if (this.s != null && !this.s.equals("")) {
                    GuiInterface.this.textAt(this.x + 6, this.y, this.s);
                    GL11.glColor3f(1.0f, 1.0f, 1.0f);
                }
                if (this.ic.count == 1 && this.ic.currentuses > 0 && this.ic.getMaxStack() == 1 && (it = this.ic.getItem()) != null && (md = it.maxuses) > 0) {
                    float pu = (float)this.ic.currentuses / (float)md;
                    GuiInterface.this.drawUsed(pu, this.x, this.y, this.xsize, 2.0f);
                }
            } else {
                if (this.t != null) {
                    GL11.glColor3f(tcolor, tcolor, tcolor);
                    GuiInterface.this.drawRectangleWithTexture(this.t, this.x, this.y, this.xsize, this.ysize);
                }
                if (this.s != null && !this.s.equals("")) {
                    GuiInterface.this.textAt(this.x + 6, this.y, this.s);
                    GL11.glColor3f(1.0f, 1.0f, 1.0f);
                }
            }
        }
    }
}

