/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entities;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.newdawn.slick.opengl.Texture;

public class Flag
extends EntityLiving {
    public List<Entity> hostiles = null;

    public Flag(World w) {
        super(w);
        this.maxrenderdist = 256;
        this.height = 10.0f;
        this.width = 1.0f;
        this.uniquename = "DangerZone:Flag";
        this.setMaxHealth(5000.0f);
        this.setHealth(5000.0f);
        this.setDefense(2.0f);
        this.takesFallDamage = false;
        this.setExperience(1);
        this.daytimespawn = false;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = false;
        this.temperament = 1;
        this.hostiles = new ArrayList<Entity>();
        this.ignoreCollisions = true;
        this.tower_defense_enable = false;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 12) {
            return;
        }
        if (this.getListNext() >= 0 && e instanceof Player) {
            return;
        }
        this.doAttackFromCustom(e, dt, pain, false);
    }

    @Override
    public void addKnockback(float dir, float xz, float y) {
    }

    public void setCounter(int count) {
        this.setVarInt(14, count);
    }

    public int getCounter() {
        return this.getVarInt(14);
    }

    public void setListNext(int next) {
        this.setVarInt(15, next);
    }

    public int getListNext() {
        return this.getVarInt(15);
    }

    @Override
    public void setBaby(boolean tf) {
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        this.rotation_pitch_motion = 0.0f;
        this.rotation_roll_motion = 0.0f;
        this.rotation_pitch = 0.0f;
        this.rotation_roll = 0.0f;
        float h = this.getHealth();
        if (h < 1.0f) {
            h = 1.0f;
        }
        h = this.getMaxHealth() / h;
        this.rotation_yaw_motion = h - 1.0f;
        this.rotation_yaw_motion *= 5.0f;
        if (this.rotation_yaw_motion > 100.0f) {
            this.rotation_yaw_motion = 100.0f;
        }
        this.removeAllEffects();
        if (h > 32.0f) {
            h = 32.0f;
        }
        if (h > 4.0f) {
            Utils.spawnParticles(this.world, "DangerZone:ParticleSparkle", (int)(h / 2.0f), this.dimension, this.posx, this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz, true);
        }
        if (h > 2.0f) {
            Utils.spawnParticles(this.world, "DangerZone:ParticleSmoke", (int)(h * 2.0f), this.dimension, this.posx, this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz, true);
        }
        if (this.getListNext() < 0) {
            this.temperament = 2;
            return;
        }
        if (this.hostiles.isEmpty()) {
            Entity e;
            Iterator<Entities.ElistInfo> ii = Entities.entities.iterator();
            ArrayList<Entity> temphostiles = new ArrayList<Entity>();
            while (ii.hasNext()) {
                Entities.ElistInfo st = ii.next();
                e = Entities.spawnEntityByName(st.uniquename, null);
                if (e == null || !(e instanceof EntityLiving) || e.temperament != 1) continue;
                EntityLiving el = (EntityLiving)e;
                if (!el.tower_defense_enable) continue;
                temphostiles.add(e);
            }
            while (!temphostiles.isEmpty()) {
                e = this.findlowesthostile(temphostiles);
                this.hostiles.add(e);
            }
        }
        this.setCounter(this.getCounter() + 1);
        if (this.getCounter() > 300) {
            this.setCounter(0);
            Entity e = null;
            EntityLiving el = this.find_next_critter();
            if (el != null) {
                int howmany = 12;
                float hardness = el.getAttackDamage() * el.getDefense();
                if (hardness > 5.0f) {
                    howmany = 10;
                }
                if (hardness > 10.0f) {
                    howmany = 8;
                }
                if (hardness > 30.0f) {
                    howmany = 6;
                }
                if (hardness > 100.0f) {
                    howmany = 5;
                }
                if (hardness > 500.0f) {
                    howmany = 4;
                }
                int i = 0;
                while (i < howmany) {
                    float dir = this.world.rand.nextFloat() * 360.0f;
                    double px = this.posx + Math.cos(dir) * (double)(20.0f + el.getWidth());
                    double pz = this.posz + Math.sin(dir) * (double)(20.0f + el.getWidth());
                    int j = 255;
                    while (j > 0) {
                        if (this.world.getblock(this.dimension, (int)px, j, (int)pz) != 0) break;
                        --j;
                    }
                    double py = (float)j + el.getHeight() * 2.0f;
                    e = this.world.createEntityByName(el.uniquename, this.dimension, px, py, pz);
                    if (e != null) {
                        e.init();
                        this.world.spawnEntityInWorld(e);
                    }
                    ++i;
                }
                e = this.world.createEntityByName("DangerZone:Lightning", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.init();
                    this.world.spawnEntityInWorld(e);
                }
            } else {
                this.do_finished();
                this.setListNext(-1);
                this.setHealth(this.getMaxHealth());
            }
        }
    }

    public Entity findlowesthostile(List<Entity> inlist) {
        Entity thisone = null;
        float hardness = 1.0E11f;
        int index = 0;
        Iterator<Entity> ii = inlist.iterator();
        int here = 0;
        while (ii.hasNext()) {
            thisone = ii.next();
            if (thisone.getAttackDamage() * thisone.getDefense() < hardness) {
                index = here;
                hardness = thisone.getAttackDamage() * thisone.getDefense();
            }
            ++here;
        }
        thisone = inlist.get(index);
        inlist.remove(index);
        return thisone;
    }

    public EntityLiving find_next_critter() {
        int next = this.getListNext();
        if (next >= this.hostiles.size()) {
            return null;
        }
        EntityLiving e = (EntityLiving)this.hostiles.get(next);
        this.setListNext(next + 1);
        return e;
    }

    public void do_finished() {
        int howmany = 80 + this.world.rand.nextInt(30);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.coinsilver.itemID, 10.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 80 + this.world.rand.nextInt(30);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.coingold.itemID, 10.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 80 + this.world.rand.nextInt(30);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.coinplatinum.itemID, 10.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        Utils.doDropRand(this.world, 0, Items.flag.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Entity e = this.world.createEntityByName("DangerZone:Lightning", this.dimension, this.posx, this.posy, this.posz);
        if (e != null) {
            e.init();
            this.world.spawnEntityInWorld(e);
        }
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            int n = 0;
            while (n < 10) {
                int i = this.world.rand.nextInt(5) - this.world.rand.nextInt(5);
                int k = this.world.rand.nextInt(5) - this.world.rand.nextInt(5);
                int j = this.world.rand.nextInt(15);
                this.world.setblock(this.dimension, (int)(this.posx + (double)i), (int)(this.posy + (double)j), (int)(this.posz + (double)k), 0);
                ++n;
            }
        }
        super.update(deltaT);
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, Items.flag.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Flagtexture.png");
        }
        return this.texture;
    }
}

