/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class EntityExp
extends Entity {
    public int deathtimer = 600;
    public int pickup_delay = 0;
    public int points = 0;
    int nexttext = 0;
    int nexttextcount = 0;
    int countdir = 1;
    boolean tried = false;

    public EntityExp(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = "DangerZone:Experience";
        this.pickup_delay = 10;
        this.points = 0;
        if (w != null) {
            this.nexttext = w.rand.nextInt(8);
            this.nexttextcount = w.rand.nextInt(10);
        }
        this.canthitme = true;
        this.setFlying(true);
    }

    @Override
    public void writeSelf(Properties prop, String tag) {
        super.writeSelf(prop, tag);
        prop.setProperty(String.format("%s%s", tag, "DEATHTIMER"), String.format("%d", this.deathtimer));
        prop.setProperty(String.format("%s%s", tag, "POINTS"), String.format("%d", this.points));
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.deathtimer = Utils.getPropertyInt(prop, String.format("%s%s", tag, "DEATHTIMER"), 0, 32768, 600);
        this.points = Utils.getPropertyInt(prop, String.format("%s%s", tag, "POINTS"), 0, 10000, 1);
    }

    @Override
    public void update(float deltaT) {
        float rate = (float)DangerZone.entityupdaterate / (float)DangerZone.serverentityupdaterate;
        if (this.world.isServer) {
            Player p;
            boolean inliquid = false;
            int bbid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)(this.getHeight() + 0.25f)), (int)this.posz);
            if (Blocks.isSolid(bbid)) {
                this.motiony += 0.007f * deltaT;
            } else {
                if (Blocks.isLiquid(bbid)) {
                    Blocks.entityInLiquid(bbid, this);
                    inliquid = true;
                }
                this.motiony -= 0.005f * deltaT;
            }
            this.setInLiquid(inliquid);
            this.motiony *= 1.0f - 0.05f * deltaT;
            this.motionx *= 1.0f - 0.05f * deltaT;
            this.motionz *= 1.0f - 0.05f * deltaT;
            if (this.getOnFire() != 0) {
                this.deathtimer -= 5;
            }
            --this.deathtimer;
            if (this.deathtimer <= 0) {
                this.deadflag = true;
                return;
            }
            if (this.pickup_delay > 0) {
                --this.pickup_delay;
            }
            this.rotation_yaw_motion = 0.0f;
            this.rotation_pitch_motion = 0.0f;
            this.rotation_roll_motion = 0.0f;
            this.rotation_pitch = 0.0f;
            this.rotation_yaw = 0.0f;
            this.rotation_roll = 0.0f;
            if (!this.deadflag && this.pickup_delay <= 0 && (p = DangerZone.server.findNearestPlayer(this)) != null && this.getDistanceFromEntity(p) < 7.0 && !p.deadflag && p.getGameMode() != 3) {
                if (this.getDistanceFromEntityCenter(p) < (double)p.getWidth()) {
                    p.setExperience(p.getExperience() + this.getExperience());
                    this.deadflag = true;
                    if (this.getBID() == 0) {
                        this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                    }
                }
                float tdir = (float)Math.atan2(p.posx - this.posx, p.posz - this.posz);
                double factor = 1.0;
                double dist = this.getDistanceFromEntity(p);
                factor = 7.0 / dist;
                if (factor > 1.0) {
                    factor = 1.0;
                }
                this.motionx = (float)((double)this.motionx + (double)0.04f * factor * Math.sin(tdir) * (double)deltaT);
                this.motionz = (float)((double)this.motionz + (double)0.04f * factor * Math.cos(tdir) * (double)deltaT);
                if (this.posy > p.posy + (double)(p.getHeight() / 2.0f)) {
                    this.motiony -= 0.02f * deltaT;
                }
                if (this.posy < p.posy + (double)(p.getHeight() / 2.0f)) {
                    this.motiony += 0.06f * deltaT;
                }
            }
            if (!this.tried && !this.deadflag && DangerZone.server.entityManager.active_entities > DangerZone.max_entities / 4) {
                List<Entity> nearby_list = null;
                Entity e = null;
                nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(8.0f, this.dimension, this.posx, this.posy, this.posz);
                if (nearby_list != null && !nearby_list.isEmpty()) {
                    ListIterator<Entity> li = nearby_list.listIterator();
                    while (li.hasNext()) {
                        e = li.next();
                        if (e == this || !(e instanceof EntityExp) || e.deadflag) continue;
                        EntityExp ex = (EntityExp)e;
                        ex.setExperience(ex.getExperience() + this.getExperience());
                        ex.deathtimer = 1200;
                        this.deadflag = true;
                        break;
                    }
                }
                this.tried = true;
            }
            if (this.getInLiquid()) {
                this.doInLiquid(1.0f);
                this.motionx *= 0.9f;
                this.motiony *= 0.9f;
                this.motionz *= 0.9f;
                this.doSolidsPushback(0.0f, deltaT);
            }
        } else {
            this.motiony *= 1.0f - 0.05f * deltaT * rate;
            this.motionx *= 1.0f - 0.05f * deltaT * rate;
            this.motionz *= 1.0f - 0.05f * deltaT * rate;
        }
        super.update(deltaT);
    }

    public int getSubTexture() {
        int howfast = 16;
        if (this.getExperience() >= 10) {
            howfast = 8;
        }
        if (this.getExperience() >= 100) {
            howfast = 4;
        }
        if (this.getExperience() >= 1000) {
            howfast = 1;
        }
        ++this.nexttextcount;
        if (this.nexttextcount >= howfast) {
            this.nexttextcount = 0;
            this.nexttext += this.countdir;
            if (this.nexttext > 7) {
                this.nexttext = 7;
                this.countdir = -1;
            }
            if (this.nexttext < 0) {
                this.nexttext = 0;
                this.countdir = 1;
            }
        }
        return this.nexttext;
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/misc/exp.png");
        }
        return this.texture;
    }

    /*
     * Unable to fully structure code
     */
    public boolean doSolidsPushback(float kf, float deltaT) {
        wdth = this.getWidth();
        intwidth = (int)(wdth / 2.0f + 0.995f);
        tmx = this.motionx * deltaT;
        tmz = this.motionz * deltaT;
        rate = (float)DangerZone.entityupdaterate / (float)DangerZone.serverentityupdaterate;
        if (!this.world.isServer) {
            tmx *= rate;
            tmz *= rate;
        }
        hitsomething = false;
        dist = (float)Math.sqrt(tmx * tmx + tmz * tmz);
        curdist = 0.0f;
        bid = 0;
        if (dist != 0.0f) ** GOTO lbl72
        return false;
lbl-1000:
        // 1 sources

        {
            if ((curdist += 0.1f) > dist) {
                curdist = dist;
            }
            mx = curdist / dist * tmx;
            mz = curdist / dist * tmz;
            upx = this.posx + (double)mx;
            upz = this.posz + (double)mz;
            i = -intwidth;
            while (i <= intwidth) {
                j = -intwidth;
                while (j <= intwidth) {
                    bid = this.world.getblock(this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                    if (bid != 0 && Blocks.isSolid(bid, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j)) {
                        itemp = (int)upx + i;
                        dx = (double)itemp + 0.5 - this.posx;
                        itemp = (int)upz + j;
                        dz = (double)itemp + 0.5 - this.posz;
                        if (Math.abs(dx) - (double)(0.51f + wdth / 2.0f) < 0.0 && Math.abs(dz) - (double)(0.51f + wdth / 2.0f) < 0.0) {
                            this.posx = dx > 0.0 ? (this.posx -= 0.019999999552965164) : (this.posx += 0.019999999552965164);
                            this.posz = dz > 0.0 ? (this.posz -= 0.019999999552965164) : (this.posz += 0.019999999552965164);
                            itemp = (int)this.posx + i;
                            dx = (double)itemp + 0.5 - this.posx;
                            itemp = (int)this.posz + j;
                            dz = (double)itemp + 0.5 - this.posz;
                        }
                        dxsave = dx;
                        if (dx < 0.0 && mx < 0.0f) {
                            if (Math.abs(dz) < (double)(0.51f + wdth / 2.0f)) {
                                dx += 0.5099999904632568;
                                if ((dx += (double)(wdth / 2.0f)) > (double)mx) {
                                    this.motionx = (float)(dx / (double)deltaT);
                                    hitsomething = true;
                                    Blocks.bumpedBlock(bid, this, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                                }
                            }
                        } else if (dx > 0.0 && mx > 0.0f && Math.abs(dz) < (double)(0.51f + wdth / 2.0f)) {
                            dx -= 0.5099999904632568;
                            if ((dx -= (double)(wdth / 2.0f)) < (double)mx) {
                                this.motionx = (float)(dx / (double)deltaT);
                                hitsomething = true;
                                Blocks.bumpedBlock(bid, this, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                            }
                        }
                        dx = dxsave;
                        if (dz < 0.0 && mz < 0.0f) {
                            if (Math.abs(dx) < (double)(0.51f + wdth / 2.0f)) {
                                dz += 0.5099999904632568;
                                if ((dz += (double)(wdth / 2.0f)) > (double)mz) {
                                    this.motionz = (float)(dz / (double)deltaT);
                                    hitsomething = true;
                                    Blocks.bumpedBlock(bid, this, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                                }
                            }
                        } else if (dz > 0.0 && mz > 0.0f && Math.abs(dx) < (double)(0.51f + wdth / 2.0f)) {
                            dz -= 0.5099999904632568;
                            if ((dz -= (double)(wdth / 2.0f)) < (double)mz) {
                                this.motionz = (float)(dz / (double)deltaT);
                                hitsomething = true;
                                Blocks.bumpedBlock(bid, this, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
lbl72:
            // 2 sources

            ** while (curdist < dist && !hitsomething)
        }
lbl73:
        // 1 sources

        return hitsomething;
    }

    @Override
    public float getBrightness() {
        if (this.getExperience() < 10) {
            return -0.25f;
        }
        if (this.getExperience() < 100) {
            return 0.0f;
        }
        return 0.25f;
    }
}

