/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.PlayerKeyEvent;
import dangerzone.TextureMapper;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class DroneClaw
extends EntityLiving {
    public Entity thrower = null;
    public Entity caught = null;
    public float open = 0.0f;
    public boolean open_down;
    public boolean close_down;
    public boolean oc_sound;

    public DroneClaw(World w) {
        super(w);
        this.maxrenderdist = 400;
        this.height = 0.75f;
        this.width = 0.75f;
        this.uniquename = "DangerZone:DroneClaw";
        this.setMaxHealth(60.0f);
        this.setHealth(60.0f);
        this.setDefense(1.0f);
        this.takesFallDamage = false;
        this.setExperience(10);
        this.daytimedespawn = false;
        this.nighttimedespawn = false;
        this.canFly = true;
        this.setFlying(true);
        this.always_draw = true;
        this.temperament = 1;
        this.oc_sound = false;
        this.close_down = false;
        this.open_down = false;
        this.ignoreCollisions = true;
        this.tower_defense_enable = false;
    }

    public float getOpen() {
        return this.getVarFloat(10);
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.thrower == null || this.thrower.deadflag) {
            this.deadflag = true;
            super.doEntityAction(deltaT);
            return;
        }
        float speed = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        if (speed > 0.001f) {
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.motionx, this.motionz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw = (float)((double)this.rotation_yaw + (double)(ddiff * 180.0f) / Math.PI / 5.0);
            float pitch = speed * 90.0f;
            if (pitch > 90.0f) {
                pitch = 90.0f;
            }
            this.rotation_pitch = pitch;
            this.rotation_yaw_motion = 0.0f;
        } else {
            this.rotation_yaw_motion = 1.0f;
            this.rotation_pitch = 0.0f;
        }
        this.motiony = 0.2f * deltaT;
        PlayerKeyEvent plk = null;
        while ((plk = this.getNextKeyEvent()) != null) {
            if (plk.key == 1) {
                this.deadflag = true;
                return;
            }
            if (plk.key == 203) {
                this.close_down = plk.isDown;
            }
            if (plk.key != 205) continue;
            if (plk.isDown) {
                this.open_down = true;
                continue;
            }
            this.open_down = false;
        }
        if (this.close_down) {
            if (!this.oc_sound) {
                this.play_oc_sound();
                this.oc_sound = true;
            }
            this.open += 3.0f;
            if (this.open > 30.0f) {
                this.open = 30.0f;
            }
            this.setVarFloat(10, this.open);
            this.catch_something();
        }
        if (this.open_down) {
            if (!this.oc_sound) {
                this.play_oc_sound();
                this.oc_sound = true;
            }
            this.open -= 3.0f;
            if (this.open < -50.0f) {
                this.open = -50.0f;
            }
            this.setVarFloat(10, this.open);
            if (this.open < 0.0f && this.caught != null) {
                this.release();
            }
        }
        if (!this.close_down && !this.open_down) {
            this.oc_sound = false;
        }
        this.update_caught();
    }

    public void play_oc_sound() {
        this.world.playSound("DangerZone:motor_openclose", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
    }

    @Override
    public void doDeathDrops() {
    }

    public void release() {
        if (this.caught != null && this.caught instanceof EntityBlockItem) {
            Item it;
            InventoryContainer ic = this.caught.getInventory(0);
            if (ic.count == 1 && (it = ic.getItem()) != null) {
                this.rotation_pitch += 90.0f;
                this.rotation_pitch_head += 90.0f;
                if (it.onRightClick(this, null, ic)) {
                    this.caught.deadflag = true;
                }
                this.rotation_pitch -= 90.0f;
                this.rotation_pitch_head -= 90.0f;
            }
        }
        this.caught = null;
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/DroneClawtexture.png");
        }
        return this.texture;
    }

    public void update_caught() {
        if (this.caught == null) {
            return;
        }
        if (this.caught.deadflag) {
            this.caught = null;
            return;
        }
        this.caught.posy = this.posy + 0.25 * Math.cos(Math.toRadians(this.rotation_pitch));
        this.caught.posx = this.posx;
        this.caught.posz = this.posz;
        this.caught.posx += 1.5 * Math.sin(Math.toRadians(this.rotation_pitch)) * Math.sin(Math.toRadians(this.rotation_yaw));
        this.caught.posz += 1.5 * Math.sin(Math.toRadians(this.rotation_pitch)) * Math.cos(Math.toRadians(this.rotation_yaw));
        this.caught.motionx = this.motionx;
        this.caught.motiony = this.motiony;
        this.caught.motionz = this.motionz;
        if (this.caught instanceof Player) {
            Player pl = (Player)this.caught;
            pl.server_thread.sendPositionAndVelocityUpdateToPlayer(pl);
        }
        if (this.caught instanceof EntityBlockItem) {
            ((EntityBlockItem)this.caught).deathtimer = 1200;
        }
        if (this.caught instanceof EntityLiving) {
            ((EntityLiving)this.caught).fallcount = 0;
        }
        if (this.caught.getOnFire() != 0) {
            this.caught.setOnFire(0);
        }
    }

    public void catch_something() {
        if (this.caught != null) {
            return;
        }
        if (this.open > 0.0f && this.open < 30.0f) {
            List<Entity> nearby_list = null;
            nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(this.getWidth() * 3.0f, this.dimension, this.posx, this.posy, this.posz);
            if (nearby_list != null && !nearby_list.isEmpty()) {
                Entity e = null;
                Collections.sort(nearby_list, this.TargetSorter);
                ListIterator<Entity> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    e = li.next();
                    if (e == this) continue;
                    if (e instanceof EntityBlockItem && e.posy > this.posy - 1.0 && e.posy < this.posy + (double)this.getHeight() + 1.0) {
                        this.caught = e;
                        break;
                    }
                    if (!(e instanceof EntityLiving) || !(e.posy + (double)e.getHeight() > this.posy - 1.0) || !(e.posy < this.posy + (double)this.getHeight() + 1.0) || !(e.getHeight() * e.getWidth() < 5.25f)) continue;
                    this.caught = e;
                    break;
                }
            }
        }
    }
}

