/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Anteater
extends EntityLiving {
    public Anteater(World w) {
        super(w);
        this.maxrenderdist = 130;
        this.height = 1.25f;
        this.width = 0.95f;
        this.uniquename = "DangerZone:Anteater";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(50.0f);
        this.setHealth(50.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(5.0f);
        this.movefrequency = 45;
        this.setExperience(50);
        this.setCanDespawn(false);
        this.canSwim = true;
        this.enableHostility(14.0f, 3.5f);
        this.temperament = 2;
        this.enableTaming(14);
        this.enableFollowHeldFood(12);
        this.enableDroppedFood(12);
    }

    @Override
    public boolean isFoodItem(int foodid) {
        return foodid == Items.deadbug.itemID;
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e.getWidth() * e.getHeight() > 0.063f) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:anteater_hit";
    }

    @Override
    public String getDeathSound() {
        return null;
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophyanteater.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Anteatertexture.png");
        }
        return this.texture;
    }
}

