/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.World;
import dangerzone.blocks.BlockRail;
import dangerzone.blocks.Blocks;
import dangerzone.threads.FastBlockTicker;

public class BlockUpRail
extends BlockRail {
    public BlockUpRail(String n, String txt, String fulltxt) {
        super(n, txt, fulltxt);
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        if (w.isServer) {
            int bid = w.getblock(d, x, y - 1, z);
            int bid2 = w.getblock(d, x, y + 1, z);
            if (!Blocks.isSolid(bid) || bid2 != 0) {
                Blocks.doBreakBlock(this.blockID, w, d, x, y, z);
                w.setblock(d, x, y, z, 0);
            }
        }
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (w.isServer) {
            int bid = w.getblock(d, x, y - 1, z);
            int bid2 = w.getblock(d, x, y + 1, z);
            if (!Blocks.isSolid(bid) || bid2 != 0) {
                Blocks.doBreakBlock(this.blockID, w, d, x, y, z);
                w.setblock(d, x, y, z, 0);
                return;
            }
            int meta = 0;
            if (this.isRailBlock(w, d, x + 1, y, z)) {
                meta |= 1;
            }
            if (this.isRailBlock(w, d, x - 1, y, z)) {
                meta |= 2;
            }
            if (this.isRailBlock(w, d, x, y, z + 1)) {
                meta |= 4;
            }
            if (this.isRailBlock(w, d, x, y, z - 1)) {
                meta |= 8;
            }
            if (this.isRailBlock(w, d, x + 1, y - 1, z)) {
                meta |= 1;
            }
            if (this.isRailBlock(w, d, x - 1, y - 1, z)) {
                meta |= 2;
            }
            if (this.isRailBlock(w, d, x, y - 1, z + 1)) {
                meta |= 4;
            }
            if (this.isRailBlock(w, d, x, y - 1, z - 1)) {
                meta |= 8;
            }
            w.setblockandmeta(d, x, y, z, this.blockID, meta);
            FastBlockTicker.addFastTick(d, x, y, z, 8 + w.rand.nextInt(3));
        }
    }
}

