/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.BreakChecks;
import dangerzone.DangerZone;
import dangerzone.StitchedTexture;
import dangerzone.Utils;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlockItem;
import dangerzone.threads.VBODataBuilderThread;
import org.lwjgl.opengl.GL11;

public class BlockSapling
extends Block {
    private boolean compiled = false;
    private int myrenderid = 0;
    private float blockrenderwidth = 16.0f;

    public BlockSapling(String n, String txt) {
        super(n, txt);
        this.isStone = false;
        this.maxdamage = 5;
        this.mindamage = 1;
        this.breaksound = "DangerZone:dirt_hit";
        this.placesound = "DangerZone:dirt_place";
        this.hitsound = "DangerZone:dirt_hit";
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.randomtick = true;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            EntityBlockItem e;
            w.setblock(d, x, y, z, 0);
            if (w.rand.nextInt(4) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                e.fill(this, 1);
                w.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return;
        }
        Utils.spawnParticlesFromServer(w, "DangerZone:ParticleSparkle", 10, d, (float)x + 0.5f, (float)y + 0.25f, (float)z + 0.5f);
        if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
            return;
        }
        if (w.getblock(d, x, y + 1, z) != 0) {
            w.setblock(d, x, y, z, 0);
            return;
        }
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            w.setblock(d, x, y, z, 0);
            return;
        }
        if (w.rand.nextInt(15) != 1) {
            return;
        }
        w.setblock(d, x, y, z, 0);
        Trees tr = new Trees();
        if (this.blockID == Blocks.sapling_tallwood.blockID) {
            tr.TallWoodTree(w, d, x, y, z);
        }
        if (this.blockID == Blocks.sapling_cherry.blockID) {
            tr.makeFruitTree(w, d, x, y - 1, z, Blocks.cherryleaves.blockID);
        }
        if (this.blockID == Blocks.sapling_peach.blockID) {
            tr.makeFruitTree(w, d, x, y - 1, z, Blocks.peachleaves.blockID);
        }
        if (this.blockID == Blocks.sapling_apple.blockID) {
            tr.makeFruitTree(w, d, x, y - 1, z, Blocks.appleleaves.blockID);
        }
        if (this.blockID == Blocks.sapling_scragglyredwood.blockID) {
            tr.ScragglyRedwoodTree(w, d, x, y, z);
        }
        if (this.blockID == Blocks.sapling_scraggly.blockID) {
            tr.ScragglyTreeWithBranches(w, d, x, y, z);
        }
        if (this.blockID == Blocks.sapling_bigroundredwood.blockID) {
            tr.MakeBigRoundTree(w, d, x, y, z, Blocks.redwoodlog.blockID, Blocks.redwoodleaves.blockID, 6);
        }
        if (this.blockID == Blocks.sapling_bigroundwillow.blockID) {
            tr.MakeBigRoundTree(w, d, x, y, z, Blocks.willowlog.blockID, Blocks.willowleaves.blockID, 6);
        }
        if (this.blockID == Blocks.sapling_flower.blockID) {
            tr.flowerTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_flowertwo.blockID) {
            tr.flowerTreeTwo(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_scrub.blockID) {
            tr.scrubTree(w, d, x, y - 1, z, w.rand.nextInt(4));
        }
        if (this.blockID == Blocks.sapling_flowernormal.blockID) {
            tr.flowerTreeNormal(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_umbrella.blockID) {
            tr.umbrellaTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_bulb.blockID) {
            tr.bulbTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_looplowspiral.blockID) {
            tr.looplowspiralTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_loop.blockID) {
            tr.loopTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_generic.blockID) {
            tr.makeGenericTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_tallwillow.blockID) {
            tr.TallWillowTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_vase.blockID) {
            tr.vaseTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_spiral.blockID) {
            tr.spiralTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_loopspiral.blockID) {
            tr.loopspiralTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_bowl.blockID) {
            tr.bowlTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_doublebowl.blockID) {
            tr.doublebowlTree(w, d, x, y - 1, z);
        }
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        float brw = this.blockrenderwidth / 2.0f;
        st = VBODataBuilderThread.findVBOtextureforblockside(0, bid);
        v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            this.myrenderid = DangerZone.wr.getNextRenderID();
            GL11.glNewList(this.myrenderid, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f);
            GL11.glEnd();
            GL11.glEndList();
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glCallList(this.myrenderid);
        GL11.glDisable(3042);
    }
}

