/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.StitchedTexture;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.ModelRail;
import dangerzone.entities.Entity;
import dangerzone.threads.FastBlockTicker;
import dangerzone.threads.VBODataBuilderThread;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.Texture;

public class BlockRail
extends Block {
    public ModelRail mbf = null;
    public String fulltexturestring = null;
    public Texture fulltexture = null;

    public BlockRail(String n, String txt, String fulltxt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.renderAllSides = true;
        this.alwaysRender = true;
        this.alwaystick = true;
        this.maxdamage = 10;
        this.burntime = 30;
        this.fulltexturestring = fulltxt;
        if (this.mbf == null) {
            this.mbf = new ModelRail();
        }
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid;
        if (w.isServer && !Blocks.isSolid(bid = w.getblock(d, x, y - 1, z))) {
            Blocks.doBreakBlock(this.blockID, w, d, x, y, z);
            w.setblock(d, x, y, z, 0);
        }
    }

    @Override
    public void tickMeFast(World w, int d, int x, int y, int z) {
        this.tickMe(w, d, x, y, z);
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (w.isServer) {
            int bid = w.getblock(d, x, y - 1, z);
            if (!Blocks.isSolid(bid)) {
                Blocks.doBreakBlock(this.blockID, w, d, x, y, z);
                w.setblock(d, x, y, z, 0);
                return;
            }
            int meta = 0;
            if (this.isRailBlock(w, d, x + 1, y, z)) {
                meta |= 1;
            }
            if (this.isRailBlock(w, d, x - 1, y, z)) {
                meta |= 2;
            }
            if (this.isRailBlock(w, d, x, y, z + 1)) {
                meta |= 4;
            }
            if (this.isRailBlock(w, d, x, y, z - 1)) {
                meta |= 8;
            }
            if (this.isRailBlock(w, d, x + 1, y - 1, z)) {
                meta |= 1;
            }
            if (this.isRailBlock(w, d, x - 1, y - 1, z)) {
                meta |= 2;
            }
            if (this.isRailBlock(w, d, x, y - 1, z + 1)) {
                meta |= 4;
            }
            if (this.isRailBlock(w, d, x, y - 1, z - 1)) {
                meta |= 8;
            }
            if (meta == 1 && this.isRailBlock(w, d, x - 1, y + 1, z)) {
                meta |= 0x10;
            }
            if (meta == 2 && this.isRailBlock(w, d, x + 1, y + 1, z)) {
                meta |= 0x10;
            }
            if (meta == 4 && this.isRailBlock(w, d, x, y + 1, z - 1)) {
                meta |= 0x10;
            }
            if (meta == 8 && this.isRailBlock(w, d, x, y + 1, z + 1)) {
                meta |= 0x10;
            }
            w.setblockandmeta(d, x, y, z, this.blockID, meta);
            FastBlockTicker.addFastTick(d, x, y, z, 8 + w.rand.nextInt(3));
        }
    }

    public boolean isRailBlock(World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y, z);
        if (bid == 0) {
            return false;
        }
        Block b = Blocks.getBlock(bid);
        return b instanceof BlockRail;
    }

    @Override
    public Texture getTexture(int side) {
        if (this.texture == null || this.fulltexture == null) {
            this.texture = this.initBlockTexture(this.texturepath);
            this.fulltexture = this.initBlockTexture(this.fulltexturestring);
        }
        if (side == 5) {
            return this.fulltexture;
        }
        return this.texture;
    }

    @Override
    public String getStitchedTextureName(int side) {
        return this.fulltexturestring;
    }

    @Override
    public void renderMeHeld(WorldRenderer wr, Entity e, int bid, boolean isdisplay) {
        if (e == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f, 4.0f, 0.0f);
        GL11.glScalef(2.0f, 2.0f, 2.0f);
        this.renderMe(wr, e.world, e.dimension, (int)e.posx, (int)e.posy, (int)e.posz, bid, 3, 0, false);
        GL11.glScalef(0.5f, 0.5f, 0.5f);
        GL11.glPopMatrix();
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        st = VBODataBuilderThread.findVBOtextureforblockside(5, bid);
        if (st == null) {
            return;
        }
        v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v == null) {
            return;
        }
        if ((meta & 0x10) == 0) {
            this.mbf.railcenter.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
            this.mbf.railpost.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
            if ((meta & 1) != 0) {
                this.mbf.railside.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
            }
            if ((meta & 2) != 0) {
                this.mbf.railside.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 180);
            }
            if ((meta & 4) != 0) {
                this.mbf.railside.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 90);
            }
            if ((meta & 8) != 0) {
                this.mbf.railside.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, -90);
            }
        } else {
            int angle = 180;
            if ((meta & 2) != 0) {
                angle = 0;
            }
            if ((meta & 4) != 0) {
                angle = -90;
            }
            if ((meta & 8) != 0) {
                angle = 90;
            }
            this.mbf.railsideA.renderRotatedToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0, angle, 0);
            this.mbf.railsideB.renderRotatedToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0, angle, 0);
            this.mbf.railsideC.renderRotatedToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0, angle, 0);
            this.mbf.railsideD.renderRotatedToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0, angle, 0);
            this.mbf.railcenterA.renderRotatedToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0, angle, 0);
            this.mbf.railpostA.renderRotatedToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0, angle, 0);
            this.mbf.railpostB.renderRotatedToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0, angle, 0);
            this.mbf.railpostC.renderRotatedToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0, angle, 0);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        wr.loadtextureforblockside(5, bid, false);
        GL11.glTranslatef(0.0f, -8.0f, 0.0f);
        if ((meta & 0x10) == 0) {
            this.mbf.railcenter.render(1.0f);
            this.mbf.railpost.render(1.0f);
            if ((meta & 1) == 1) {
                this.mbf.railside.render(1.0f);
            }
            if ((meta & 2) == 2) {
                GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
                this.mbf.railside.render(1.0f);
                GL11.glRotatef(-180.0f, 0.0f, 1.0f, 0.0f);
            }
            if ((meta & 4) == 4) {
                GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
                this.mbf.railside.render(1.0f);
                GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            }
            if ((meta & 8) == 8) {
                GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
                this.mbf.railside.render(1.0f);
                GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
            }
        }
    }
}

