/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.StitchedTexture;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.BlockRail;
import dangerzone.blocks.Blocks;
import dangerzone.threads.FastBlockTicker;
import dangerzone.threads.VBODataBuilderThread;
import org.lwjgl.opengl.GL11;

public class BlockDownRail
extends BlockRail {
    public BlockDownRail(String n, String txt, String fulltxt) {
        super(n, txt, fulltxt);
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        if (w.isServer) {
            int bid = w.getblock(d, x, y + 1, z);
            int bid2 = w.getblock(d, x, y - 1, z);
            if (!Blocks.isSolid(bid) || bid2 != 0) {
                Blocks.doBreakBlock(this.blockID, w, d, x, y, z);
                w.setblock(d, x, y, z, 0);
            }
        }
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (w.isServer) {
            int bid = w.getblock(d, x, y + 1, z);
            int bid2 = w.getblock(d, x, y - 1, z);
            if (!Blocks.isSolid(bid) || bid2 != 0) {
                Blocks.doBreakBlock(this.blockID, w, d, x, y, z);
                w.setblock(d, x, y, z, 0);
                return;
            }
            int meta = 0;
            if (this.isRailBlock(w, d, x + 1, y, z)) {
                meta |= 1;
            }
            if (this.isRailBlock(w, d, x - 1, y, z)) {
                meta |= 2;
            }
            if (this.isRailBlock(w, d, x, y, z + 1)) {
                meta |= 4;
            }
            if (this.isRailBlock(w, d, x, y, z - 1)) {
                meta |= 8;
            }
            if (this.isRailBlock(w, d, x + 1, y - 1, z)) {
                meta |= 1;
            }
            if (this.isRailBlock(w, d, x - 1, y - 1, z)) {
                meta |= 2;
            }
            if (this.isRailBlock(w, d, x, y - 1, z + 1)) {
                meta |= 4;
            }
            if (this.isRailBlock(w, d, x, y - 1, z - 1)) {
                meta |= 8;
            }
            w.setblockandmeta(d, x, y, z, this.blockID, meta);
            FastBlockTicker.addFastTick(d, x, y, z, 8 + w.rand.nextInt(3));
        }
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        st = VBODataBuilderThread.findVBOtextureforblockside(5, bid);
        if (st == null) {
            return;
        }
        v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v == null) {
            return;
        }
        this.mbf.railcenter.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        this.mbf.railpostA.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo + 4, zo, 0);
        this.mbf.railpost.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo + 14, zo, 0);
        if ((meta & 1) != 0) {
            this.mbf.railside.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        }
        if ((meta & 2) != 0) {
            this.mbf.railside.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 180);
        }
        if ((meta & 4) != 0) {
            this.mbf.railside.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 90);
        }
        if ((meta & 8) != 0) {
            this.mbf.railside.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, -90);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        wr.loadtextureforblockside(5, bid, false);
        GL11.glTranslatef(0.0f, -8.0f, 0.0f);
        this.mbf.railcenter.render(1.0f);
        GL11.glTranslatef(0.0f, 4.0f, 0.0f);
        this.mbf.railpostA.render(1.0f);
        GL11.glTranslatef(0.0f, 10.0f, 0.0f);
        this.mbf.railpost.render(1.0f);
        GL11.glTranslatef(0.0f, -14.0f, 0.0f);
        if ((meta & 1) == 1) {
            this.mbf.railside.render(1.0f);
        }
        if ((meta & 2) == 2) {
            GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
            this.mbf.railside.render(1.0f);
            GL11.glRotatef(-180.0f, 0.0f, 1.0f, 0.0f);
        }
        if ((meta & 4) == 4) {
            GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
            this.mbf.railside.render(1.0f);
            GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        }
        if ((meta & 8) == 8) {
            GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            this.mbf.railside.render(1.0f);
            GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        }
    }
}

