/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.PIDController;
import dangerzone.PlayerKeyEvent;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.DroneClaw;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Drone
extends EntityLiving {
    public Entity thrower = null;
    public DroneClaw clawentity = null;
    PIDController pidy = null;
    float tiltfb;
    float tiltlr;
    boolean lefthit;
    boolean righthit;
    boolean forwardhit;
    boolean backwardhit;
    boolean uphit;
    boolean downhit;
    int clawpos = 0;
    boolean down_isdown;
    boolean up_isdown;
    boolean updown_sound;

    public Drone(World w) {
        super(w);
        this.maxrenderdist = 400;
        this.height = 0.75f;
        this.width = 1.25f;
        this.uniquename = "DangerZone:Drone";
        this.setMaxHealth(20.0f);
        this.setHealth(20.0f);
        this.setDefense(1.0f);
        this.takesFallDamage = false;
        this.setExperience(10);
        this.daytimedespawn = false;
        this.nighttimedespawn = false;
        this.canFly = true;
        this.setFlying(true);
        this.tiltlr = 0.0f;
        this.tiltfb = 0.0f;
        this.righthit = false;
        this.lefthit = false;
        this.backwardhit = false;
        this.forwardhit = false;
        this.downhit = false;
        this.uphit = false;
        this.always_draw = true;
        this.temperament = 1;
        this.clawpos = 0;
        this.updown_sound = false;
        this.up_isdown = false;
        this.down_isdown = false;
        this.tower_defense_enable = false;
    }

    @Override
    public void init() {
        super.init();
        this.eyeheight = 0.0625f;
    }

    public void setDirectionAndVelocity(float x, float y, float z, float velocity, float variability) {
        this.motionx = x * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
        this.motiony = y * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
        this.motionz = z * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
    }

    public float getTiltLR() {
        return this.getVarFloat(10);
    }

    public float getTiltFB() {
        return this.getVarFloat(9);
    }

    @Override
    public void update(float deltaT) {
        this.rotation_pitch = this.getTiltFB() * 25.0f;
        super.update(deltaT);
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.thrower == null || this.thrower.deadflag && !this.deadflag) {
            this.deadflag = true;
            Utils.doDropRand(this.world, 0, Items.drone.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
            super.doEntityAction(deltaT);
            return;
        }
        if (this.pidy == null) {
            this.pidy = new PIDController(0.05f, 3.0f, 0.25f, 0.9f, 7.1f, -1.5f, 1.5f);
            this.pidy.setHoldpos(this.posy + (double)(this.motiony * deltaT));
        }
        if (this.clawentity != null && this.clawentity.deadflag) {
            this.clawentity = null;
        }
        float faster = deltaT * 2.0f;
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.toRadians(this.thrower.rotation_yaw);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 6.0);
        cdir = (float)Math.toRadians(this.rotation_yaw_head);
        tdir = (float)Math.toRadians(this.thrower.rotation_yaw_head);
        ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
        this.rotation_pitch_head = this.thrower.rotation_pitch_head;
        this.tiltlr *= 0.8f;
        if (Math.abs(this.tiltlr) < 0.01f) {
            this.tiltlr = 0.0f;
        }
        this.tiltfb *= 0.8f;
        if (Math.abs(this.tiltfb) < 0.01f) {
            this.tiltfb = 0.0f;
        }
        if (this.thrower.getForward()) {
            this.motionx = (float)((double)this.motionx + (double)this.moveSpeed * Math.sin(tdir) * (double)faster);
            this.motionz = (float)((double)this.motionz + (double)this.moveSpeed * Math.cos(tdir) * (double)faster);
            this.tiltfb += 0.25f;
            if (this.tiltfb > 1.0f) {
                this.tiltfb = 1.0f;
            }
            if (!this.forwardhit) {
                this.world.playSound("DangerZone:drone", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            this.forwardhit = true;
        } else {
            this.forwardhit = false;
        }
        if (this.thrower.getBackward()) {
            this.motionx = (float)((double)this.motionx - (double)this.moveSpeed * Math.sin(tdir) * (double)faster);
            this.motionz = (float)((double)this.motionz - (double)this.moveSpeed * Math.cos(tdir) * (double)faster);
            this.tiltfb -= 0.25f;
            if (this.tiltfb < -1.0f) {
                this.tiltfb = -1.0f;
            }
            if (!this.backwardhit) {
                this.world.playSound("DangerZone:drone", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            this.backwardhit = true;
        } else {
            this.backwardhit = false;
        }
        if (this.thrower.getLeft()) {
            this.motionx = (float)((double)this.motionx + (double)this.moveSpeed * Math.sin((double)tdir + 1.5707963267948966) * (double)faster);
            this.motionz = (float)((double)this.motionz + (double)this.moveSpeed * Math.cos((double)tdir + 1.5707963267948966) * (double)faster);
            this.tiltlr -= 0.25f;
            if (this.tiltlr < -1.0f) {
                this.tiltlr = -1.0f;
            }
            if (!this.lefthit) {
                this.world.playSound("DangerZone:drone", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            this.lefthit = true;
        } else {
            this.lefthit = false;
        }
        if (this.thrower.getRight()) {
            this.motionx = (float)((double)this.motionx - (double)this.moveSpeed * Math.sin((double)tdir + 1.5707963267948966) * (double)faster);
            this.motionz = (float)((double)this.motionz - (double)this.moveSpeed * Math.cos((double)tdir + 1.5707963267948966) * (double)faster);
            this.tiltlr += 0.25f;
            if (this.tiltlr > 1.0f) {
                this.tiltlr = 1.0f;
            }
            if (!this.righthit) {
                this.world.playSound("DangerZone:drone", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            this.righthit = true;
        } else {
            this.righthit = false;
        }
        this.setVarFloat(9, this.tiltfb);
        this.setVarFloat(10, this.tiltlr);
        boolean hover = true;
        if (this.thrower.getUp()) {
            this.motiony += 0.05f * faster;
            this.pidy.setHoldpos(this.posy + (double)(this.motiony * deltaT));
            hover = false;
            if (!this.uphit) {
                this.world.playSound("DangerZone:drone", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            this.uphit = true;
        } else {
            this.uphit = false;
        }
        if (this.thrower.getDown()) {
            this.motiony -= 0.01f * faster;
            this.pidy.setHoldpos(this.posy + (double)(this.motiony * deltaT));
            hover = false;
            if (!this.downhit) {
                this.world.playSound("DangerZone:drone", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            this.downhit = true;
        } else {
            this.downhit = false;
        }
        if (hover) {
            float adjust = deltaT * this.pidy.getAdjustment(this.posy, this.motiony * deltaT);
            this.motiony += adjust;
        }
        this.motiony += 0.15f * deltaT;
        PlayerKeyEvent plk = null;
        while ((plk = this.getNextKeyEvent()) != null) {
            if (this.clawentity != null) {
                this.clawentity.addKeyEvent(plk.key, plk.isDown);
            }
            if (plk.key == 1 && plk.isDown) {
                this.deadflag = true;
                Utils.doDropRand(this.world, 0, Items.drone.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
                return;
            }
            if (plk.key == 208) {
                this.down_isdown = plk.isDown;
            }
            if (plk.key != 200) continue;
            if (plk.isDown) {
                this.up_isdown = true;
                continue;
            }
            this.up_isdown = false;
        }
        while ((plk = this.getNextMouseEvent()) != null) {
        }
        if (this.down_isdown) {
            if (!this.updown_sound) {
                this.play_updown_sound();
                this.updown_sound = true;
            }
            if (this.clawentity == null) {
                this.clawentity = (DroneClaw)this.world.createEntityByName("DangerZone:DroneClaw", this.dimension, this.posx, this.posy - 1.0, this.posz);
                if (this.clawentity != null) {
                    this.clawentity.init();
                    this.clawentity.motionx = this.motionx;
                    this.clawentity.motiony = this.motiony;
                    this.clawentity.motionz = this.motionz;
                    this.clawentity.thrower = this;
                    this.world.spawnEntityInWorld(this.clawentity);
                }
            }
            ++this.clawpos;
            if (this.clawpos > 300) {
                this.clawpos = 300;
            }
        }
        if (this.up_isdown) {
            if (!this.updown_sound) {
                this.play_updown_sound();
                this.updown_sound = true;
            }
            --this.clawpos;
            if (this.clawpos < 0) {
                this.clawpos = 0;
            }
        }
        if (!this.down_isdown && !this.up_isdown) {
            this.updown_sound = false;
        }
        if (this.clawentity != null) {
            while (this.clawentity.isSolidAtLevel(this.clawentity.dimension, this.clawentity.posx, this.posy - 1.0 - (double)(0.1f * (float)this.clawpos) + (double)this.motiony, this.clawentity.posz)) {
                this.clawpos -= 2;
                if (this.clawpos <= 0) break;
            }
        }
        if (this.clawpos <= 0) {
            this.clawpos = 0;
            if (this.clawentity != null) {
                this.clawentity.deadflag = true;
                this.clawentity = null;
            }
        }
        if (this.clawentity != null) {
            this.clawentity.posy = this.posy - 1.0 - (double)(0.1f * (float)this.clawpos) + (double)this.motiony;
            this.clawentity.posx += (this.posx - this.clawentity.posx) / 4.0;
            this.clawentity.posz += (this.posz - this.clawentity.posz) / 4.0;
            this.clawentity.motionx += (this.motionx - this.clawentity.motionx) / 4.0f;
            this.clawentity.motionz += (this.motionz - this.clawentity.motionz) / 4.0f;
            this.clawentity.motiony += (this.motiony - this.clawentity.motiony) / 4.0f;
            float dist = 0.1f * (float)this.clawpos;
            while (dist > 0.0f) {
                if (this.world.rand.nextInt(30) == 0) {
                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 1, this.dimension, this.posx, this.posy + (double)this.motiony - (double)dist, this.posz);
                }
                dist -= 0.1f;
            }
        }
    }

    public void play_updown_sound() {
        this.world.playSound("DangerZone:motor_updown", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
    }

    @Override
    public void doDeathDrops() {
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Dronetexture.png");
        }
        return this.texture;
    }
}

