/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.BreakChecks;
import dangerzone.DangerZone;
import dangerzone.StitchedTexture;
import dangerzone.World;
import dangerzone.blocks.BlockFalling;
import dangerzone.blocks.Blocks;
import org.newdawn.slick.opengl.Texture;

public class GrassBlock
extends BlockFalling {
    public Texture ttop = null;
    public Texture tbottom = null;
    public Texture tside = null;
    public String topname;
    public String bottomname;
    public String sidename;
    StitchedTexture sttop = new StitchedTexture();
    StitchedTexture stside = new StitchedTexture();
    StitchedTexture stbottom = new StitchedTexture();

    public GrassBlock(String n, String top, String bottom, String side) {
        super(n, "");
        this.topname = top;
        this.bottomname = bottom;
        this.sidename = side;
        this.randomtick = true;
        this.isDirt = true;
        this.maxdamage = 12;
        this.breaksound = "DangerZone:dirt_hit";
        this.placesound = "DangerZone:dirt_place";
        this.hitsound = "DangerZone:dirt_hit";
    }

    @Override
    public String getStepSound() {
        int i = DangerZone.rand.nextInt(4);
        if (i == 0) {
            return "DangerZone:grass1";
        }
        if (i == 1) {
            return "DangerZone:grass2";
        }
        if (i == 2) {
            return "DangerZone:grass3";
        }
        return "DangerZone:grass4";
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (Blocks.isSolid(w.getblock(d, x, y + 1, z), w, d, x, y, z) && !Blocks.isLeaves(w.getblock(d, x, y + 1, z))) {
            w.setblock(d, x, y, z, Blocks.dirt.blockID);
            return;
        }
        if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
            return;
        }
        if (w.rand.nextInt(10) == 1) {
            int i = -1;
            while (i <= 1) {
                int j = -1;
                while (j <= 1) {
                    int k = -1;
                    while (k <= 1) {
                        if (w.getblock(d, x + i, y + j, z + k) == Blocks.dirt.blockID && w.getblock(d, x + i, y + j + 1, z + k) == 0 && w.rand.nextInt(3) == 1) {
                            w.setblockandmeta(d, x + i, y + j, z + k, Blocks.grassblock.blockID, w.rand.nextInt(4) << 12);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public Texture getTexture(int side) {
        if (this.ttop == null) {
            this.ttop = this.initBlockTexture(this.topname);
        }
        if (this.tbottom == null) {
            this.tbottom = this.initBlockTexture(this.bottomname);
        }
        if (this.tside == null) {
            this.tside = this.initBlockTexture(this.sidename);
        }
        if (side == 0) {
            return this.ttop;
        }
        if (side == 5) {
            return this.tbottom;
        }
        return this.tside;
    }

    @Override
    public StitchedTexture getStitchedTexture(int side) {
        if (side == 0) {
            return this.sttop;
        }
        if (side == 5) {
            return this.stbottom;
        }
        return this.stside;
    }

    @Override
    public String getStitchedTextureName(int side) {
        if (side == 0) {
            return this.topname;
        }
        if (side == 5) {
            return this.bottomname;
        }
        return this.sidename;
    }
}

