/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.biomes;

import dangerzone.Chunk;
import dangerzone.DangerZone;
import dangerzone.Fastmath;
import dangerzone.World;
import dangerzone.biomes.BiomeManager;
import java.util.Random;

public class OverWorldBiomeManager
extends BiomeManager {
    float[] biomefloats = new float[this.genlen];
    float[] biomeoffs = new float[this.genlen];
    float[] biomescalex = new float[this.genlen];
    float[] biomescalez = new float[this.genlen];
    int[] biomepwrs = new int[this.genlen];
    int[] biomept = new int[this.genlen];
    int genlen = 40;

    public OverWorldBiomeManager() {
        int i = this.biomefloats.length;
        Random myrand = DangerZone.server_world != null ? new Random(DangerZone.server_world.worldseed + 127L) : new Random(127L);
        int j = 0;
        while (j < i) {
            this.biomefloats[j] = (0.1f + myrand.nextFloat()) * 5.0f;
            this.biomeoffs[j] = myrand.nextFloat() * 3.1415f;
            this.biomescalex[j] = (0.1f + myrand.nextFloat()) * 2.0f;
            this.biomescalez[j] = (0.1f + myrand.nextFloat()) * 2.0f;
            this.biomepwrs[j] = 1 + myrand.nextInt(5);
            this.biomept[j] = myrand.nextInt(3);
            ++j;
        }
    }

    public int genvalue(int dx, int dz) {
        int val = 0;
        int iters = this.biomefloats.length;
        float fval = 1.0f;
        int i = 0;
        while (i < iters) {
            fval = this.biomept[i] == 0 ? (fval += this.getoneval(i, dx, dz)) : (this.biomept[i] == 1 ? (fval *= this.getoneval(i, dx, dz)) : (fval -= this.getoneval(i, dx, dz)));
            ++i;
        }
        val = (int)fval;
        return val;
    }

    public float getoneval(int index, int dx, int dz) {
        float fval = 0.0f;
        float tval = fval = (float)Fastmath.sin((double)this.biomeoffs[index] + Math.toRadians((float)dx * this.biomescalex[index] + (float)dz * this.biomescalez[index]));
        int i = 0;
        while (i < this.biomepwrs[index]) {
            fval *= tval;
            ++i;
        }
        return fval *= this.biomefloats[index];
    }

    public void localgenerateheightmaps(World w, int d, Chunk c, int cx, int cz, int[][] dirtheight, int[][] stoneheight, int[][] baseheight) {
        float dirtamp = 0.02f;
        int dx = (cx << 4) + (int)(w.worldseed & 0xFFFFL);
        int dz = (cz << 4) + (int)(w.worldseed >> 16 & 0xFFFFL);
        int waterlevel = 60;
        int avgheight = 70;
        float tval = 0.0f;
        dx %= 1080000;
        dz %= 1080000;
        int i = 0;
        while (i < 16) {
            int k = 0;
            while (k < 16) {
                float t;
                tval = t = (float)this.genvalue(dx + i, dz + k);
                if ((t += (float)avgheight) < 0.0f) {
                    t = 0.0f;
                }
                if (t > 255.0f) {
                    t = 255.0f;
                }
                stoneheight[i][k] = (int)t;
                t = tval * dirtamp;
                dirtheight[i][k] = (int)t + stoneheight[i][k] + 1;
                if (dirtheight[i][k] < 0) {
                    dirtheight[i][k] = 0;
                }
                if (dirtheight[i][k] > 255) {
                    dirtheight[i][k] = 255;
                }
                if (stoneheight[i][k] < waterlevel + 10 && stoneheight[i][k] >= waterlevel) {
                    t = tval * (dirtamp / 2.0f);
                    dirtheight[i][k] = (int)t + stoneheight[i][k] + 1;
                    if (dirtheight[i][k] < 0) {
                        dirtheight[i][k] = 0;
                    }
                    if (dirtheight[i][k] > 255) {
                        dirtheight[i][k] = 255;
                    }
                }
                baseheight[i][k] = 0;
                ++k;
            }
            ++i;
        }
    }
}

