/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.Chunk;
import dangerzone.DangerZone;
import dangerzone.Dimension;
import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.ModelBase;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.StitchedTextureFile;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRendererUtils;
import dangerzone.biomes.Biome;
import dangerzone.biomes.BiomeManager;
import dangerzone.blocks.Block;
import dangerzone.blocks.BlockFlower;
import dangerzone.blocks.BlockLeaves;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.particles.Particle;
import dangerzone.threads.CleanerThread;
import dangerzone.threads.VBODataBuilderThread;
import java.awt.Font;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;

public class WorldRenderer {
    private volatile List<long[]> VBO_delete_list;
    public static Lock VBOlistlock = new ReentrantLock();
    public static Texture heart_texture = null;
    public static Texture unheart_texture = null;
    public static Texture hungerfull_texture = null;
    public static Texture hungerempty_texture = null;
    public static Texture bubble_texture = null;
    public static Texture sun_texture = null;
    public static Texture moon_texture = null;
    public static Texture magic_texture = null;
    public static Texture magicempty_texture = null;
    public static int last_texture = -1;
    public static StitchedTextureFile[] stitches = null;
    public static int next_stitch = 0;
    public volatile int oneblock = -1;
    public int blockrenderwidth = 16;
    public static volatile int focus_x;
    public static volatile int focus_y;
    public static volatile int focus_z;
    public static volatile int focus_side;
    public static volatile double poi_x;
    public static volatile double poi_y;
    public static volatile double poi_z;
    public static volatile boolean do_draw_focus;
    public static volatile int focus_bid;
    public static volatile int focus_meta;
    public static volatile float focus_damage;
    public static volatile float focus_maxdamage;
    public static volatile float focus_dist;
    public static volatile Entity focus_entity;
    public float linewidth = 3.0f;
    private int topid;
    private int bottomid;
    private int leftid;
    private int rightid;
    private int frontid;
    private int backid;
    private Font awtfont = null;
    public TrueTypeFont font = null;
    public static float brightness_red;
    public static float brightness_green;
    public static float brightness_blue;
    private float sky_red;
    private float sky_green;
    private float sky_blue;
    private Entity ent;
    private static Lock lock;
    private long lasttime = 0L;
    private long nowtime = 0L;
    public int fps = 0;
    private int fpscounter = 0;
    private int pps = 0;
    private float bounce = 0.0f;
    private float lastbounce = 0.0f;
    private float eatbounce = 0.0f;
    private int hit_cycles = 7;
    private int hit_cycle_count = 0;
    private int hit_cycle_dir = 1;
    private float hitx = -20.0f;
    private float hity = 10.0f;
    private float hitz = -25.0f;
    private float hitp = 62.0f;
    private float hitw = 34.0f;
    private float hitr = -137.0f;
    private float hitxn = -24.5f;
    private float hityn = 7.4f;
    private float hitzn = -33.8f;
    private float hitpn = 29.8f;
    private float hitwn = 7.7f;
    private float hitrn = 83.6f;
    private int eat_cycles = 7;
    private int eat_cycle_count = 0;
    private int eat_cycle_dir = 1;
    private int eat_delay_count = 0;
    private float eatx = -10.5f;
    private float eaty = -2.1f;
    private float eatz = 18.5f;
    private float eatp = -58.1f;
    private float eatw = -80.8f;
    private float eatr = 59.0f;
    private float eatxn = -12.7f;
    private float eatyn = -0.6f;
    private float eatzn = 20.5f;
    private float eatpn = 63.2f;
    private float eatwn = 55.9f;
    private float eatrn = 58.3f;
    boolean washurt = false;
    float ouch = 1.0f;
    private float f5x;
    private float f5y;
    private float f5z;
    private float f5yaw;
    private float f5pitch;
    private float cdir;
    private float tdir;
    private float pdiff;
    private float ydiff;
    private float rdiff;
    private static volatile long nextVBOid;
    public static volatile Map<Long, VBOBuffer> VBOmap;
    private volatile List<VBOBuffer> translucentVBOs;
    public volatile int VBOmemorysize;
    public int lastplayerdimension = 0;
    private boolean eat_sound = true;
    private double traveled = 0.0;
    public long framecounter = 0L;
    public static volatile int vbocount;
    public VBODataBuilderThread builder = null;
    private int usex;
    private int usey;
    private int usez;
    private int uses;
    private Entity usee = null;
    private FloatBuffer wrfogColor = null;
    public Entity ViewFromEntity = null;
    public float Viewer_yaw = 0.0f;
    public boolean normal_sun = true;

    static {
        do_draw_focus = false;
        focus_damage = 0.0f;
        focus_maxdamage = 0.0f;
        focus_dist = 0.0f;
        focus_entity = null;
        lock = new ReentrantLock();
        VBOmap = null;
        vbocount = 0;
    }

    public WorldRenderer() {
        heart_texture = TextureMapper.getTexture("res/menus/heart.png");
        unheart_texture = TextureMapper.getTexture("res/menus/unheart.png");
        hungerfull_texture = TextureMapper.getTexture("res/menus/hungerfull.png");
        hungerempty_texture = TextureMapper.getTexture("res/menus/hungerempty.png");
        bubble_texture = TextureMapper.getTexture("res/menus/bubble.png");
        magic_texture = TextureMapper.getTexture("res/menus/star.png");
        magicempty_texture = TextureMapper.getTexture("res/menus/star_empty.png");
        GregorianCalendar gcalendar = new GregorianCalendar();
        int nowmonth = gcalendar.get(2);
        int nowday = gcalendar.get(5);
        if (nowmonth == 9 && nowday == 31) {
            sun_texture = TextureMapper.getTexture("res/misc/sunpumpkin.png");
            this.normal_sun = false;
        } else {
            sun_texture = TextureMapper.getTexture("res/misc/sun.png");
        }
        moon_texture = TextureMapper.getTexture("res/misc/moon.png");
        stitches = new StitchedTextureFile[20];
        nextVBOid = 1L;
        VBOmap = new HashMap<Long, VBOBuffer>();
        this.VBO_delete_list = new ArrayList<long[]>();
        this.translucentVBOs = new ArrayList<VBOBuffer>();
        this.framecounter = 0L;
        vbocount = 0;
        this.VBOmemorysize = 0;
        if (this.font == null) {
            this.awtfont = new Font("Times New Roman", 0, 24);
            this.font = new TrueTypeFont(this.awtfont, false);
        }
        this.oneblock = -1;
        this.topid = this.getNextRenderID();
        GL11.glNewList(this.topid, 4864);
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
        GL11.glEnd();
        GL11.glEndList();
        this.bottomid = this.getNextRenderID();
        GL11.glNewList(this.bottomid, 4864);
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
        GL11.glEnd();
        GL11.glEndList();
        this.frontid = this.getNextRenderID();
        GL11.glNewList(this.frontid, 4864);
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
        GL11.glEnd();
        GL11.glEndList();
        this.backid = this.getNextRenderID();
        GL11.glNewList(this.backid, 4864);
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
        GL11.glEnd();
        GL11.glEndList();
        this.leftid = this.getNextRenderID();
        GL11.glNewList(this.leftid, 4864);
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
        GL11.glEnd();
        GL11.glEndList();
        this.rightid = this.getNextRenderID();
        GL11.glNewList(this.rightid, 4864);
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
        GL11.glEnd();
        GL11.glEndList();
        this.wrfogColor = BufferUtils.createFloatBuffer(4);
        this.wrfogColor.put(0.75f);
        this.wrfogColor.put(0.75f);
        this.wrfogColor.put(0.75f);
        this.wrfogColor.put(1.0f);
        this.wrfogColor.position(0);
        this.ViewFromEntity = DangerZone.player;
        this.Viewer_yaw = DangerZone.player.rotation_yaw_head;
    }

    public void loadBlockTextures() {
        StitchedTexture st = null;
        int bid = 0;
        while (bid < 2048) {
            if (Blocks.BlockArray[bid] != null) {
                int side = 0;
                while (side < 6) {
                    st = Blocks.BlockArray[bid].getStitchedTexture(side);
                    if (st.texturesindex < 0) {
                        StitchedTextureFile stf = stitches[next_stitch];
                        if (stf == null) {
                            WorldRenderer.stitches[WorldRenderer.next_stitch] = new StitchedTextureFile();
                        }
                        stf = stitches[next_stitch];
                        if (stf.nexty >= 32) {
                            stitches[next_stitch].doMakeMipMaps();
                            WorldRenderer.stitches[++WorldRenderer.next_stitch] = new StitchedTextureFile();
                        }
                        st.texturesindex = next_stitch;
                        StitchedTexture stnew = stitches[next_stitch].doAddTextureToBuffer(Blocks.BlockArray[bid].getStitchedTextureName(side));
                        if (stnew != null) {
                            st.yoffsetmax = stnew.yoffsetmax;
                            st.yoffsetmin = stnew.yoffsetmin;
                            st.xoffsetmax = stnew.xoffsetmax;
                            st.xoffsetmin = stnew.xoffsetmin;
                        }
                    }
                    ++side;
                }
            }
            ++bid;
        }
        stitches[next_stitch].doMakeMipMaps();
    }

    public void loadOneBlockTexture(int bid) {
        StitchedTexture st = null;
        if (Blocks.BlockArray[bid] != null) {
            int side = 0;
            while (side < 6) {
                st = Blocks.BlockArray[bid].getStitchedTexture(side);
                if (st.texturesindex < 0) {
                    StitchedTextureFile stf = stitches[next_stitch];
                    if (stf == null) {
                        WorldRenderer.stitches[WorldRenderer.next_stitch] = new StitchedTextureFile();
                    }
                    stf = stitches[next_stitch];
                    if (stf.nexty >= 32) {
                        WorldRenderer.stitches[++WorldRenderer.next_stitch] = new StitchedTextureFile();
                    }
                    st.texturesindex = next_stitch;
                    StitchedTexture stnew = stitches[next_stitch].doAddTexture(Blocks.BlockArray[bid].getStitchedTextureName(side));
                    if (stnew != null) {
                        st.yoffsetmax = stnew.yoffsetmax;
                        st.yoffsetmin = stnew.yoffsetmin;
                        st.xoffsetmax = stnew.xoffsetmax;
                        st.xoffsetmin = stnew.xoffsetmin;
                    }
                }
                ++side;
            }
        }
    }

    private void doHouseKeeping(World world) {
        ++this.framecounter;
        if (this.builder == null) {
            this.builder = new VBODataBuilderThread(world);
            Thread cwt = new Thread(this.builder);
            cwt.setPriority(5);
            cwt.start();
        }
        ++this.fpscounter;
        this.nowtime = System.currentTimeMillis();
        if (this.nowtime - this.lasttime > 1000L) {
            this.fps = (this.fps * 2 + this.fpscounter) / 3;
            if (this.fps < 1) {
                this.fps = 1;
            }
            this.fpscounter = 0;
            this.lasttime = this.nowtime;
            this.pps = DangerZone.packets_per_second;
            DangerZone.packets_per_second = 0;
            DangerZone.chunks_per_second = 0;
        }
        if (this.lastplayerdimension != DangerZone.player.dimension) {
            world.chunkcache.releaseAllVBOs();
            this.lastplayerdimension = DangerZone.player.dimension;
            CleanerThread.cleanmenowplease = true;
            while (CleanerThread.cleanmenowplease) {
                Thread.yield();
            }
        }
        if (this.oneblock != -1) {
            this.loadOneBlockTexture(this.oneblock);
            this.oneblock = -1;
        }
        VBOlistlock.lock();
        if (!this.VBO_delete_list.isEmpty()) {
            Iterator<long[]> ii = this.VBO_delete_list.iterator();
            while (ii.hasNext()) {
                long[] st = ii.next();
                if (st != null) {
                    int vdx = 0;
                    while (vdx < 20) {
                        if (st[vdx] != 0L) {
                            VBOBuffer v = VBOmap.get(st[vdx]);
                            if (v != null) {
                                VBOmap.remove(v.VBOid);
                                --vbocount;
                                v.free();
                            }
                            st[vdx] = 0L;
                        }
                        ++vdx;
                    }
                }
                ii.remove();
            }
        }
        int maxvbo = 3200;
        int maxdirect = 600;
        if (!DangerZone.bits64mode) {
            maxvbo = 2400;
            maxdirect = 400;
        }
        if (DangerZone.renderdistance <= 16) {
            int calc = DangerZone.renderdistance * 2;
            calc *= calc;
            if ((calc *= 3) < maxvbo) {
                maxvbo = calc;
            }
            if ((calc = 600 * DangerZone.renderdistance / 24) < maxdirect) {
                maxdirect = calc;
            }
        }
        if (vbocount > maxvbo || this.VBOmemorysize / 0x100000 > maxdirect) {
            Iterator<Map.Entry<Long, VBOBuffer>> it = VBOmap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, VBOBuffer> pair = it.next();
                VBOBuffer v = pair.getValue();
                if (v == null || this.framecounter - v.lastusedframe <= 10L) continue;
                --vbocount;
                v.free();
                it.remove();
            }
        }
        VBOlistlock.unlock();
        if (this.ViewFromEntity != DangerZone.player) {
            if (this.ViewFromEntity == null) {
                this.ViewFromEntity = DangerZone.player;
                this.Viewer_yaw = DangerZone.player.rotation_yaw_head;
            }
            if (this.ViewFromEntity.deadflag) {
                this.ViewFromEntity = DangerZone.player;
                this.Viewer_yaw = DangerZone.player.rotation_yaw_head;
            }
        }
        if (this.ViewFromEntity.dimension != DangerZone.player.dimension) {
            this.ViewFromEntity.dimension = DangerZone.player.dimension;
        }
    }

    private void calcBounceAndFocus(World world) {
        if (this.ViewFromEntity != DangerZone.player) {
            this.lastbounce = 0.0f;
            this.bounce = 0.0f;
            this.ViewFromEntity.rotation_pitch_head %= 360.0f;
            this.ViewFromEntity.rotation_yaw_head %= 360.0f;
            this.ViewFromEntity.rotation_roll_head %= 360.0f;
            this.Viewer_yaw = 360.0f - (this.ViewFromEntity.rotation_yaw_head + 180.0f) % 360.0f;
            focus_meta = 0;
            focus_bid = 0;
            focus_z = 0;
            focus_y = 0;
            focus_x = 0;
            focus_dist = 0.0f;
            focus_damage = 0.0f;
            focus_entity = null;
            return;
        }
        this.Viewer_yaw = DangerZone.player.rotation_yaw_head;
        if (DangerZone.player.getGameMode() != 2 && DangerZone.player.getGameMode() != 3 && DangerZone.player.getRiddenEntity() == null) {
            double rdd = Math.sqrt(DangerZone.player.motionx * DangerZone.player.motionx + DangerZone.player.motionz * DangerZone.player.motionz);
            if (DangerZone.player.isLadder()) {
                rdd = Math.abs(DangerZone.player.motiony * 2.0f);
            }
            this.traveled += rdd;
            if (DangerZone.player.isBaby()) {
                this.traveled += rdd;
                rdd /= 2.0;
            }
            rdd /= 18.0;
            if ((rdd *= ((double)0.35f - rdd) * 2.0) < 0.0) {
                rdd = 0.0;
            }
            if (DangerZone.gofast != 0) {
                this.bounce = (float)(rdd * Math.cos(Math.toRadians(this.traveled * 11.3)));
            } else {
                this.bounce = (float)(rdd * Math.cos(Math.toRadians(this.traveled * 13.3)));
                this.bounce = (float)((double)this.bounce * 2.5);
            }
            if (!DangerZone.player.getOnGround() && !DangerZone.player.isLadder()) {
                this.bounce = 0.0f;
            }
        } else {
            this.bounce = 0.0f;
        }
        if (this.bounce != 0.0f && (this.lastbounce > 0.0f && this.bounce < 0.0f || this.lastbounce < 0.0f && this.bounce > 0.0f)) {
            DangerZone.world.playSound(Blocks.getStepSound(DangerZone.world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy - (double)0.1f), (int)DangerZone.player.posz)), DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f + (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.2f);
        }
        this.lastbounce = this.bounce;
        DangerZone.player.posx += Math.cos(Math.toRadians(DangerZone.player.rotation_yaw)) * (double)this.bounce / 12.0;
        DangerZone.player.posz += Math.sin(Math.toRadians(DangerZone.player.rotation_yaw)) * (double)this.bounce / 12.0;
        if (this.bounce < 0.0f) {
            this.bounce = -this.bounce;
        }
        DangerZone.player.rotation_pitch_head %= 360.0f;
        DangerZone.player.rotation_yaw_head %= 360.0f;
        DangerZone.player.rotation_roll_head %= 360.0f;
        this.find_focus(world);
    }

    private void lookAtSelf(World world) {
        float t;
        float ddst;
        Entity e;
        float dst;
        this.f5pitch = 0.0f;
        this.f5yaw = 0.0f;
        this.f5z = 0.0f;
        this.f5y = 0.0f;
        this.f5x = 0.0f;
        if (DangerZone.f5_front) {
            dst = this.ViewFromEntity.getHeight() * 3.25f;
            if (dst < 6.0f) {
                dst = 6.0f;
            }
            if ((e = this.ViewFromEntity.getRiddenEntity()) != null && dst < (ddst = e.getHeight() * 3.25f)) {
                dst = ddst;
            }
            t = (float)Math.cos(Math.toRadians(this.ViewFromEntity.rotation_pitch_head));
            this.f5y = (float)Math.sin(Math.toRadians(this.ViewFromEntity.rotation_pitch_head)) * dst * (float)this.blockrenderwidth;
            this.f5x = (float)Math.cos(Math.toRadians(this.Viewer_yaw + 90.0f)) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5z = (float)Math.sin(Math.toRadians(this.Viewer_yaw + 90.0f)) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5yaw = 180.0f;
            this.f5pitch = -this.ViewFromEntity.rotation_pitch_head * 2.0f;
        }
        if (DangerZone.f5_back) {
            dst = this.ViewFromEntity.getHeight() * 4.25f;
            if (dst < 8.0f) {
                dst = 8.0f;
            }
            if ((e = this.ViewFromEntity.getRiddenEntity()) != null && dst < (ddst = e.getHeight() * 4.25f)) {
                dst = ddst;
            }
            t = (float)Math.cos(Math.toRadians(this.ViewFromEntity.rotation_pitch_head));
            this.f5y = -((float)Math.sin(Math.toRadians(this.ViewFromEntity.rotation_pitch_head))) * dst * (float)this.blockrenderwidth;
            this.f5x = -((float)Math.cos(Math.toRadians(this.Viewer_yaw + 90.0f))) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5z = -((float)Math.sin(Math.toRadians(this.Viewer_yaw + 90.0f))) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5yaw = 0.0f;
            this.f5pitch = 0.0f;
        }
        if (DangerZone.f5_front || DangerZone.f5_back) {
            this.Scalef5toSolid();
        }
    }

    private void doClickyStuff(World world) {
        InventoryContainer ic;
        int i;
        if (this.ViewFromEntity != DangerZone.player) {
            return;
        }
        if (this.hit_cycle_count != 0) {
            i = this.fps / 10;
            if (i < 1) {
                i = 1;
            }
            if (i > 6) {
                i = 6;
            }
            this.hit_cycles = i + 1;
            this.hit_cycle_count += this.hit_cycle_dir;
            if (this.hit_cycle_count >= this.hit_cycles) {
                if (DangerZone.doleftclick) {
                    DangerZone.player.leftclick(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.magic_power, DangerZone.magic_type, poi_x, poi_y, poi_z);
                    DangerZone.doleftclick = false;
                    DangerZone.magic_power = 0.0f;
                }
                if (DangerZone.dorightclick) {
                    DangerZone.player.rightclick(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, poi_x, poi_y, poi_z);
                    DangerZone.dorightclick = false;
                    DangerZone.magic_power = 0.0f;
                }
                this.hit_cycle_dir = -1;
            }
        } else if (DangerZone.do_hit_cycle != 0) {
            this.hit_cycle_count = 1;
            this.hit_cycle_dir = 1;
            this.usex = focus_x;
            this.usey = focus_y;
            this.usez = focus_z;
            this.uses = focus_side;
            this.usee = focus_entity;
            if (DangerZone.doleftclick) {
                int which = DangerZone.player.world.rand.nextInt(6);
                if (which == 0) {
                    DangerZone.player.world.playSound("DangerZone:swish3", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy + 1.25, DangerZone.player.posz, 0.25f, 1.0f);
                }
                if (which == 1) {
                    DangerZone.player.world.playSound("DangerZone:swish4", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy + 1.25, DangerZone.player.posz, 0.25f, 1.0f);
                }
                if (which == 2) {
                    DangerZone.player.world.playSound("DangerZone:swish5", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy + 1.25, DangerZone.player.posz, 0.25f, 1.0f);
                }
                if (which == 3) {
                    DangerZone.player.world.playSound("DangerZone:swish6", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy + 1.25, DangerZone.player.posz, 0.25f, 1.0f);
                }
                if (which == 4) {
                    DangerZone.player.world.playSound("DangerZone:swish7", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy + 1.25, DangerZone.player.posz, 0.25f, 1.0f);
                }
                if (which == 5) {
                    DangerZone.player.world.playSound("DangerZone:swish8", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy + 1.25, DangerZone.player.posz, 0.25f, 1.0f);
                }
            }
        }
        if (this.eat_cycle_count != 0) {
            i = this.fps / 2;
            if (i < 1) {
                i = 1;
            }
            if (i > 30) {
                i = 30;
            }
            this.eat_cycles = i + 1;
            this.eat_cycle_count += this.eat_cycle_dir;
            if (this.eat_cycle_count >= this.eat_cycles) {
                InventoryContainer ic2 = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
                this.eat_cycle_count = this.eat_cycles;
                if (this.eat_delay_count > 0) {
                    if (this.eat_sound) {
                        world.playSound("DangerZone:eating", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);
                    }
                    this.eat_sound = false;
                    --this.eat_delay_count;
                } else {
                    Item itm;
                    if (ic2 != null && Items.isFood(ic2.iid) && (DangerZone.player.getHunger() < DangerZone.player.getMaxHunger() || Items.eatAnyTime(ic2.iid)) && (itm = ic2.getItem()) != null) {
                        itm.onFoodEaten(DangerZone.player);
                        DangerZone.server_connection.playerActionToServer(0, 2, itm.itemID, 0, 0, 0, 0, 0.0f, 0);
                        if (ic2 != null && Items.isFood(ic2.iid)) {
                            Utils.spawnParticlesScaled(DangerZone.player.world, "DangerZone:ParticleItem", 10, DangerZone.player.dimension, DangerZone.player.posx + (double)((float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 0.25f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head))), DangerZone.player.posy + (double)(DangerZone.player.height * 9.25f / 10.0f) - (double)((float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 0.25f), DangerZone.player.posz + (double)((float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 0.25f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head))), ic2.iid, 0.25f, true);
                        }
                    }
                    this.eat_cycle_dir = -1;
                }
            }
        } else if (DangerZone.do_food_cycle != 0 && (ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex())) != null && Items.isFood(ic.iid) && (DangerZone.player.getHunger() < DangerZone.player.getMaxHunger() || Items.eatAnyTime(ic.iid))) {
            this.eat_cycle_count = 1;
            this.eat_cycle_dir = 1;
            this.eat_delay_count = this.fps + 10;
            this.eat_sound = true;
        }
        if (DangerZone.dorightclickup) {
            DangerZone.player.rightclickup(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.rightbuttondowncounter * 100 / this.fps);
            DangerZone.dorightclickup = false;
            DangerZone.rightbuttondowncounter = 0;
        }
        if (DangerZone.singleshot) {
            DangerZone.player.singleshot(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.rightbuttondowncounter * 100 / this.fps);
            DangerZone.singleshot = false;
        }
        if (DangerZone.semiauto) {
            DangerZone.player.semiauto(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.rightbuttondowncounter * 100 / this.fps);
            DangerZone.semiauto = false;
        }
        if (DangerZone.fullauto) {
            DangerZone.player.fullauto(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID, DangerZone.rightbuttondowncounter * 100 / this.fps);
            DangerZone.fullauto = false;
        }
        DangerZone.player.setRightButtonDownCount(DangerZone.rightbuttondowncounter * 100 / this.fps);
    }

    private void drawPlayerHeldItem(World world) {
        if (this.ViewFromEntity != DangerZone.player) {
            return;
        }
        if (DangerZone.player.getHotbar(DangerZone.player.gethotbarindex()) != null && !DangerZone.f5_front && !DangerZone.f5_back) {
            Block bl;
            InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
            if (ic.bid != 0 && ((bl = Blocks.BlockArray[ic.bid]) instanceof BlockFlower || bl instanceof BlockLeaves) && this.hit_cycle_count >= this.hit_cycles) {
                Utils.spawnParticlesScaled(DangerZone.player.world, "DangerZone:ParticleDust", 4, DangerZone.player.dimension, DangerZone.player.posx + (double)((float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 2.0f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head))), DangerZone.player.posy + (double)(DangerZone.player.height * 9.5f / 10.0f) - (double)((float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 2.0f), DangerZone.player.posz + (double)((float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 2.0f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head))), 0, 0.125f, false);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef(6.0f, -(4.0f + this.bounce * 2.0f), -540.0f / (float)DangerZone.fieldOfView);
            GL11.glRotatef(-15.0f, 1.0f, 3.0f, 0.0f);
            WorldRenderer.recalcBrightness(DangerZone.player.dimension, (int)(DangerZone.player.posy + (double)(DangerZone.player.getHeight() / 2.0f)));
            this.setBrightness(WorldRendererUtils.getLightMapValue(world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy + (double)(DangerZone.player.getHeight() / 2.0f)), (int)DangerZone.player.posz));
            if (ic.bid != 0) {
                if (this.hit_cycle_count != 0) {
                    GL11.glTranslatef(this.hitx * ((float)this.hit_cycle_count / (float)this.hit_cycles) / 2.0f, this.hity * ((float)this.hit_cycle_count / (float)this.hit_cycles) / 2.0f, this.hitz * ((float)this.hit_cycle_count / (float)this.hit_cycles) / 2.0f);
                    GL11.glRotatef(-this.hitp * ((float)this.hit_cycle_count / (float)this.hit_cycles), 1.0f, 0.0f, 0.0f);
                    GL11.glRotatef(this.hitw * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 1.0f, 0.0f);
                    GL11.glRotatef(-this.hitr * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 0.0f, 1.0f);
                }
                GL11.glScalef(0.2f, 0.2f, 0.2f);
                if (Blocks.hasOwnRenderer(ic.bid)) {
                    Blocks.renderMeHeld(DangerZone.wr, DangerZone.player, ic.bid, false);
                } else {
                    this.drawTexturedCube(255, Blocks.isSolidForRender(ic.bid), ic.bid, 0, false);
                }
            } else if (ic.iid != 0) {
                GL11.glScalef(0.35f, 0.35f, 0.35f);
                GL11.glEnable(3042);
                GL11.glBlendFunc(770, 771);
                if (Items.isFlipped(ic.iid)) {
                    if (Items.getfullholdcount(ic.iid) != 0.0f && (DangerZone.rightbuttondowncounter != 0 || DangerZone.rapidfire_delay != 0)) {
                        GL11.glTranslatef(-10.8f, 8.7f, 7.9f);
                        GL11.glRotatef(-174.2f, 1.0f, 0.0f, 0.0f);
                        GL11.glRotatef(65.3f + this.bounce * 4.0f, 0.0f, 1.0f, 0.0f);
                        GL11.glRotatef(-39.2f + this.bounce * 4.0f, 0.0f, 0.0f, 1.0f);
                    } else if (this.hit_cycle_count != 0) {
                        GL11.glTranslatef(1.0f + this.hitx * ((float)this.hit_cycle_count / (float)this.hit_cycles), 3.0f + this.hity * ((float)this.hit_cycle_count / (float)this.hit_cycles), 3.0f + this.hitz * ((float)this.hit_cycle_count / (float)this.hit_cycles));
                        GL11.glRotatef(-91.0f + this.hitp * ((float)this.hit_cycle_count / (float)this.hit_cycles), 1.0f, 0.0f, 0.0f);
                        GL11.glRotatef(102.0f + this.bounce * 4.0f + this.hitw * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 1.0f, 0.0f);
                        GL11.glRotatef(-124.0f + this.bounce * 4.0f + this.hitr * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 0.0f, 1.0f);
                    } else if (this.eat_cycle_count != 0) {
                        this.eatbounce = this.bounce;
                        if (this.eat_cycle_count >= this.eat_cycles && this.eat_delay_count > 0) {
                            this.eatbounce = (float)Math.cos(Math.toRadians((float)DangerZone.player.lifetimeticker * 25.3f));
                        }
                        GL11.glTranslatef(1.0f + this.eatx * ((float)this.eat_cycle_count / (float)this.eat_cycles), 3.0f + this.eaty * ((float)this.eat_cycle_count / (float)this.eat_cycles), 3.0f + this.eatz * ((float)this.eat_cycle_count / (float)this.eat_cycles));
                        GL11.glRotatef(-91.0f + this.eatp * ((float)this.eat_cycle_count / (float)this.eat_cycles), 1.0f, 0.0f, 0.0f);
                        GL11.glRotatef(102.0f + this.eatbounce * 4.0f + this.eatw * ((float)this.eat_cycle_count / (float)this.eat_cycles), 0.0f, 1.0f, 0.0f);
                        GL11.glRotatef(-124.0f + this.eatbounce * 4.0f + this.eatr * ((float)this.eat_cycle_count / (float)this.eat_cycles), 0.0f, 0.0f, 1.0f);
                    } else {
                        GL11.glTranslatef(1.0f, 3.0f, 3.0f);
                        GL11.glRotatef(-91.0f, 1.0f, 0.0f, 0.0f);
                        GL11.glRotatef(102.0f + this.bounce * 4.0f, 0.0f, 1.0f, 0.0f);
                        GL11.glRotatef(-124.0f + this.bounce * 4.0f, 0.0f, 0.0f, 1.0f);
                    }
                } else if (Items.getfullholdcount(ic.iid) != 0.0f && (DangerZone.rightbuttondowncounter != 0 || DangerZone.rapidfire_delay != 0)) {
                    GL11.glTranslatef(-7.7f, 8.3f, 5.4f);
                    GL11.glRotatef(-6.3f, 1.0f, 0.0f, 0.0f);
                    GL11.glRotatef(-60.1f + this.bounce * 4.0f, 0.0f, 1.0f, 0.0f);
                    GL11.glRotatef(120.5f + this.bounce * 4.0f, 0.0f, 0.0f, 1.0f);
                } else if (this.hit_cycle_count != 0) {
                    GL11.glTranslatef(1.2f + this.hitxn * ((float)this.hit_cycle_count / (float)this.hit_cycles), 4.0f + this.hityn * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.1f + this.hitzn * ((float)this.hit_cycle_count / (float)this.hit_cycles));
                    GL11.glRotatef(-30.0f + this.hitpn * ((float)this.hit_cycle_count / (float)this.hit_cycles), 1.0f, 0.0f, 0.0f);
                    GL11.glRotatef(-67.7f + this.bounce * 4.0f + this.hitwn * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 1.0f, 0.0f);
                    GL11.glRotatef(120.5f + this.bounce * 4.0f + this.hitrn * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 0.0f, 1.0f);
                } else if (this.eat_cycle_count != 0) {
                    this.eatbounce = this.bounce;
                    if (this.eat_cycle_count >= this.eat_cycles && this.eat_delay_count > 0) {
                        this.eatbounce = (float)Math.cos(Math.toRadians((float)DangerZone.player.lifetimeticker * 25.3f));
                    }
                    GL11.glTranslatef(1.2f + this.eatxn * ((float)this.eat_cycle_count / (float)this.eat_cycles), 4.0f + this.eatyn * ((float)this.eat_cycle_count / (float)this.eat_cycles), 0.1f + this.eatzn * ((float)this.eat_cycle_count / (float)this.eat_cycles));
                    GL11.glRotatef(-30.0f + this.eatpn * ((float)this.eat_cycle_count / (float)this.eat_cycles), 1.0f, 0.0f, 0.0f);
                    GL11.glRotatef(-67.7f + this.eatbounce * 4.0f + this.eatwn * ((float)this.eat_cycle_count / (float)this.eat_cycles), 0.0f, 1.0f, 0.0f);
                    GL11.glRotatef(120.5f + this.eatbounce * 4.0f + this.eatrn * ((float)this.eat_cycle_count / (float)this.eat_cycles), 0.0f, 0.0f, 1.0f);
                } else {
                    GL11.glTranslatef(1.2f, 4.0f, 0.1f);
                    if (Items.isFlopped(ic.iid)) {
                        GL11.glRotatef(-6.0f, 1.0f, 0.0f, 0.0f);
                    } else {
                        GL11.glRotatef(-30.0f, 1.0f, 0.0f, 0.0f);
                    }
                    GL11.glRotatef(-67.7f + this.bounce * 4.0f, 0.0f, 1.0f, 0.0f);
                    GL11.glRotatef(120.5f + this.bounce * 4.0f, 0.0f, 0.0f, 1.0f);
                }
                this.forceloadtexture(Items.getTexture(ic.iid));
                Items.renderMeHeld(this, DangerZone.player, ic, true);
                GL11.glDisable(3042);
            }
            GL11.glPopMatrix();
        }
    }

    public void renderWorld(World world) {
        float velocity;
        int pbid;
        double rdd;
        double rhdir;
        double rr;
        double pi = 3.1415926545;
        int torender = 6;
        double dist = 0.0;
        this.doHouseKeeping(world);
        this.calcBounceAndFocus(world);
        this.lookAtSelf(world);
        this.recalcSkyBrightness();
        if (DangerZone.f12_on && DangerZone.current_gui == null) {
            this.sky_blue = 0.5f;
            this.sky_green = 0.5f;
            this.sky_red = 0.5f;
        }
        if (DangerZone.fog_enable) {
            this.wrfogColor.position(0);
            this.wrfogColor.put(this.sky_red);
            this.wrfogColor.put(this.sky_green);
            this.wrfogColor.put(this.sky_blue);
            this.wrfogColor.put(1.0f);
            this.wrfogColor.position(0);
            GL11.glFog(2918, this.wrfogColor);
        }
        GL11.glClearColor(this.sky_red, this.sky_green, this.sky_blue, 0.0f);
        GL11.glClear(16640);
        GL11.glLoadIdentity();
        GL11.glTexParameteri(3553, 10241, 9728);
        GL11.glTexParameteri(3553, 10240, 9728);
        GL14.glSecondaryColor3f(0.0f, 0.0f, 0.0f);
        GL11.glEnable(33880);
        WorldRenderer.recalcBrightness(this.ViewFromEntity.dimension, 60);
        this.setBrightness();
        last_texture = -1;
        if (DangerZone.f12_on && DangerZone.current_gui == null) {
            GL11.glPushMatrix();
            GL11.glTranslated(0.0, -(DangerZone.player.posy * (double)this.blockrenderwidth), 0.0);
            this.sky_blue = 0.15f;
            this.sky_green = 0.15f;
            this.sky_red = 0.15f;
            WorldRendererUtils.drawShowcaseMonster();
            GL11.glPopMatrix();
            GL11.glFlush();
            return;
        }
        GL11.glPushMatrix();
        GL11.glRotatef(this.ViewFromEntity.rotation_pitch_head + this.f5pitch, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.Viewer_yaw + this.f5yaw, 0.0f, 1.0f, 0.0f);
        GL11.glTranslated(-(this.ViewFromEntity.posx * (double)this.blockrenderwidth % (double)(16 * this.blockrenderwidth)) + (double)(this.blockrenderwidth / 2) + (double)this.f5x, -((this.ViewFromEntity.posy + (double)this.ViewFromEntity.eyeheight + (double)this.bounce - 0.5) * (double)this.blockrenderwidth) + (double)this.f5y, -(this.ViewFromEntity.posz * (double)this.blockrenderwidth % (double)(16 * this.blockrenderwidth)) + (double)(this.blockrenderwidth / 2) + (double)this.f5z);
        torender = this.ViewFromEntity.rotation_pitch_head < 45.0f || this.ViewFromEntity.rotation_pitch_head > 315.0f ? DangerZone.renderdistance : DangerZone.renderdistance - 2;
        if (torender < 3) {
            torender = 3;
        }
        do_draw_focus = false;
        WorldRendererUtils.drawSunAndMoon(world, this.normal_sun);
        int i = -torender;
        while (i <= torender) {
            int j = -torender;
            while (j <= torender) {
                if (Math.sqrt(i * i + j * j) <= (double)torender) {
                    dist = (float)Math.sqrt(i * i + j * j);
                    rr = (float)Math.atan2(j * 16, i * 16);
                    rdd = Math.abs(rr - (rhdir = Math.toRadians((this.Viewer_yaw + this.f5yaw - 90.0f) % 360.0f))) % (pi * 2.0);
                    if (rdd > pi) {
                        rdd -= pi * 2.0;
                    }
                    rdd = Math.abs(rdd);
                    if (!((this.ViewFromEntity.rotation_pitch_head < 45.0f || this.ViewFromEntity.rotation_pitch_head > 315.0f) && (dist > 8.0 && rdd > pi / 3.0 * (double)DangerZone.fieldOfView / 45.0 || dist > 4.0 && rdd > pi / 2.0 * (double)DangerZone.fieldOfView / 45.0 || dist > 1.0 && rdd > pi * 3.0 / 4.0 * (double)DangerZone.fieldOfView / 45.0 && !DangerZone.f5_front && !DangerZone.f5_back))) {
                        this.renderChunk(world, i, j, this.ViewFromEntity.posx, this.ViewFromEntity.posy, this.ViewFromEntity.posz);
                    }
                }
                ++j;
            }
            ++i;
        }
        GL11.glPopMatrix();
        GL11.glFlush();
        if (focus_x != 0 && focus_z != 0 && ((pbid = world.getblock(this.ViewFromEntity.dimension, (int)this.ViewFromEntity.posx, (int)(this.ViewFromEntity.posy + (double)this.ViewFromEntity.eyeheight), (int)this.ViewFromEntity.posz)) == 0 || !Blocks.isSolid(pbid) || Blocks.isLiquid(pbid))) {
            GL11.glPushMatrix();
            GL11.glRotatef(this.ViewFromEntity.rotation_pitch_head + this.f5pitch, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(this.Viewer_yaw + this.f5yaw, 0.0f, 1.0f, 0.0f);
            GL11.glTranslated(-((this.ViewFromEntity.posx - ((double)focus_x + 0.5)) * (double)this.blockrenderwidth) + (double)this.f5x, -((this.ViewFromEntity.posy + (double)this.ViewFromEntity.eyeheight + (double)this.bounce - ((double)focus_y + 0.5)) * (double)this.blockrenderwidth) + (double)this.f5y, -((this.ViewFromEntity.posz - ((double)focus_z + 0.5)) * (double)this.blockrenderwidth) + (double)this.f5z);
            if (focus_damage != 0.0f && focus_maxdamage > 0.0f) {
                GL11.glScalef(1.0f - 0.65f * focus_damage / focus_maxdamage, 1.0f - 0.65f * focus_damage / focus_maxdamage, 1.0f - 0.65f * focus_damage / focus_maxdamage);
                GL11.glRotatef((float)((double)(15.0f * focus_damage / focus_maxdamage) * Math.cos(Math.toRadians(this.ViewFromEntity.lifetimeticker * 3L))), 1.0f, 0.0f, 0.0f);
                GL11.glRotatef((float)((double)(15.0f * focus_damage / focus_maxdamage) * Math.cos(Math.toRadians(this.ViewFromEntity.lifetimeticker * 7L))), 0.0f, 1.0f, 0.0f);
                GL11.glRotatef((float)((double)(15.0f * focus_damage / focus_maxdamage) * Math.cos(Math.toRadians(this.ViewFromEntity.lifetimeticker * 5L))), 0.0f, 0.0f, 1.0f);
            } else {
                GL11.glScalef(1.001f, 1.001f, 1.001f);
            }
            this.setBrightnessFocusBlock();
            if (Blocks.hasOwnRenderer(focus_bid)) {
                Blocks.renderMe(this, world, this.ViewFromEntity.dimension, focus_x, focus_y, focus_z, focus_bid, focus_meta, 255, true);
            } else {
                this.drawTexturedCube(255, Blocks.isSolidForRender(focus_bid), focus_bid, focus_meta, true);
            }
            this.setBrightness();
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glRotatef(this.ViewFromEntity.rotation_pitch_head + this.f5pitch, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.Viewer_yaw + this.f5yaw, 0.0f, 1.0f, 0.0f);
        int inext = 0;
        boolean doforce = false;
        ModelBase modl = null;
        Entity morphent = null;
        String petname = null;
        inext = 0;
        while (inext < DangerZone.max_entities) {
            this.ent = DangerZone.entityManager.entities[inext];
            if (this.ent != null && this.ent.dimension == this.ViewFromEntity.dimension && (this.ent.entityID != this.ViewFromEntity.entityID || this.ViewFromEntity.always_draw) && (dist = this.ViewFromEntity.getDistanceFromEntity(this.ent)) <= (double)this.ent.maxrenderdist && dist <= (double)(torender * 16)) {
                rr = (float)Math.atan2(this.ent.display_posz - this.ViewFromEntity.posz, this.ent.display_posx - this.ViewFromEntity.posx);
                rdd = Math.abs(rr - (rhdir = Math.toRadians((this.Viewer_yaw + this.f5yaw - 90.0f) % 360.0f))) % (pi * 2.0);
                if (rdd > pi) {
                    rdd -= pi * 2.0;
                }
                rdd = Math.abs(rdd);
                if ((this.ent.always_draw || !(this.ViewFromEntity.rotation_pitch_head < 45.0f) && !(this.ViewFromEntity.rotation_pitch_head > 315.0f) || !(dist > 16.0) || !(rdd > pi / 2.0 * (double)DangerZone.fieldOfView / 45.0) || DangerZone.f5_front || DangerZone.f5_back) && !this.ent.isInvisible() && this.ent.model != null) {
                    modl = this.ent.model;
                    morphent = null;
                    if (this.ent instanceof Player) {
                        Player pp = (Player)this.ent;
                        modl = pp.model;
                        morphent = pp.morph;
                    }
                    petname = this.ent.getPetName();
                    GL11.glPushMatrix();
                    GL11.glTranslated(-((this.ViewFromEntity.posx - this.ent.display_posx) * (double)this.blockrenderwidth) + (double)this.f5x, -((this.ViewFromEntity.posy + (double)this.ViewFromEntity.eyeheight + (double)this.bounce - this.ent.display_posy) * (double)this.blockrenderwidth) + (double)this.f5y, -((this.ViewFromEntity.posz - this.ent.display_posz) * (double)this.blockrenderwidth) + (double)this.f5z);
                    if (this.ent.display_rotation_roll != 0.0f) {
                        GL11.glRotatef(this.ent.display_rotation_roll, 0.0f, 0.0f, 1.0f);
                    }
                    if (this.ent.display_rotation_yaw != 0.0f) {
                        GL11.glRotatef(this.ent.display_rotation_yaw, 0.0f, 1.0f, 0.0f);
                    }
                    if (this.ent.display_rotation_pitch != 0.0f) {
                        GL11.glRotatef(this.ent.display_rotation_pitch, 1.0f, 0.0f, 0.0f);
                    }
                    WorldRenderer.recalcBrightness(this.ViewFromEntity.dimension, (int)(this.ent.display_posy + (double)(this.ent.getHeight() / 2.0f)));
                    this.setBrightness(this.ent.getBrightness() + WorldRendererUtils.getLightMapValue(this.ent.world, this.ent.dimension, (int)this.ent.display_posx, (int)(this.ent.display_posy + (double)(this.ent.getHeight() / 2.0f)), (int)this.ent.display_posz));
                    this.ouch = 1.0f;
                    this.washurt = this.ent.isHurt();
                    if (this.washurt) {
                        this.ouch = 1.1f;
                        GL11.glColor3f(1.0f, 0.15f, 0.15f);
                    }
                    if (this.ent.getDeathFactor() > 0.0f) {
                        this.ouch = this.ent.getDeathFactor();
                    }
                    velocity = (float)Math.sqrt(this.ent.motionx * this.ent.motionx + this.ent.motiony * this.ent.motiony + this.ent.motionz * this.ent.motionz);
                    this.cdir = (float)Math.toRadians(this.ent.display_rotation_pitch);
                    this.tdir = (float)Math.toRadians(this.ent.rotation_pitch_head);
                    this.pdiff = this.tdir - this.cdir;
                    while ((double)this.pdiff > Math.PI) {
                        this.pdiff = (float)((double)this.pdiff - Math.PI * 2);
                    }
                    while ((double)this.pdiff < -Math.PI) {
                        this.pdiff = (float)((double)this.pdiff + Math.PI * 2);
                    }
                    this.pdiff = (float)Math.toDegrees(this.pdiff);
                    this.cdir = (float)Math.toRadians(this.ent.display_rotation_yaw);
                    this.tdir = (float)Math.toRadians(this.ent.rotation_yaw_head);
                    this.ydiff = this.tdir - this.cdir;
                    while ((double)this.ydiff > Math.PI) {
                        this.ydiff = (float)((double)this.ydiff - Math.PI * 2);
                    }
                    while ((double)this.ydiff < -Math.PI) {
                        this.ydiff = (float)((double)this.ydiff + Math.PI * 2);
                    }
                    this.ydiff = (float)Math.toDegrees(this.ydiff);
                    this.cdir = (float)Math.toRadians(this.ent.display_rotation_roll);
                    this.tdir = (float)Math.toRadians(this.ent.rotation_roll_head);
                    this.rdiff = this.tdir - this.cdir;
                    while ((double)this.rdiff > Math.PI) {
                        this.rdiff = (float)((double)this.rdiff - Math.PI * 2);
                    }
                    while ((double)this.rdiff < -Math.PI) {
                        this.rdiff = (float)((double)this.rdiff + Math.PI * 2);
                    }
                    this.rdiff = (float)Math.toDegrees(this.rdiff);
                    GL11.glPushMatrix();
                    if (morphent != null) {
                        if (doforce) {
                            this.forceloadtexture(modl.getTexture(morphent));
                            doforce = false;
                        } else {
                            this.loadtexture(modl.getTexture(morphent));
                        }
                        modl.doScale(morphent);
                        modl.render(morphent, this.ent.lifetimeticker, velocity, this.pdiff, this.ydiff, this.rdiff, this.ouch);
                    } else {
                        if (doforce) {
                            this.forceloadtexture(modl.getTexture(this.ent));
                            doforce = false;
                        } else {
                            this.loadtexture(modl.getTexture(this.ent));
                        }
                        modl.doScale(this.ent);
                        modl.render(this.ent, this.ent.lifetimeticker, velocity, this.pdiff, this.ydiff, this.rdiff, this.ouch);
                    }
                    GL11.glPopMatrix();
                    if (this.ent.display_rotation_pitch != 0.0f) {
                        GL11.glRotatef(-this.ent.display_rotation_pitch, 1.0f, 0.0f, 0.0f);
                    }
                    if (this.ent.display_rotation_yaw != 0.0f) {
                        GL11.glRotatef(-this.ent.display_rotation_yaw, 0.0f, 1.0f, 0.0f);
                    }
                    if (this.ent.display_rotation_roll != 0.0f) {
                        GL11.glRotatef(-this.ent.display_rotation_roll, 0.0f, 0.0f, 1.0f);
                    }
                    GL11.glRotatef(-(this.Viewer_yaw + this.f5yaw), 0.0f, 1.0f, 0.0f);
                    if (petname != null) {
                        doforce = true;
                        if (this.ent.isBaby()) {
                            GL11.glScalef(0.25f, 0.25f, 0.25f);
                        }
                        GL11.glScalef(0.15f, 0.15f, 0.15f);
                        WorldRendererUtils.textAt(this.font, -(this.font.getWidth(petname) / 2), this.ent.getNameHeight() * 125.0f + 30.0f, petname);
                        GL11.glScalef(6.6666665f, 6.6666665f, 6.6666665f);
                        if (this.ent.isBaby()) {
                            GL11.glScalef(4.0f, 4.0f, 4.0f);
                        }
                    }
                    if (this.ent.getOnFire() > 0) {
                        GL11.glPushMatrix();
                        WorldRendererUtils.drawEntityOnFire(this.ent);
                        GL11.glPopMatrix();
                    }
                    if (this.washurt && DangerZone.showhitbox) {
                        if (this.ent.isBaby()) {
                            GL11.glScalef(0.25f, 0.25f, 0.25f);
                        }
                        GL11.glTranslated(0.0, this.ent.getHeight() * 8.0f, 0.0);
                        GL11.glScalef(this.ent.getWidth(), this.ent.getHeight(), this.ent.getWidth());
                        GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.25f);
                        this.forceloadtexture(Blocks.BlockArray[Blocks.hitbox.blockID].getTexture(0));
                        this.drawTexturedCube(255, false, Blocks.hitbox.blockID, 0, false);
                        GL11.glScalef(1.0f / this.ent.getWidth(), 1.0f / this.ent.getHeight(), 1.0f / this.ent.getWidth());
                        GL11.glTranslated(0.0, -this.ent.getHeight() * 8.0f, 0.0);
                        if (this.ent.isBaby()) {
                            GL11.glScalef(4.0f, 4.0f, 4.0f);
                        }
                    }
                    if (this.washurt) {
                        this.setBrightness();
                    }
                    GL11.glPopMatrix();
                }
            }
            ++inext;
        }
        petname = null;
        inext = 0;
        DangerZone.particleManager.particle_list_lock.lock();
        int npart = DangerZone.particleManager.particle_list.size();
        while (inext < npart) {
            Particle pst = DangerZone.particleManager.particle_list.get(inext);
            dist = pst.getDistanceFromEntity(this.ViewFromEntity);
            if (dist <= (double)pst.maxrenderdist && dist <= (double)(torender * 16)) {
                rr = (float)Math.atan2(pst.posz - this.ViewFromEntity.posz, pst.posx - this.ViewFromEntity.posx);
                rdd = Math.abs(rr - (rhdir = Math.toRadians((this.Viewer_yaw + this.f5yaw - 90.0f) % 360.0f))) % (pi * 2.0);
                if (rdd > pi) {
                    rdd -= pi * 2.0;
                }
                rdd = Math.abs(rdd);
                if ((this.ViewFromEntity.rotation_pitch_head < 45.0f || this.ViewFromEntity.rotation_pitch_head > 315.0f) && dist > 4.0 && rdd > pi / 2.0 * (double)DangerZone.fieldOfView / 45.0 && !DangerZone.f5_front && !DangerZone.f5_back) {
                    ++inext;
                    continue;
                }
                if (pst.model != null) {
                    GL11.glPushMatrix();
                    GL11.glTranslated(-((this.ViewFromEntity.posx - pst.posx) * (double)this.blockrenderwidth) + (double)this.f5x, -((this.ViewFromEntity.posy + (double)this.ViewFromEntity.eyeheight + (double)this.bounce - pst.posy) * (double)this.blockrenderwidth) + (double)this.f5y, -((this.ViewFromEntity.posz - pst.posz) * (double)this.blockrenderwidth) + (double)this.f5z);
                    GL11.glRotatef(pst.rotation_roll, 0.0f, 0.0f, 1.0f);
                    GL11.glRotatef(pst.rotation_yaw, 0.0f, 1.0f, 0.0f);
                    GL11.glRotatef(pst.rotation_pitch, 1.0f, 0.0f, 0.0f);
                    WorldRenderer.recalcBrightness(this.ViewFromEntity.dimension, (int)pst.posy);
                    this.setBrightness(pst.brightness + WorldRendererUtils.getLightMapValue(world, pst.dimension, (int)pst.posx, (int)pst.posy, (int)pst.posz));
                    GL11.glScalef(pst.renderscale, pst.renderscale, pst.renderscale);
                    if (doforce) {
                        this.forceloadtexture(pst.model.getTexture(pst));
                        doforce = false;
                    } else {
                        this.loadtexture(pst.model.getTexture(pst));
                    }
                    pst.model.renderParticle(pst);
                    GL11.glPopMatrix();
                }
            }
            ++inext;
        }
        DangerZone.particleManager.particle_list_lock.unlock();
        if ((DangerZone.f5_front || DangerZone.f5_back) && this.ViewFromEntity == DangerZone.player) {
            modl = this.ViewFromEntity.model;
            morphent = null;
            if (this.ViewFromEntity == DangerZone.player) {
                morphent = DangerZone.player.morph;
            }
            this.ent = this.ViewFromEntity;
            if (!this.ent.isInvisible()) {
                GL11.glPushMatrix();
                GL11.glTranslated(-((this.ViewFromEntity.posx - this.ent.posx) * (double)this.blockrenderwidth) + (double)this.f5x, -((this.ViewFromEntity.posy + (double)this.ViewFromEntity.eyeheight + (double)this.bounce - this.ent.posy) * (double)this.blockrenderwidth) + (double)this.f5y, -((this.ViewFromEntity.posz - this.ent.posz) * (double)this.blockrenderwidth) + (double)this.f5z);
                float fyw = 360.0f - (this.ent.rotation_yaw + 180.0f) % 360.0f;
                GL11.glRotatef(fyw, 0.0f, 1.0f, 0.0f);
                GL11.glRotatef(this.ent.rotation_pitch, 1.0f, 0.0f, 0.0f);
                WorldRenderer.recalcBrightness(this.ViewFromEntity.dimension, (int)(this.ViewFromEntity.posy + (double)(this.ViewFromEntity.getHeight() / 2.0f)));
                this.setBrightness(WorldRendererUtils.getLightMapValue(world, this.ViewFromEntity.dimension, (int)this.ViewFromEntity.posx, (int)(this.ViewFromEntity.posy + (double)(this.ent.getHeight() / 2.0f)), (int)this.ViewFromEntity.posz));
                GL11.glPushMatrix();
                if (morphent != null) {
                    this.loadtexture(modl.getTexture(morphent));
                    modl.doScale(morphent);
                } else {
                    this.loadtexture(modl.getTexture(this.ent));
                    modl.doScale(this.ent);
                }
                this.ouch = 1.0f;
                this.washurt = this.ent.isHurt();
                if (this.washurt) {
                    this.ouch = 1.1f;
                    GL11.glColor3f(1.0f, 0.15f, 0.15f);
                }
                if (this.ent.getDeathFactor() > 0.0f) {
                    this.ouch = this.ent.getDeathFactor();
                }
                velocity = (float)Math.sqrt(this.ent.motionx * this.ent.motionx + this.ent.motiony * this.ent.motiony + this.ent.motionz * this.ent.motionz);
                this.cdir = (float)Math.toRadians(this.ent.rotation_pitch);
                this.tdir = (float)Math.toRadians(this.ent.rotation_pitch_head);
                this.pdiff = this.tdir - this.cdir;
                while ((double)this.pdiff > Math.PI) {
                    this.pdiff = (float)((double)this.pdiff - Math.PI * 2);
                }
                while ((double)this.pdiff < -Math.PI) {
                    this.pdiff = (float)((double)this.pdiff + Math.PI * 2);
                }
                this.pdiff = (float)Math.toDegrees(this.pdiff);
                this.cdir = (float)Math.toRadians(this.ent.rotation_yaw);
                this.tdir = (float)Math.toRadians(this.ent.rotation_yaw_head);
                this.ydiff = this.tdir - this.cdir;
                while ((double)this.ydiff > Math.PI) {
                    this.ydiff = (float)((double)this.ydiff - Math.PI * 2);
                }
                while ((double)this.ydiff < -Math.PI) {
                    this.ydiff = (float)((double)this.ydiff + Math.PI * 2);
                }
                this.ydiff = (float)Math.toDegrees(this.ydiff);
                this.cdir = (float)Math.toRadians(this.ent.rotation_roll);
                this.tdir = (float)Math.toRadians(this.ent.rotation_roll_head);
                this.rdiff = this.tdir - this.cdir;
                while ((double)this.rdiff > Math.PI) {
                    this.rdiff = (float)((double)this.rdiff - Math.PI * 2);
                }
                while ((double)this.rdiff < -Math.PI) {
                    this.rdiff = (float)((double)this.rdiff + Math.PI * 2);
                }
                this.rdiff = (float)Math.toDegrees(this.rdiff);
                if (morphent != null) {
                    modl.render(morphent, this.ent.lifetimeticker, velocity, this.pdiff, -this.ydiff, this.rdiff, this.ouch);
                } else {
                    modl.render(this.ent, this.ent.lifetimeticker, velocity, this.pdiff, -this.ydiff, this.rdiff, this.ouch);
                }
                GL11.glPopMatrix();
                GL11.glRotatef(-this.ent.display_rotation_roll, 0.0f, 0.0f, 1.0f);
                GL11.glRotatef(-this.ent.display_rotation_pitch, 1.0f, 0.0f, 0.0f);
                if (this.ent.getPetName() != null) {
                    if (this.ent.isBaby()) {
                        GL11.glScalef(0.25f, 0.25f, 0.25f);
                    }
                    GL11.glScalef(0.15f, 0.15f, 0.15f);
                    WorldRendererUtils.textAt(this.font, -(5 * this.ent.getPetName().length()), this.ent.getNameHeight() * 125.0f + 30.0f, this.ent.getPetName());
                    GL11.glScalef(6.6666665f, 6.6666665f, 6.6666665f);
                    if (this.ent.isBaby()) {
                        GL11.glScalef(4.0f, 4.0f, 4.0f);
                    }
                }
                if (this.ent.getOnFire() > 0) {
                    WorldRendererUtils.drawEntityOnFire(this.ent);
                }
                if (this.washurt) {
                    this.setBrightness();
                }
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
        this.doClickyStuff(world);
        this.drawPlayerHeldItem(world);
        GL11.glPushMatrix();
        GL11.glRotatef(this.ViewFromEntity.rotation_pitch_head + this.f5pitch, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.Viewer_yaw + this.f5yaw, 0.0f, 1.0f, 0.0f);
        GL11.glTranslated(-(this.ViewFromEntity.posx * (double)this.blockrenderwidth % (double)(16 * this.blockrenderwidth)) + (double)(this.blockrenderwidth / 2) + (double)this.f5x, -((this.ViewFromEntity.posy + (double)this.ViewFromEntity.eyeheight + (double)this.bounce - 0.5) * (double)this.blockrenderwidth) + (double)this.f5y, -(this.ViewFromEntity.posz * (double)this.blockrenderwidth % (double)(16 * this.blockrenderwidth)) + (double)(this.blockrenderwidth / 2) + (double)this.f5z);
        if (!this.translucentVBOs.isEmpty()) {
            Iterator<VBOBuffer> iitr = this.translucentVBOs.iterator();
            VBOBuffer sstr = null;
            while (iitr.hasNext()) {
                sstr = iitr.next();
                GL11.glPushMatrix();
                GL11.glTranslatef(sstr.xoff, 0.0f, sstr.zoff);
                this.loadStitchedtexture(sstr.textureindex);
                sstr.lastusedframe = this.framecounter;
                sstr.draw();
                GL11.glPopMatrix();
            }
            this.translucentVBOs.clear();
        }
        GL11.glPopMatrix();
        WorldRenderer.recalcBrightness(DangerZone.player.dimension, 60);
        this.setBrightness();
        if (DangerZone.overlays_on && !DangerZone.f5_front && !DangerZone.f5_back) {
            GL11.glDisable(3553);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glLineWidth(1.0f);
            GL11.glBegin(3);
            GL11.glColor3f(0.65f, 0.65f, 0.65f);
            GL11.glVertex3f(-0.04f, 0.0f, -2.0f);
            GL11.glVertex3f(0.04f, 0.0f, -2.0f);
            GL11.glEnd();
            GL11.glBegin(3);
            GL11.glColor3f(0.65f, 0.65f, 0.65f);
            GL11.glVertex3f(0.0f, 0.04f, -2.0f);
            GL11.glVertex3f(0.0f, -0.04f, -2.0f);
            GL11.glEnd();
            GL11.glDisable(3042);
            GL11.glEnable(3553);
        }
        if (DangerZone.overlays_on) {
            this.doMenuThings(world);
        }
        GL11.glFlush();
    }

    private void doMenuThings(World world) {
        int i;
        if (this.ViewFromEntity != DangerZone.player) {
            return;
        }
        GL11.glDisable(2929);
        GL11.glMatrixMode(5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, DangerZone.screen_width, 0.0, DangerZone.screen_height, -320.0, 320.0);
        GL11.glMatrixMode(5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glEnable(3553);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        WorldRendererUtils.drawHotbar(world);
        WorldRendererUtils.drawHealth(world);
        WorldRendererUtils.drawHunger(world);
        WorldRendererUtils.drawMagic(world);
        WorldRendererUtils.drawAir(world);
        if (DangerZone.messagetimer > 0 && DangerZone.messagestring != null) {
            --DangerZone.messagetimer;
            WorldRendererUtils.drawRectangleWithTexture(DangerZone.textinputtexture, 30.0f, 120.0f, 600.0f, 30.0f);
            WorldRendererUtils.textAt(this.font, 50.0f, 150.0f, DangerZone.messagestring);
        }
        if (DangerZone.hotmessagetimer > 0 && DangerZone.hotmessagestring != null) {
            --DangerZone.hotmessagetimer;
            WorldRendererUtils.drawRectangleWithTexture(DangerZone.textinputtexture, DangerZone.screen_width / 2 - 5 * DangerZone.hotmessagestring.length() - 50, 85.0f, 13 * DangerZone.hotmessagestring.length() + 20, 30.0f);
            WorldRendererUtils.textAt(this.font, DangerZone.screen_width / 2 - 5 * DangerZone.hotmessagestring.length() - 30, 115.0f, DangerZone.hotmessagestring);
            InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
            if (DangerZone.current_gui == null && ic != null && ic.iid != 0 && ic.count == 1 && ic.getMaxStack() == 1 && ic.attributes != null) {
                int ayoff = 250;
                i = 1;
                while (i < 10) {
                    int val = ic.getAttribute(i);
                    if (val > 0) {
                        String outtext = "";
                        if (i == 1) {
                            outtext = "Accuracy:   ";
                        }
                        if (i == 2) {
                            outtext = "Damage:     ";
                        }
                        if (i == 3) {
                            outtext = "Durability: ";
                        }
                        if (i == 4) {
                            outtext = "Reach:      ";
                        }
                        if (i == 5) {
                            outtext = "Spam:       ";
                        }
                        outtext = String.valueOf(outtext) + String.format("%d", val);
                        WorldRendererUtils.textAt(this.font, 20.0f, ayoff, outtext);
                        ayoff -= 25;
                    }
                    ++i;
                }
            }
        } else if (DangerZone.current_gui == null) {
            String s = String.format("%d", DangerZone.player.getExperience());
            WorldRendererUtils.textAt(this.font, DangerZone.screen_width / 2 - 5 * s.length() - 30, 140.0f, s);
        }
        if (DangerZone.f3_on && DangerZone.current_gui == null) {
            int modepos = 10;
            String s = String.format("Version: %s", DangerZone.versionstring);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 10, s);
            s = String.format("FPS: %d at Render Distance: %d", this.fps, DangerZone.renderdistance);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 50, s);
            if (DangerZone.server != null && DangerZone.server_chunk_cache != null) {
                Dimension dd = Dimensions.DimensionArray[DangerZone.player.dimension];
                if (dd != null) {
                    Biome bb;
                    s = String.format("Dimension: %s", dd.getDisplayName());
                    WorldRendererUtils.textAt(this.font, DangerZone.screen_width / 2, DangerZone.screen_height - 10, s);
                    BiomeManager bm = dd.getBiomeManager();
                    if (bm != null && (bb = bm.getBiomeForChunk(null, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz)) != null) {
                        s = String.format("Biome: %s", bb.uniquename);
                        WorldRendererUtils.textAt(this.font, DangerZone.screen_width / 2, DangerZone.screen_height - 50, s);
                    }
                }
                modepos = 90;
            }
            s = "Survival";
            if (DangerZone.player.getGameMode() == 1) {
                s = "Creative";
            }
            if (DangerZone.player.getGameMode() == 2) {
                s = "Ghost";
            }
            if (DangerZone.player.getGameMode() == 3) {
                s = "Limbo";
            }
            s = String.format("GameMode: %s", s);
            WorldRendererUtils.textAt(this.font, DangerZone.screen_width / 2, DangerZone.screen_height - modepos, s);
            s = "Normal";
            if (DangerZone.player.getGameDifficulty() == -1) {
                s = "Easy";
            }
            if (DangerZone.player.getGameDifficulty() == -2) {
                s = "Girly";
            }
            if (DangerZone.player.getGameDifficulty() == 1) {
                s = "Hard";
            }
            if (DangerZone.player.getGameDifficulty() == 2) {
                s = "Brutal";
            }
            s = String.format("Difficulty: %s", s);
            WorldRendererUtils.textAt(this.font, DangerZone.screen_width / 2, DangerZone.screen_height - (modepos + 40), s);
            Chunk c = world.chunkcache.getChunk(world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
            if (c != null) {
                List<String> owners = c.ownernames;
                if (owners != null) {
                    int olen = owners.size();
                    i = 0;
                    s = "Chunk Owners: ";
                    while (olen > 0) {
                        s = String.valueOf(s) + owners.get(i);
                        s = String.valueOf(s) + ", ";
                        --olen;
                        ++i;
                    }
                    WorldRendererUtils.textAt(this.font, DangerZone.screen_width / 2, DangerZone.screen_height - (modepos + 80), s);
                }
                c = null;
            }
            s = String.format("XPOS: %d", (int)DangerZone.player.posx);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 90, s);
            s = String.format("YPOS: %d", (int)DangerZone.player.posy);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 130, s);
            s = String.format("ZPOS: %d", (int)DangerZone.player.posz);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 170, s);
            s = String.format("Packets: %d", this.pps);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 210, s);
            s = String.format("VBO memory: %d MB", this.VBOmemorysize / 0x100000);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 250, s);
            s = String.format("Light LVL: %f", Float.valueOf(WorldRendererUtils.getTotalLightAt(DangerZone.player.world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz)));
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 290, s);
            if (DangerZone.server != null) {
                s = String.format("Entity Freelist: %d", DangerZone.server.entityManager.entity_free_list.size());
                WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 330, s);
                s = String.format("Entities: %d", DangerZone.server.entityManager.entity_list.size());
                WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 370, s);
                if (DangerZone.particleManager != null) {
                    s = String.format("Particles: %d", DangerZone.particleManager.particle_list.size());
                    WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 410, s);
                }
            } else {
                s = String.format("Server Latency(ms): %d", DangerZone.server_connection.lastaverageloop);
                WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 330, s);
            }
        }
        GL11.glMatrixMode(5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode(5888);
        GL11.glPopMatrix();
        GL11.glEnable(2929);
    }

    private void find_focus(World w) {
        double dist;
        ListIterator<Entity> li;
        double delta = 0.0;
        Entity tempe = null;
        List<Entity> nearby_list = null;
        ArrayList<Entity> check_list = new ArrayList<Entity>();
        int riddenid = 0;
        Entity ridden = DangerZone.player.getRiddenEntity();
        if (ridden != null) {
            riddenid = ridden.entityID;
        }
        double fx = DangerZone.player.posx;
        double fy = DangerZone.player.posy + (double)DangerZone.player.eyeheight;
        double fz = DangerZone.player.posz;
        int x = (int)fx;
        int y = (int)fy;
        int z = (int)fz;
        int eyebid = w.getblock(DangerZone.player.dimension, x, y, z);
        double dir = Math.toRadians((DangerZone.player.rotation_yaw_head - 90.0f) % 360.0f);
        double dx = Math.cos(dir);
        double dz = Math.sin(dir);
        double dy = Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head % 360.0f));
        double xzscale = Math.abs(Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head % 360.0f)));
        dx *= xzscale;
        dz *= xzscale;
        dy = -dy;
        float reach = 2.0f + DangerZone.player.getHeight() * 2.5f;
        if (reach < 2.0f) {
            reach = 2.0f;
        }
        float itemreach = reach - 1.0f;
        float blockreach = reach;
        float itemwidth = 0.125f;
        InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
        if (ic != null) {
            itemreach += 0.5f * (float)ic.getAttribute(4);
            blockreach += 0.25f * (float)ic.getAttribute(4);
            itemwidth += 0.25f * (float)ic.getAttribute(1);
        }
        if (itemreach > reach) {
            reach = itemreach;
        }
        if (blockreach > reach) {
            reach = blockreach;
        }
        if ((nearby_list = DangerZone.entityManager.findEntitiesInRange(20.0f + reach, DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz)) != null && !nearby_list.isEmpty()) {
            li = nearby_list.listIterator();
            while (li.hasNext()) {
                tempe = li.next();
                dist = Math.sqrt((fx - tempe.posx) * (fx - tempe.posx) + (fy - tempe.posy) * (fy - tempe.posy) + (fz - tempe.posz) * (fz - tempe.posz));
                dist -= 0.125;
                dist -= (double)(tempe.getWidth() / 2.0f);
                if (tempe == DangerZone.player || tempe.canthitme || !(dist < 14.0) || tempe.entityID == riddenid) continue;
                check_list.add(tempe);
            }
        }
        if (ridden != null && dy < -0.75) {
            check_list.add(ridden);
        }
        int lz = 0;
        int ly = 0;
        int lx = 0;
        int lfx = focus_x;
        int lfy = focus_y;
        int lfz = focus_z;
        while (delta < (double)reach) {
            fx = DangerZone.player.posx + dx * delta;
            fy = DangerZone.player.posy + (double)DangerZone.player.eyeheight + dy * delta;
            fz = DangerZone.player.posz + dz * delta;
            x = (int)fx;
            y = (int)fy;
            z = (int)fz;
            if (delta < (double)itemreach && check_list != null && !check_list.isEmpty()) {
                li = check_list.listIterator();
                while (li.hasNext()) {
                    tempe = li.next();
                    if (!(fy > tempe.posy - (double)itemwidth) || !(fy < tempe.posy + (double)tempe.getHeight() + (double)itemwidth)) continue;
                    dist = Math.sqrt((fx - tempe.posx) * (fx - tempe.posx) + (fz - tempe.posz) * (fz - tempe.posz));
                    dist -= (double)itemwidth;
                    if (!((dist -= (double)(tempe.getWidth() / 2.0f)) < 0.0)) continue;
                    focus_meta = 0;
                    focus_bid = 0;
                    focus_z = 0;
                    focus_y = 0;
                    focus_x = 0;
                    focus_dist = (float)dist;
                    focus_entity = tempe;
                    poi_x = fx;
                    poi_y = fy;
                    poi_z = fz;
                    return;
                }
            }
            if (delta < (double)blockreach && x != lx || y != ly || z != lz) {
                lx = x;
                ly = y;
                lz = z;
                int bid = w.getblock(DangerZone.player.dimension, x, y, z);
                if (eyebid != 0 && Blocks.isLiquid(eyebid) && Blocks.isLiquid(bid)) {
                    bid = 0;
                }
                if (bid != 0) {
                    if (!Blocks.isSolid(bid) && check_list != null) {
                        int tlx = lx;
                        int tlz = lz;
                        int tly = ly;
                        double tdelta = delta;
                        while (tdelta < (double)itemreach) {
                            fx = DangerZone.player.posx + dx * tdelta;
                            fy = DangerZone.player.posy + (double)DangerZone.player.eyeheight + dy * tdelta;
                            fz = DangerZone.player.posz + dz * tdelta;
                            int tx = (int)fx;
                            int ty = (int)fy;
                            int tz = (int)fz;
                            if (tx != tlx || ty != tly || tz != tlz) {
                                int tbid = w.getblock(DangerZone.player.dimension, tx, ty, tz);
                                if (Blocks.isSolid(tbid)) break;
                                tlx = tx;
                                tly = ty;
                                tlz = tz;
                            }
                            if (!check_list.isEmpty()) {
                                li = check_list.listIterator();
                                while (li.hasNext()) {
                                    tempe = li.next();
                                    if (!(fy > tempe.posy - (double)itemwidth) || !(fy < tempe.posy + (double)tempe.getHeight() + (double)itemwidth)) continue;
                                    dist = Math.sqrt((fx - tempe.posx) * (fx - tempe.posx) + (fz - tempe.posz) * (fz - tempe.posz));
                                    dist -= (double)itemwidth;
                                    if (!((dist -= (double)(tempe.getWidth() / 2.0f)) < 0.0)) continue;
                                    focus_meta = 0;
                                    focus_bid = 0;
                                    focus_z = 0;
                                    focus_y = 0;
                                    focus_x = 0;
                                    focus_dist = (float)dist;
                                    focus_entity = tempe;
                                    poi_x = fx;
                                    poi_y = fy;
                                    poi_z = fz;
                                    return;
                                }
                            }
                            tdelta += 0.1;
                        }
                    }
                    double delta2 = delta;
                    x = (int)(DangerZone.player.posx + dx * (delta -= (double)0.1f));
                    y = (int)(DangerZone.player.posy + (double)DangerZone.player.eyeheight + dy * delta);
                    z = (int)(DangerZone.player.posz + dz * delta);
                    lx = x;
                    ly = y;
                    lz = z;
                    while (delta < delta2 + (double)0.01f) {
                        fx = DangerZone.player.posx + dx * delta;
                        fy = DangerZone.player.posy + (double)DangerZone.player.eyeheight + dy * delta;
                        fz = DangerZone.player.posz + dz * delta;
                        x = (int)fx;
                        y = (int)fy;
                        z = (int)fz;
                        if (x != lx || y != ly || z != lz) {
                            lx = x;
                            ly = y;
                            lz = z;
                            bid = w.getblock(DangerZone.player.dimension, x, y, z);
                            if (eyebid != 0 && Blocks.isLiquid(eyebid) && Blocks.isLiquid(bid)) {
                                bid = 0;
                            }
                            if (bid != 0) {
                                dx = DangerZone.player.posx + dx * delta;
                                dy = DangerZone.player.posy + (double)DangerZone.player.eyeheight + dy * delta;
                                dz = DangerZone.player.posz + dz * delta;
                                dist = 2.0;
                                double lastdist = 2.0;
                                focus_side = 0;
                                poi_x = fx;
                                poi_y = fy;
                                poi_z = fz;
                                double sx = (double)x + 0.5;
                                double sy = (double)y + 1.0;
                                double sz = (double)z + 0.5;
                                dist = Math.sqrt((sx - dx) * (sx - dx) + (sy - dy) * (sy - dy) + (sz - dz) * (sz - dz));
                                if (dist < lastdist) {
                                    lastdist = dist;
                                    focus_side = 0;
                                }
                                if ((dist = Math.sqrt(((sx = (double)x + 0.5) - dx) * (sx - dx) + ((sy = (double)y + 0.5) - dy) * (sy - dy) + ((sz = (double)z + 0.0) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    focus_side = 2;
                                }
                                if ((dist = Math.sqrt(((sx = (double)x + 0.5) - dx) * (sx - dx) + ((sy = (double)y + 0.5) - dy) * (sy - dy) + ((sz = (double)z + 1.0) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    focus_side = 1;
                                }
                                if ((dist = Math.sqrt(((sx = (double)x + 0.0) - dx) * (sx - dx) + ((sy = (double)y + 0.5) - dy) * (sy - dy) + ((sz = (double)z + 0.5) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    focus_side = 3;
                                }
                                if ((dist = Math.sqrt(((sx = (double)x + 1.0) - dx) * (sx - dx) + ((sy = (double)y + 0.5) - dy) * (sy - dy) + ((sz = (double)z + 0.5) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    focus_side = 4;
                                }
                                if ((dist = Math.sqrt(((sx = (double)x + 0.5) - dx) * (sx - dx) + ((sy = (double)y + 0.0) - dy) * (sy - dy) + ((sz = (double)z + 0.5) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    focus_side = 5;
                                }
                                focus_x = lx;
                                focus_y = ly;
                                focus_z = lz;
                                focus_bid = bid;
                                focus_meta = w.getblockmeta(DangerZone.player.dimension, x, y, z);
                                focus_dist = (float)delta;
                                focus_entity = null;
                                if (lfx != focus_x || lfy != focus_y || lfz != focus_z) {
                                    focus_damage = 0.0f;
                                    focus_maxdamage = Blocks.getMaxDamage(bid);
                                    if (focus_maxdamage < 1.0f) {
                                        focus_maxdamage = 1.0f;
                                    }
                                }
                                return;
                            }
                        }
                        delta += (double)0.01f;
                    }
                }
            }
            delta += 0.1;
        }
        focus_meta = 0;
        focus_bid = 0;
        focus_z = 0;
        focus_y = 0;
        focus_x = 0;
        poi_z = 0.0;
        poi_y = 0.0;
        poi_x = 0.0;
        focus_dist = 0.0f;
        focus_entity = null;
    }

    private void renderChunk(World world, int xrel, int zrel, double px, double py, double pz) {
        VBOBuffer v = null;
        int xpos = xrel * 16 + (int)px;
        int zpos = zrel * 16 + (int)pz;
        Chunk c = world.chunkcache.getDecoratedChunkForRenderer(DangerZone.player.dimension, xpos, 0, zpos);
        if (c == null) {
            return;
        }
        VBOlistlock.lock();
        int itemp = 0;
        while (itemp <= 20) {
            if (c.VBOids[itemp] <= 0L) break;
            v = VBOmap.get(c.VBOids[itemp]);
            if (v == null) {
                int ivi = 0;
                while (ivi < 20) {
                    if (c.VBOids[ivi] > 0L) {
                        v = VBOmap.get(c.VBOids[ivi]);
                        if (v != null) {
                            VBOmap.remove(v.VBOid);
                            --vbocount;
                            v.free();
                        }
                        c.VBOids[ivi] = 0L;
                    }
                    ++ivi;
                }
                VBOlistlock.unlock();
                return;
            }
            ++itemp;
        }
        VBOlistlock.unlock();
        GL11.glPushMatrix();
        GL11.glTranslatef(xrel * 16 * this.blockrenderwidth, 0.0f, zrel * 16 * this.blockrenderwidth);
        itemp = 0;
        while (itemp <= 20) {
            if (c.VBOids[itemp] <= 0L) break;
            VBOlistlock.lock();
            v = VBOmap.get(c.VBOids[itemp]);
            VBOlistlock.unlock();
            if (v != null) {
                if (!v.isTranslucent) {
                    this.loadStitchedtexture(v.textureindex);
                    v.lastusedframe = this.framecounter;
                    v.draw();
                } else {
                    v.xoff = xrel * 16 * this.blockrenderwidth;
                    v.zoff = zrel * 16 * this.blockrenderwidth;
                    this.translucentVBOs.add(v);
                }
            }
            ++itemp;
        }
        GL11.glPopMatrix();
    }

    public void drawTexturedCube(int sides, boolean isSolid, int bid, int meta, boolean focus) {
        if (bid <= 0 || bid >= 2048) {
            return;
        }
        if (Blocks.BlockArray[bid] == null) {
            return;
        }
        if (!isSolid) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
        }
        if ((meta & 0xFC00) != 0) {
            GL11.glPushMatrix();
            if ((meta & 0xC000) == 16384) {
                GL11.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
            }
            if ((meta & 0xC000) == 32768) {
                GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
            }
            if ((meta & 0xC000) == 49152) {
                GL11.glRotatef(270.0f, 1.0f, 0.0f, 0.0f);
            }
            if ((meta & 0x3000) == 4096) {
                GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            }
            if ((meta & 0x3000) == 8192) {
                GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
            }
            if ((meta & 0x3000) == 12288) {
                GL11.glRotatef(270.0f, 0.0f, 1.0f, 0.0f);
            }
            if ((meta & 0xC00) == 1024) {
                GL11.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
            }
            if ((meta & 0xC00) == 2048) {
                GL11.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
            }
            if ((meta & 0xC00) == 3072) {
                GL11.glRotatef(270.0f, 0.0f, 0.0f, 1.0f);
            }
            sides = 255;
        }
        if ((sides & 0x20) != 0 && this.loadtextureforblockside(0, bid, isSolid)) {
            GL11.glCallList(this.topid);
        }
        if ((sides & 0x10) != 0 && this.loadtextureforblockside(5, bid, isSolid)) {
            GL11.glCallList(this.bottomid);
        }
        if ((sides & 8) != 0 && this.loadtextureforblockside(1, bid, isSolid)) {
            GL11.glCallList(this.frontid);
        }
        if ((sides & 4) != 0 && this.loadtextureforblockside(2, bid, isSolid)) {
            GL11.glCallList(this.backid);
        }
        if ((sides & 1) != 0 && this.loadtextureforblockside(3, bid, isSolid)) {
            GL11.glCallList(this.leftid);
        }
        if ((sides & 2) != 0 && this.loadtextureforblockside(4, bid, isSolid)) {
            GL11.glCallList(this.rightid);
        }
        if ((meta & 0xFC00) != 0) {
            GL11.glPopMatrix();
        }
        if (!isSolid) {
            GL11.glDisable(3042);
        }
        if (focus) {
            if (focus_side == 0) {
                GL11.glLineWidth(this.linewidth);
                GL11.glBegin(3);
                GL11.glColor3f(0.0f, 0.0f, 0.0f);
                GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glEnd();
            }
            if (focus_side == 5) {
                GL11.glLineWidth(this.linewidth);
                GL11.glBegin(3);
                GL11.glColor3f(0.0f, 0.0f, 0.0f);
                GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glEnd();
            }
            if (focus_side == 1) {
                GL11.glLineWidth(this.linewidth);
                GL11.glBegin(3);
                GL11.glColor3f(0.0f, 0.0f, 0.0f);
                GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glEnd();
            }
            if (focus_side == 2) {
                GL11.glLineWidth(this.linewidth);
                GL11.glBegin(3);
                GL11.glColor3f(0.0f, 0.0f, 0.0f);
                GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glEnd();
            }
            if (focus_side == 3) {
                GL11.glLineWidth(this.linewidth);
                GL11.glBegin(3);
                GL11.glColor3f(0.0f, 0.0f, 0.0f);
                GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glEnd();
            }
            if (focus_side == 4) {
                GL11.glLineWidth(this.linewidth);
                GL11.glBegin(3);
                GL11.glColor3f(0.0f, 0.0f, 0.0f);
                GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
                GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
                GL11.glEnd();
            }
        }
    }

    public void drawTexturedSquare(int side, boolean isSolid, int bid) {
        if (bid <= 0 || bid >= 2048) {
            return;
        }
        if (Blocks.BlockArray[bid] == null) {
            return;
        }
        if (!isSolid) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
        }
        if (this.loadtextureforblockside(side, bid, isSolid)) {
            GL11.glCallList(this.frontid);
        }
        if (!isSolid) {
            GL11.glDisable(3042);
        }
    }

    public void loadStitchedtexture(int which) {
        if (which < 0 || which > 19) {
            return;
        }
        if (stitches[which] != null && last_texture != WorldRenderer.stitches[which].textureID) {
            stitches[which].bind();
            last_texture = WorldRenderer.stitches[which].textureID;
        }
    }

    public boolean loadtextureforblockside(int side, int bid, boolean solid) {
        Texture lt = Blocks.BlockArray[bid].getTexture(side);
        if (lt == null) {
            return false;
        }
        if (last_texture != lt.getTextureID()) {
            TextureImpl.unbind();
            lt.bind();
            last_texture = lt.getTextureID();
            GL11.glTexParameteri(3553, 10241, 9728);
            GL11.glTexParameteri(3553, 10240, 9728);
        }
        return true;
    }

    public boolean forceloadtexture(Texture lt) {
        if (lt == null) {
            return false;
        }
        last_texture = -1;
        TextureImpl.unbind();
        lt.bind();
        GL11.glTexParameteri(3553, 10241, 9728);
        GL11.glTexParameteri(3553, 10240, 9728);
        return true;
    }

    public boolean loadtexture(Texture lt) {
        if (lt == null) {
            return false;
        }
        if (last_texture != lt.getTextureID()) {
            last_texture = lt.getTextureID();
            TextureImpl.unbind();
            lt.bind();
            GL11.glTexParameteri(3553, 10241, 9728);
            GL11.glTexParameteri(3553, 10240, 9728);
        }
        return true;
    }

    public static void recalcBrightness(int d, int yp) {
        float f = WorldRendererUtils.getBrightnessForLevel(d, yp);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        brightness_green = brightness_blue = f;
        brightness_red = brightness_blue;
    }

    public void recalcSkyBrightness() {
        float tod = DangerZone.world.timetimer % DangerZone.world.lengthOfDay;
        float fsin = (float)Math.sin(Math.toRadians(tod / (float)DangerZone.world.lengthOfDay * 360.0f));
        if ((fsin *= 1.75f) > 1.0f) {
            fsin = 1.0f;
        }
        if (fsin < -1.0f) {
            fsin = -1.0f;
        }
        float fsky = 0.5f + 0.45f * fsin;
        float maxfsky = 1.0f - 0.5f * ((float)DangerZone.thundercount / 300.0f);
        if (maxfsky < 0.5f) {
            maxfsky = 0.5f;
        }
        if (fsky > maxfsky) {
            fsky = maxfsky;
        }
        int pld = DangerZone.player.dimension;
        this.sky_red = Dimensions.DimensionArray[pld].sky_red * fsky;
        this.sky_green = Dimensions.DimensionArray[pld].sky_green * fsky;
        this.sky_blue = Dimensions.DimensionArray[pld].sky_blue * fsky;
    }

    public void setBrightness() {
        GL11.glColor3f(brightness_red, brightness_green, brightness_blue);
    }

    public void setBrightness(float m) {
        float flb;
        float flg;
        float flr = brightness_red + m;
        if (flr < 0.0f) {
            flr = 0.0f;
        }
        if (flr > 1.0f) {
            flr = 1.0f;
        }
        if ((flg = brightness_green + m) < 0.0f) {
            flg = 0.0f;
        }
        if (flg > 1.0f) {
            flg = 1.0f;
        }
        if ((flb = brightness_blue + m) < 0.0f) {
            flb = 0.0f;
        }
        if (flb > 1.0f) {
            flb = 1.0f;
        }
        GL11.glColor3f(flr, flg, flb);
    }

    public void setBrightnessFocus() {
        float bval = 1.0f;
        if (!DangerZone.world.isDaytime()) {
            bval = 0.75f;
        }
        GL11.glColor3f(bval, bval, bval);
    }

    public void setBrightnessFocusBlock() {
        float bval = WorldRendererUtils.getTotalLightAt(DangerZone.world, DangerZone.player.dimension, focus_x, focus_y, focus_z);
        if (bval > 1.0f) {
            bval = 1.0f;
        }
        if (bval < 0.0f) {
            bval = 0.0f;
        }
        bval = bval > 0.65f ? (bval -= 0.35f) : (bval += 0.35f);
        GL11.glColor3f(bval, bval, bval);
    }

    public void setBrightnessNonFocus() {
        float bval = 0.75f;
        if (!DangerZone.world.isDaytime()) {
            bval = 0.5f;
        }
        GL11.glColor3f(bval, bval, bval);
    }

    public int getNextRenderID() {
        lock.lock();
        int i = GL11.glGenLists(1);
        lock.unlock();
        return i;
    }

    public static long getNextVBOid() {
        lock.lock();
        long i = nextVBOid++;
        lock.unlock();
        return i;
    }

    public void deleteVBOlist(long[] vboids) {
        VBOlistlock.lock();
        this.VBO_delete_list.add(vboids);
        VBOlistlock.unlock();
    }

    private void Scalef5toSolid() {
        float dst = 0.0f;
        float dz = 0.0f;
        float dy = 0.0f;
        float dx = 0.0f;
        int lz = 0;
        int ly = 0;
        int lx = 0;
        while (dst <= 8.0f) {
            dx = this.f5x * dst / 8.0f;
            dy = this.f5y * dst / 8.0f;
            dz = this.f5z * dst / 8.0f;
            int ix = (int)(this.ViewFromEntity.posx - (double)(dx / (float)this.blockrenderwidth));
            int iy = (int)(this.ViewFromEntity.posy + (double)this.ViewFromEntity.eyeheight - (double)(dy / (float)this.blockrenderwidth));
            int iz = (int)(this.ViewFromEntity.posz - (double)(dz / (float)this.blockrenderwidth));
            if (ix != lx || iy != ly || iz != lz) {
                lx = ix;
                ly = iy;
                lz = iz;
                int bid = DangerZone.world.getblock(this.ViewFromEntity.dimension, ix, iy, iz);
                if (bid != 0 && Blocks.isSolidForRender(bid)) {
                    if ((dst -= 0.25f) < 0.0f) {
                        dst = 0.0f;
                    }
                    dx = this.f5x * dst / 8.0f;
                    dy = this.f5y * dst / 8.0f;
                    dz = this.f5z * dst / 8.0f;
                    break;
                }
            }
            dst += 0.1f;
        }
        this.f5x = dx;
        this.f5y = dy;
        this.f5z = dz;
    }
}

