/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.BaseMod;
import dangerzone.DangerZone;
import dangerzone.ModListEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.newdawn.slick.util.ResourceLoader;
import org.newdawn.slick.util.ResourceLocation;

public class ModLoader {
    private static final Class[] parameters = new Class[]{URL.class};

    public ModLoader() {
        ResourceLoader.addResourceLocation((ResourceLocation)new ResLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String loadmods() {
        String curdir = System.getProperty("user.dir");
        File[] files = new File(String.valueOf(curdir) + "/mods").listFiles();
        JarFile jf = null;
        if (files == null) {
            return null;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                BaseMod instance = null;
                if (file.getName().endsWith(".jar")) {
                    try {
                        jf = new JarFile(file.getAbsolutePath());
                        Enumeration<JarEntry> ev = jf.entries();
                        while (ev.hasMoreElements()) {
                            Object o;
                            JarEntry je = ev.nextElement();
                            if (!je.getName().endsWith("Main.class")) continue;
                            String fixedname = je.getName().replace('/', '.');
                            fixedname = fixedname.replace('\\', '.');
                            fixedname = fixedname.replace(".class", "");
                            ModLoader.addFile(file);
                            Constructor<?> cs = ClassLoader.getSystemClassLoader().loadClass(fixedname).getConstructor(new Class[0]);
                            if (cs == null || !((o = cs.newInstance(new Object[0])) instanceof BaseMod)) continue;
                            instance = (BaseMod)o;
                            break;
                        }
                    }
                    catch (IOException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    if (instance == null) {
                        System.out.printf("File: %s is incompatible. Please remove it.\n", file.getAbsolutePath());
                        return file.getAbsolutePath();
                    }
                    if (!this.isCompatible(instance.versionBuiltWith())) {
                        System.out.printf("File: %s is incompatible. Please remove it.\n", file.getAbsolutePath());
                        return file.getAbsolutePath();
                    }
                    ModListEntry thismod = new ModListEntry();
                    thismod.versionbuiltwith = instance.versionBuiltWith();
                    thismod.modname = instance.getModName();
                    thismod.modinstance = instance;
                    thismod.filepath = file.getAbsolutePath();
                    thismod.jarfile = jf;
                    DangerZone.all_the_mods.add(thismod);
                    instance.registerThings();
                }
            }
            ++n2;
        }
        for (ModListEntry me : DangerZone.all_the_mods) {
            me.modinstance.postLoadProcessing();
            System.out.printf("Loaded mod: %s\n", me.modname);
        }
        return null;
    }

    public boolean loadmods(List<String> namelist) {
        String curdir = System.getProperty("user.dir");
        File[] files = new File(String.valueOf(curdir) + "/mods").listFiles();
        JarFile jf = null;
        if (files == null) {
            return false;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                BaseMod instance = null;
                if (file.getName().endsWith(".jar")) {
                    try {
                        jf = new JarFile(file.getAbsolutePath());
                        Enumeration<JarEntry> ev = jf.entries();
                        while (ev.hasMoreElements()) {
                            Object o;
                            JarEntry je = ev.nextElement();
                            if (!je.getName().endsWith("Main.class")) continue;
                            String fixedname = je.getName().replace('/', '.');
                            fixedname = fixedname.replace('\\', '.');
                            fixedname = fixedname.replace(".class", "");
                            ModLoader.addFile(file);
                            Constructor<?> cs = ClassLoader.getSystemClassLoader().loadClass(fixedname).getConstructor(new Class[0]);
                            if (cs == null || !((o = cs.newInstance(new Object[0])) instanceof BaseMod)) continue;
                            instance = (BaseMod)o;
                            break;
                        }
                    }
                    catch (IOException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    if (instance != null && this.isCompatible(instance.versionBuiltWith()) && this.isonList(namelist, instance.getModName())) {
                        ModListEntry thismod = new ModListEntry();
                        thismod.versionbuiltwith = instance.versionBuiltWith();
                        thismod.modname = instance.getModName();
                        thismod.modinstance = instance;
                        thismod.filepath = file.getAbsolutePath();
                        thismod.jarfile = jf;
                        DangerZone.all_the_mods.add(thismod);
                        instance.registerThings();
                    }
                }
            }
            ++n2;
        }
        if (namelist.size() != DangerZone.all_the_mods.size()) {
            return false;
        }
        for (ModListEntry me : DangerZone.all_the_mods) {
            me.modinstance.postLoadProcessing();
            System.out.printf("Loaded mod: %s\n", me.modname);
        }
        return true;
    }

    private boolean isonList(List<String> mlist, String s) {
        int i = mlist.size();
        int k = 0;
        while (k < i) {
            if (s.equals(mlist.get(k))) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private boolean isCompatible(String modver) {
        return DangerZone.versionstring.equals(modver);
    }

    public static void addFile(File f) throws IOException {
        ModLoader.addURL(f.toURI().toURL());
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public void loadservermods() {
        String curdir = System.getProperty("user.dir");
        File[] files = new File(String.valueOf(curdir) + "/server_mods").listFiles();
        JarFile jf = null;
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                BaseMod instance = null;
                if (file.getName().endsWith(".jar")) {
                    try {
                        jf = new JarFile(file.getAbsolutePath());
                        Enumeration<JarEntry> ev = jf.entries();
                        while (ev.hasMoreElements()) {
                            Object o;
                            JarEntry je = ev.nextElement();
                            if (!je.getName().endsWith("Main.class")) continue;
                            String fixedname = je.getName().replace('/', '.');
                            fixedname = fixedname.replace('\\', '.');
                            fixedname = fixedname.replace(".class", "");
                            ModLoader.addFile(file);
                            Constructor<?> cs = ClassLoader.getSystemClassLoader().loadClass(fixedname).getConstructor(new Class[0]);
                            if (cs == null || !((o = cs.newInstance(new Object[0])) instanceof BaseMod)) continue;
                            instance = (BaseMod)o;
                            break;
                        }
                    }
                    catch (IOException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        System.out.printf("Cannot load file: %s\n", file.getAbsolutePath());
                        e.printStackTrace();
                    }
                    if (instance != null && this.isCompatible(instance.versionBuiltWith())) {
                        ModListEntry thismod = new ModListEntry();
                        thismod.versionbuiltwith = instance.versionBuiltWith();
                        thismod.modname = instance.getModName();
                        thismod.modinstance = instance;
                        thismod.filepath = file.getAbsolutePath();
                        thismod.jarfile = jf;
                        DangerZone.all_the_server_mods.add(thismod);
                        instance.registerThings();
                    }
                }
            }
            ++n2;
        }
        for (ModListEntry me : DangerZone.all_the_server_mods) {
            me.modinstance.postLoadProcessing();
            System.out.printf("Loaded Server mod: %s\n", me.modname);
        }
    }

    public class ResLoader
    implements ResourceLocation {
        public URL getResource(String arg0) {
            return null;
        }

        public InputStream getResourceAsStream(String arg0) {
            if (DangerZone.all_the_mods == null || DangerZone.all_the_mods.isEmpty()) {
                return null;
            }
            InputStream is = null;
            Iterator<ModListEntry> ii = DangerZone.all_the_mods.iterator();
            String str = arg0;
            if (str.charAt(0) == '/') {
                str = arg0.substring(1);
            }
            while (ii.hasNext()) {
                ModListEntry me = ii.next();
                try {
                    is = me.jarfile.getInputStream(me.jarfile.getEntry(str));
                }
                catch (Exception e) {
                    is = null;
                }
                if (is == null) continue;
                return is;
            }
            return null;
        }
    }
}

