/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.items;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.WorldRenderer;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityExtendedRangeDamage;
import dangerzone.gui.InventoryMenus;
import dangerzone.items.Item;
import dangerzone.items.ModelPistol;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.Texture;

public class ItemPistol
extends Item {
    Texture texturebig = null;
    ModelPistol ma = null;

    public ItemPistol(String n, String txt, int att, int uses) {
        super(n, txt);
        this.maxstack = 1;
        this.maxuses = uses;
        this.attackstrength = att;
        this.menu = InventoryMenus.HARDWARE;
        this.hold_straight = true;
        this.do_shoot_clicks = true;
    }

    public void renderMe(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay) {
        if (this.texturebig == null) {
            this.texturebig = TextureMapper.getTexture("res/items/Pistoltexture.png");
        }
        DangerZone.wr.loadtexture(this.texturebig);
        if (this.ma == null) {
            this.ma = new ModelPistol();
        }
        GL11.glRotatef((float)82.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)170.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)41.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)2.0f, (float)-23.0f, (float)1.0f);
        if (this.ma != null) {
            this.ma.render(e, ic);
        }
    }

    @Override
    public void renderMeHeld(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay) {
        if (e == null) {
            return;
        }
        float count = e.getRightButtonDownCount();
        if (count > this.getfullholdcount()) {
            count = this.getfullholdcount();
        }
        float pct = count / this.getfullholdcount();
        if (isdisplay && e.getRightButtonDownCount() != 0) {
            GL11.glRotatef((float)(8.6f * pct), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(16.8f * pct), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-3.9f * pct), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)(-4.4f * pct), (float)(-8.1f * pct), (float)(7.4f * pct));
        }
        this.renderMe(wr, e, ic, isdisplay);
    }

    @Override
    public boolean singleshot(Entity holder, InventoryContainer ic, int holdcount) {
        return this.shoot_a_shot(holder, ic, holdcount);
    }

    public boolean shoot_a_shot(Entity holder, InventoryContainer ic, int holdcount) {
        if (holder.world.isServer) {
            float mz;
            float my;
            float mx;
            int spam = ic.getAttribute(5);
            int acc = ic.getAttribute(1);
            int dmg = ic.getAttribute(2);
            int rch = ic.getAttribute(4);
            float held = holdcount + 10 * spam;
            if (acc < 1) {
                acc = 1;
            }
            float acu = 1 / acc;
            float dam = this.attackstrength + 2 * dmg;
            float spd = 0.75f * (float)rch;
            if (held > this.getfullholdcount()) {
                held = this.getfullholdcount();
            }
            if (this.maxuses - ic.currentuses <= 1) {
                return false;
            }
            if (held < this.getfullholdcount()) {
                return false;
            }
            EntityExtendedRangeDamage e = (EntityExtendedRangeDamage)holder.world.createEntityByName("DangerZone:ExtendedRangeDamage", holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 1.5f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.25f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 1.5f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 1.5f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))));
            if (e != null) {
                e.init();
                e.setDamageType(8);
                e.setRange(128);
                e.thrower = holder;
                e.setAttackDamage(dam);
                e.setItemDamage(1);
                mx = (float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head));
                my = -((float)Math.sin(Math.toRadians(holder.rotation_pitch_head - 0.75f)));
                mz = (float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head));
                e.setDirectionAndVelocity(mx, my, mz, 15.25f + spd, 0.03f * acu);
                holder.world.spawnEntityInWorld(e);
                if (holder.world.rand.nextBoolean()) {
                    holder.world.playSound("DangerZone:22cal_1", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 1.15f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.2f);
                } else {
                    holder.world.playSound("DangerZone:22cal_2", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 1.15f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.2f);
                }
            } else {
                return false;
            }
            Utils.spawnParticlesFromServerScaled(holder.world, "DangerZone:ParticleDust", 10, holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.25f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 0.35f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), 0, 0.15f * (holder.getWidth() + holder.getHeight()) / 4.0f);
            Utils.spawnParticlesFromServerScaledWithDirection(holder.world, "DangerZone:ParticleBlast", 20, holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.25f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 0.35f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), mx, my, mz, 0, 0.15f * (holder.getWidth() + holder.getHeight()) / 4.0f, 1.25f, 0.5f);
            holder.addKnockback(e, 0.05f, 0.02f);
            return !(holder instanceof Player) || holder.getGameMode() == 0;
        }
        return false;
    }

    @Override
    public float getfullholdcount() {
        return 20.0f;
    }
}

