/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.ModelBase;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.BlockSpawner;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import org.newdawn.slick.opengl.Texture;

public class EntitySpawner
extends Entity {
    Entity trophyentity = null;
    ModelBase trophymodel = null;
    float trophyscale = 1.0f;
    int timer = 100;
    int blkmeta = 0;

    public EntitySpawner(World w) {
        super(w);
        this.uniquename = "DangerZone:EntitySpawner";
        this.ignoreCollisions = true;
        this.canthitme = true;
        this.width = 0.25f;
        this.height = 0.25f;
        this.maxrenderdist = 64;
    }

    @Override
    public void init() {
        super.init();
        this.timer = this.getVarInt(2);
        if (this.timer > 1) {
            this.timer = this.world.rand.nextInt(this.timer);
        }
    }

    @Override
    public void update(float deltaT) {
        int bid = 0;
        if (this.trophyentity == null) {
            this.trophyentity = this.world.createEntityByName(this.getVarString(0), this.dimension, this.posx, this.posy, this.posz);
            if (this.trophyentity != null) {
                this.trophymodel = this.trophyentity.model;
                this.trophyscale = this.getVarFloat(0);
            }
        }
        if (this.world.isServer) {
            bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
            if (bid == 0) {
                this.deadflag = true;
            } else if (Blocks.getBlock(bid) instanceof BlockSpawner) {
                this.blkmeta = this.world.getblockmeta(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
            } else {
                this.deadflag = true;
            }
            if (!this.deadflag && DangerZone.server.isPlayerCloseInDimension(this, 16.0f)) {
                int nparticle;
                --this.timer;
                if (this.timer <= 0) {
                    this.timer = this.getVarInt(2);
                    if (this.timer > 1) {
                        this.timer += this.world.rand.nextInt(this.timer);
                    }
                    float lv = 0.0f;
                    if (this.blkmeta == 0) {
                        lv = this.getLightAtLocation(this.world, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
                    }
                    if ((this.blkmeta != 0 || lv > this.getVarFloat(1) && lv < this.getVarFloat(2)) && this.trophyentity != null) {
                        int i = 0;
                        while (i < this.getVarInt(3)) {
                            Entity e;
                            float range = this.trophyentity.getWidth() * 2.0f;
                            range += 2.0f;
                            int ht = (int)this.trophyentity.getHeight();
                            boolean fits = false;
                            double px = this.posx;
                            double py = this.posy;
                            double pz = this.posz;
                            int tries = 0;
                            while (tries < 10 && !fits) {
                                px = this.posx + (double)(range * (this.world.rand.nextFloat() - this.world.rand.nextFloat()));
                                pz = this.posz + (double)(range * (this.world.rand.nextFloat() - this.world.rand.nextFloat()));
                                py = this.posy;
                                int k = ht;
                                while (k >= -ht && !fits) {
                                    if ((this.trophyentity.canFly || this.isSolidHere(this.world, this.dimension, px, py + (double)k, pz, this.trophyentity.getWidth())) && !this.isSolidHere(this.world, this.dimension, px, py + (double)k + 1.0, pz, this.trophyentity.getWidth())) {
                                        fits = true;
                                        if (ht > 0) {
                                            int j = 1;
                                            while (j <= ht && fits) {
                                                if (this.isSolidHere(this.world, this.dimension, px, py + (double)k + (double)j + 1.0, pz, this.trophyentity.getWidth())) {
                                                    fits = false;
                                                }
                                                ++j;
                                            }
                                        }
                                        if (fits) {
                                            py = py + (double)k + 1.0;
                                        }
                                    }
                                    --k;
                                }
                                ++tries;
                            }
                            if (fits && (e = this.world.createEntityByName(this.getVarString(0), this.dimension, px, py, pz)) != null) {
                                e.init();
                                e.doFromSpawner();
                                this.world.spawnEntityInWorld(e);
                            }
                            ++i;
                        }
                    }
                }
                if (this.timer < this.getVarInt(2) && (nparticle = (int)(6.0f - 6.0f * ((float)this.timer / (float)this.getVarInt(2)))) > 0) {
                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleFire", nparticle, this.dimension, this.posx, this.posy + 0.25, this.posz);
                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSparkle", nparticle, this.dimension, this.posx, this.posy + 0.25, this.posz);
                }
            }
        }
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        this.rotation_yaw_motion = 10.0f;
        super.update(deltaT);
    }

    @Override
    public Texture getTexture() {
        if (this.trophyentity != null) {
            return this.trophyentity.getTexture();
        }
        return null;
    }

    private boolean isSolidHere(World w, int d, double x, double y, double z, float width) {
        int intwidth = (int)(width / 2.0f + 0.5f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isSolid(w.getblock(d, (int)x + i, (int)y, (int)z + j))) {
                    int itemp = (int)x + i;
                    double dx = x - ((double)itemp + 0.5);
                    if ((dx = Math.abs(dx)) < (double)(0.49f + width / 2.0f)) {
                        itemp = (int)z + j;
                        double dz = z - ((double)itemp + 0.5);
                        if ((dz = Math.abs(dz)) < (double)(0.49f + width / 2.0f)) {
                            return true;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

