/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;

public class EntityChest
extends Entity {
    public int blocktries = 0;

    public EntityChest(World w) {
        super(w);
        this.uniquename = "DangerZone:EntityChest";
        this.ignoreCollisions = true;
        this.width = 0.01f;
        this.height = 0.01f;
        this.has_inventory = true;
        this.maxrenderdist = 64;
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz) != Blocks.chest.blockID) {
            ++this.blocktries;
            if (this.blocktries > 20) {
                this.dumpInventory();
                this.deadflag = true;
            }
        }
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        super.update(deltaT);
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz) != Blocks.chest.blockID) {
            if (this.world.isServer) {
                this.dumpInventory();
            }
            this.deadflag = true;
            return false;
        }
        if (!p.world.isServer) {
            Blocks.rightClickOnBlock(Blocks.chest.blockID, p, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
        }
        return false;
    }

    private void dumpInventory() {
        InventoryContainer ic = null;
        int i = 0;
        while (i < 50) {
            EntityBlockItem e;
            ic = this.getInventory(i);
            if (ic != null && (e = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx, this.posy, this.posz)) != null) {
                e.fill(ic);
                e.rotation_pitch = this.world.rand.nextInt(360);
                e.rotation_yaw = this.world.rand.nextInt(360);
                e.rotation_roll = this.world.rand.nextInt(360);
                e.motionx = this.world.rand.nextFloat() - this.world.rand.nextFloat() / 10.0f;
                e.motiony = this.world.rand.nextFloat() / 2.0f;
                e.motionz = this.world.rand.nextFloat() - this.world.rand.nextFloat() / 10.0f;
                this.world.spawnEntityInWorld(e);
            }
            ++i;
        }
    }
}

