/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.biomes;

import dangerzone.Chunk;
import dangerzone.DangerZone;
import dangerzone.Fastmath;
import dangerzone.World;
import java.util.Random;

public class Biome {
    public String uniquename = "";
    public boolean should_add_caves = true;
    public boolean should_add_flowers = true;
    public boolean should_add_roaches = true;
    public boolean should_add_butterflies = true;
    public boolean should_add_dungeons = true;
    public boolean should_add_waterplants = true;
    public long bioRand = 0L;
    public float rarityFactor = 1.0f;
    public float mul_red;
    public float mul_green;
    public float mul_blue;
    public float mixbiomesize = 10.0f;
    public int avgheight = 70;
    public int waterlevel = 60;
    float[] mixfloats = null;
    float[] mixoffs;
    float[] mixscalex;
    float[] mixscalez;
    int mixlen = 30;

    public Biome(String n) {
        this.uniquename = n;
        char[] b = n.toCharArray();
        int i = 0;
        while (i < b.length) {
            this.bioRand += (long)((i + 1) * b[i]);
            ++i;
        }
        this.bioRand <<= 32;
        i = 0;
        while (i < b.length) {
            this.bioRand += (long)((i + 3) * b[i]);
            this.bioRand += (long)b[i];
            ++i;
        }
        if (DangerZone.server_world != null) {
            this.bioRand ^= DangerZone.server_world.worldseed;
            this.mixfloats = new float[this.mixlen];
            this.mixoffs = new float[this.mixlen];
            this.mixscalex = new float[this.mixlen];
            this.mixscalez = new float[this.mixlen];
            Random myrand = new Random(DangerZone.server_world.worldseed + this.bioRand);
            int j = 0;
            while (j < this.mixlen) {
                this.mixfloats[j] = 1.0f + myrand.nextFloat();
                this.mixscalex[j] = (0.1f + myrand.nextFloat()) * this.mixbiomesize;
                this.mixscalez[j] = (0.1f + myrand.nextFloat()) * this.mixbiomesize;
                this.mixoffs[j] = myrand.nextFloat() * 3.1415f;
                ++j;
            }
        }
        this.mul_blue = 1.0f;
        this.mul_green = 1.0f;
        this.mul_red = 1.0f;
    }

    public float mixgenvalue(int dx, int dz) {
        int iters = this.mixfloats.length;
        float fval = 0.0f;
        int i = 0;
        while (i < iters) {
            fval = i % 1 == 0 ? (fval += this.mixgetoneval(i, dx, dz)) : (fval -= this.mixgetoneval(i, dx, dz));
            ++i;
        }
        return fval;
    }

    public float mixgetoneval(int index, int dx, int dz) {
        float fval = 0.0f;
        fval = (float)Fastmath.sin((double)this.mixoffs[index] + Math.toRadians((float)dz * this.mixscalez[index]));
        fval += (float)Fastmath.sin((double)this.mixoffs[index] + Math.toRadians((float)dx * this.mixscalex[index]));
        return fval *= this.mixfloats[index];
    }

    public float getValueForBiome(int x, int y, int z) {
        float bioval = this.mixgenvalue(x >> 4, z >> 4);
        return bioval * this.rarityFactor;
    }

    public void generateheightmaps(World w, int d, Chunk c, int cx, int cz, int[][] dirtheight, int[][] stoneheight, int[][] baseheight) {
    }

    public void generate(World w, int d, Chunk c, int cx, int cz, int[][] ditrheight, int[][] stoneheight, int[][] baseheight) {
    }

    public void decorate(World world, int d, Chunk c, int chunkx, int chunkz) {
    }
}

