/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.ToDoItem;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ToDoList {
    public static final int IGNORED = 0;
    public static final int CRAFTED = 1;
    public static final int KILLED = 2;
    public static final int SPAWNED = 3;
    public static final int TAMED = 4;
    public static final int RIDDEN = 5;
    public static final int PICKEDUP = 6;
    public static final int DIMENSION = 7;
    public static final int PLACED = 8;
    public static final int SPELLCAST = 9;
    public static final int LEVELED = 10;
    public static final int EATEN = 11;
    public static final int ARMORPLACED = 12;
    public static final int BROKEN = 13;
    public static final int PETFED = 14;
    public static final int AFFECTED = 15;
    public static final int ITEMRIGHTCLICKEDBLOCK = 16;
    public static List<ToDoItem> todo;

    public ToDoList() {
        todo = new ArrayList<ToDoItem>();
    }

    public static void registerToDoItem(ToDoItem tobedone) {
        if (ToDoList.find(tobedone.uniquename) != null) {
            System.out.printf("todo name (%s) not unique - NOT ADDED\n", tobedone.uniquename);
            return;
        }
        todo.add(tobedone);
    }

    public static ToDoItem find(String i1) {
        if (i1 == null) {
            return null;
        }
        if (todo == null) {
            return null;
        }
        if (todo.isEmpty()) {
            return null;
        }
        for (ToDoItem r : todo) {
            if (!i1.equals(r.uniquename)) continue;
            return r;
        }
        return null;
    }

    public static void onCrafted(Player pl, InventoryContainer ic) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 1) continue;
            r.onCrafted(pl, ic);
        }
    }

    public static void onKilled(Player pl, Entity ent) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 2) continue;
            r.onKilled(pl, ent);
        }
    }

    public static void onSpawned(Player pl, Entity ent) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 3) continue;
            r.onSpawned(pl, ent);
        }
    }

    public static void onTamed(Player pl, EntityLiving ent) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 4) continue;
            r.onTamed(pl, ent);
        }
    }

    public static void onRidden(Player pl, Entity ent) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 3) continue;
            r.onRidden(pl, ent);
        }
    }

    public static void onPickedUp(Player pl, InventoryContainer ic) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 6) continue;
            r.onPickedUp(pl, ic);
        }
    }

    public static void onDimension(Player pl, int oldd, int newd) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 7) continue;
            r.onDimension(pl, oldd, newd);
        }
    }

    public static void onPlaced(Player pl, int dimension, int x, int y, int z, int bid) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 8) continue;
            r.onPlaced(pl, dimension, x, y, z, bid);
        }
    }

    public static void onBroken(Player pl, int dimension, int x, int y, int z, int bid) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 8) continue;
            r.onBroken(pl, dimension, x, y, z, bid);
        }
    }

    public static void onSpellCast(Player pl, int spellid, float spellstrength) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 9) continue;
            r.onSpellCast(pl, spellid, spellstrength);
        }
    }

    public static void onLeveled(Player pl, int xp) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 10) continue;
            r.onLeveled(pl, xp);
        }
    }

    public static void onEaten(Player pl, InventoryContainer ic) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 11) continue;
            r.onEaten(pl, ic);
        }
    }

    public static void onArmorPlaced(Player pl, InventoryContainer ic, int slot) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 12) continue;
            r.onArmorPlaced(pl, ic, slot);
        }
    }

    public static void onPetFed(Player pl, Entity ent, InventoryContainer ic) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 14) continue;
            r.onPetFed(pl, ent, ic);
        }
    }

    public static void onAffected(Player pl, int type, int duration, float amp) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 15) continue;
            r.onAffected(pl, type, duration, amp);
        }
    }

    public static void itemRightClickedBlock(Player pl, InventoryContainer ic, int dimension, int focusx, int focusy, int focusz) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            if (r.type != 16) continue;
            r.itemRightClickedBlock(pl, ic, dimension, focusx, focusy, focusz);
        }
    }

    public static void writeSelf(Properties prop, String tag) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            r.writeSelf(prop, String.valueOf(tag) + r.uniquename);
        }
    }

    public static void readSelf(Properties prop, String tag) {
        if (todo == null) {
            return;
        }
        if (todo.isEmpty()) {
            return;
        }
        for (ToDoItem r : todo) {
            r.readSelf(prop, String.valueOf(tag) + r.uniquename);
        }
    }
}

