/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.CommandHandler;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityCloud;
import dangerzone.entities.EntityFire;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.EntityVolcano;
import dangerzone.items.Items;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class DZCommandHandler
extends CommandHandler {
    @Override
    public boolean doCommand(Player pl, String cmd) {
        StringTokenizer st = new StringTokenizer(cmd);
        if (!pl.world.isServer) {
            return false;
        }
        String s = st.nextToken();
        if (!st.hasMoreTokens()) {
            return true;
        }
        s = st.nextToken();
        if (s.equalsIgnoreCase("time")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 0x40) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens() && (s = st.nextToken()).equalsIgnoreCase("set") && st.hasMoreTokens()) {
                int newtime;
                s = st.nextToken();
                if (s.equalsIgnoreCase("day")) {
                    DangerZone.server_world.timetimer = DangerZone.server_world.lengthOfDay / 4;
                    DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
                    return true;
                }
                if (s.equalsIgnoreCase("night")) {
                    DangerZone.server_world.timetimer = DangerZone.server_world.lengthOfDay * 3 / 4;
                    DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
                    return true;
                }
                if (s.equalsIgnoreCase("dawn")) {
                    DangerZone.server_world.timetimer = 0;
                    DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
                    return true;
                }
                if (s.equalsIgnoreCase("dusk")) {
                    DangerZone.server_world.timetimer = DangerZone.server_world.lengthOfDay / 2;
                    DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
                    return true;
                }
                try {
                    newtime = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    newtime = -1;
                }
                if (newtime >= 0 && newtime <= DangerZone.server_world.lengthOfDay) {
                    DangerZone.server_world.timetimer = newtime;
                    DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
                    return true;
                }
                return this.errOther(pl, " Error: invalid time");
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("sethome")) {
            pl.home_dimension = pl.dimension;
            pl.home_x = pl.posx;
            pl.home_y = pl.posy;
            pl.home_z = pl.posz;
            DangerZone.server.saveThisPlayer(pl);
            return true;
        }
        if (s.equalsIgnoreCase("home")) {
            Utils.doTeleport(pl, pl.home_dimension, pl.home_x, pl.home_y, pl.home_z);
            return true;
        }
        if (s.equalsIgnoreCase("spawn")) {
            Utils.doTeleport(pl, 1, 10000.0f + (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 64.0f, 100.0, 10000.0f + (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 64.0f);
            return true;
        }
        if (s.equalsIgnoreCase("tp") || s.equalsIgnoreCase("teleport")) {
            int newz = 0;
            int newy = 0;
            int newx = 0;
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 4) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                Entity e = DangerZone.server.entityManager.findPlayerByName(s);
                if (e != null) {
                    if (!st.hasMoreTokens()) {
                        Utils.doTeleport(pl, e.dimension, e.posx, e.posy, e.posz);
                        return true;
                    }
                    s = st.nextToken();
                    Entity ee = DangerZone.server.entityManager.findPlayerByName(s);
                    if (ee != null) {
                        if ((pl.player_privs & 2) == 0) {
                            return this.errPermissionDenied(pl);
                        }
                        Utils.doTeleport((Player)e, ee.dimension, ee.posx, ee.posy, ee.posz);
                        return true;
                    }
                    if ((pl.player_privs & 2) == 0) {
                        return this.errPermissionDenied(pl);
                    }
                    try {
                        newx = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ex) {
                        newx = 0;
                    }
                    if (st.hasMoreTokens()) {
                        s = st.nextToken();
                        try {
                            newy = Integer.parseInt(s);
                        }
                        catch (NumberFormatException ex) {
                            newy = 0;
                        }
                    }
                    if (st.hasMoreTokens()) {
                        s = st.nextToken();
                        try {
                            newz = Integer.parseInt(s);
                        }
                        catch (NumberFormatException ex) {
                            newz = 0;
                        }
                    }
                    if (newx > 0 && newy > 0 && newy < 256 && newz > 0) {
                        Utils.doTeleport((Player)e, e.dimension, newx, newy, newz);
                        return true;
                    }
                    return this.errOther(pl, " Error: invalid coodinates");
                }
                try {
                    newx = Integer.parseInt(s);
                }
                catch (NumberFormatException ex) {
                    newx = 0;
                }
                if (st.hasMoreTokens()) {
                    s = st.nextToken();
                    try {
                        newy = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ex) {
                        newy = 0;
                    }
                }
                if (st.hasMoreTokens()) {
                    s = st.nextToken();
                    try {
                        newz = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ex) {
                        newz = 0;
                    }
                }
                if (newx > 0 && newy > 0 && newy < 256 && newz > 0) {
                    Utils.doTeleport(pl, pl.dimension, newx, newy, newz);
                    return true;
                }
                return this.errOther(pl, " Error: invalid coodinates");
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("stop") || s.equalsIgnoreCase("shutdown")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 0x80) == 0) {
                return this.errPermissionDenied(pl);
            }
            DangerZone.gameover = 1;
            return true;
        }
        if (s.equalsIgnoreCase("rebuild")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                if (s.equalsIgnoreCase("chunk")) {
                    DangerZone.server_chunk_cache.rebuildChunk(pl.dimension, (int)pl.posx, 100, (int)pl.posz);
                    return true;
                }
                if (s.equalsIgnoreCase("area")) {
                    int i = -4;
                    while (i <= 4) {
                        int j = -4;
                        while (j <= 4) {
                            DangerZone.server_chunk_cache.rebuildChunk(pl.dimension, (int)pl.posx + i * 16, 100, (int)pl.posz + j * 16);
                            ++j;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("show")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 0x20) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                if (s.equalsIgnoreCase("eid")) {
                    int i = 1;
                    while (i < DangerZone.max_entities) {
                        Entity e = DangerZone.server.entityManager.findEntityByID(i);
                        if (e != null && e.dimension == pl.dimension) {
                            e.setPetName(String.format("%d", i));
                            return true;
                        }
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i < DangerZone.max_entities) {
                        Entity e = DangerZone.server.entityManager.findEntityByID(i);
                        if (e != null && e.dimension == pl.dimension) {
                            e.setPetName(null);
                            return true;
                        }
                        ++i;
                    }
                }
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("weather")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 0x10) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                if (s.equalsIgnoreCase("clear")) {
                    int i = 1;
                    while (i < DangerZone.max_entities) {
                        Entity e = DangerZone.server.entityManager.findEntityByID(i);
                        if (e != null && e.dimension == pl.dimension && e instanceof EntityCloud && (e.getBID() == Blocks.cloud_thunder.blockID || e.getBID() == Blocks.cloud_rain.blockID)) {
                            e.deadflag = true;
                        }
                        ++i;
                    }
                    return true;
                }
                return this.errOther(pl, " Error: unknown weather");
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("kill")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 8) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                if (s.equalsIgnoreCase("all")) {
                    int i = 1;
                    while (i < DangerZone.max_entities) {
                        Entity e = DangerZone.server.entityManager.findEntityByID(i);
                        if (e != null && pl.getDistanceFromEntity(e) < 256.0 && !(e instanceof Player) && e instanceof EntityLiving && e.getOwnerName() == null) {
                            e.deadflag = true;
                        }
                        ++i;
                    }
                    return true;
                }
                if (s.equalsIgnoreCase("hostile")) {
                    int i = 1;
                    while (i < DangerZone.max_entities) {
                        Entity e = DangerZone.server.entityManager.findEntityByID(i);
                        if (e != null && pl.getDistanceFromEntity(e) < 256.0 && e instanceof EntityLiving && e.temperament == 1 && !(e instanceof Player) && e.getOwnerName() == null) {
                            e.deadflag = true;
                        }
                        ++i;
                    }
                    return true;
                }
                if (s.equalsIgnoreCase("items")) {
                    int i = 1;
                    while (i < DangerZone.max_entities) {
                        Entity e = DangerZone.server.entityManager.findEntityByID(i);
                        if (e != null && pl.getDistanceFromEntity(e) < 256.0 && e instanceof EntityBlockItem) {
                            e.deadflag = true;
                        }
                        ++i;
                    }
                    return true;
                }
                if (s.equalsIgnoreCase("pets")) {
                    int i = 1;
                    while (i < DangerZone.max_entities) {
                        Entity e = DangerZone.server.entityManager.findEntityByID(i);
                        if (e != null && pl.getDistanceFromEntity(e) < 256.0 && !(e instanceof Player) && e instanceof EntityLiving && e.getOwnerName() != null) {
                            e.deadflag = true;
                        }
                        ++i;
                    }
                    return true;
                }
                if (s.equalsIgnoreCase("volcanoes")) {
                    int i = 1;
                    while (i < DangerZone.max_entities) {
                        Entity e = DangerZone.server.entityManager.findEntityByID(i);
                        if (e != null && pl.getDistanceFromEntity(e) < 256.0 && e instanceof EntityVolcano) {
                            e.deadflag = true;
                        }
                        ++i;
                    }
                    return true;
                }
                Entity e = DangerZone.server.entityManager.findPlayerByName(s);
                if (e != null) {
                    Player tlp = (Player)e;
                    tlp.setGameMode(3);
                    tlp.server_thread.fatal_error = 1;
                    return true;
                }
                return this.errOther(pl, " Error: don't know how to kill that!");
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("nofire")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 0x100) == 0) {
                return this.errPermissionDenied(pl);
            }
            int i = 1;
            while (i < DangerZone.max_entities) {
                Entity e = DangerZone.server.entityManager.findEntityByID(i);
                if (e != null && pl.getDistanceFromEntity(e) < 256.0 && !(e instanceof Player) && e instanceof EntityFire) {
                    e.deadflag = true;
                }
                ++i;
            }
            return true;
        }
        if (s.equalsIgnoreCase("op")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                Entity e = DangerZone.server.entityManager.findPlayerByName(s);
                if (e != null) {
                    Player plyr = (Player)e;
                    plyr.player_privs = -1;
                    DangerZone.server.save_privs(plyr.myname, plyr.player_privs);
                    return true;
                }
                return this.errOther(pl, " Error: player not found");
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("deop")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                Entity e = DangerZone.server.entityManager.findPlayerByName(s);
                if (e != null) {
                    Player plyr = (Player)e;
                    plyr.player_privs = 0;
                    DangerZone.server.save_privs(plyr.myname, plyr.player_privs);
                    return true;
                }
                return this.errOther(pl, " Error: player not found");
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("givepriv")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                Entity e = DangerZone.server.entityManager.findPlayerByName(s);
                if (e != null) {
                    int newpriv = 0;
                    if (st.hasMoreTokens()) {
                        s = st.nextToken();
                        if (s.equalsIgnoreCase("gamemode")) {
                            newpriv = 1;
                        }
                        if (s.equalsIgnoreCase("op")) {
                            newpriv = 2;
                        }
                        if (s.equalsIgnoreCase("teleport")) {
                            newpriv = 4;
                        }
                        if (s.equalsIgnoreCase("kill")) {
                            newpriv = 8;
                        }
                        if (s.equalsIgnoreCase("weather")) {
                            newpriv = 16;
                        }
                        if (s.equalsIgnoreCase("misc")) {
                            newpriv = 32;
                        }
                        if (s.equalsIgnoreCase("time")) {
                            newpriv = 64;
                        }
                        if (s.equalsIgnoreCase("shutdown")) {
                            newpriv = 128;
                        }
                        if (s.equalsIgnoreCase("nofire")) {
                            newpriv = 256;
                        }
                        if (s.equalsIgnoreCase("chat")) {
                            newpriv = 512;
                        }
                    }
                    Player plyr = (Player)e;
                    plyr.player_privs |= newpriv;
                    DangerZone.server.save_privs(plyr.myname, plyr.player_privs);
                    return true;
                }
                return this.errOther(pl, " Error: player not found");
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("takepriv")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                Entity e = DangerZone.server.entityManager.findPlayerByName(s);
                if (e != null) {
                    int newpriv = 0;
                    if (st.hasMoreTokens()) {
                        s = st.nextToken();
                        if (s.equalsIgnoreCase("gamemode")) {
                            newpriv = 1;
                        }
                        if (s.equalsIgnoreCase("op")) {
                            newpriv = 2;
                        }
                        if (s.equalsIgnoreCase("teleport")) {
                            newpriv = 4;
                        }
                        if (s.equalsIgnoreCase("kill")) {
                            newpriv = 8;
                        }
                        if (s.equalsIgnoreCase("weather")) {
                            newpriv = 16;
                        }
                        if (s.equalsIgnoreCase("misc")) {
                            newpriv = 32;
                        }
                        if (s.equalsIgnoreCase("time")) {
                            newpriv = 64;
                        }
                        if (s.equalsIgnoreCase("shutdown")) {
                            newpriv = 128;
                        }
                        if (s.equalsIgnoreCase("nofire")) {
                            newpriv = 256;
                        }
                        if (s.equalsIgnoreCase("chat")) {
                            newpriv = 512;
                        }
                    }
                    Player plyr = (Player)e;
                    plyr.player_privs &= ~newpriv;
                    DangerZone.server.save_privs(plyr.myname, plyr.player_privs);
                    return true;
                }
                return this.errOther(pl, " Error: player not found");
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("cavegeneration")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.generatecaves = s.equalsIgnoreCase("true");
            } else {
                String outstring = String.format("CaveGeneration = %s", DangerZone.generatecaves ? "true" : "false");
                pl.server_thread.sendCommandToPlayer(outstring);
            }
            return true;
        }
        if (s.equalsIgnoreCase("playnicely")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.playnicely = s.equalsIgnoreCase("true");
            } else {
                String outstring = String.format("PlayNicely = %s", DangerZone.playnicely ? "true" : "false");
                pl.server_thread.sendCommandToPlayer(outstring);
            }
            return true;
        }
        if (s.equalsIgnoreCase("firedamage")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.firedamage = s.equalsIgnoreCase("true");
            } else {
                String outstring = String.format("FireDamage = %s", DangerZone.firedamage ? "true" : "false");
                pl.server_thread.sendCommandToPlayer(outstring);
            }
            return true;
        }
        if (s.equalsIgnoreCase("petprotection")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.petprotection = s.equalsIgnoreCase("true");
            } else {
                String outstring = String.format("PetProtection = %s", DangerZone.petprotection ? "true" : "false");
                pl.server_thread.sendCommandToPlayer(outstring);
            }
            return true;
        }
        if (s.equalsIgnoreCase("freezeworld")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.freeze_world = s.equalsIgnoreCase("true");
            } else {
                String outstring = String.format("FreezeWorld = %s", DangerZone.freeze_world ? "true" : "false");
                pl.server_thread.sendCommandToPlayer(outstring);
            }
            return true;
        }
        if (s.equalsIgnoreCase("private_server")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.private_server = s.equalsIgnoreCase("true");
            } else {
                String outstring = String.format("PrivateServer = %s", DangerZone.private_server ? "true" : "false");
                pl.server_thread.sendCommandToPlayer(outstring);
            }
            return true;
        }
        if (s.equalsIgnoreCase("validateplayers")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.require_valid_passwords = s.equalsIgnoreCase("true");
            } else {
                String outstring = String.format("ValidatePlayers = %s", DangerZone.require_valid_passwords ? "true" : "false");
                pl.server_thread.sendCommandToPlayer(outstring);
            }
            return true;
        }
        if (s.equalsIgnoreCase("allowanonymous")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.allow_anonymous = s.equalsIgnoreCase("true");
            } else {
                String outstring = String.format("Allow Anonymous Players = %s", DangerZone.allow_anonymous ? "true" : "false");
                pl.server_thread.sendCommandToPlayer(outstring);
            }
            return true;
        }
        if (s.equalsIgnoreCase("defaultprivs")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                int newpriv = 0;
                while (st.hasMoreTokens()) {
                    s = st.nextToken();
                    if (s.equalsIgnoreCase("gamemode")) {
                        newpriv |= 1;
                    }
                    if (s.equalsIgnoreCase("op")) {
                        newpriv |= 2;
                    }
                    if (s.equalsIgnoreCase("teleport")) {
                        newpriv |= 4;
                    }
                    if (s.equalsIgnoreCase("kill")) {
                        newpriv |= 8;
                    }
                    if (s.equalsIgnoreCase("weather")) {
                        newpriv |= 0x10;
                    }
                    if (s.equalsIgnoreCase("misc")) {
                        newpriv |= 0x20;
                    }
                    if (s.equalsIgnoreCase("time")) {
                        newpriv |= 0x40;
                    }
                    if (s.equalsIgnoreCase("shutdown")) {
                        newpriv |= 0x80;
                    }
                    if (s.equalsIgnoreCase("nofire")) {
                        newpriv |= 0x100;
                    }
                    if (!s.equalsIgnoreCase("chat")) continue;
                    newpriv |= 0x200;
                }
                DangerZone.default_privs = newpriv;
            } else {
                String outstring = "  DefaultPrivs = ";
                if ((DangerZone.default_privs & 1) != 0) {
                    outstring = String.valueOf(outstring) + "GameMode ";
                }
                if ((DangerZone.default_privs & 2) != 0) {
                    outstring = String.valueOf(outstring) + "OP ";
                }
                if ((DangerZone.default_privs & 4) != 0) {
                    outstring = String.valueOf(outstring) + "Teleport ";
                }
                if ((DangerZone.default_privs & 8) != 0) {
                    outstring = String.valueOf(outstring) + "Kill ";
                }
                if ((DangerZone.default_privs & 0x10) != 0) {
                    outstring = String.valueOf(outstring) + "Weather ";
                }
                if ((DangerZone.default_privs & 0x20) != 0) {
                    outstring = String.valueOf(outstring) + "Misc ";
                }
                if ((DangerZone.default_privs & 0x40) != 0) {
                    outstring = String.valueOf(outstring) + "Time ";
                }
                if ((DangerZone.default_privs & 0x80) != 0) {
                    outstring = String.valueOf(outstring) + "Shutdown ";
                }
                if ((DangerZone.default_privs & 0x100) != 0) {
                    outstring = String.valueOf(outstring) + "NoFire ";
                }
                if ((DangerZone.default_privs & 0x200) != 0) {
                    outstring = String.valueOf(outstring) + "Chat ";
                }
                pl.server_thread.sendCommandToPlayer(outstring);
            }
            return true;
        }
        if (s.equalsIgnoreCase("maxplayers")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                int newmaxplayers;
                s = st.nextToken();
                try {
                    newmaxplayers = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    newmaxplayers = 10;
                }
                if (newmaxplayers < 2 || newmaxplayers > 255) {
                    newmaxplayers = 10;
                }
                DangerZone.max_players_on_server = newmaxplayers;
            } else {
                String outstring = String.format("MaxPlayers = %d", DangerZone.max_players_on_server);
                pl.server_thread.sendCommandToPlayer(outstring);
            }
            return true;
        }
        if (s.equalsIgnoreCase("chunkowner")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                ArrayList<String> newowners = null;
                s = st.nextToken();
                if (!s.equals("null")) {
                    newowners = new ArrayList<String>();
                    newowners.add(s);
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        newowners.add(s);
                    }
                }
                DangerZone.server_chunk_cache.setChunkOwners(pl.dimension, (int)pl.posx, (int)pl.posy, (int)pl.posz, newowners);
            } else {
                List<String> owners = DangerZone.server_chunk_cache.getChunkOwners(pl.dimension, (int)pl.posx, (int)pl.posy, (int)pl.posz);
                if (owners != null) {
                    String outstring = "Chunk Owners: ";
                    int i = 0;
                    int ilen = owners.size();
                    while (ilen > 0) {
                        outstring = String.valueOf(outstring) + owners.get(i);
                        outstring = String.valueOf(outstring) + ", ";
                        --ilen;
                        ++i;
                    }
                    pl.server_thread.sendCommandToPlayer(outstring);
                } else {
                    pl.server_thread.sendCommandToPlayer("no owners");
                }
            }
            return true;
        }
        if (s.equalsIgnoreCase("ban")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.server.setBanned(s, true);
                Entity e = DangerZone.server.entityManager.findPlayerByName(s);
                if (e != null) {
                    Player tlp = (Player)e;
                    tlp.setGameMode(3);
                    tlp.server_thread.fatal_error = 1;
                }
                return true;
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("unban")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.server.setBanned(s, false);
                return true;
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("whitelist")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.server.setBanned(s, true);
                return true;
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("unwhitelist")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.server.setBanned(s, false);
                return true;
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("showprivs")) {
            Player tpl = pl;
            Entity e = null;
            if (st.hasMoreTokens()) {
                if ((pl.player_privs & 2) == 0) {
                    return this.errPermissionDenied(pl);
                }
                s = st.nextToken();
                e = DangerZone.server.entityManager.findPlayerByName(s);
                if (e != null) {
                    tpl = (Player)e;
                } else {
                    return this.errOther(pl, " Error: player not found");
                }
            }
            String outstring = "  Privs for ";
            outstring = String.valueOf(outstring) + tpl.myname;
            outstring = String.valueOf(outstring) + ": ";
            if ((tpl.player_privs & 1) != 0) {
                outstring = String.valueOf(outstring) + "GameMode ";
            }
            if ((tpl.player_privs & 2) != 0) {
                outstring = String.valueOf(outstring) + "OP ";
            }
            if ((tpl.player_privs & 4) != 0) {
                outstring = String.valueOf(outstring) + "Teleport ";
            }
            if ((tpl.player_privs & 8) != 0) {
                outstring = String.valueOf(outstring) + "Kill ";
            }
            if ((tpl.player_privs & 0x10) != 0) {
                outstring = String.valueOf(outstring) + "Weather ";
            }
            if ((tpl.player_privs & 0x20) != 0) {
                outstring = String.valueOf(outstring) + "Misc ";
            }
            if ((tpl.player_privs & 0x40) != 0) {
                outstring = String.valueOf(outstring) + "Time ";
            }
            if ((tpl.player_privs & 0x80) != 0) {
                outstring = String.valueOf(outstring) + "Shutdown ";
            }
            if ((tpl.player_privs & 0x100) != 0) {
                outstring = String.valueOf(outstring) + "NoFire ";
            }
            if ((tpl.player_privs & 0x200) != 0) {
                outstring = String.valueOf(outstring) + "Chat ";
            }
            pl.server_thread.sendCommandToPlayer(outstring);
            return true;
        }
        if (s.equalsIgnoreCase("who") || s.equalsIgnoreCase("players")) {
            String outstring = "  Players: ";
            DangerZone.server.player_list_lock.lock();
            int nonline = 0;
            int i = 0;
            while (i < DangerZone.server.max_players) {
                Player ppl;
                if (DangerZone.server.players[i] != null && (ppl = DangerZone.server.players[i].p) != null) {
                    outstring = String.valueOf(outstring) + ppl.myname;
                    if ((ppl.player_privs & 2) != 0) {
                        outstring = String.valueOf(outstring) + "(OP)";
                    }
                    outstring = String.valueOf(outstring) + ", ";
                    if (++nonline > 5) {
                        nonline = 0;
                        outstring = String.valueOf(outstring) + "\n   ";
                    }
                }
                ++i;
            }
            DangerZone.server.player_list_lock.unlock();
            pl.server_thread.sendCommandToPlayer(outstring);
            return true;
        }
        if (s.equalsIgnoreCase("items")) {
            if (!st.hasMoreTokens()) {
                return this.errOther(pl, " Error: need a search string");
            }
            s = "";
            while (st.hasMoreTokens()) {
                s = String.valueOf(s) + st.nextToken();
                if (!st.hasMoreTokens()) continue;
                s = String.valueOf(s) + " ";
            }
            String outstring = "";
            int i = 0;
            while (i < 2048) {
                if (Items.ItemArray[i] != null && Items.ItemArray[i].uniquename.toLowerCase().contains(s.toLowerCase())) {
                    outstring = String.valueOf(outstring) + String.format("Item: %d : %s\n", i, Items.ItemArray[i].uniquename);
                }
                ++i;
            }
            pl.server_thread.sendCommandToPlayer(outstring);
            return true;
        }
        if (s.equalsIgnoreCase("blocks")) {
            if (!st.hasMoreTokens()) {
                return this.errOther(pl, " Error: need a search string");
            }
            s = "";
            while (st.hasMoreTokens()) {
                s = String.valueOf(s) + st.nextToken();
                if (!st.hasMoreTokens()) continue;
                s = String.valueOf(s) + " ";
            }
            String outstring = "";
            int i = 0;
            while (i < 2048) {
                if (Blocks.BlockArray[i] != null && Blocks.BlockArray[i].uniquename.toLowerCase().contains(s.toLowerCase())) {
                    outstring = String.valueOf(outstring) + String.format("Block: %d : %s\n", i, Blocks.BlockArray[i].uniquename);
                }
                ++i;
            }
            pl.server_thread.sendCommandToPlayer(outstring);
            return true;
        }
        if (s.equalsIgnoreCase("give")) {
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                Entity e = DangerZone.server.entityManager.findPlayerByName(s);
                if (e != null) {
                    Player plyr = (Player)e;
                    if (st.hasMoreTokens()) {
                        s = st.nextToken();
                        if (s.toLowerCase().equals("item")) {
                            if (st.hasMoreTokens()) {
                                int maxcount;
                                int iid;
                                s = st.nextToken();
                                try {
                                    iid = Integer.parseInt(s);
                                }
                                catch (NumberFormatException ex) {
                                    iid = 0;
                                }
                                if (iid <= 0 || iid >= 2048 || Items.ItemArray[iid] == null) {
                                    return this.errOther(pl, " Error: invalid itemID");
                                }
                                int count = 1;
                                if (st.hasMoreTokens()) {
                                    s = st.nextToken();
                                    try {
                                        count = Integer.parseInt(s);
                                    }
                                    catch (NumberFormatException ex) {
                                        count = 1;
                                    }
                                }
                                if (count > (maxcount = Items.getMaxStack(iid))) {
                                    count = maxcount;
                                }
                                InventoryContainer ic = new InventoryContainer();
                                ic.iid = iid;
                                ic.count = count;
                                plyr.putMeInASlot(ic);
                                return true;
                            }
                            return this.errOther(pl, " Error: expected itemID");
                        }
                        if (s.toLowerCase().equals("block")) {
                            if (st.hasMoreTokens()) {
                                int maxcount;
                                int bid;
                                s = st.nextToken();
                                try {
                                    bid = Integer.parseInt(s);
                                }
                                catch (NumberFormatException ex) {
                                    bid = 0;
                                }
                                if (bid <= 0 || bid >= 2048 || Blocks.BlockArray[bid] == null) {
                                    return this.errOther(pl, " Error: invalid blockID");
                                }
                                int count = 1;
                                if (st.hasMoreTokens()) {
                                    s = st.nextToken();
                                    try {
                                        count = Integer.parseInt(s);
                                    }
                                    catch (NumberFormatException ex) {
                                        count = 1;
                                    }
                                }
                                if (count > (maxcount = Blocks.getMaxStack(bid))) {
                                    count = maxcount;
                                }
                                InventoryContainer ic = new InventoryContainer();
                                ic.bid = bid;
                                ic.count = count;
                                plyr.putMeInASlot(ic);
                                return true;
                            }
                            return this.errOther(pl, " Error: expected itemID");
                        }
                    }
                } else {
                    return this.errOther(pl, " Error: player not found");
                }
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("clearinventory")) {
            Entity e;
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens() && (e = DangerZone.server.entityManager.findPlayerByName(s = st.nextToken())) != null) {
                Player plyr = (Player)e;
                int i = 0;
                while (i < 64) {
                    plyr.setVarInventory(i, null);
                    ++i;
                }
                return true;
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("kick")) {
            Entity e;
            if ((pl.player_privs & 2) == 0) {
                return this.errPermissionDenied(pl);
            }
            if (st.hasMoreTokens() && (e = DangerZone.server.entityManager.findPlayerByName(s = st.nextToken())) != null) {
                Player plyr = (Player)e;
                plyr.server_thread.fatal_error = 1;
                return true;
            }
            return this.errInvalidCmd(pl);
        }
        if (s.equalsIgnoreCase("whereis")) {
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                Entity e = DangerZone.server.entityManager.findPlayerByName(s);
                if (e != null) {
                    String outstring = String.format(" %d: %d, %d, %d", e.dimension, (int)e.posx, (int)e.posy, (int)e.posz);
                    pl.server_thread.sendCommandToPlayer(outstring);
                    return true;
                }
                return this.errOther(pl, " Error: player not found");
            }
            return this.errInvalidCmd(pl);
        }
        return false;
    }

    public boolean errInvalidCmd(Player pl) {
        pl.server_thread.sendCommandToPlayer(" Error: Command Syntax");
        return false;
    }

    public boolean errPermissionDenied(Player pl) {
        pl.server_thread.sendCommandToPlayer(" Error: Permission Denied");
        return false;
    }

    public boolean errOther(Player pl, String str) {
        pl.server_thread.sendCommandToPlayer(str);
        return false;
    }
}

