/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.DangerZone;
import dangerzone.ListInt;
import dangerzone.Player;
import dangerzone.ServerHooker;
import dangerzone.Swarm;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Flag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ServerEntityUpdateLoop
implements Runnable {
    public List<ListInt> entity_list;
    public List<ListInt> entity_free_list;
    public Entity[] entities;
    public Lock entity_list_lock = new ReentrantLock();
    public long upticker = 1L;
    public int active_entities;

    @Override
    public void run() {
        long lasttime = System.currentTimeMillis();
        long loop_interval = DangerZone.serverentityupdaterate;
        int inext = 0;
        this.entity_list_lock.lock();
        this.entities = new Entity[DangerZone.max_entities];
        this.entity_list = new ArrayList<ListInt>();
        this.entity_free_list = new ArrayList<ListInt>();
        int j = 1;
        while (j < DangerZone.max_entities) {
            this.entity_free_list.add(new ListInt(j));
            ++j;
        }
        this.entity_list_lock.unlock();
        while (DangerZone.gameover == 0) {
            long currtime = System.currentTimeMillis();
            long tlong = currtime - lasttime;
            if ((tlong = loop_interval - tlong) < 0L) {
                tlong = 0L;
            }
            if (tlong > loop_interval) {
                tlong = loop_interval;
            }
            if (tlong > 0L) {
                try {
                    Thread.sleep(tlong);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                currtime = System.currentTimeMillis();
            }
            tlong = currtime - lasttime;
            lasttime = currtime;
            float deltaT = tlong;
            if (deltaT < 100.0f) {
                deltaT = 100.0f;
            }
            if (deltaT > 500.0f) {
                deltaT = 500.0f;
            }
            deltaT /= (float)loop_interval;
            if (DangerZone.start_client) {
                int tmp = DangerZone.renderdistance;
                if ((tmp += 4) > 24) {
                    tmp = 24;
                }
                DangerZone.entityupdatedist = tmp * 16;
            }
            inext = 0;
            int ent_counter = 0;
            if (DangerZone.f12_on) {
                DangerZone.server.flushAll();
                continue;
            }
            Swarm.doSpawnSwarm();
            ServerHooker.entity_loop_start(deltaT);
            int i = 0;
            while (i < DangerZone.server.max_players) {
                if (DangerZone.server.players[i] != null && DangerZone.server.players[i].p != null) {
                    ServerHooker.player_entity_loop_start(DangerZone.server.players[i].p);
                }
                ++i;
            }
            inext = 0;
            while (inext < DangerZone.max_entities) {
                Entity ent = this.entities[inext];
                if (ent != null && ent.deadflag) {
                    this.removeEntityByID(inext);
                    DangerZone.server.sendEntityRemoveToAll(ent);
                } else if (ent != null) {
                    if (DangerZone.server.isPlayerCloseInDimension(ent)) {
                        ServerHooker.entity_action(ent, deltaT);
                        ent.doEntityAction(deltaT);
                        ent.doEntityCollisions(deltaT);
                        ent.update(deltaT);
                        ++ent_counter;
                    } else if (!DangerZone.server_chunk_cache.chunkExists(ent.dimension, (int)ent.posx, 100, (int)ent.posz)) {
                        DangerZone.chunkwriter.addEntity(ent);
                    }
                    if (ent instanceof Player) {
                        ++ent.stray_entity_ticker;
                        if (ent.stray_entity_ticker > 300) {
                            Player plyr = (Player)ent;
                            plyr.server_thread.fatal_error = 1;
                            this.removeEntityByID(inext);
                            DangerZone.server.removeMe(plyr.server_thread);
                            DangerZone.server.sendEntityRemoveToAllExcept(plyr, ent);
                        }
                    }
                }
                ++inext;
            }
            this.active_entities = ent_counter;
            DangerZone.server.flushAll();
            ++this.upticker;
        }
        return;
    }

    private int find_entity_slot() {
        int retval = -1;
        if (this.entity_free_list.size() > 0) {
            ListInt il = this.entity_free_list.get(0);
            retval = il.index;
            this.entity_free_list.remove(0);
        }
        return retval;
    }

    public int addEntity(Entity e) {
        this.entity_list_lock.lock();
        int i = this.find_entity_slot();
        if (i <= 0) {
            e.entityID = -1;
            this.entity_list_lock.unlock();
            return -1;
        }
        this.entities[i] = e;
        e.entityID = i;
        this.entity_list.add(new ListInt(i));
        this.entity_list_lock.unlock();
        return i;
    }

    public Entity[] getEntitiesInChunk(int dim, int cx, int cz) {
        this.entity_list_lock.lock();
        Entity[] retlist = new Entity[DangerZone.max_entities];
        Iterator<ListInt> ii = this.entity_list.iterator();
        int i = 0;
        while (i < DangerZone.max_entities) {
            retlist[i] = null;
            ++i;
        }
        while (ii.hasNext()) {
            ListInt st = ii.next();
            if (this.entities[st.index] == null || this.entities[st.index].dimension != dim || (int)this.entities[st.index].posx >> 4 != cx || (int)this.entities[st.index].posz >> 4 != cz) continue;
            retlist[st.index] = this.entities[st.index];
        }
        this.entity_list_lock.unlock();
        return retlist;
    }

    public boolean areEntitiesInChunk(int dim, int cx, int cz) {
        this.entity_list_lock.lock();
        for (ListInt st : this.entity_list) {
            if (this.entities[st.index] == null || this.entities[st.index].dimension != dim || (int)this.entities[st.index].posx >> 4 != cx || (int)this.entities[st.index].posz >> 4 != cz) continue;
            this.entity_list_lock.unlock();
            return true;
        }
        this.entity_list_lock.unlock();
        return false;
    }

    public Entity findEntityByID(int eid) {
        Entity ent = null;
        if (eid == 0) {
            return null;
        }
        this.entity_list_lock.lock();
        for (ListInt st : this.entity_list) {
            if (this.entities[st.index] == null || this.entities[st.index].entityID != eid) continue;
            ent = this.entities[st.index];
            break;
        }
        this.entity_list_lock.unlock();
        return ent;
    }

    public Entity findPlayerByName(String playername) {
        if (playername == null) {
            return null;
        }
        Entity ent = null;
        this.entity_list_lock.lock();
        for (ListInt st : this.entity_list) {
            if (this.entities[st.index] == null || !(this.entities[st.index] instanceof Player)) continue;
            Player p = (Player)this.entities[st.index];
            if (!p.myname.toLowerCase().equals(playername.toLowerCase())) continue;
            ent = this.entities[st.index];
            break;
        }
        this.entity_list_lock.unlock();
        return ent;
    }

    public int removeEntityByID(int eid) {
        this.entity_list_lock.lock();
        Iterator<ListInt> ii = this.entity_list.iterator();
        int retid = -1;
        while (ii.hasNext()) {
            ListInt st = ii.next();
            if (this.entities[st.index] == null || this.entities[st.index].entityID != eid) continue;
            this.entities[st.index] = null;
            ii.remove();
            this.entity_free_list.add(new ListInt(st.index));
            retid = eid;
            break;
        }
        this.entity_list_lock.unlock();
        return retid;
    }

    public List<Entity> findEntitiesInRange(float range, int dim, double x, double y, double z) {
        this.entity_list_lock.lock();
        ArrayList<Entity> retlist = new ArrayList<Entity>();
        for (ListInt st : this.entity_list) {
            if (this.entities[st.index] == null || this.entities[st.index].dimension != dim) continue;
            double dx = x - this.entities[st.index].posx;
            double dy = y - this.entities[st.index].posy;
            double dz = z - this.entities[st.index].posz;
            if (!((dx = Math.sqrt(dx * dx + dy * dy + dz * dz)) < (double)range && this.entities[st.index] instanceof EntityLiving) && !(this.entities[st.index] instanceof Flag)) continue;
            retlist.add(this.entities[st.index]);
        }
        this.entity_list_lock.unlock();
        return retlist;
    }

    public List<Entity> findALLEntitiesInRange(float range, int dim, double x, double y, double z) {
        this.entity_list_lock.lock();
        ArrayList<Entity> retlist = new ArrayList<Entity>();
        for (ListInt st : this.entity_list) {
            if (this.entities[st.index] == null || this.entities[st.index].dimension != dim) continue;
            double dx = x - this.entities[st.index].posx;
            double dy = y - this.entities[st.index].posy;
            double dz = z - this.entities[st.index].posz;
            if (!((dx = Math.sqrt(dx * dx + dy * dy + dz * dz)) < (double)range)) continue;
            retlist.add(this.entities[st.index]);
        }
        this.entity_list_lock.unlock();
        return retlist;
    }
}

