/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Martian
extends EntityLiving {
    public Martian(World w) {
        super(w);
        this.width = 0.65f;
        this.height = 1.55f;
        this.uniquename = "DangerZone:Martian";
        this.has_inventory = true;
        this.setMaxHealth(30.0f);
        this.setHealth(30.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(5.0f);
        this.setExperience(80);
        this.setMaxAir(400.0f);
        this.setAir(400.0f);
        this.searchDistance = 50.0f;
        this.attackRange = 2.0f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = true;
        this.tower_defense_enable = true;
        this.moveSpeed = 0.25f;
        this.setCanDespawn(false);
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (!this.world.isServer) {
            InventoryContainer icm = this.getHotbar(0);
            if (icm != null && icm.iid == Items.bow.itemID) {
                return false;
            }
            DangerZone.tradegui.ec = this;
            DangerZone.setActiveGui(DangerZone.tradegui);
        } else {
            InventoryContainer icm = this.getHotbar(0);
            if (icm != null && icm.iid == Items.bow.itemID) {
                return false;
            }
            this.setStaying(true);
        }
        return false;
    }

    @Override
    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        InventoryContainer ic = this.getHotbar(0);
        if (ic == null) {
            this.setVarInt(30, 0);
            return;
        }
        int cost = 0;
        if (ic.bid == Blocks.redleaves.blockID) {
            cost = 10;
        }
        if (ic.bid == Blocks.yellowleaves.blockID) {
            cost = 10;
        }
        if (ic.bid == Blocks.orangeleaves.blockID) {
            cost = 10;
        }
        if (ic.bid == Blocks.flower_red.blockID) {
            cost = 50;
        }
        if (ic.bid == Blocks.flower_pink.blockID) {
            cost = 50;
        }
        if (ic.bid == Blocks.flower_yellow.blockID) {
            cost = 50;
        }
        if (ic.bid == Blocks.flower_purple.blockID) {
            cost = 300;
        }
        this.setVarInt(30, 0);
        this.setVarInt(30, cost * ic.count);
    }

    @Override
    public void init() {
        block15: {
            int i;
            block18: {
                block17: {
                    block16: {
                        super.init();
                        if (this.world == null || !this.world.isServer || this.getInitialized() != 0) break block15;
                        this.setInitialized(1);
                        if (this.world.rand.nextInt(3) != 1) break block16;
                        int itd = Items.bow.itemID;
                        InventoryContainer ic = new InventoryContainer();
                        ic.iid = itd;
                        ic.count = 1;
                        ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
                        this.setHotbar(0, ic);
                        this.sethotbarindex(0);
                        ic = new InventoryContainer();
                        ic.iid = Items.arrow.itemID;
                        ic.count = 64;
                        this.setHotbar(1, ic);
                        ic = new InventoryContainer();
                        ic.iid = Items.arrow.itemID;
                        ic.count = 64;
                        this.setHotbar(2, ic);
                        ic = new InventoryContainer();
                        ic.iid = Items.arrow.itemID;
                        ic.count = 64;
                        this.setHotbar(3, ic);
                        ic = new InventoryContainer();
                        ic.iid = Items.arrow.itemID;
                        ic.count = 64;
                        this.setHotbar(4, ic);
                        break block15;
                    }
                    if (!this.world.rand.nextBoolean()) break block17;
                    switch (this.world.rand.nextInt(3)) {
                        case 0: {
                            i = 0;
                            while (i < 8) {
                                this.setInventory(i, this.getSomethingB());
                                ++i;
                            }
                            break block18;
                        }
                        case 1: {
                            i = 0;
                            while (i < 8) {
                                this.setInventory(i, this.getSomethingBR());
                                ++i;
                            }
                            break block18;
                        }
                        default: {
                            i = 0;
                            while (i < 8) {
                                this.setInventory(i, this.getSomethingBW());
                                ++i;
                            }
                            break block18;
                        }
                    }
                }
                switch (this.world.rand.nextInt(3)) {
                    case 0: {
                        i = 0;
                        while (i < 8) {
                            this.setInventory(i, this.getSomethingI());
                            ++i;
                        }
                        break;
                    }
                    case 1: {
                        i = 0;
                        while (i < 8) {
                            this.setInventory(i, this.getSomethingIF());
                            ++i;
                        }
                        break;
                    }
                    default: {
                        i = 0;
                        while (i < 8) {
                            this.setInventory(i, this.getSomethingIS());
                            ++i;
                        }
                        break block4;
                    }
                }
            }
            i = 0;
            while (i < 8) {
                this.setVarInt(i + 16, this.world.rand.nextInt(300) * 10 + 10);
                ++i;
            }
        }
    }

    private InventoryContainer getSomethingI() {
        int i = this.world.rand.nextInt(43);
        switch (i) {
            case 0: {
                return new InventoryContainer("DangerZone:Door", 2);
            }
            case 1: {
                return new InventoryContainer("DangerZone:Sign", 4);
            }
            case 2: {
                return new InventoryContainer("DangerZone:DangerZone:Spawn Cloud", 8);
            }
            case 3: {
                return new InventoryContainer("DangerZone:Wooden Sword", 1);
            }
            case 4: {
                return new InventoryContainer("DangerZone:Stone Sword", 1);
            }
            case 5: {
                return new InventoryContainer("DangerZone:Copper Sword", 1);
            }
            case 6: {
                return new InventoryContainer("DangerZone:Tin Sword", 1);
            }
            case 7: {
                return new InventoryContainer("DangerZone:Silver Sword", 1);
            }
            case 8: {
                return new InventoryContainer("DangerZone:Platinum Sword", 1);
            }
            case 9: {
                return new InventoryContainer("DangerZone:Darkness", 32);
            }
            case 10: {
                return new InventoryContainer("DangerZone:Lightness", 32);
            }
            case 11: {
                return new InventoryContainer("DangerZone:Diamond", 1);
            }
            case 12: {
                return new InventoryContainer("DangerZone:Emerald", 4);
            }
            case 13: {
                return new InventoryContainer("DangerZone:Bloodstone", 4);
            }
            case 14: {
                return new InventoryContainer("DangerZone:Sunstone", 2);
            }
            case 21: {
                return new InventoryContainer("DangerZone:Silver Helmet", 1);
            }
            case 22: {
                return new InventoryContainer("DangerZone:Silver Chestplate", 1);
            }
            case 23: {
                return new InventoryContainer("DangerZone:Silver Leggings", 1);
            }
            case 24: {
                return new InventoryContainer("DangerZone:Silver Boots", 1);
            }
            case 25: {
                return new InventoryContainer("DangerZone:Furball", 64);
            }
            case 26: {
                return new InventoryContainer("DangerZone:Vamire Teeth", 2);
            }
            case 27: {
                return new InventoryContainer("DangerZone:Instability", 32);
            }
            case 28: {
                return new InventoryContainer("DangerZone:Auto-Fence Key", 1);
            }
            case 29: {
                return new InventoryContainer("DangerZone:String", 8);
            }
            case 30: {
                return new InventoryContainer("DangerZone:Bucket", 1);
            }
            case 31: {
                return new InventoryContainer("DangerZone:Charcoal Stick", 4);
            }
            case 32: {
                return new InventoryContainer("DangerZone:Paper", 32);
            }
            case 33: {
                return new InventoryContainer("DangerZone:Arrow", 32);
            }
        }
        return null;
    }

    private InventoryContainer getSomethingIF() {
        int i = this.world.rand.nextInt(43);
        switch (i) {
            case 15: {
                return new InventoryContainer("DangerZone:Raw Goose", 16);
            }
            case 16: {
                return new InventoryContainer("DangerZone:Raw Ostrich", 16);
            }
            case 17: {
                return new InventoryContainer("DangerZone:Raw Fish", 16);
            }
            case 18: {
                return new InventoryContainer("DangerZone:Raw Meat", 16);
            }
            case 19: {
                return new InventoryContainer("DangerZone:Awful Gluten Free Bread", 32);
            }
            case 20: {
                return new InventoryContainer("DangerZone:Dead Bug", 4);
            }
        }
        return null;
    }

    private InventoryContainer getSomethingIS() {
        int i = this.world.rand.nextInt(43);
        switch (i) {
            case 34: {
                return new InventoryContainer("DangerZone:Speed 1", 4);
            }
            case 35: {
                return new InventoryContainer("DangerZone:Regeneration 1", 4);
            }
            case 36: {
                return new InventoryContainer("DangerZone:Accuracy Scroll I", 4);
            }
            case 37: {
                return new InventoryContainer("DangerZone:Damage Scroll I", 4);
            }
            case 38: {
                return new InventoryContainer("DangerZone:Durability Scroll I", 4);
            }
            case 39: {
                return new InventoryContainer("DangerZone:Reach Scroll I", 4);
            }
            case 40: {
                return new InventoryContainer("DangerZone:Spam Scroll I", 4);
            }
            case 41: {
                return new InventoryContainer("DangerZone:Harm Scroll", 4);
            }
            case 42: {
                return new InventoryContainer("DangerZone:Heal Scroll", 4);
            }
        }
        return null;
    }

    private InventoryContainer getSomethingB() {
        int i = this.world.rand.nextInt(38);
        switch (i) {
            case 0: {
                return new InventoryContainer("DangerZone:Stone", 64);
            }
            case 1: {
                return new InventoryContainer("DangerZone:Grey Stone", 64);
            }
            case 2: {
                return new InventoryContainer("DangerZone:White Stone", 64);
            }
            case 3: {
                return new InventoryContainer("DangerZone:Hard Rock", 64);
            }
            case 4: {
                return new InventoryContainer("DangerZone:Fire Stone", 64);
            }
            case 5: {
                return new InventoryContainer("DangerZone:Copper Ore", 64);
            }
            case 6: {
                return new InventoryContainer("DangerZone:Tin Ore", 64);
            }
            case 7: {
                return new InventoryContainer("DangerZone:Silver Ore", 64);
            }
            case 8: {
                return new InventoryContainer("DangerZone:Chunk Marker", 64);
            }
            case 9: {
                return new InventoryContainer("DangerZone:Dark Ore", 64);
            }
            case 10: {
                return new InventoryContainer("DangerZone:Light Ore", 64);
            }
            case 11: {
                return new InventoryContainer("DangerZone:Cockroach Nest", 64);
            }
            case 12: {
                return new InventoryContainer("DangerZone:Glass", 64);
            }
            case 22: {
                return new InventoryContainer("DangerZone:Auto-Fence", 64);
            }
            case 23: {
                return new InventoryContainer("DangerZone:Fence Post", 64);
            }
            case 24: {
                return new InventoryContainer("DangerZone:Ladder", 64);
            }
            case 25: {
                return new InventoryContainer("DangerZone:Shredder", 2);
            }
        }
        return null;
    }

    private InventoryContainer getSomethingBW() {
        int i = this.world.rand.nextInt(38);
        switch (i) {
            case 13: {
                return new InventoryContainer("DangerZone:Water Pump", 4);
            }
            case 14: {
                return new InventoryContainer("DangerZone:Water Spout", 16);
            }
            case 15: {
                return new InventoryContainer("DangerZone:Water Light", 16);
            }
            case 16: {
                return new InventoryContainer("DangerZone:Water Dark", 16);
            }
            case 17: {
                return new InventoryContainer("DangerZone:Music Box", 2);
            }
            case 18: {
                return new InventoryContainer("DangerZone:Puddle Maker", 8);
            }
            case 19: {
                return new InventoryContainer("DangerZone:Water Cannon", 8);
            }
            case 20: {
                return new InventoryContainer("DangerZone:Squishy Stone", 32);
            }
            case 21: {
                return new InventoryContainer("DangerZone:Water Switch", 8);
            }
            case 22: {
                return new InventoryContainer("DangerZone:Auto-Fence", 64);
            }
            case 23: {
                return new InventoryContainer("DangerZone:Fence Post", 64);
            }
            case 24: {
                return new InventoryContainer("DangerZone:Ladder", 64);
            }
            case 25: {
                return new InventoryContainer("DangerZone:Shredder", 2);
            }
        }
        return null;
    }

    private InventoryContainer getSomethingBR() {
        int i = this.world.rand.nextInt(38);
        switch (i) {
            case 26: {
                return new InventoryContainer("DangerZone:MagLev Rail", 64);
            }
            case 27: {
                return new InventoryContainer("DangerZone:Acceleration Rail", 8);
            }
            case 28: {
                return new InventoryContainer("DangerZone:Deceleration Rail", 8);
            }
            case 29: {
                return new InventoryContainer("DangerZone:Stop Rail", 4);
            }
            case 30: {
                return new InventoryContainer("DangerZone:Levitate Up Rail", 4);
            }
            case 31: {
                return new InventoryContainer("DangerZone:Levitate Down Rail", 4);
            }
            case 32: {
                return new InventoryContainer("DangerZone:Slow Speed Rail", 8);
            }
            case 33: {
                return new InventoryContainer("DangerZone:Medium Speed Rail", 8);
            }
            case 34: {
                return new InventoryContainer("DangerZone:Load Rail", 4);
            }
            case 35: {
                return new InventoryContainer("DangerZone:Unload Rail", 4);
            }
            case 36: {
                return new InventoryContainer("DangerZone:Dimension+ Rail", 2);
            }
            case 37: {
                return new InventoryContainer("DangerZone:Dimension- Rail", 2);
            }
        }
        return null;
    }

    @Override
    public void doTargetPrep(Entity ent) {
        InventoryContainer ic = this.getHotbar(0);
        if (ic == null || ic.iid != Items.bow.itemID) {
            this.temperament = 2;
            this.setAttacking(false);
            this.enable_hostile = false;
            this.moveSpeed = 0.25f;
            return;
        }
        this.enable_hostile = true;
        this.temperament = 1;
        if (ent == null) {
            this.setRightButtonDownCount(0);
            this.moveSpeed = 0.25f;
            this.setAttacking(false);
        } else if (this.getDistanceFromEntity(ent) > (double)this.attackRange) {
            this.setRightButtonDownCount(this.getRightButtonDownCount() + 10);
            this.lookAtEntity(ent);
            this.setAttacking(false);
            this.moveSpeed = 0.05f;
        } else {
            this.setRightButtonDownCount(0);
            this.setAttacking(true);
            this.moveSpeed = 0.25f;
        }
    }

    @Override
    public void doDistanceAttack(Entity victim) {
        InventoryContainer ic;
        if (this.world.isServer && (ic = this.getHotbar(0)) != null && ic.iid == Items.bow.itemID) {
            float dist;
            this.lookAtEntity(victim);
            float fullholdcount = Items.getfullholdcount(ic.iid);
            float curcount = this.getRightButtonDownCount();
            if (curcount < 20.0f) {
                curcount = 20.0f;
            }
            if (curcount > (fullholdcount *= (dist = (float)this.getDistanceFromEntity(victim)) / this.searchDistance)) {
                Item it = ic.getItem();
                it.rightclickup(this, ic, (int)curcount);
                this.setRightButtonDownCount(0);
            }
        }
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        int which = this.world.rand.nextInt(4);
        if (which == 0) {
            return "DangerZone:martian_living1";
        }
        if (which == 1) {
            return "DangerZone:martian_living2";
        }
        if (which == 2) {
            return "DangerZone:martian_living3";
        }
        return "DangerZone:martian_living4";
    }

    @Override
    public float getLivingSoundVolume() {
        return 0.25f;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:martian_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:martian_death";
    }

    @Override
    public String getAttackSound() {
        return null;
    }

    @Override
    public void doDeathDrops() {
        int i = 0;
        while (i < 60) {
            this.setVarInventory(i, null);
            ++i;
        }
        super.doDeathDrops();
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophymartian.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Martian) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Martiantexture.png");
        }
        return this.texture;
    }
}

