/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Frog;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class DesertRainFrog
extends EntityLiving {
    private int jumpcount = 0;

    public DesertRainFrog(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = "DangerZone:Desert Rain Frog";
        this.moveSpeed = 0.16f;
        this.setMaxHealth(2.0f);
        this.setHealth(2.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(2.0f);
        this.movefrequency = 40;
        this.setExperience(1);
        this.canSwim = true;
        this.takesFallDamage = false;
        this.attackRange = 1.0f;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.searchDistance = 8.0f;
        this.enable_droppedfood = true;
        this.foodsearchDistance = 10;
        this.enable_hostile = true;
        this.canridemaglevcart = true;
    }

    @Override
    public boolean isFoodItem(int foodid) {
        return foodid == Items.deadbug.itemID;
    }

    @Override
    public void onKill(Entity e) {
        this.heal(1.0f);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof DesertRainFrog) {
            return false;
        }
        if (e instanceof Frog) {
            return false;
        }
        if (e.getWidth() * e.getHeight() > 0.53f) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            if (this.jumpcount > 0) {
                --this.jumpcount;
            }
            if (this.jumpcount == 0 && this.world.rand.nextInt(75) == 1) {
                this.jumpAround();
                this.jumpcount = 75;
            }
            if (this.world.rand.nextInt(10000) == 10 && this.getCanDespawn()) {
                this.deadflag = true;
            }
        }
        super.update(deltaT);
    }

    @Override
    public String getLivingSound() {
        switch (this.world.rand.nextInt(10)) {
            case 0: {
                return "DangerZone:rainfrog1";
            }
            case 1: {
                return "DangerZone:rainfrog2";
            }
            case 2: {
                return "DangerZone:rainfrog3";
            }
            case 3: {
                return "DangerZone:rainfrog4";
            }
            case 4: {
                return "DangerZone:rainfrog5";
            }
            case 5: {
                return "DangerZone:rainfrog6";
            }
            case 6: {
                return "DangerZone:rainfrog7";
            }
            case 7: {
                return "DangerZone:rainfrog8";
            }
            case 8: {
                return "DangerZone:rainfrog9";
            }
            case 9: {
                return "DangerZone:rainfrog10";
            }
        }
        return null;
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:rainfrog_death";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:rainfrog_hit";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophydesertrainfrog.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, Items.squeaktoy.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.deadbug.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    private void jumpAround() {
        this.target = null;
        this.motiony += 0.55f + Math.abs(this.world.rand.nextFloat() * 0.55f);
        this.posy += (double)0.2f;
        float f = 0.58f + Math.abs(this.world.rand.nextFloat() * 0.65f);
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        this.motionx = (float)((double)this.motionx + (double)f * Math.sin(cdir));
        this.motionz = (float)((double)this.motionz + (double)f * Math.cos(cdir));
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/DesertRainFrogtexture.png");
        }
        return this.texture;
    }
}

