/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.BreakChecks;
import dangerzone.DangerZone;
import dangerzone.StitchedTexture;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlockItem;
import dangerzone.threads.VBODataBuilderThread;
import org.lwjgl.opengl.GL11;

public class SeaPlant
extends Block {
    private boolean compiled = false;
    private int myrenderid = 0;
    private float blockrenderwidth = 16.0f;

    public SeaPlant(String n, String txt) {
        super(n, txt);
        this.breaksound = "DangerZone:leavesbreak";
        this.placesound = "DangerZone:leavesplace";
        this.hitsound = "DangerZone:leaves_hit";
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.randomtick = true;
        this.isLeaves = true;
        this.isWaterPlant = true;
        this.maxdamage = 1;
        this.burntime = 10;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        EntityBlockItem e;
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.stone.blockID && bid != Blocks.sand.blockID) {
            w.setblock(d, x, y, z, Blocks.water.blockID);
            if (w.rand.nextInt(4) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                e.fill(this, 1);
                w.spawnEntityInWorld(e);
            }
        }
        if ((bid = w.getblock(d, x, y + 1, z)) != Blocks.waterstatic.blockID && bid != Blocks.water.blockID) {
            w.setblock(d, x, y, z, Blocks.water.blockID);
            if (w.rand.nextInt(4) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                e.fill(this, 1);
                w.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        int k;
        int j;
        int i;
        int count = 0;
        if (w.getblock(d, x, y + 1, z) != Blocks.waterstatic.blockID) {
            w.setblock(d, x, y, z, Blocks.water.blockID);
            return;
        }
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.stone.blockID && bid != Blocks.sand.blockID) {
            w.setblock(d, x, y, z, Blocks.water.blockID);
            return;
        }
        if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
            return;
        }
        if (w.rand.nextInt(25) == 1) {
            i = -2;
            while (i <= 2) {
                j = -1;
                while (j <= 1) {
                    k = -2;
                    while (k <= 2) {
                        if (w.getblock(d, x + i, y + j, z + k) == this.blockID) {
                            ++count;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            if (count > 3) {
                w.setblock(d, x, y, z, Blocks.water.blockID);
                return;
            }
        }
        if (w.rand.nextInt(200) == 1) {
            i = -1;
            while (i <= 1) {
                j = -1;
                while (j <= 1) {
                    k = -1;
                    while (k <= 1) {
                        bid = w.getblock(d, x + i, y + j, z + k);
                        if ((bid == Blocks.stone.blockID || bid == Blocks.sand.blockID) && w.getblock(d, x + i, y + j + 1, z + k) == Blocks.waterstatic.blockID && w.rand.nextInt(4) == 1) {
                            w.setblock(d, x + i, y + j + 1, z + k, this.blockID);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        float brw = this.blockrenderwidth / 2.0f;
        st = VBODataBuilderThread.findVBOtextureforblockside(0, bid);
        v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            this.myrenderid = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)this.myrenderid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glEnd();
            GL11.glEndList();
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        GL11.glCallList((int)this.myrenderid);
    }
}

